/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.jute;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import oadd.org.apache.jute.Index;
import oadd.org.apache.jute.InputArchive;
import oadd.org.apache.jute.Record;

public class BinaryInputArchive
implements InputArchive {
    public static final String UNREASONBLE_LENGTH = "Unreasonable length = ";
    private DataInput in;
    public static final int maxBuffer = Integer.getInteger("jute.maxbuffer", 1048575);

    public static BinaryInputArchive getArchive(InputStream strm) {
        return new BinaryInputArchive(new DataInputStream(strm));
    }

    public BinaryInputArchive(DataInput in) {
        this.in = in;
    }

    public byte readByte(String tag) throws IOException {
        return this.in.readByte();
    }

    public boolean readBool(String tag) throws IOException {
        return this.in.readBoolean();
    }

    public int readInt(String tag) throws IOException {
        return this.in.readInt();
    }

    public long readLong(String tag) throws IOException {
        return this.in.readLong();
    }

    public float readFloat(String tag) throws IOException {
        return this.in.readFloat();
    }

    public double readDouble(String tag) throws IOException {
        return this.in.readDouble();
    }

    public String readString(String tag) throws IOException {
        int len = this.in.readInt();
        if (len == -1) {
            return null;
        }
        this.checkLength(len);
        byte[] b = new byte[len];
        this.in.readFully(b);
        return new String(b, "UTF8");
    }

    public byte[] readBuffer(String tag) throws IOException {
        int len = this.readInt(tag);
        if (len == -1) {
            return null;
        }
        this.checkLength(len);
        byte[] arr = new byte[len];
        this.in.readFully(arr);
        return arr;
    }

    public void readRecord(Record r, String tag) throws IOException {
        r.deserialize(this, tag);
    }

    public void startRecord(String tag) throws IOException {
    }

    public void endRecord(String tag) throws IOException {
    }

    public Index startVector(String tag) throws IOException {
        int len = this.readInt(tag);
        if (len == -1) {
            return null;
        }
        return new BinaryIndex(len);
    }

    public void endVector(String tag) throws IOException {
    }

    public Index startMap(String tag) throws IOException {
        return new BinaryIndex(this.readInt(tag));
    }

    public void endMap(String tag) throws IOException {
    }

    private void checkLength(int len) throws IOException {
        if (len < 0 || len > maxBuffer + 1024) {
            throw new IOException(UNREASONBLE_LENGTH + len);
        }
    }

    private static class BinaryIndex
    implements Index {
        private int nelems;

        BinaryIndex(int nelems) {
            this.nelems = nelems;
        }

        public boolean done() {
            return this.nelems <= 0;
        }

        public void incr() {
            --this.nelems;
        }
    }
}

