/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.metastore;

import java.util.HashMap;
import java.util.Map;
import oadd.org.apache.drill.common.expression.SchemaPath;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.record.metadata.SchemaPathUtils;
import oadd.org.apache.drill.exec.record.metadata.TupleMetadata;
import oadd.org.apache.drill.metastore.BaseMetadata;
import oadd.org.apache.drill.metastore.ColumnStatistics;
import oadd.org.apache.drill.metastore.LocationProvider;
import oadd.org.apache.drill.metastore.StatisticsKind;
import org.apache.hadoop.fs.Path;

public class FileMetadata
implements BaseMetadata,
LocationProvider {
    private final Path location;
    private final TupleMetadata schema;
    private final Map<SchemaPath, ColumnStatistics> columnsStatistics;
    private final Map<String, Object> fileStatistics;
    private final Map<String, StatisticsKind> statisticsKinds;
    private final String tableName;
    private final long lastModifiedTime;

    public FileMetadata(Path location, TupleMetadata schema, Map<SchemaPath, ColumnStatistics> columnsStatistics, Map<StatisticsKind, Object> fileStatistics, String tableName, long lastModifiedTime) {
        this.schema = schema;
        this.columnsStatistics = columnsStatistics;
        this.fileStatistics = new HashMap<String, Object>();
        this.statisticsKinds = new HashMap<String, StatisticsKind>();
        fileStatistics.forEach((statisticsKind, value) -> {
            this.fileStatistics.put(statisticsKind.getName(), value);
            this.statisticsKinds.put(statisticsKind.getName(), (StatisticsKind)statisticsKind);
        });
        this.location = location;
        this.tableName = tableName;
        this.lastModifiedTime = lastModifiedTime;
    }

    @Override
    public Object getStatisticsForColumn(SchemaPath columnName, StatisticsKind statisticsKind) {
        return this.columnsStatistics.get(columnName).getStatistic(statisticsKind);
    }

    @Override
    public Object getStatistic(StatisticsKind statisticsKind) {
        return this.fileStatistics.get(statisticsKind.getName());
    }

    @Override
    public boolean containsExactStatistics(StatisticsKind statisticsKind) {
        return this.statisticsKinds.get(statisticsKind.getName()).isExact();
    }

    @Override
    public ColumnStatistics getColumnStatistics(SchemaPath columnName) {
        return this.columnsStatistics.get(columnName);
    }

    @Override
    public Path getLocation() {
        return this.location;
    }

    @Override
    public ColumnMetadata getColumn(SchemaPath name) {
        return SchemaPathUtils.getColumnMetadata(name, this.schema);
    }

    @Override
    public TupleMetadata getSchema() {
        return this.schema;
    }

    @Override
    public Map<SchemaPath, ColumnStatistics> getColumnsStatistics() {
        return this.columnsStatistics;
    }

    public String getTableName() {
        return this.tableName;
    }

    public long getLastModifiedTime() {
        return this.lastModifiedTime;
    }
}

