/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.metastore;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import oadd.org.apache.drill.metastore.ColumnStatistics;
import oadd.org.apache.drill.metastore.StatisticsKind;

public class ColumnStatisticsImpl<T>
implements ColumnStatistics<T> {
    private final Map<String, Object> statistics = new HashMap<String, Object>();
    private final Map<String, StatisticsKind> statisticsKinds = new HashMap<String, StatisticsKind>();
    private final Comparator<T> valueComparator;

    public ColumnStatisticsImpl(Map<StatisticsKind, Object> statistics, Comparator<T> valueComparator) {
        statistics.forEach((statisticsKind, value) -> {
            this.statistics.put(statisticsKind.getName(), value);
            this.statisticsKinds.put(statisticsKind.getName(), (StatisticsKind)statisticsKind);
        });
        this.valueComparator = valueComparator;
    }

    @Override
    public Object getStatistic(StatisticsKind statisticsKind) {
        return this.statistics.get(statisticsKind.getName());
    }

    @Override
    public boolean containsStatistic(StatisticsKind statisticsKind) {
        return this.statistics.containsKey(statisticsKind.getName());
    }

    @Override
    public boolean containsExactStatistics(StatisticsKind statisticsKind) {
        return this.statisticsKinds.get(statisticsKind.getName()).isExact();
    }

    @Override
    public Comparator<T> getValueComparator() {
        return this.valueComparator;
    }

    @Override
    public ColumnStatistics<T> cloneWithStats(ColumnStatistics statistics) {
        HashMap<StatisticsKind, Object> newStats = new HashMap<StatisticsKind, Object>();
        this.statistics.forEach((statisticsName, value) -> {
            StatisticsKind statisticsKind = this.statisticsKinds.get(statisticsName);
            Object statisticsValue = statistics.getStatistic(statisticsKind);
            if (statisticsValue != null && (statistics.containsExactStatistics(statisticsKind) || !statisticsKind.isExact())) {
                newStats.put(statisticsKind, statisticsValue);
            } else {
                newStats.put(statisticsKind, value);
            }
        });
        return new ColumnStatisticsImpl<T>(newStats, this.valueComparator);
    }
}

