/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.BasicTypeHelper;
import oadd.org.apache.drill.exec.expr.holders.NullableDecimal28DenseHolder;
import oadd.org.apache.drill.exec.expr.holders.RepeatedDecimal28DenseHolder;
import oadd.org.apache.drill.exec.util.DecimalUtility;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;

public class RepeatedDecimal28DenseHolderReaderImpl
extends AbstractFieldReader {
    private NullableDecimal28DenseHolder holder = new NullableDecimal28DenseHolder();
    private int index = -1;
    private RepeatedDecimal28DenseHolder repeatedHolder;

    public RepeatedDecimal28DenseHolderReaderImpl(RepeatedDecimal28DenseHolder holder) {
        this.repeatedHolder = holder;
    }

    @Override
    public int size() {
        return this.repeatedHolder.end - this.repeatedHolder.start;
    }

    @Override
    public boolean next() {
        if (this.index + 1 < this.repeatedHolder.end) {
            ++this.index;
            this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + this.index, this.holder);
            return true;
        }
        return false;
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public TypeProtos.MajorType getType() {
        return BasicTypeHelper.getType(this.holder);
    }

    @Override
    public boolean isSet() {
        return this.repeatedHolder.end != this.repeatedHolder.start;
    }

    @Override
    public BigDecimal readBigDecimal(int index) {
        this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + index, this.holder);
        BigDecimal value = this.readBigDecimal();
        if (this.index > -1) {
            this.repeatedHolder.vector.getAccessor().get(this.repeatedHolder.start + this.index, this.holder);
        }
        return value;
    }

    @Override
    public BigDecimal readBigDecimal() {
        if (!this.isSet()) {
            return null;
        }
        return DecimalUtility.getBigDecimalFromDense(this.holder.buffer, this.holder.start, 3, this.holder.scale, 28, 12);
    }

    @Override
    public Object readObject() {
        ArrayList<BigDecimal> valList = Lists.newArrayList();
        for (int i = this.repeatedHolder.start; i < this.repeatedHolder.end; ++i) {
            valList.add(this.repeatedHolder.vector.getAccessor().getObject(i));
        }
        return valList;
    }

    private Object readSingleObject() {
        if (!this.isSet()) {
            return null;
        }
        return DecimalUtility.getBigDecimalFromDense(this.holder.buffer, this.holder.start, 3, this.holder.scale, 28, 12);
    }
}

