/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.BasicTypeHelper;
import oadd.org.apache.drill.exec.expr.holders.Decimal9Holder;
import oadd.org.apache.drill.exec.expr.holders.NullableDecimal9Holder;
import oadd.org.apache.drill.exec.vector.complex.impl.AbstractFieldReader;
import oadd.org.apache.drill.exec.vector.complex.writer.Decimal9Writer;

public class Decimal9HolderReaderImpl
extends AbstractFieldReader {
    private Decimal9Holder holder;

    public Decimal9HolderReaderImpl(Decimal9Holder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public TypeProtos.MajorType getType() {
        return BasicTypeHelper.getType(this.holder);
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public void read(Decimal9Holder h2) {
        h2.value = this.holder.value;
        h2.scale = this.holder.scale;
        h2.precision = this.holder.precision;
    }

    @Override
    public void read(NullableDecimal9Holder h2) {
        h2.value = this.holder.value;
        h2.scale = this.holder.scale;
        h2.precision = this.holder.precision;
        h2.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public BigDecimal readBigDecimal() {
        BigInteger value = BigInteger.valueOf(this.holder.value);
        return new BigDecimal(value, this.holder.scale);
    }

    @Override
    public Object readObject() {
        return this.readSingleObject();
    }

    private Object readSingleObject() {
        BigInteger value = BigInteger.valueOf(this.holder.value);
        return new BigDecimal(value, this.holder.scale);
    }

    @Override
    public void copyAsValue(Decimal9Writer writer) {
        writer.write(this.holder);
    }
}

