/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.complex.impl;

import java.util.Iterator;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.expr.holders.UnionHolder;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.vector.UntypedNullHolder;
import oadd.org.apache.drill.exec.vector.complex.impl.ComplexCopier;
import oadd.org.apache.drill.exec.vector.complex.impl.UnionWriter;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import oadd.org.apache.drill.exec.vector.complex.writer.BaseWriter;
import oadd.org.apache.drill.exec.vector.complex.writer.FieldWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractBaseReader
implements FieldReader {
    static final Logger logger = LoggerFactory.getLogger(AbstractBaseReader.class);
    private int index;

    @Override
    public void setPosition(int index) {
        this.index = index;
    }

    int idx() {
        return this.index;
    }

    @Override
    public void reset() {
        this.index = 0;
    }

    @Override
    public Iterator<String> iterator() {
        throw new IllegalStateException("The current reader doesn't support reading as a map.");
    }

    @Override
    public TypeProtos.MajorType getType() {
        throw new IllegalStateException("The current reader doesn't support getting type information.");
    }

    @Override
    public MaterializedField getField() {
        return MaterializedField.create("unknown", Types.LATE_BIND_TYPE);
    }

    @Override
    public boolean next() {
        throw new IllegalStateException("The current reader doesn't support getting next information.");
    }

    @Override
    public int size() {
        throw new IllegalStateException("The current reader doesn't support getting size information.");
    }

    @Override
    public void read(UnionHolder holder) {
        holder.reader = this;
        holder.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public void read(int index, UnionHolder holder) {
        throw new IllegalStateException("The current reader doesn't support reading union type");
    }

    @Override
    public void read(UntypedNullHolder holder) {
        throw new IllegalStateException("The current reader doesn't support reading untyped null");
    }

    @Override
    public void read(int index, UntypedNullHolder holder) {
        throw new IllegalStateException("The current reader doesn't support reading untyped null");
    }

    @Override
    public void copyAsValue(UnionWriter writer) {
        throw new IllegalStateException("The current reader doesn't support reading union type");
    }

    @Override
    public void copyAsValue(BaseWriter.ListWriter writer) {
        ComplexCopier.copy(this, (FieldWriter)writer);
    }

    @Override
    public String getTypeString() {
        return this.getType().getMinorType().name();
    }
}

