/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor.writer;

import java.util.List;
import java.util.Map;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.vector.accessor.ColumnWriterIndex;
import oadd.org.apache.drill.exec.vector.accessor.impl.HierarchicalFormatter;
import oadd.org.apache.drill.exec.vector.accessor.writer.AbstractObjectWriter;
import oadd.org.apache.drill.exec.vector.accessor.writer.AbstractTupleWriter;
import oadd.org.apache.drill.exec.vector.complex.DictVector;

public class DictEntryWriter
extends AbstractTupleWriter {
    private final ColumnMetadata dictColumnSchema;

    public static DictEntryObjectWriter buildDictEntryWriter(ColumnMetadata schema, List<AbstractObjectWriter> keyValueWriters, DictVector vector) {
        DictEntryWriter dictEntryWriter = vector != null ? new DictEntryWriter(schema, keyValueWriters) : new DummyDictEntryWriter(schema, keyValueWriters);
        return new DictEntryObjectWriter(dictEntryWriter);
    }

    public DictEntryWriter(ColumnMetadata schema, List<AbstractObjectWriter> writers) {
        super(schema.tupleSchema(), writers);
        this.dictColumnSchema = schema;
    }

    @Override
    public void bindIndex(ColumnWriterIndex index) {
        this.bindIndex(index, new AbstractTupleWriter.MemberWriterIndex(index));
    }

    @Override
    public ColumnMetadata schema() {
        return this.dictColumnSchema;
    }

    @Override
    public void setObject(Object value) {
        if (value instanceof Map.Entry) {
            Map.Entry entry = (Map.Entry)value;
            this.set(0, entry.getKey());
            this.set(1, entry.getValue());
        } else {
            super.setObject(value);
        }
    }

    private static class DummyDictEntryWriter
    extends DictEntryWriter {
        DummyDictEntryWriter(ColumnMetadata schema, List<AbstractObjectWriter> writers) {
            super(schema, writers);
        }
    }

    public static class DictEntryObjectWriter
    extends AbstractTupleWriter.TupleObjectWriter {
        public DictEntryObjectWriter(DictEntryWriter entryWriter) {
            super(entryWriter);
        }

        void setKeyValue(Object key, Object value) {
            this.tupleWriter.set(0, key);
            this.tupleWriter.set(1, value);
        }

        @Override
        public void dump(HierarchicalFormatter format) {
            format.startObject(this).attribute("dictEntryWriter");
            this.tupleWriter.dump(format);
            format.endObject();
        }
    }
}

