/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor.convert;

import java.util.Map;
import java.util.function.Function;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.record.metadata.ColumnMetadata;
import oadd.org.apache.drill.exec.vector.accessor.ScalarWriter;
import oadd.org.apache.drill.exec.vector.accessor.convert.AbstractWriteConverter;
import org.apache.drill.shaded.guava.com.google.common.base.Charsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConvertFromString
extends AbstractWriteConverter {
    public static final String BLANK_ACTION_PROP = "blank-as";
    public static final String BLANK_AS_NULL = "null";
    public static final String BLANK_AS_ZERO = "0";
    public static final String BLANK_AS_SKIP = "skip";
    protected static final Logger logger = LoggerFactory.getLogger(AbstractConvertFromString.class);
    protected final Function<String, String> prepare;

    public AbstractConvertFromString(ScalarWriter baseWriter) {
        this(baseWriter, null);
    }

    public AbstractConvertFromString(ScalarWriter baseWriter, Map<String, String> properties) {
        super(baseWriter);
        this.prepare = this.buildPrepare(baseWriter.schema(), properties);
    }

    private Function<String, String> buildPrepare(ColumnMetadata schema, Map<String, String> properties) {
        String blankProp = schema.property("drill.blank-as");
        if (blankProp == null && properties != null) {
            blankProp = properties.get(BLANK_ACTION_PROP);
        }
        if (blankProp != null) {
            switch (blankProp.toLowerCase()) {
                case "null": {
                    return this.skipBlankFn(schema);
                }
                case "0": {
                    return this.blankAsZeroFn(schema);
                }
                case "skip": {
                    if (schema.isNullable()) {
                        return this.blankToNullFn();
                    }
                    return this.blankAsZeroFn(schema);
                }
            }
            logger.warn("Invalid conversion option '{}', skipping", (Object)blankProp);
        }
        if (schema.isNullable()) {
            return this.nullableStrFn();
        }
        return AbstractConvertFromString.skipBlanksFn();
    }

    private Function<String, String> blankAsZeroFn(ColumnMetadata schema) {
        if (!Types.isNumericType(schema.type())) {
            return this.skipBlankFn(schema);
        }
        if (schema.isNullable()) {
            return this.nullableBlankToZeroFn();
        }
        return this.blankToZeroFn();
    }

    private Function<String, String> skipBlankFn(ColumnMetadata schema) {
        if (schema.isNullable()) {
            return this.blankToNullFn();
        }
        return this.skipBlankFn();
    }

    private static Function<String, String> skipBlanksFn() {
        return s2 -> s2 == null ? s2 : s2.trim();
    }

    private Function<String, String> nullableStrFn() {
        return s2 -> {
            if (s2 == null) {
                this.setNull();
                return null;
            }
            return s2.trim();
        };
    }

    private Function<String, String> blankToNullFn() {
        return s2 -> {
            if (s2 == null) {
                this.setNull();
                return null;
            }
            if ((s2 = s2.trim()).isEmpty()) {
                this.setNull();
                return null;
            }
            return s2;
        };
    }

    private Function<String, String> skipBlankFn() {
        return s2 -> {
            if (s2 == null) {
                return null;
            }
            return (s2 = s2.trim()).isEmpty() ? null : s2;
        };
    }

    private Function<String, String> nullableBlankToZeroFn() {
        return s2 -> {
            if (s2 == null) {
                this.setNull();
                return null;
            }
            return (s2 = s2.trim()).isEmpty() ? BLANK_AS_ZERO : s2;
        };
    }

    private Function<String, String> blankToZeroFn() {
        return s2 -> {
            if (s2 == null) {
                return null;
            }
            return (s2 = s2.trim()).isEmpty() ? BLANK_AS_ZERO : s2;
        };
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.setNull();
        } else {
            this.setString((String)value);
        }
    }

    @Override
    public void setBytes(byte[] bytes, int length) {
        this.setString(new String(bytes, 0, length, Charsets.UTF_8));
    }
}

