/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector.accessor;

import java.io.InputStream;
import java.math.BigDecimal;
import oadd.io.netty.buffer.ByteBufInputStream;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.expr.holders.VarDecimalHolder;
import oadd.org.apache.drill.exec.vector.VarDecimalVector;
import oadd.org.apache.drill.exec.vector.accessor.AbstractSqlAccessor;

public class VarDecimalAccessor
extends AbstractSqlAccessor {
    private static final TypeProtos.MajorType TYPE = Types.required(TypeProtos.MinorType.VARDECIMAL);
    private final VarDecimalVector.Accessor ac;

    public VarDecimalAccessor(VarDecimalVector vector) {
        this.ac = vector.getAccessor();
    }

    @Override
    public TypeProtos.MajorType getType() {
        return TYPE;
    }

    @Override
    public boolean isNull(int index) {
        return false;
    }

    @Override
    public Class<?> getObjectClass() {
        return BigDecimal.class;
    }

    @Override
    public Object getObject(int index) {
        return this.ac.getObject(index);
    }

    @Override
    public InputStream getStream(int index) {
        VarDecimalHolder h2 = new VarDecimalHolder();
        this.ac.get(index, h2);
        return new ByteBufInputStream(h2.buffer.slice(h2.start, h2.end));
    }

    @Override
    public byte[] getBytes(int index) {
        return this.ac.get(index);
    }

    @Override
    public String getString(int index) {
        BigDecimal bd = this.getBigDecimal(index);
        return bd.toString();
    }

    @Override
    public BigDecimal getBigDecimal(int index) {
        return this.ac.getObject(index);
    }
}

