/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.expr.holders.ObjectHolder;
import oadd.org.apache.drill.exec.memory.AllocationManager;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.vector.BaseValueVector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;

public class ObjectVector
extends BaseValueVector {
    private final int ALLOCATION_SIZE = 4096;
    private final Accessor accessor = new Accessor();
    private final Mutator mutator = new Mutator();
    private int maxCount = 0;
    private int count = 0;
    private List<Object[]> objectArrayList = new ArrayList<Object[]>();

    public ObjectVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
    }

    public void addNewArray() {
        this.objectArrayList.add(new Object[4096]);
        this.maxCount += 4096;
    }

    @Override
    public FieldReader getReader() {
        throw new UnsupportedOperationException("ObjectVector does not support this");
    }

    @Override
    public void setInitialCapacity(int numRecords) {
    }

    @Override
    public void allocateNew() throws OutOfMemoryException {
        this.addNewArray();
    }

    public void allocateNew(int valueCount) throws OutOfMemoryException {
        while (this.maxCount < valueCount) {
            this.addNewArray();
        }
    }

    @Override
    public boolean allocateNewSafe() {
        this.allocateNew();
        return true;
    }

    @Override
    public int getBufferSize() {
        throw new UnsupportedOperationException("ObjectVector does not support this");
    }

    @Override
    public int getAllocatedSize() {
        return 0;
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        throw new UnsupportedOperationException("ObjectVector does not support this");
    }

    @Override
    public void close() {
        this.clear();
    }

    @Override
    public void clear() {
        this.objectArrayList.clear();
        this.maxCount = 0;
        this.count = 0;
    }

    @Override
    public MaterializedField getField() {
        return this.field;
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        throw new UnsupportedOperationException("ObjectVector does not support this");
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        throw new UnsupportedOperationException("ObjectVector does not support this");
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        throw new UnsupportedOperationException("ObjectVector does not support this");
    }

    @Override
    public void copyEntry(int toIndex, ValueVector from, int fromIndex) {
        throw new UnsupportedOperationException("ObjectVector does not support this");
    }

    @Override
    public int getValueCapacity() {
        return this.maxCount;
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public DrillBuf[] getBuffers(boolean clear) {
        throw new UnsupportedOperationException("ObjectVector does not support this");
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        throw new UnsupportedOperationException("ObjectVector does not support this");
    }

    @Override
    public UserBitShared.SerializedField getMetadata() {
        throw new UnsupportedOperationException("ObjectVector does not support this");
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public Iterator<ValueVector> iterator() {
        throw new UnsupportedOperationException("ObjectVector does not support this");
    }

    @Override
    public void toNullable(ValueVector nullableVector) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void collectLedgers(Set<AllocationManager.BufferLedger> ledgers) {
    }

    @Override
    public int getPayloadByteCount(int valueCount) {
        return 0;
    }

    @Override
    public void exchange(ValueVector other) {
        ObjectVector target = (ObjectVector)other;
        List<Object[]> tempList = this.objectArrayList;
        this.objectArrayList = target.objectArrayList;
        target.objectArrayList = tempList;
        int tempCount = this.count;
        this.count = target.count;
        target.count = tempCount;
        tempCount = this.maxCount;
        this.maxCount = target.maxCount;
        target.maxCount = tempCount;
    }

    public final class Accessor
    extends BaseValueVector.BaseAccessor {
        @Override
        public Object getObject(int index) {
            int listOffset = index / 4096;
            if (listOffset >= ObjectVector.this.objectArrayList.size()) {
                ObjectVector.this.addNewArray();
            }
            return ((Object[])ObjectVector.this.objectArrayList.get(listOffset))[index % 4096];
        }

        @Override
        public int getValueCount() {
            return ObjectVector.this.count;
        }

        public Object get(int index) {
            return this.getObject(index);
        }

        public void get(int index, ObjectHolder holder) {
            holder.obj = this.getObject(index);
        }
    }

    public final class Mutator
    implements ValueVector.Mutator {
        public void set(int index, Object obj) {
            int listOffset = index / 4096;
            if (listOffset >= ObjectVector.this.objectArrayList.size()) {
                ObjectVector.this.addNewArray();
            }
            ((Object[])((ObjectVector)ObjectVector.this).objectArrayList.get((int)listOffset))[index % 4096] = obj;
        }

        public boolean setSafe(int index, long value) {
            this.set(index, value);
            return true;
        }

        protected void set(int index, ObjectHolder holder) {
            this.set(index, holder.obj);
        }

        public boolean setSafe(int index, ObjectHolder holder) {
            this.set(index, holder);
            return true;
        }

        @Override
        public void setValueCount(int valueCount) {
            ObjectVector.this.count = valueCount;
        }

        @Override
        public void reset() {
            ObjectVector.this.count = 0;
            ObjectVector.this.maxCount = 0;
            ObjectVector.this.objectArrayList = new ArrayList();
            ObjectVector.this.addNewArray();
        }

        @Override
        public void generateTestData(int values) {
        }

        @Override
        public void exchange(ValueVector.Mutator other) {
        }
    }
}

