/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.vector;

import oadd.io.netty.buffer.DrillBuf;
import oadd.org.apache.drill.common.exceptions.DrillRuntimeException;
import oadd.org.apache.drill.exec.exception.OutOfMemoryException;
import oadd.org.apache.drill.exec.exception.OversizedAllocationException;
import oadd.org.apache.drill.exec.expr.holders.IntervalYearHolder;
import oadd.org.apache.drill.exec.expr.holders.NullableIntervalYearHolder;
import oadd.org.apache.drill.exec.memory.BufferAllocator;
import oadd.org.apache.drill.exec.proto.UserBitShared;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.TransferPair;
import oadd.org.apache.drill.exec.vector.BaseDataValueVector;
import oadd.org.apache.drill.exec.vector.BaseValueVector;
import oadd.org.apache.drill.exec.vector.DateUtilities;
import oadd.org.apache.drill.exec.vector.FixedWidthVector;
import oadd.org.apache.drill.exec.vector.NullableIntervalYearVector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.VectorTrimmer;
import oadd.org.apache.drill.exec.vector.complex.impl.IntervalYearReaderImpl;
import oadd.org.apache.drill.exec.vector.complex.reader.FieldReader;
import oadd.org.joda.time.Period;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IntervalYearVector
extends BaseDataValueVector
implements FixedWidthVector {
    private static final Logger logger = LoggerFactory.getLogger(IntervalYearVector.class);
    public static final int VALUE_WIDTH = 4;
    public static final int MAX_VALUE_COUNT = MAX_BUFFER_SIZE / 4;
    public static final int MAX_SCALAR_COUNT = Math.min(65536, MAX_VALUE_COUNT);
    public static final int NET_MAX_SCALAR_SIZE = 4 * MAX_SCALAR_COUNT;
    private final FieldReader reader = new IntervalYearReaderImpl(this);
    private final Accessor accessor = new Accessor();
    private final Mutator mutator = new Mutator();
    private int allocationSizeInBytes = Math.min(16384, MAX_BUFFER_SIZE);
    private int allocationMonitor = 0;

    public IntervalYearVector(MaterializedField field, BufferAllocator allocator) {
        super(field, allocator);
    }

    @Override
    public FieldReader getReader() {
        return this.reader;
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        return valueCount * 4;
    }

    @Override
    public int getValueCapacity() {
        return this.data.capacity() / 4;
    }

    @Override
    public Accessor getAccessor() {
        return this.accessor;
    }

    @Override
    public Mutator getMutator() {
        return this.mutator;
    }

    @Override
    public void setInitialCapacity(int valueCount) {
        long size = (long)valueCount * 4L;
        if (size > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed allocation size");
        }
        this.allocationSizeInBytes = (int)size;
    }

    @Override
    public void allocateNew() {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryException("Failure while allocating buffer.");
        }
    }

    @Override
    public boolean allocateNewSafe() {
        long curAllocationSize = this.allocationSizeInBytes;
        if (this.allocationMonitor > 10) {
            curAllocationSize = Math.max(8L, curAllocationSize / 2L);
            this.allocationMonitor = 0;
        } else if (this.allocationMonitor < -2) {
            curAllocationSize = (long)this.allocationSizeInBytes * 2L;
            this.allocationMonitor = 0;
        }
        try {
            this.allocateBytes(curAllocationSize);
        }
        catch (DrillRuntimeException ex) {
            return false;
        }
        return true;
    }

    @Override
    public void allocateNew(int valueCount) {
        this.allocateBytes(valueCount * 4);
    }

    @Override
    public void reset() {
        this.allocationSizeInBytes = 4096;
        this.allocationMonitor = 0;
        this.zeroVector();
        super.reset();
    }

    private void allocateBytes(long size) {
        if (size > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Requested amount of memory is more than max allowed allocation size");
        }
        int curSize = (int)size;
        this.clear();
        this.data = this.allocator.buffer(curSize);
        this.data.readerIndex(0);
        this.allocationSizeInBytes = curSize;
    }

    public void reAlloc() {
        long newAllocationSize;
        int currentCapacity = this.data.capacity();
        for (newAllocationSize = this.allocationSizeInBytes == 0 ? 256L : (long)this.allocationSizeInBytes * 2L; newAllocationSize < (long)currentCapacity; newAllocationSize *= 2L) {
        }
        if (newAllocationSize > Integer.MAX_VALUE) {
            throw new OversizedAllocationException("Unable to expand the buffer. Max allowed buffer size is reached.");
        }
        this.reallocRaw((int)newAllocationSize);
        this.data.setZero(currentCapacity, this.data.capacity() - currentCapacity);
    }

    @Override
    public DrillBuf reallocRaw(int newAllocationSize) {
        logger.debug("Reallocating vector [{}]. # of bytes: [{}] -> [{}]", this.field, this.allocationSizeInBytes, newAllocationSize);
        if (newAllocationSize == 0) {
            throw new IllegalStateException("Attempt to reAlloc a zero-sized vector");
        }
        DrillBuf newBuf = this.allocator.buffer(newAllocationSize);
        newBuf.setBytes(0, this.data, 0, this.data.capacity());
        newBuf.writerIndex(this.data.writerIndex());
        this.data.release(1);
        this.data = newBuf;
        this.allocationSizeInBytes = newAllocationSize;
        return newBuf;
    }

    @Override
    public void zeroVector() {
        this.data.setZero(0, this.data.capacity());
    }

    @Override
    public void load(UserBitShared.SerializedField metadata, DrillBuf buffer) {
        Preconditions.checkArgument(this.field.getName().equals(metadata.getNamePart().getName()), "The field %s doesn't match the provided metadata %s.", (Object)this.field, (Object)metadata);
        int actualLength = metadata.getBufferLength();
        int valueCount = metadata.getValueCount();
        int expectedLength = valueCount * 4;
        assert (actualLength == expectedLength) : String.format("Expected to load %d bytes but actually loaded %d bytes", expectedLength, actualLength);
        this.clear();
        if (this.data != null) {
            this.data.release(1);
        }
        this.data = buffer.slice(0, actualLength);
        this.data.retain(1);
        this.data.writerIndex(actualLength);
    }

    @Override
    public TransferPair getTransferPair(BufferAllocator allocator) {
        return new TransferImpl(this.getField(), allocator);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(this.getField().withPath(ref), allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((IntervalYearVector)to);
    }

    public void transferTo(IntervalYearVector target) {
        target.clear();
        target.data = this.data.transferOwnership((BufferAllocator)target.allocator).buffer;
        target.data.writerIndex(this.data.writerIndex());
        this.clear();
    }

    public void splitAndTransferTo(int startIndex, int length, IntervalYearVector target) {
        int startPoint = startIndex * 4;
        int sliceLength = length * 4;
        target.clear();
        target.data = this.data.slice((int)startPoint, (int)sliceLength).transferOwnership((BufferAllocator)target.allocator).buffer;
        target.data.writerIndex(sliceLength);
    }

    @Override
    public int getPayloadByteCount(int valueCount) {
        return valueCount * 4;
    }

    @Override
    public int getValueWidth() {
        return 4;
    }

    public void copyFrom(int fromIndex, int thisIndex, IntervalYearVector from) {
        this.data.setInt(thisIndex * 4, from.data.getInt(fromIndex * 4));
    }

    public void copyFromSafe(int fromIndex, int thisIndex, IntervalYearVector from) {
        while (thisIndex >= this.getValueCapacity()) {
            this.reAlloc();
        }
        this.copyFrom(fromIndex, thisIndex, from);
    }

    @Override
    public void copyEntry(int toIndex, ValueVector from, int fromIndex) {
        this.copyFromSafe(fromIndex, toIndex, (IntervalYearVector)from);
    }

    public void decrementAllocationMonitor() {
        if (this.allocationMonitor > 0) {
            this.allocationMonitor = 0;
        }
        --this.allocationMonitor;
    }

    private void incrementAllocationMonitor() {
        ++this.allocationMonitor;
    }

    @Override
    public void toNullable(ValueVector nullableVector) {
        NullableIntervalYearVector dest = (NullableIntervalYearVector)nullableVector;
        dest.getMutator().fromNotNullable(this);
    }

    public final class Mutator
    extends BaseValueVector.BaseMutator {
        private Mutator() {
        }

        public void set(int index, int value) {
            IntervalYearVector.this.data.setInt(index * 4, value);
        }

        public void setSafe(int index, int value) {
            while (index >= IntervalYearVector.this.getValueCapacity()) {
                IntervalYearVector.this.reAlloc();
            }
            this.set(index, value);
        }

        protected void set(int index, IntervalYearHolder holder) {
            IntervalYearVector.this.data.setInt(index * 4, holder.value);
        }

        public void setSafe(int index, IntervalYearHolder holder) {
            while (index >= IntervalYearVector.this.getValueCapacity()) {
                IntervalYearVector.this.reAlloc();
            }
            this.set(index, holder);
        }

        protected void set(int index, NullableIntervalYearHolder holder) {
            IntervalYearVector.this.data.setInt(index * 4, holder.value);
        }

        public void setSafe(int index, NullableIntervalYearHolder holder) {
            while (index >= IntervalYearVector.this.getValueCapacity()) {
                IntervalYearVector.this.reAlloc();
            }
            this.set(index, holder);
        }

        @Override
        public void generateTestData(int size) {
            this.setValueCount(size);
            boolean even = true;
            int valueCount = IntervalYearVector.this.getAccessor().getValueCount();
            for (int i = 0; i < valueCount; ++i) {
                if (even) {
                    this.set(i, Integer.MIN_VALUE);
                } else {
                    this.set(i, Integer.MAX_VALUE);
                }
                even = !even;
            }
        }

        public void generateTestDataAlt(int size) {
            this.setValueCount(size);
            boolean even = true;
            int valueCount = IntervalYearVector.this.getAccessor().getValueCount();
            for (int i = 0; i < valueCount; ++i) {
                if (even) {
                    this.set(i, 1);
                } else {
                    this.set(i, 0);
                }
                even = !even;
            }
        }

        @Override
        public void setValueCount(int valueCount) {
            int currentValueCapacity = IntervalYearVector.this.getValueCapacity();
            int idx = 4 * valueCount;
            while (valueCount > IntervalYearVector.this.getValueCapacity()) {
                IntervalYearVector.this.reAlloc();
            }
            if (valueCount > 0 && currentValueCapacity > valueCount * 2) {
                IntervalYearVector.this.incrementAllocationMonitor();
            } else if (IntervalYearVector.this.allocationMonitor > 0) {
                IntervalYearVector.this.allocationMonitor = 0;
            }
            VectorTrimmer.trim(IntervalYearVector.this.data, idx);
            IntervalYearVector.this.data.writerIndex(valueCount * 4);
        }
    }

    public final class Accessor
    extends BaseValueVector.BaseAccessor {
        @Override
        public int getValueCount() {
            return IntervalYearVector.this.data.writerIndex() / 4;
        }

        @Override
        public boolean isNull(int index) {
            return false;
        }

        public int get(int index) {
            return IntervalYearVector.this.data.getInt(index * 4);
        }

        public long getTwoAsLong(int index) {
            return IntervalYearVector.this.data.getLong(index * 4);
        }

        @Override
        public Period getObject(int index) {
            return DateUtilities.fromIntervalYear(this.get(index));
        }

        public StringBuilder getAsStringBuilder(int index) {
            int value = this.get(index);
            return DateUtilities.intervalYearStringBuilder(value);
        }

        public void get(int index, IntervalYearHolder holder) {
            holder.value = IntervalYearVector.this.data.getInt(index * 4);
        }

        public void get(int index, NullableIntervalYearHolder holder) {
            holder.isSet = 1;
            holder.value = IntervalYearVector.this.data.getInt(index * 4);
        }
    }

    private class TransferImpl
    implements TransferPair {
        private IntervalYearVector to;

        public TransferImpl(MaterializedField field, BufferAllocator allocator) {
            this.to = new IntervalYearVector(field, allocator);
        }

        public TransferImpl(IntervalYearVector to) {
            this.to = to;
        }

        @Override
        public IntervalYearVector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            IntervalYearVector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            IntervalYearVector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, IntervalYearVector.this);
        }
    }
}

