/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oadd.org.apache.drill.common.map.CaseInsensitiveMap;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.exec.expr.TypeHelper;
import oadd.org.apache.drill.exec.memory.AllocationManager;
import oadd.org.apache.drill.exec.memory.BaseAllocator;
import oadd.org.apache.drill.exec.record.BatchSchema;
import oadd.org.apache.drill.exec.record.MaterializedField;
import oadd.org.apache.drill.exec.record.RecordBatch;
import oadd.org.apache.drill.exec.record.VectorAccessible;
import oadd.org.apache.drill.exec.record.VectorContainer;
import oadd.org.apache.drill.exec.record.VectorInitializer;
import oadd.org.apache.drill.exec.record.VectorWrapper;
import oadd.org.apache.drill.exec.record.selection.SelectionVector2;
import oadd.org.apache.drill.exec.vector.AllocationHelper;
import oadd.org.apache.drill.exec.vector.NullableVector;
import oadd.org.apache.drill.exec.vector.UInt4Vector;
import oadd.org.apache.drill.exec.vector.UntypedNullVector;
import oadd.org.apache.drill.exec.vector.ValueVector;
import oadd.org.apache.drill.exec.vector.VariableWidthVector;
import oadd.org.apache.drill.exec.vector.complex.AbstractMapVector;
import oadd.org.apache.drill.exec.vector.complex.AbstractRepeatedMapVector;
import oadd.org.apache.drill.exec.vector.complex.RepeatedListVector;
import oadd.org.apache.drill.exec.vector.complex.RepeatedValueVector;
import oadd.org.apache.drill.exec.vector.complex.RepeatedVariableWidthVectorLike;
import org.apache.drill.shaded.guava.com.google.common.collect.Sets;
import org.bouncycastle.util.Strings;

public class RecordBatchSizer {
    private static final int OFFSET_VECTOR_WIDTH = 4;
    private static final int BIT_VECTOR_WIDTH = 1;
    private Map<String, ColumnSize> columnSizes = new QuoteInsensitiveMap(CaseInsensitiveMap.newHashMap());
    private List<ColumnSize> columnSizesList = new ArrayList<ColumnSize>();
    private int rowCount;
    private long accountedMemorySize;
    private int grossRowWidth;
    private int netRowWidth;
    private int netRowWidthCap50;
    private int rowAllocWidth;
    private int stdRowWidth;
    public SelectionVector2 sv2 = null;
    private int sv2Size;
    private int avgDensity;
    private Set<AllocationManager.BufferLedger> ledgers = Sets.newIdentityHashSet();
    private long netBatchSize;
    public int maxSize;
    public int nullableCount;

    public static long multiplyByFactors(long size, double ... factors) {
        double doubleSize = size;
        for (double factor : factors) {
            doubleSize *= factor;
        }
        return (long)doubleSize;
    }

    public static long multiplyByFactor(long size, double factor) {
        return (long)((double)size * factor);
    }

    public static int getStdNetSizePerEntryCommon(TypeProtos.MajorType majorType, boolean isOptional, boolean isRepeated, boolean isRepeatedList, Map<String, ColumnSize> children) {
        int stdNetSize;
        try {
            stdNetSize = TypeHelper.getSize(majorType);
        }
        catch (Exception e) {
            stdNetSize = 0;
        }
        if (isOptional) {
            ++stdNetSize;
        }
        if (isRepeated) {
            stdNetSize = stdNetSize * 5 + 4;
        }
        if (children != null) {
            for (ColumnSize columnSize : children.values()) {
                stdNetSize += columnSize.getStdNetSizePerEntry();
            }
        }
        if (isRepeatedList) {
            stdNetSize = stdNetSize * 5 + 4;
        }
        return stdNetSize;
    }

    private ColumnSize getComplexColumn(String path) {
        String[] segments = Strings.split((String)path, (char)'.');
        Map<String, ColumnSize> map = this.columnSizes;
        return this.getComplexColumnImpl(segments, 0, map);
    }

    private ColumnSize getComplexColumnImpl(String[] segments, int level, Map<String, ColumnSize> map) {
        ColumnSize result = map.get(segments[level]);
        if (result == null || level == segments.length - 1) {
            return result;
        }
        map = result.getChildren();
        if (map == null) {
            return null;
        }
        return this.getComplexColumnImpl(segments, level + 1, map);
    }

    public ColumnSize getColumn(String name) {
        ColumnSize columnSize = this.columnSizes.get(name);
        if (columnSize != null) {
            return columnSize;
        }
        return this.getComplexColumn(name);
    }

    public RecordBatchSizer(RecordBatch batch) {
        this(batch, batch.getSchema() == null ? null : (batch.getSchema().getSelectionVectorMode() == BatchSchema.SelectionVectorMode.TWO_BYTE ? batch.getSelectionVector2() : null));
    }

    public RecordBatchSizer(VectorAccessible va) {
        this(va, null);
    }

    public RecordBatchSizer(VectorAccessible va, SelectionVector2 sv2) {
        this.rowCount = va.getRecordCount();
        for (VectorWrapper vw : va) {
            ColumnSize colSize = this.measureColumn((ValueVector)vw.getValueVector(), "");
            this.columnSizes.put(vw.getField().getName(), colSize);
            this.columnSizesList.add(colSize);
            this.stdRowWidth += colSize.getStdDataSizePerEntry();
            this.netBatchSize += (long)colSize.getTotalNetSize();
            this.maxSize = Math.max(this.maxSize, colSize.getTotalDataSize());
            if (colSize.metadata.isNullable()) {
                ++this.nullableCount;
            }
            this.netRowWidth += colSize.getNetSizePerEntry();
        }
        this.sv2 = sv2;
    }

    public void applySv2() {
        if (this.sv2 == null) {
            return;
        }
        this.sv2Size = BaseAllocator.nextPowerOfTwo(2 * this.rowCount);
        this.avgDensity = RecordBatchSizer.safeDivide(this.netBatchSize * 100L, this.getActualSize());
        this.accountedMemorySize += (long)this.sv2Size;
    }

    private int roundUpToPowerOf2(int arg) {
        if (arg <= 2) {
            return 2;
        }
        if (arg <= 4) {
            return 4;
        }
        if (arg <= 8) {
            return 8;
        }
        if (arg <= 16) {
            return 16;
        }
        if (arg <= 32) {
            return 32;
        }
        return 64;
    }

    private ColumnSize measureColumn(ValueVector v, String prefix) {
        ColumnSize colSize = new ColumnSize(v, prefix);
        switch (v.getField().getType().getMinorType()) {
            case MAP: 
            case DICT: {
                this.expandMap(colSize, v, prefix + v.getField().getName() + ".");
                break;
            }
            case LIST: {
                if (v.getField().getDataMode() != TypeProtos.DataMode.REPEATED) break;
                this.expandList(colSize, (RepeatedListVector)v, prefix + v.getField().getName() + ".");
                break;
            }
            default: {
                v.collectLedgers(this.ledgers);
            }
        }
        this.netRowWidthCap50 += !colSize.isVariableWidth ? colSize.getNetSizePerEntry() : 8 + this.roundUpToPowerOf2(Math.min(colSize.getNetSizePerEntry(), 50));
        return colSize;
    }

    private void expandMap(ColumnSize colSize, ValueVector mapVector, String prefix) {
        for (ValueVector vector : mapVector) {
            colSize.children.put(vector.getField().getName(), this.measureColumn(vector, prefix));
        }
        if (mapVector.getField().getDataMode() == TypeProtos.DataMode.REPEATED) {
            ((RepeatedValueVector)mapVector).getOffsetVector().collectLedgers(this.ledgers);
        }
    }

    private void expandList(ColumnSize colSize, RepeatedListVector vector, String prefix) {
        colSize.children.put(vector.getField().getName(), this.measureColumn(vector.getDataVector(), prefix));
        vector.collectLedgers(this.ledgers);
    }

    public static int safeDivide(long num, long denom) {
        if (denom == 0L) {
            return 0;
        }
        return (int)Math.ceil((double)num / (double)denom);
    }

    public static int safeDivide(int num, int denom) {
        if (denom == 0) {
            return 0;
        }
        return (int)Math.ceil((double)num / (double)denom);
    }

    public static int safeDivide(int num, float denom) {
        if (denom == 0.0f) {
            return 0;
        }
        return (int)Math.ceil((double)num / (double)denom);
    }

    public static int safeDivide(int num, double denom) {
        if (denom == 0.0) {
            return 0;
        }
        return (int)Math.ceil((double)num / denom);
    }

    public int rowCount() {
        return this.rowCount;
    }

    public int getStdRowWidth() {
        if (this.stdRowWidth != 0) {
            return this.stdRowWidth;
        }
        for (ColumnSize columnSize : this.columnSizes.values()) {
            this.stdRowWidth += columnSize.getStdDataSizePerEntry();
        }
        return this.stdRowWidth;
    }

    public int getRowAllocWidth() {
        if (this.rowAllocWidth != 0) {
            return this.rowAllocWidth;
        }
        for (ColumnSize columnSize : this.columnSizes.values()) {
            this.rowAllocWidth += columnSize.getAllocSizePerEntry();
        }
        return this.rowAllocWidth;
    }

    public long getActualSize() {
        if (this.accountedMemorySize != 0L) {
            return this.accountedMemorySize;
        }
        for (AllocationManager.BufferLedger ledger : this.ledgers) {
            this.accountedMemorySize += (long)ledger.getAccountedSize();
        }
        if (this.sv2 != null) {
            this.sv2Size = this.sv2.getBuffer(false).capacity();
            this.accountedMemorySize += (long)this.sv2Size;
        }
        return this.accountedMemorySize;
    }

    public int getGrossRowWidth() {
        if (this.grossRowWidth != 0) {
            return this.grossRowWidth;
        }
        this.grossRowWidth = RecordBatchSizer.safeDivide(this.getActualSize(), (long)this.rowCount);
        return this.grossRowWidth;
    }

    public int getAvgDensity() {
        return RecordBatchSizer.safeDivide(this.netBatchSize * 100L, this.getActualSize());
    }

    public int getNetRowWidth() {
        return this.netRowWidth;
    }

    public Map<String, ColumnSize> columns() {
        return this.columnSizes;
    }

    public List<ColumnSize> columnsList() {
        return this.columnSizesList;
    }

    public int getNetRowWidthCap50() {
        return this.netRowWidthCap50 + this.nullableCount;
    }

    public boolean hasSv2() {
        return this.sv2 != null;
    }

    public long getNetBatchSize() {
        return this.netBatchSize;
    }

    public int getMaxAvgColumnSize() {
        return RecordBatchSizer.safeDivide(this.maxSize, this.rowCount);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Batch size: {");
        buf.append("  Records: ");
        buf.append(this.rowCount);
        buf.append(", Total size: ");
        buf.append(this.accountedMemorySize);
        buf.append(", Data size: ");
        buf.append(this.netBatchSize);
        buf.append(", Gross row width: ");
        buf.append(this.grossRowWidth);
        buf.append(", Net row width: ");
        buf.append(this.netRowWidth);
        buf.append(", Density: ");
        buf.append(this.avgDensity);
        buf.append("% }\n");
        buf.append("Batch schema & sizes: {\n");
        for (ColumnSize colSize : this.columnSizes.values()) {
            buf.append("  ");
            buf.append(colSize.toString());
            buf.append(" }\n");
        }
        buf.append(" }\n");
        return buf.toString();
    }

    public VectorInitializer buildVectorInitializer() {
        VectorInitializer initializer = new VectorInitializer();
        for (ColumnSize colSize : this.columnSizes.values()) {
            colSize.buildVectorInitializer(initializer);
        }
        return initializer;
    }

    public void allocateVectors(VectorContainer container, int recordCount) {
        for (VectorWrapper<?> w : container) {
            ColumnSize colSize = this.columnSizes.get(w.getField().getName());
            colSize.allocateVector((ValueVector)w.getValueVector(), recordCount);
        }
    }

    private static final class QuoteInsensitiveMap
    implements Map<String, ColumnSize> {
        private final Map<String, ColumnSize> originalMap;

        private QuoteInsensitiveMap(Map<String, ColumnSize> originalMap) {
            this.originalMap = originalMap;
        }

        @Override
        public int size() {
            return this.originalMap.size();
        }

        @Override
        public boolean isEmpty() {
            return this.originalMap.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.originalMap.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.originalMap.containsValue(value);
        }

        @Override
        public ColumnSize get(Object key) {
            ColumnSize value = this.originalMap.get(key);
            if (value == null) {
                value = this.originalMap.get(this.quoteString(key));
            }
            return value;
        }

        @Override
        public ColumnSize put(String key, ColumnSize value) {
            return this.originalMap.put(key, value);
        }

        @Override
        public ColumnSize remove(Object key) {
            ColumnSize value = this.originalMap.remove(key);
            if (value == null) {
                value = this.originalMap.remove(this.quoteString(key));
            }
            return value;
        }

        @Override
        public void putAll(Map<? extends String, ? extends ColumnSize> m4) {
            this.originalMap.putAll(m4);
        }

        @Override
        public void clear() {
            this.originalMap.clear();
        }

        @Override
        public Set<String> keySet() {
            return this.originalMap.keySet();
        }

        @Override
        public Collection<ColumnSize> values() {
            return this.originalMap.values();
        }

        @Override
        public Set<Map.Entry<String, ColumnSize>> entrySet() {
            return this.originalMap.entrySet();
        }

        private String quoteString(Object key) {
            if (key instanceof String) {
                return "`" + key + '`';
            }
            throw new IllegalArgumentException();
        }
    }

    public class ColumnSize {
        public final String prefix;
        public final MaterializedField metadata;
        private int totalDataSize;
        private int totalNetSize;
        private final int valueCount;
        private int elementCount;
        private float cardinality;
        private boolean isVariableWidth;
        private boolean isRepeated;
        private boolean isOptional;
        private Map<String, ColumnSize> children = CaseInsensitiveMap.newHashMap();

        public boolean hasStdDataSize() {
            return !this.isVariableWidth && !this.isRepeated;
        }

        public int getStdDataSizePerEntry() {
            int stdDataSize;
            try {
                stdDataSize = TypeHelper.getSize(this.metadata.getType());
                if (this.isVariableWidth) {
                    stdDataSize -= 4;
                }
                if (this.isRepeated) {
                    stdDataSize *= 5;
                }
            }
            catch (Exception e) {
                stdDataSize = 0;
            }
            for (ColumnSize columnSize : this.children.values()) {
                stdDataSize += columnSize.getStdDataSizePerEntry();
            }
            if (this.isRepeatedList()) {
                stdDataSize *= 5;
            }
            return stdDataSize;
        }

        public int getStdNetSizePerEntry() {
            return RecordBatchSizer.getStdNetSizePerEntryCommon(this.metadata.getType(), this.isOptional, this.isRepeated, this.isRepeatedList(), this.children);
        }

        public int getDataSizePerEntry() {
            return RecordBatchSizer.safeDivide(this.getTotalDataSize(), this.getValueCount());
        }

        public int getNetSizePerEntry() {
            return RecordBatchSizer.safeDivide(this.getTotalNetSize(), this.getValueCount());
        }

        public int getAllocSizePerEntry() {
            int stdNetSize;
            if (RecordBatchSizer.this.rowCount() != 0) {
                return this.getNetSizePerEntry();
            }
            try {
                stdNetSize = TypeHelper.getSize(this.metadata.getType());
                switch (this.metadata.getType().getMinorType()) {
                    case VARBINARY: 
                    case VARCHAR: 
                    case VAR16CHAR: 
                    case VARDECIMAL: {
                        stdNetSize = 12;
                    }
                }
            }
            catch (Exception e) {
                stdNetSize = 0;
            }
            if (this.isOptional) {
                ++stdNetSize;
            }
            if (this.isRepeated) {
                stdNetSize = stdNetSize * 5 + 4;
            }
            for (ColumnSize columnSize : this.children.values()) {
                stdNetSize += columnSize.getAllocSizePerEntry();
            }
            if (this.isRepeatedList()) {
                stdNetSize = stdNetSize * 5 + 4;
            }
            return stdNetSize;
        }

        public int getStdNetOrNetSizePerEntry() {
            if (this.hasStdDataSize()) {
                return this.getStdNetSizePerEntry();
            }
            return this.getNetSizePerEntry();
        }

        public int getTotalDataSize() {
            int dataSize = this.totalDataSize;
            for (ColumnSize columnSize : this.children.values()) {
                dataSize += columnSize.getTotalDataSize();
            }
            return dataSize;
        }

        public int getTotalNetSize() {
            return this.totalNetSize;
        }

        public int getValueCount() {
            return this.valueCount;
        }

        public int getElementCount() {
            return this.elementCount;
        }

        public float getCardinality() {
            return this.cardinality;
        }

        public boolean isVariableWidth() {
            return this.isVariableWidth;
        }

        public Map<String, ColumnSize> getChildren() {
            return this.children;
        }

        public boolean isComplex() {
            switch (this.metadata.getType().getMinorType()) {
                case LIST: 
                case MAP: 
                case DICT: 
                case UNION: {
                    return true;
                }
            }
            return false;
        }

        public boolean isRepeatedList() {
            return this.metadata.getType().getMinorType() == TypeProtos.MinorType.LIST && this.metadata.getDataMode() == TypeProtos.DataMode.REPEATED;
        }

        private int getEntryWidthForAlloc() {
            int width = 0;
            if (this.isVariableWidth) {
                width = this.getAllocSizePerEntry() - 4;
                if (this.isOptional) {
                    --width;
                }
                if (this.isRepeated && RecordBatchSizer.this.rowCount() == 0) {
                    return RecordBatchSizer.safeDivide(width, 5);
                }
            }
            return RecordBatchSizer.safeDivide(width, this.getEntryCardinalityForAlloc());
        }

        private float getEntryCardinalityForAlloc() {
            return this.getCardinality() == 0.0f ? (float)(this.isRepeated ? 5 : 1) : this.getCardinality();
        }

        public ColumnSize(ValueVector v, String prefix) {
            this.prefix = prefix;
            this.valueCount = v.getAccessor().getValueCount();
            this.metadata = v.getField();
            this.isVariableWidth = v instanceof VariableWidthVector || v instanceof RepeatedVariableWidthVectorLike;
            this.elementCount = this.valueCount;
            this.cardinality = this.valueCount == 0 ? 0.0f : 1.0f;
            this.totalNetSize = v.getPayloadByteCount(this.valueCount);
            if (this.metadata.getType().getMinorType() == TypeProtos.MinorType.UNION || this.metadata.getType().getMinorType() == TypeProtos.MinorType.LIST && v.getField().getDataMode() != TypeProtos.DataMode.REPEATED) {
                this.totalDataSize = this.totalNetSize;
            }
            switch (v.getField().getDataMode()) {
                case REPEATED: {
                    this.isRepeated = true;
                    this.elementCount = this.getElementCount(v);
                    float f = this.cardinality = this.valueCount == 0 ? 0.0f : (float)this.elementCount * 1.0f / (float)this.valueCount;
                    if (this.isComplex()) {
                        return;
                    }
                    if (this.isVariableWidth) {
                        VariableWidthVector dataVector = (VariableWidthVector)((RepeatedValueVector)v).getDataVector();
                        this.totalDataSize = dataVector.getCurrentSizeInBytes();
                        break;
                    }
                    ValueVector dataVector = ((RepeatedValueVector)v).getDataVector();
                    this.totalDataSize = dataVector.getPayloadByteCount(this.elementCount);
                    break;
                }
                case OPTIONAL: {
                    this.isOptional = true;
                    if (this.isComplex()) {
                        return;
                    }
                    if (this.isVariableWidth) {
                        VariableWidthVector variableWidthVector = (VariableWidthVector)((NullableVector)v).getValuesVector();
                        this.totalDataSize = variableWidthVector.getCurrentSizeInBytes();
                        break;
                    }
                    if (v instanceof UntypedNullVector) {
                        return;
                    }
                    this.totalDataSize = ((NullableVector)v).getValuesVector().getPayloadByteCount(this.valueCount);
                    break;
                }
                case REQUIRED: {
                    if (this.isComplex()) {
                        return;
                    }
                    if (this.isVariableWidth) {
                        this.totalDataSize = ((VariableWidthVector)v).getCurrentSizeInBytes();
                        break;
                    }
                    this.totalDataSize = v.getPayloadByteCount(this.valueCount);
                    break;
                }
            }
        }

        private int getElementCount(ValueVector v) {
            UInt4Vector offsetVector = ((RepeatedValueVector)v).getOffsetVector();
            int childCount = this.valueCount == 0 ? 0 : offsetVector.getAccessor().get(this.valueCount);
            return childCount;
        }

        private void allocateMap(AbstractMapVector map, int recordCount) {
            if (map instanceof AbstractRepeatedMapVector) {
                ((AbstractRepeatedMapVector)map).allocateOffsetsNew(recordCount);
                recordCount = (int)((float)recordCount * this.getEntryCardinalityForAlloc());
            }
            for (ValueVector vector : map) {
                this.children.get(vector.getField().getName()).allocateVector(vector, recordCount);
            }
        }

        private void allocateRepeatedList(RepeatedListVector vector, int recordCount) {
            vector.allocateOffsetsNew(recordCount);
            recordCount = (int)((float)recordCount * this.getEntryCardinalityForAlloc());
            ColumnSize child = this.children.get(vector.getField().getName());
            if (vector.getDataVector() != null) {
                child.allocateVector(vector.getDataVector(), recordCount);
            }
        }

        public void allocateVector(ValueVector vector, int recordCount) {
            if (vector instanceof AbstractMapVector) {
                this.allocateMap((AbstractMapVector)vector, recordCount);
                return;
            }
            if (vector instanceof RepeatedListVector) {
                this.allocateRepeatedList((RepeatedListVector)vector, recordCount);
                return;
            }
            AllocationHelper.allocate(vector, recordCount, this.getEntryWidthForAlloc(), this.getEntryCardinalityForAlloc());
        }

        public String toString() {
            StringBuilder buf = new StringBuilder().append(this.prefix).append(this.metadata.getName()).append("(type: ").append(this.metadata.getType().getMode().name()).append(" ").append(this.metadata.getType().getMinorType().name()).append(", count: ").append(this.valueCount);
            if (this.metadata.getDataMode() == TypeProtos.DataMode.REPEATED) {
                buf.append(", elements: ").append(this.elementCount).append(", per-array: ").append(this.cardinality);
            }
            buf.append(", Per entry: std data size: ").append(this.getStdDataSizePerEntry()).append(", std net size: ").append(this.getStdNetSizePerEntry()).append(", actual data size: ").append(this.getDataSizePerEntry()).append(", actual net size: ").append(this.getNetSizePerEntry()).append("  Totals: data size: ").append(this.getTotalDataSize()).append(", net size: ").append(this.getTotalNetSize()).append(")");
            return buf.toString();
        }

        public void buildVectorInitializer(VectorInitializer initializer) {
            int width = 0;
            switch (this.metadata.getType().getMinorType()) {
                case VARBINARY: 
                case VARCHAR: 
                case VAR16CHAR: {
                    width = this.getNetSizePerEntry() - 4;
                    if (this.metadata.getDataMode() != TypeProtos.DataMode.OPTIONAL) break;
                    --width;
                    break;
                }
            }
            String name = this.prefix + this.metadata.getName();
            if (this.metadata.getDataMode() == TypeProtos.DataMode.REPEATED) {
                if (width > 0) {
                    initializer.variableWidthArray(name, (float)width / this.cardinality, this.cardinality);
                } else {
                    initializer.fixedWidthArray(name, this.cardinality);
                }
            } else if (width > 0) {
                initializer.variableWidth(name, width);
            }
            for (ColumnSize columnSize : this.children.values()) {
                columnSize.buildVectorInitializer(initializer);
            }
        }
    }
}

