/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.record;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import oadd.org.apache.drill.common.types.TypeProtos;
import oadd.org.apache.drill.common.types.Types;
import oadd.org.apache.drill.exec.expr.BasicTypeHelper;
import oadd.org.apache.drill.exec.proto.UserBitShared;

public class MaterializedField {
    private final String name;
    private TypeProtos.MajorType type;
    private final LinkedHashSet<MaterializedField> children;

    private MaterializedField(String name, TypeProtos.MajorType type, LinkedHashSet<MaterializedField> children) {
        this.name = name;
        this.type = type;
        this.children = children;
    }

    public static MaterializedField create(UserBitShared.SerializedField serField) {
        LinkedHashSet<MaterializedField> children = new LinkedHashSet<MaterializedField>();
        for (UserBitShared.SerializedField sf : serField.getChildList()) {
            children.add(MaterializedField.create(sf));
        }
        return new MaterializedField(serField.getNamePart().getName(), serField.getMajorType(), children);
    }

    public UserBitShared.SerializedField getSerializedField() {
        UserBitShared.SerializedField.Builder serializedFieldBuilder = this.getAsBuilder();
        for (MaterializedField childMaterializedField : this.getChildren()) {
            serializedFieldBuilder.addChild(childMaterializedField.getSerializedField());
        }
        return serializedFieldBuilder.build();
    }

    public UserBitShared.SerializedField.Builder getAsBuilder() {
        return UserBitShared.SerializedField.newBuilder().setMajorType(this.type).setNamePart(UserBitShared.NamePart.newBuilder().setName(this.name).build());
    }

    public Collection<MaterializedField> getChildren() {
        return new ArrayList<MaterializedField>(this.children);
    }

    public MaterializedField newWithChild(MaterializedField child) {
        MaterializedField newField = this.clone();
        newField.addChild(child);
        return newField;
    }

    public void addChild(MaterializedField field) {
        this.children.add(field);
    }

    public void removeChild(MaterializedField field) {
        this.children.remove(field);
    }

    public void replaceType(TypeProtos.MajorType newType) {
        assert (this.type.getMinorType() == newType.getMinorType());
        assert (this.type.getMode() == newType.getMode());
        this.type = newType;
    }

    public MaterializedField clone() {
        return this.withPathAndType(this.name, this.getType());
    }

    public MaterializedField cloneEmpty() {
        return MaterializedField.create(this.name, this.type.toBuilder().clearSubType().build());
    }

    public MaterializedField withType(TypeProtos.MajorType type) {
        return this.withPathAndType(this.name, type);
    }

    public MaterializedField withPath(String name) {
        return this.withPathAndType(name, this.getType());
    }

    public MaterializedField withPathAndType(String name, TypeProtos.MajorType type) {
        LinkedHashSet<MaterializedField> newChildren = new LinkedHashSet<MaterializedField>(this.children.size());
        for (MaterializedField child : this.children) {
            newChildren.add(child.clone());
        }
        return new MaterializedField(name, type, newChildren);
    }

    public boolean matches(UserBitShared.SerializedField field) {
        MaterializedField f = MaterializedField.create(field);
        return f.equals(this);
    }

    public static MaterializedField create(String name, TypeProtos.MajorType type) {
        return new MaterializedField(name, type, new LinkedHashSet<MaterializedField>());
    }

    public String getName() {
        return this.name;
    }

    public int getWidth() {
        return this.type.getWidth();
    }

    public TypeProtos.MajorType getType() {
        return this.type;
    }

    public int getScale() {
        return this.type.getScale();
    }

    public int getPrecision() {
        return this.type.getPrecision();
    }

    public boolean isNullable() {
        return this.type.getMode() == TypeProtos.DataMode.OPTIONAL;
    }

    public TypeProtos.DataMode getDataMode() {
        return this.type.getMode();
    }

    public MaterializedField getOtherNullableVersion() {
        TypeProtos.DataMode newDataMode;
        TypeProtos.MajorType mt = this.type;
        switch (mt.getMode()) {
            case OPTIONAL: {
                newDataMode = TypeProtos.DataMode.REQUIRED;
                break;
            }
            case REQUIRED: {
                newDataMode = TypeProtos.DataMode.OPTIONAL;
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return new MaterializedField(this.name, mt.toBuilder().setMode(newDataMode).build(), this.children);
    }

    public Class<?> getValueClass() {
        return BasicTypeHelper.getValueVectorClass(this.getType().getMinorType(), this.getDataMode());
    }

    public int hashCode() {
        return Objects.hash(this.name.toLowerCase(), this.type);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MaterializedField other = (MaterializedField)obj;
        return this.name.equalsIgnoreCase(other.name) && Objects.equals(this.type, other.type);
    }

    public boolean isEquivalent(MaterializedField other) {
        if (!this.name.equalsIgnoreCase(other.name)) {
            return false;
        }
        if (!Types.isEquivalent(this.type, other.type)) {
            return false;
        }
        if (this.type.getMinorType() != TypeProtos.MinorType.MAP) {
            return true;
        }
        if (this.children == null || other.children == null) {
            return this.children == other.children;
        }
        if (this.children.size() != other.children.size()) {
            return false;
        }
        Iterator thisIter = this.children.iterator();
        Iterator otherIter = other.children.iterator();
        while (thisIter.hasNext()) {
            MaterializedField otherChild;
            MaterializedField thisChild = (MaterializedField)thisIter.next();
            if (thisChild.isEquivalent(otherChild = (MaterializedField)otherIter.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isPromotableTo(MaterializedField other, boolean allowModeChange) {
        if (!this.name.equalsIgnoreCase(other.name)) {
            return false;
        }
        if (this.type.getMinorType() != other.type.getMinorType()) {
            return false;
        }
        if (this.type.getMode() != other.type.getMode()) {
            if (!allowModeChange) {
                return false;
            }
            if (this.type.getMode() != TypeProtos.DataMode.REQUIRED || other.type.getMode() != TypeProtos.DataMode.OPTIONAL) {
                return false;
            }
        }
        if (this.type.getScale() > other.type.getScale()) {
            return false;
        }
        if (this.type.getPrecision() > other.type.getPrecision()) {
            return false;
        }
        if (this.type.getMinorType() != TypeProtos.MinorType.MAP) {
            return true;
        }
        if (this.children == null || other.children == null) {
            return this.children == other.children;
        }
        if (this.children.size() != other.children.size()) {
            return false;
        }
        Iterator thisIter = this.children.iterator();
        Iterator otherIter = other.children.iterator();
        while (thisIter.hasNext()) {
            MaterializedField otherChild;
            MaterializedField thisChild = (MaterializedField)thisIter.next();
            if (thisChild.isPromotableTo(otherChild = (MaterializedField)otherIter.next(), allowModeChange)) continue;
            return false;
        }
        return true;
    }

    public String toString(boolean includeChildren) {
        int maxLen = 10;
        StringBuilder builder = new StringBuilder();
        builder.append("[`").append(this.name).append("` (").append(this.type.getMinorType().name());
        if (this.type.hasPrecision()) {
            builder.append("(");
            builder.append(this.type.getPrecision());
            if (this.type.hasScale()) {
                builder.append(", ");
                builder.append(this.type.getScale());
            }
            builder.append(")");
        }
        builder.append(":").append(this.type.getMode().name()).append(")");
        if (includeChildren) {
            if (this.type.getSubTypeCount() > 0) {
                builder.append(", subtypes=(").append(this.type.getSubTypeList().toString()).append(")");
            }
            if (this.children != null && !this.children.isEmpty()) {
                builder.append(", children=(").append(this.toString(this.children, 10)).append(")");
            }
        }
        return builder.append("]").toString();
    }

    public String toString() {
        return this.toString(true);
    }

    private String toString(Collection<?> collection, int maxLen) {
        StringBuilder builder = new StringBuilder();
        Iterator<?> iterator = collection.iterator();
        for (int i = 0; iterator.hasNext() && i < maxLen; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(iterator.next());
        }
        return builder.toString();
    }
}

