/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.proto;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import oadd.io.protostuff.Input;
import oadd.io.protostuff.Output;
import oadd.io.protostuff.Schema;
import oadd.org.apache.drill.exec.proto.BitData;
import oadd.org.apache.drill.exec.proto.SchemaUserBitShared;
import oadd.org.apache.drill.exec.proto.UserBitShared;

public final class SchemaBitData {

    public static final class RuntimeFilterBDef {
        public static final MessageSchema WRITE = new MessageSchema();
        public static final BuilderSchema MERGE = new BuilderSchema();
        private static final HashMap<String, Integer> fieldMap = new HashMap();

        public static String getFieldName(int number) {
            switch (number) {
                case 1: {
                    return "queryId";
                }
                case 2: {
                    return "majorFragmentId";
                }
                case 3: {
                    return "minorFragmentId";
                }
                case 4: {
                    return "toForeman";
                }
                case 5: {
                    return "bloomFilterSizeInBytes";
                }
                case 6: {
                    return "probeFields";
                }
                case 7: {
                    return "hjOpId";
                }
                case 8: {
                    return "rfIdentifier";
                }
            }
            return null;
        }

        public static int getFieldNumber(String name) {
            Integer number = fieldMap.get(name);
            return number == null ? 0 : number;
        }

        static {
            fieldMap.put("queryId", 1);
            fieldMap.put("majorFragmentId", 2);
            fieldMap.put("minorFragmentId", 3);
            fieldMap.put("toForeman", 4);
            fieldMap.put("bloomFilterSizeInBytes", 5);
            fieldMap.put("probeFields", 6);
            fieldMap.put("hjOpId", 7);
            fieldMap.put("rfIdentifier", 8);
        }

        public static class BuilderSchema
        implements Schema<BitData.RuntimeFilterBDef.Builder> {
            public void mergeFrom(Input input, BitData.RuntimeFilterBDef.Builder builder) throws IOException {
                int number = input.readFieldNumber((Schema)this);
                while (true) {
                    switch (number) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            builder.setQueryId((UserBitShared.QueryId.Builder)input.mergeObject((Object)UserBitShared.QueryId.newBuilder(), (Schema)SchemaUserBitShared.QueryId.MERGE));
                            break;
                        }
                        case 2: {
                            builder.setMajorFragmentId(input.readInt32());
                            break;
                        }
                        case 3: {
                            builder.setMinorFragmentId(input.readInt32());
                            break;
                        }
                        case 4: {
                            builder.setToForeman(input.readBool());
                            break;
                        }
                        case 5: {
                            builder.addBloomFilterSizeInBytes(input.readInt32());
                            break;
                        }
                        case 6: {
                            builder.addProbeFields(input.readString());
                            break;
                        }
                        case 7: {
                            builder.setHjOpId(input.readInt32());
                            break;
                        }
                        case 8: {
                            builder.setRfIdentifier(input.readInt64());
                            break;
                        }
                        default: {
                            input.handleUnknownField(number, (Schema)this);
                        }
                    }
                    number = input.readFieldNumber((Schema)this);
                }
            }

            public boolean isInitialized(BitData.RuntimeFilterBDef.Builder builder) {
                return builder.isInitialized();
            }

            public BitData.RuntimeFilterBDef.Builder newMessage() {
                return BitData.RuntimeFilterBDef.newBuilder();
            }

            public String getFieldName(int number) {
                return RuntimeFilterBDef.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return RuntimeFilterBDef.getFieldNumber(name);
            }

            public Class<BitData.RuntimeFilterBDef.Builder> typeClass() {
                return BitData.RuntimeFilterBDef.Builder.class;
            }

            public String messageName() {
                return BitData.RuntimeFilterBDef.class.getSimpleName();
            }

            public String messageFullName() {
                return BitData.RuntimeFilterBDef.class.getName();
            }

            public void writeTo(Output output, BitData.RuntimeFilterBDef.Builder builder) throws IOException {
            }
        }

        public static class MessageSchema
        implements Schema<BitData.RuntimeFilterBDef> {
            public void writeTo(Output output, BitData.RuntimeFilterBDef message) throws IOException {
                if (message.hasQueryId()) {
                    output.writeObject(1, (Object)message.getQueryId(), (Schema)SchemaUserBitShared.QueryId.WRITE, false);
                }
                if (message.hasMajorFragmentId()) {
                    output.writeInt32(2, message.getMajorFragmentId(), false);
                }
                if (message.hasMinorFragmentId()) {
                    output.writeInt32(3, message.getMinorFragmentId(), false);
                }
                if (message.hasToForeman()) {
                    output.writeBool(4, message.getToForeman(), false);
                }
                Iterator<Object> iterator = message.getBloomFilterSizeInBytesList().iterator();
                while (iterator.hasNext()) {
                    int bloomFilterSizeInBytes = iterator.next();
                    output.writeInt32(5, bloomFilterSizeInBytes, true);
                }
                for (String probeFields : message.getProbeFieldsList()) {
                    output.writeString(6, (CharSequence)probeFields, true);
                }
                if (message.hasHjOpId()) {
                    output.writeInt32(7, message.getHjOpId(), false);
                }
                if (message.hasRfIdentifier()) {
                    output.writeInt64(8, message.getRfIdentifier(), false);
                }
            }

            public boolean isInitialized(BitData.RuntimeFilterBDef message) {
                return message.isInitialized();
            }

            public String getFieldName(int number) {
                return RuntimeFilterBDef.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return RuntimeFilterBDef.getFieldNumber(name);
            }

            public Class<BitData.RuntimeFilterBDef> typeClass() {
                return BitData.RuntimeFilterBDef.class;
            }

            public String messageName() {
                return BitData.RuntimeFilterBDef.class.getSimpleName();
            }

            public String messageFullName() {
                return BitData.RuntimeFilterBDef.class.getName();
            }

            public void mergeFrom(Input input, BitData.RuntimeFilterBDef message) throws IOException {
            }

            public BitData.RuntimeFilterBDef newMessage() {
                return null;
            }
        }
    }

    public static final class FragmentRecordBatch {
        public static final MessageSchema WRITE = new MessageSchema();
        public static final BuilderSchema MERGE = new BuilderSchema();
        private static final HashMap<String, Integer> fieldMap = new HashMap();

        public static String getFieldName(int number) {
            switch (number) {
                case 1: {
                    return "queryId";
                }
                case 2: {
                    return "receivingMajorFragmentId";
                }
                case 3: {
                    return "receivingMinorFragmentId";
                }
                case 4: {
                    return "sendingMajorFragmentId";
                }
                case 5: {
                    return "sendingMinorFragmentId";
                }
                case 6: {
                    return "def";
                }
                case 7: {
                    return "isLastBatch";
                }
            }
            return null;
        }

        public static int getFieldNumber(String name) {
            Integer number = fieldMap.get(name);
            return number == null ? 0 : number;
        }

        static {
            fieldMap.put("queryId", 1);
            fieldMap.put("receivingMajorFragmentId", 2);
            fieldMap.put("receivingMinorFragmentId", 3);
            fieldMap.put("sendingMajorFragmentId", 4);
            fieldMap.put("sendingMinorFragmentId", 5);
            fieldMap.put("def", 6);
            fieldMap.put("isLastBatch", 7);
        }

        public static class BuilderSchema
        implements Schema<BitData.FragmentRecordBatch.Builder> {
            public void mergeFrom(Input input, BitData.FragmentRecordBatch.Builder builder) throws IOException {
                int number = input.readFieldNumber((Schema)this);
                while (true) {
                    switch (number) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            builder.setQueryId((UserBitShared.QueryId.Builder)input.mergeObject((Object)UserBitShared.QueryId.newBuilder(), (Schema)SchemaUserBitShared.QueryId.MERGE));
                            break;
                        }
                        case 2: {
                            builder.setReceivingMajorFragmentId(input.readInt32());
                            break;
                        }
                        case 3: {
                            builder.addReceivingMinorFragmentId(input.readInt32());
                            break;
                        }
                        case 4: {
                            builder.setSendingMajorFragmentId(input.readInt32());
                            break;
                        }
                        case 5: {
                            builder.setSendingMinorFragmentId(input.readInt32());
                            break;
                        }
                        case 6: {
                            builder.setDef((UserBitShared.RecordBatchDef.Builder)input.mergeObject((Object)UserBitShared.RecordBatchDef.newBuilder(), (Schema)SchemaUserBitShared.RecordBatchDef.MERGE));
                            break;
                        }
                        case 7: {
                            builder.setIsLastBatch(input.readBool());
                            break;
                        }
                        default: {
                            input.handleUnknownField(number, (Schema)this);
                        }
                    }
                    number = input.readFieldNumber((Schema)this);
                }
            }

            public boolean isInitialized(BitData.FragmentRecordBatch.Builder builder) {
                return builder.isInitialized();
            }

            public BitData.FragmentRecordBatch.Builder newMessage() {
                return BitData.FragmentRecordBatch.newBuilder();
            }

            public String getFieldName(int number) {
                return FragmentRecordBatch.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return FragmentRecordBatch.getFieldNumber(name);
            }

            public Class<BitData.FragmentRecordBatch.Builder> typeClass() {
                return BitData.FragmentRecordBatch.Builder.class;
            }

            public String messageName() {
                return BitData.FragmentRecordBatch.class.getSimpleName();
            }

            public String messageFullName() {
                return BitData.FragmentRecordBatch.class.getName();
            }

            public void writeTo(Output output, BitData.FragmentRecordBatch.Builder builder) throws IOException {
            }
        }

        public static class MessageSchema
        implements Schema<BitData.FragmentRecordBatch> {
            public void writeTo(Output output, BitData.FragmentRecordBatch message) throws IOException {
                if (message.hasQueryId()) {
                    output.writeObject(1, (Object)message.getQueryId(), (Schema)SchemaUserBitShared.QueryId.WRITE, false);
                }
                if (message.hasReceivingMajorFragmentId()) {
                    output.writeInt32(2, message.getReceivingMajorFragmentId(), false);
                }
                for (int receivingMinorFragmentId : message.getReceivingMinorFragmentIdList()) {
                    output.writeInt32(3, receivingMinorFragmentId, true);
                }
                if (message.hasSendingMajorFragmentId()) {
                    output.writeInt32(4, message.getSendingMajorFragmentId(), false);
                }
                if (message.hasSendingMinorFragmentId()) {
                    output.writeInt32(5, message.getSendingMinorFragmentId(), false);
                }
                if (message.hasDef()) {
                    output.writeObject(6, (Object)message.getDef(), (Schema)SchemaUserBitShared.RecordBatchDef.WRITE, false);
                }
                if (message.hasIsLastBatch()) {
                    output.writeBool(7, message.getIsLastBatch(), false);
                }
            }

            public boolean isInitialized(BitData.FragmentRecordBatch message) {
                return message.isInitialized();
            }

            public String getFieldName(int number) {
                return FragmentRecordBatch.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return FragmentRecordBatch.getFieldNumber(name);
            }

            public Class<BitData.FragmentRecordBatch> typeClass() {
                return BitData.FragmentRecordBatch.class;
            }

            public String messageName() {
                return BitData.FragmentRecordBatch.class.getSimpleName();
            }

            public String messageFullName() {
                return BitData.FragmentRecordBatch.class.getName();
            }

            public void mergeFrom(Input input, BitData.FragmentRecordBatch message) throws IOException {
            }

            public BitData.FragmentRecordBatch newMessage() {
                return null;
            }
        }
    }

    public static final class BitServerHandshake {
        public static final MessageSchema WRITE = new MessageSchema();
        public static final BuilderSchema MERGE = new BuilderSchema();
        private static final HashMap<String, Integer> fieldMap = new HashMap();

        public static String getFieldName(int number) {
            switch (number) {
                case 1: {
                    return "rpcVersion";
                }
                case 2: {
                    return "authenticationMechanisms";
                }
            }
            return null;
        }

        public static int getFieldNumber(String name) {
            Integer number = fieldMap.get(name);
            return number == null ? 0 : number;
        }

        static {
            fieldMap.put("rpcVersion", 1);
            fieldMap.put("authenticationMechanisms", 2);
        }

        public static class BuilderSchema
        implements Schema<BitData.BitServerHandshake.Builder> {
            public void mergeFrom(Input input, BitData.BitServerHandshake.Builder builder) throws IOException {
                int number = input.readFieldNumber((Schema)this);
                while (true) {
                    switch (number) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            builder.setRpcVersion(input.readInt32());
                            break;
                        }
                        case 2: {
                            builder.addAuthenticationMechanisms(input.readString());
                            break;
                        }
                        default: {
                            input.handleUnknownField(number, (Schema)this);
                        }
                    }
                    number = input.readFieldNumber((Schema)this);
                }
            }

            public boolean isInitialized(BitData.BitServerHandshake.Builder builder) {
                return builder.isInitialized();
            }

            public BitData.BitServerHandshake.Builder newMessage() {
                return BitData.BitServerHandshake.newBuilder();
            }

            public String getFieldName(int number) {
                return BitServerHandshake.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return BitServerHandshake.getFieldNumber(name);
            }

            public Class<BitData.BitServerHandshake.Builder> typeClass() {
                return BitData.BitServerHandshake.Builder.class;
            }

            public String messageName() {
                return BitData.BitServerHandshake.class.getSimpleName();
            }

            public String messageFullName() {
                return BitData.BitServerHandshake.class.getName();
            }

            public void writeTo(Output output, BitData.BitServerHandshake.Builder builder) throws IOException {
            }
        }

        public static class MessageSchema
        implements Schema<BitData.BitServerHandshake> {
            public void writeTo(Output output, BitData.BitServerHandshake message) throws IOException {
                if (message.hasRpcVersion()) {
                    output.writeInt32(1, message.getRpcVersion(), false);
                }
                for (String authenticationMechanisms : message.getAuthenticationMechanismsList()) {
                    output.writeString(2, (CharSequence)authenticationMechanisms, true);
                }
            }

            public boolean isInitialized(BitData.BitServerHandshake message) {
                return message.isInitialized();
            }

            public String getFieldName(int number) {
                return BitServerHandshake.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return BitServerHandshake.getFieldNumber(name);
            }

            public Class<BitData.BitServerHandshake> typeClass() {
                return BitData.BitServerHandshake.class;
            }

            public String messageName() {
                return BitData.BitServerHandshake.class.getSimpleName();
            }

            public String messageFullName() {
                return BitData.BitServerHandshake.class.getName();
            }

            public void mergeFrom(Input input, BitData.BitServerHandshake message) throws IOException {
            }

            public BitData.BitServerHandshake newMessage() {
                return null;
            }
        }
    }

    public static final class BitClientHandshake {
        public static final MessageSchema WRITE = new MessageSchema();
        public static final BuilderSchema MERGE = new BuilderSchema();
        private static final HashMap<String, Integer> fieldMap = new HashMap();

        public static String getFieldName(int number) {
            switch (number) {
                case 1: {
                    return "rpcVersion";
                }
                case 2: {
                    return "channel";
                }
            }
            return null;
        }

        public static int getFieldNumber(String name) {
            Integer number = fieldMap.get(name);
            return number == null ? 0 : number;
        }

        static {
            fieldMap.put("rpcVersion", 1);
            fieldMap.put("channel", 2);
        }

        public static class BuilderSchema
        implements Schema<BitData.BitClientHandshake.Builder> {
            public void mergeFrom(Input input, BitData.BitClientHandshake.Builder builder) throws IOException {
                int number = input.readFieldNumber((Schema)this);
                while (true) {
                    switch (number) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            builder.setRpcVersion(input.readInt32());
                            break;
                        }
                        case 2: {
                            builder.setChannel(UserBitShared.RpcChannel.valueOf(input.readEnum()));
                            break;
                        }
                        default: {
                            input.handleUnknownField(number, (Schema)this);
                        }
                    }
                    number = input.readFieldNumber((Schema)this);
                }
            }

            public boolean isInitialized(BitData.BitClientHandshake.Builder builder) {
                return builder.isInitialized();
            }

            public BitData.BitClientHandshake.Builder newMessage() {
                return BitData.BitClientHandshake.newBuilder();
            }

            public String getFieldName(int number) {
                return BitClientHandshake.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return BitClientHandshake.getFieldNumber(name);
            }

            public Class<BitData.BitClientHandshake.Builder> typeClass() {
                return BitData.BitClientHandshake.Builder.class;
            }

            public String messageName() {
                return BitData.BitClientHandshake.class.getSimpleName();
            }

            public String messageFullName() {
                return BitData.BitClientHandshake.class.getName();
            }

            public void writeTo(Output output, BitData.BitClientHandshake.Builder builder) throws IOException {
            }
        }

        public static class MessageSchema
        implements Schema<BitData.BitClientHandshake> {
            public void writeTo(Output output, BitData.BitClientHandshake message) throws IOException {
                if (message.hasRpcVersion()) {
                    output.writeInt32(1, message.getRpcVersion(), false);
                }
                if (message.hasChannel()) {
                    output.writeEnum(2, message.getChannel().getNumber(), false);
                }
            }

            public boolean isInitialized(BitData.BitClientHandshake message) {
                return message.isInitialized();
            }

            public String getFieldName(int number) {
                return BitClientHandshake.getFieldName(number);
            }

            public int getFieldNumber(String name) {
                return BitClientHandshake.getFieldNumber(name);
            }

            public Class<BitData.BitClientHandshake> typeClass() {
                return BitData.BitClientHandshake.class;
            }

            public String messageName() {
                return BitData.BitClientHandshake.class.getSimpleName();
            }

            public String messageFullName() {
                return BitData.BitClientHandshake.class.getName();
            }

            public void mergeFrom(Input input, BitData.BitClientHandshake message) throws IOException {
            }

            public BitData.BitClientHandshake newMessage() {
                return null;
            }
        }
    }
}

