/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.drill.exec.client;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import oadd.com.typesafe.config.Config;
import oadd.com.typesafe.config.ConfigFactory;
import oadd.com.typesafe.config.ConfigValue;
import oadd.com.typesafe.config.ConfigValueFactory;
import oadd.org.apache.drill.common.scanner.ClassPathScanner;
import oadd.org.apache.drill.common.util.DrillVersionInfo;
import org.apache.drill.shaded.guava.com.google.common.annotations.VisibleForTesting;
import org.jline.reader.Completer;
import org.jline.reader.impl.completer.StringsCompleter;
import org.jline.utils.AttributedString;
import org.jline.utils.AttributedStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sqlline.Application;
import sqlline.CommandHandler;
import sqlline.ConnectionMetadata;
import sqlline.OutputFormat;
import sqlline.PromptHandler;
import sqlline.ReflectiveCommandHandler;
import sqlline.SqlLine;
import sqlline.SqlLineOpts;

public class DrillSqlLineApplication
extends Application {
    private static final Logger logger = LoggerFactory.getLogger(DrillSqlLineApplication.class);
    private static final String DRILL_SQLLINE_CONF = "drill-sqlline.conf";
    private static final String DRILL_SQLLINE_OVERRIDE_CONF = "drill-sqlline-override.conf";
    private static final String DRILL_CONF = "drill-distrib.conf";
    private static final String DRILL_OVERRIDE_CONF = "drill-override.conf";
    private static final String INFO_MESSAGE_TEMPLATE_CONF = "drill.sqlline.info_message_template";
    private static final String QUOTES_CONF = "drill.sqlline.quotes";
    private static final String DRIVERS_CONF = "drill.sqlline.drivers";
    private static final String CONNECTION_URL_EXAMPLES_CONF = "drill.sqlline.connection_url_examples";
    private static final String COMMANDS_TO_EXCLUDE_CONF = "drill.sqlline.commands.exclude";
    private static final String OPTS_CONF = "drill.sqlline.opts";
    private static final String PROMPT_WITH_SCHEMA = "drill.sqlline.prompt.with_schema";
    private final Config config;

    public DrillSqlLineApplication() {
        this(DRILL_SQLLINE_CONF, DRILL_SQLLINE_OVERRIDE_CONF);
    }

    @VisibleForTesting
    public DrillSqlLineApplication(String configName, String overrideConfigName) {
        this.config = this.overrideConfig(overrideConfigName, this.overrideConnectionMode(this.loadConfig(configName)));
        if (this.config.isEmpty()) {
            logger.warn("Was unable to find / load [{}]. Will use default SqlLine configuration.", (Object)configName);
        }
    }

    public Config getConfig() {
        return this.config;
    }

    public String getInfoMessage() {
        if (this.config.hasPath(INFO_MESSAGE_TEMPLATE_CONF)) {
            String quote = "";
            if (this.config.hasPath(QUOTES_CONF)) {
                List<String> quotes = this.config.getStringList(QUOTES_CONF);
                quote = quotes.get(new Random().nextInt(quotes.size()));
            }
            return String.format(this.config.getString(INFO_MESSAGE_TEMPLATE_CONF), this.getVersion(), quote);
        }
        return super.getInfoMessage();
    }

    public String getVersion() {
        return DrillVersionInfo.getVersion();
    }

    public List<String> allowedDrivers() {
        if (this.config.hasPath(DRIVERS_CONF)) {
            return this.config.getStringList(DRIVERS_CONF);
        }
        return super.allowedDrivers();
    }

    public Map<String, OutputFormat> getOutputFormats(SqlLine sqlLine) {
        return sqlLine.getOutputFormats();
    }

    public Collection<String> getConnectionUrlExamples() {
        if (this.config.hasPath(CONNECTION_URL_EXAMPLES_CONF)) {
            return this.config.getStringList(CONNECTION_URL_EXAMPLES_CONF);
        }
        return super.getConnectionUrlExamples();
    }

    public Collection<CommandHandler> getCommandHandlers(SqlLine sqlLine) {
        ArrayList<String> commandsToExclude = new ArrayList<String>();
        boolean reloadConnect = this.config.hasPath(CONNECTION_URL_EXAMPLES_CONF);
        if (reloadConnect) {
            commandsToExclude.add("connect");
        }
        if (this.config.hasPath(COMMANDS_TO_EXCLUDE_CONF)) {
            commandsToExclude.addAll(this.config.getStringList(COMMANDS_TO_EXCLUDE_CONF));
        }
        if (commandsToExclude.isEmpty()) {
            return sqlLine.getCommandHandlers();
        }
        List<CommandHandler> commandHandlers = sqlLine.getCommandHandlers().stream().filter(c -> c.getNames().stream().noneMatch(commandsToExclude::contains)).collect(Collectors.toList());
        if (reloadConnect) {
            commandHandlers.add((CommandHandler)new ReflectiveCommandHandler(sqlLine, (Completer)new StringsCompleter(this.getConnectionUrlExamples()), new String[]{"connect", "open"}));
        }
        return commandHandlers;
    }

    public SqlLineOpts getOpts(SqlLine sqlLine) {
        SqlLineOpts opts = sqlLine.getOpts();
        if (this.config.hasPath(OPTS_CONF)) {
            Config optsConfig = this.config.getConfig(OPTS_CONF);
            optsConfig.entrySet().forEach(e -> {
                String value;
                String key = (String)e.getKey();
                if (!opts.set(key, value = String.valueOf(((ConfigValue)e.getValue()).unwrapped()), true)) {
                    logger.warn("Unable to set SqlLine property [{}] to [{}].", (Object)key, (Object)value);
                }
            });
        }
        return opts;
    }

    public PromptHandler getPromptHandler(SqlLine sqlLine) {
        if (this.config.hasPath(PROMPT_WITH_SCHEMA) && this.config.getBoolean(PROMPT_WITH_SCHEMA)) {
            return new PromptHandler(sqlLine){

                protected AttributedString getDefaultPrompt(int connectionIndex, String url, String defaultPrompt) {
                    AttributedStringBuilder builder = new AttributedStringBuilder();
                    builder.style(this.resolveStyle("f:y"));
                    builder.append((CharSequence)"apache drill");
                    ConnectionMetadata meta = this.sqlLine.getConnectionMetadata();
                    String currentSchema = meta.getCurrentSchema();
                    if (currentSchema != null) {
                        builder.append((CharSequence)" (").append((CharSequence)currentSchema).append((CharSequence)")");
                    }
                    return builder.style(this.resolveStyle("default")).append((CharSequence)"> ").toAttributedString();
                }
            };
        }
        return super.getPromptHandler(sqlLine);
    }

    private Config loadConfig(String configName) {
        Set<URL> urls = ClassPathScanner.forResource(configName, false);
        if (urls.size() != 1) {
            if (logger.isDebugEnabled()) {
                urls.forEach(u -> logger.debug("Found duplicating [{}]: [{}].", (Object)configName, (Object)u.getPath()));
            }
            return ConfigFactory.empty();
        }
        URL url = urls.iterator().next();
        try {
            logger.debug("Parsing [{}] for the url: [{}].", (Object)configName, (Object)url.getPath());
            return ConfigFactory.parseURL(url);
        }
        catch (Exception e) {
            logger.warn("Was unable to parse [{}].", (Object)url.getPath(), (Object)e);
            return ConfigFactory.empty();
        }
    }

    private Config overrideConfigValue(String path, String value, Config config) {
        return config.withValue(path, ConfigValueFactory.fromAnyRef(value));
    }

    private Config overrideConnectionMode(Config config) {
        if (config.isEmpty()) {
            return config;
        }
        String connectModePath = "drill.sqlline.opts.connectInteractionMode";
        return this.isStatusSecure() ? this.overrideConfigValue(connectModePath, "useNPTogetherOrEmpty", config) : this.overrideConfigValue(connectModePath, "notAskCredentials", config);
    }

    private Config overrideConfig(String configName, Config config) {
        Config overrideConfig = this.loadConfig(configName);
        return overrideConfig.withFallback(config).resolve();
    }

    public boolean isStatusSecure() {
        String authValuePath;
        Config drillConfig = this.overrideConfig(DRILL_OVERRIDE_CONF, this.loadConfig(DRILL_CONF));
        return drillConfig.hasPath(authValuePath = "drill.exec.security.user.auth.enabled") && drillConfig.getBoolean(authValuePath);
    }
}

