/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.curator;

import java.util.concurrent.Callable;
import oadd.org.apache.curator.CuratorZookeeperClient;
import oadd.org.apache.curator.RetryLoopImpl;
import oadd.org.apache.curator.RetrySleeper;
import oadd.org.apache.zookeeper.KeeperException;

public abstract class RetryLoop {
    public static RetrySleeper getDefaultRetrySleeper() {
        return RetryLoopImpl.getRetrySleeper();
    }

    public static <T> T callWithRetry(CuratorZookeeperClient client, Callable<T> proc) throws Exception {
        return client.getConnectionHandlingPolicy().callWithRetry(client, proc);
    }

    public abstract boolean shouldContinue();

    public abstract void markComplete();

    public static boolean shouldRetry(int rc) {
        return rc == KeeperException.Code.CONNECTIONLOSS.intValue() || rc == KeeperException.Code.OPERATIONTIMEOUT.intValue() || rc == KeeperException.Code.SESSIONMOVED.intValue() || rc == KeeperException.Code.SESSIONEXPIRED.intValue() || rc == -13;
    }

    public static boolean isRetryException(Throwable exception) {
        if (exception instanceof KeeperException) {
            KeeperException keeperException = (KeeperException)exception;
            return RetryLoop.shouldRetry(keeperException.code().intValue());
        }
        return false;
    }

    public abstract void takeException(Exception var1) throws Exception;
}

