/*
 * Decompiled with CFR 0.152.
 */
package oadd.org.apache.calcite.avatica;

import java.util.Collections;
import java.util.List;
import oadd.org.apache.calcite.avatica.AvaticaSeverity;
import oadd.org.apache.calcite.avatica.remote.Service;

public class AvaticaClientRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final int errorCode;
    private final String sqlState;
    private final AvaticaSeverity severity;
    private final List<String> serverExceptions;
    private final Service.RpcMetadataResponse metadata;

    public AvaticaClientRuntimeException(String errorMessage, int errorCode, String sqlState, AvaticaSeverity severity, List<String> serverExceptions, Service.RpcMetadataResponse metadata) {
        super(errorMessage);
        this.errorCode = errorCode;
        this.sqlState = sqlState;
        this.severity = severity;
        this.serverExceptions = serverExceptions;
        this.metadata = metadata;
    }

    public AvaticaClientRuntimeException(String message, Throwable cause) {
        super(message, cause);
        this.errorCode = -1;
        this.sqlState = "00000";
        this.severity = AvaticaSeverity.UNKNOWN;
        this.serverExceptions = Collections.singletonList("");
        this.metadata = null;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getSqlState() {
        return this.sqlState;
    }

    public AvaticaSeverity getSeverity() {
        return this.severity;
    }

    public List<String> getServerExceptions() {
        return this.serverExceptions;
    }

    public Service.RpcMetadataResponse getRpcMetadata() {
        return this.metadata;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.getClass().getSimpleName()).append(": ").append(this.getMessage()).append(". Error ").append(this.getErrorCode()).append(" (").append(this.sqlState).append(") ").append((Object)this.getSeverity()).append("\n\n");
        for (String serverException : this.getServerExceptions()) {
            sb.append(serverException).append("\n");
        }
        return sb.toString();
    }
}

