/*
 * Decompiled with CFR 0.152.
 */
package oadd.io.jsonwebtoken.impl;

import oadd.io.jsonwebtoken.impl.AbstractTextCodec;
import oadd.io.jsonwebtoken.impl.TextCodec;

public class Base64UrlCodec
extends AbstractTextCodec {
    @Override
    public String encode(byte[] data) {
        String base64Text = TextCodec.BASE64.encode(data);
        byte[] bytes = base64Text.getBytes(US_ASCII);
        bytes = this.removePadding(bytes);
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] == 43) {
                bytes[i] = 45;
                continue;
            }
            if (bytes[i] != 47) continue;
            bytes[i] = 95;
        }
        return new String(bytes, US_ASCII);
    }

    protected byte[] removePadding(byte[] bytes) {
        byte[] result = bytes;
        int paddingCount = 0;
        for (int i = bytes.length - 1; i > 0 && bytes[i] == 61; --i) {
            ++paddingCount;
        }
        if (paddingCount > 0) {
            result = new byte[bytes.length - paddingCount];
            System.arraycopy(bytes, 0, result, 0, bytes.length - paddingCount);
        }
        return result;
    }

    @Override
    public byte[] decode(String encoded) {
        char[] chars = encoded.toCharArray();
        chars = this.ensurePadding(chars);
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '-') {
                chars[i] = 43;
                continue;
            }
            if (chars[i] != '_') continue;
            chars[i] = 47;
        }
        String base64Text = new String(chars);
        return TextCodec.BASE64.decode(base64Text);
    }

    protected char[] ensurePadding(char[] chars) {
        char[] result = chars;
        int paddingCount = 0;
        int remainder = chars.length % 4;
        if (remainder == 2 || remainder == 3) {
            paddingCount = 4 - remainder;
        }
        if (paddingCount > 0) {
            result = new char[chars.length + paddingCount];
            System.arraycopy(chars, 0, result, 0, chars.length);
            for (int i = 0; i < paddingCount; ++i) {
                result[chars.length + i] = 61;
            }
        }
        return result;
    }
}

