/*
 * Decompiled with CFR 0.152.
 */
package de.huxhorn.sulky.codec;

import de.huxhorn.sulky.codec.Decoder;
import de.huxhorn.sulky.io.IOUtilities;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializableDecoder<E extends Serializable>
implements Decoder<E> {
    private boolean compressing;

    public SerializableDecoder() {
        this(false);
    }

    public SerializableDecoder(boolean compressing) {
        this.setCompressing(compressing);
    }

    public boolean isCompressing() {
        return this.compressing;
    }

    public void setCompressing(boolean compressing) {
        this.compressing = compressing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E decode(byte[] bytes) {
        Serializable serializable;
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
        ObjectInputStream ois = null;
        try {
            Serializable e;
            if (this.compressing) {
                GZIPInputStream gis = new GZIPInputStream(bis);
                ois = new ObjectInputStream(gis);
            } else {
                ois = new ObjectInputStream(bis);
            }
            Object result = ois.readObject();
            serializable = e = (Serializable)result;
        }
        catch (Throwable e) {
            E e2;
            try {
                IOUtilities.interruptIfNecessary((Throwable)e);
                e2 = null;
            }
            catch (Throwable throwable) {
                IOUtilities.closeQuietly(ois);
                IOUtilities.closeQuietly((InputStream)bis);
                throw throwable;
            }
            IOUtilities.closeQuietly((InputStream)ois);
            IOUtilities.closeQuietly((InputStream)bis);
            return e2;
        }
        IOUtilities.closeQuietly((InputStream)ois);
        IOUtilities.closeQuietly((InputStream)bis);
        return (E)serializable;
    }

    public String toString() {
        return "SerializableDecoder[compressing=" + this.compressing + "]";
    }
}

