/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Inject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.NodeToLabelsList;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.labelmanagement.LabelManager;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RmView;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;

public class NodeLabelsPage
extends RmView {
    @Override
    protected void preHead(Hamlet.HTML<HtmlPage._> html) {
        this.commonPreHead(html);
        String title = "Node labels of the cluster";
        this.setTitle(title);
        this.set("ui.dataTables.id", "nodelabels");
        this.setTableStyles(html, "nodelabels", new String[]{".healthStatus {width:10em}", ".healthReport {width:10em}"});
    }

    @Override
    protected Class<? extends SubView> content() {
        return NodeLabelsBlock.class;
    }

    static class NodeLabelsBlock
    extends HtmlBlock {
        final ResourceManager rm;

        @Inject
        NodeLabelsBlock(ResourceManager rm, View.ViewContext ctx) {
            super(ctx);
            this.rm = rm;
        }

        protected void render(HtmlBlock.Block html) {
            List<NodeToLabelsList> labelsForAllNodes = LabelManager.getInstance().getLabelsForAllNodes();
            Map<String, Integer> labelNumNodesMap = this.getLabelNumNodesMap(labelsForAllNodes);
            html.div().$class("labelnumnodes").h3("Label and num nodes")._();
            Hamlet.TBODY labelNodes = ((Hamlet.TABLE)((Hamlet.THEAD)((Hamlet.TR)((Hamlet.TR)html.table("#labelnodes").thead().$class("ui-widget-header").tr().th().$class("ui-state-default")._(new Object[]{"Label"})._()).th().$class("ui-state-default")._(new Object[]{"Num nodes"})._())._())._()).tbody().$class("ui-widget-content");
            for (Map.Entry<String, Integer> e : labelNumNodesMap.entrySet()) {
                Hamlet.TR row = labelNodes.tr().td(e.getKey());
                if (e.getValue() == null) {
                    row.td("0")._();
                    continue;
                }
                row.td(String.valueOf(e.getValue()))._();
            }
            ((Hamlet.TABLE)labelNodes._())._();
            html.div().$class("nodelabelsdata").h3("Node labels")._();
            Hamlet.TBODY nodeLabels = ((Hamlet.TABLE)((Hamlet.THEAD)html.table("#nodelabels").thead().tr().th(".node", "Node").th(".labels", "Node Labels")._())._()).tbody();
            for (NodeToLabelsList ntl : labelsForAllNodes) {
                Hamlet.TR row = nodeLabels.tr().td(ntl.getNode());
                if (ntl.getNodeLabel() == null || ntl.getNodeLabel().isEmpty()) {
                    row.td("No labels")._();
                    continue;
                }
                row.td(ntl.getNodeLabel().toString())._();
            }
            ((Hamlet.TABLE)nodeLabels._())._();
        }

        private Map<String, Integer> getLabelNumNodesMap(List<NodeToLabelsList> labelsForAllNodes) {
            HashMap<String, Integer> labelNodeQuantityMap = new HashMap<String, Integer>();
            for (NodeToLabelsList ntl : labelsForAllNodes) {
                String node = ntl.getNode();
                List nodeLabels = ntl.getNodeLabel();
                for (String label : nodeLabels) {
                    if (labelNodeQuantityMap.containsKey(label)) {
                        Integer num = (Integer)labelNodeQuantityMap.get(label);
                        num = num + 1;
                        labelNodeQuantityMap.put(label, num);
                        continue;
                    }
                    labelNodeQuantityMap.put(label, 1);
                }
            }
            return labelNodeQuantityMap;
        }
    }
}

