/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.java.dev.eval.Expression;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueUserACLInfo;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceOption;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceWeights;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainerState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.UpdatedContainerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.AbstractYarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ActiveUsersManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Allocation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.QueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplication;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.QueueEntitlement;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppAttemptRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.AppRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.ContainerExpiredSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.ContainerRescheduledEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeAddedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeRemovedSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeResourceUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.NodeUpdateSchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEvent;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.event.SchedulerEventType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationFileLoaderService;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSOpDurations;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairSchedulerEventLog;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.MaxRunningAppsEnforcer;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueueManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueuePlacementPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.WeightAdjuster;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMContainerTokenSecretManager;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.hadoop.yarn.util.resource.DiskBasedResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.LimitedPrivate(value={"yarn"})
@InterfaceStability.Unstable
public class FairScheduler
extends AbstractYarnScheduler<FSAppAttempt, FSSchedulerNode> {
    private FairSchedulerConfiguration conf;
    private Resource incrAllocation;
    private QueueManager queueMgr;
    private volatile Clock clock;
    private boolean usePortForNodeName;
    private static final Log LOG = LogFactory.getLog(FairScheduler.class);
    private static final ResourceCalculator RESOURCE_CALCULATOR = new DiskBasedResourceCalculator();
    public static final Resource CONTAINER_RESERVED = Resources.createResource((int)-1);
    protected long updateInterval;
    private final int UPDATE_DEBUG_FREQUENCY = 5;
    private int updatesToSkipForDebug = 5;
    @VisibleForTesting
    Thread updateThread;
    @VisibleForTesting
    Thread schedulingThread;
    protected final long THREAD_JOIN_TIMEOUT_MS = 1000L;
    FSQueueMetrics rootMetrics;
    FSOpDurations fsOpDurations;
    protected long lastPreemptionUpdateTime;
    private long lastPreemptCheckTime;
    protected boolean preemptionEnabled;
    protected float preemptionUtilizationThreshold;
    protected boolean isPreemptionThresholdBasedOnLabelsEnabled;
    protected long preemptionInterval;
    protected long waitTimeBeforeKill;
    protected boolean isResourcesBasedOnLabelsEnabled;
    private List<RMContainer> warnedContainers = new ArrayList<RMContainer>();
    private Map<RMContainer, FSAppAttempt> preemptMapping = new HashMap<RMContainer, FSAppAttempt>();
    protected boolean sizeBasedWeight;
    protected WeightAdjuster weightAdjuster;
    protected boolean continuousSchedulingEnabled;
    protected int continuousSchedulingSleepMs;
    private Comparator<NodeId> nodeAvailableResourceComparator = new NodeAvailableResourceComparator();
    protected double nodeLocalityThreshold;
    protected double rackLocalityThreshold;
    protected long nodeLocalityDelayMs;
    protected long rackLocalityDelayMs;
    private FairSchedulerEventLog eventLog;
    protected boolean assignMultiple;
    protected int maxAssign;
    @VisibleForTesting
    final MaxRunningAppsEnforcer maxRunningEnforcer;
    private AllocationFileLoaderService allocsLoader;
    @VisibleForTesting
    AllocationConfiguration allocConf;
    private final ReentrantReadWriteLock.ReadLock readLockAlloc;
    private final ReentrantReadWriteLock.WriteLock writeLockAlloc;

    public FairScheduler() {
        super(FairScheduler.class.getName());
        this.clock = new SystemClock();
        this.allocsLoader = new AllocationFileLoaderService();
        this.queueMgr = new QueueManager(this);
        this.maxRunningEnforcer = new MaxRunningAppsEnforcer(this);
        ReentrantReadWriteLock lockAlloc = new ReentrantReadWriteLock();
        this.readLockAlloc = lockAlloc.readLock();
        this.writeLockAlloc = lockAlloc.writeLock();
    }

    private void validateConf(Configuration conf) {
        int minMem = conf.getInt("yarn.scheduler.minimum-allocation-mb", 1024);
        int maxMem = conf.getInt("yarn.scheduler.maximum-allocation-mb", 8192);
        if (minMem < 0 || minMem > maxMem) {
            throw new YarnRuntimeException("Invalid resource scheduler memory allocation configuration, yarn.scheduler.minimum-allocation-mb=" + minMem + ", " + "yarn.scheduler.maximum-allocation-mb" + "=" + maxMem + ", min should equal greater than 0, max should be no smaller than min.");
        }
        int minVcores = conf.getInt("yarn.scheduler.minimum-allocation-vcores", 1);
        int maxVcores = conf.getInt("yarn.scheduler.maximum-allocation-vcores", 4);
        if (minVcores < 0 || minVcores > maxVcores) {
            throw new YarnRuntimeException("Invalid resource scheduler vcores allocation configuration, yarn.scheduler.minimum-allocation-vcores=" + minVcores + ", " + "yarn.scheduler.maximum-allocation-vcores" + "=" + maxVcores + ", min should equal greater than 0, max should be no smaller than min.");
        }
        double minDisk = conf.getDouble("yarn.scheduler.minimum-allocation-disks", 0.0);
        double maxDisk = conf.getDouble("yarn.scheduler.maximum-allocation-disks", 4.0);
        if (minDisk < 0.0 || minDisk > maxDisk) {
            throw new YarnRuntimeException("Invalid resource scheduler disk allocation configuration, yarn.scheduler.minimum-allocation-disks=" + minDisk + ", " + "yarn.scheduler.maximum-allocation-disks" + "=" + maxDisk + ", min should equal greater than 0, max should be no smaller than min.");
        }
    }

    public FairSchedulerConfiguration getConf() {
        return this.conf;
    }

    public QueueManager getQueueManager() {
        return this.queueMgr;
    }

    protected synchronized void update() {
        long start = this.getClock().getTime();
        this.updateStarvationStats();
        FSParentQueue rootQueue = this.queueMgr.getRootQueue();
        rootQueue.updateDemand();
        rootQueue.setFairShare(this.clusterResource);
        ((FSQueue)rootQueue).recomputeShares();
        this.updateRootQueueMetrics();
        if (LOG.isDebugEnabled() && --this.updatesToSkipForDebug < 0) {
            this.updatesToSkipForDebug = 5;
            LOG.debug((Object)("Cluster Capacity: " + this.clusterResource + "  Allocations: " + this.rootMetrics.getAllocatedResources() + "  Availability: " + Resource.newInstance((int)this.rootMetrics.getAvailableMB(), (int)this.rootMetrics.getAvailableVirtualCores()) + "  Demand: " + rootQueue.getDemand()));
        }
        long duration = this.getClock().getTime() - start;
        this.fsOpDurations.addUpdateCallDuration(duration);
    }

    private void updateStarvationStats() {
        this.lastPreemptionUpdateTime = this.clock.getTime();
        for (FSLeafQueue sched : this.queueMgr.getLeafQueues()) {
            sched.updateStarvationStats();
        }
    }

    protected synchronized void preemptTasksIfNecessary() {
        if (!this.isPreemptionThresholdBasedOnLabelsEnabled) {
            if (this.shouldAttemptPreemption()) {
                this.preemptTasksInQueues(this.queueMgr.getLeafQueues());
            }
        } else {
            Set<Expression> allLabels = this.getLabels();
            for (Expression label : allLabels) {
                List<FSQueue> fsLeafQueues = new ArrayList<FSLeafQueue>(this.queueMgr.getLeafQueues());
                Resource allocatedResource = this.getAllocatedResourceForQueues(fsLeafQueues = this.getAvailableQueuesForLabel(fsLeafQueues, label));
                if (!this.shouldAttemptPreemption(label, allocatedResource)) continue;
                this.preemptTasksInQueues(fsLeafQueues);
            }
        }
    }

    private void preemptTasksInQueues(Collection<FSLeafQueue> queues) {
        long curTime = this.getClock().getTime();
        if (curTime - this.lastPreemptCheckTime < this.preemptionInterval) {
            return;
        }
        this.lastPreemptCheckTime = curTime;
        HashMap<FSAppAttempt, Resource> resToPreempt = new HashMap<FSAppAttempt, Resource>();
        for (FSLeafQueue sched : queues) {
            resToPreempt.putAll(this.resToPreempt(sched, curTime));
        }
        if (!resToPreempt.isEmpty()) {
            this.preemptResources(resToPreempt);
        }
    }

    protected List<FSQueue> getAvailableQueuesForLabel(List<? extends FSQueue> queues, Expression label, Expression parentLabel) {
        ArrayList<FSQueue> queuesWithLabel = new ArrayList<FSQueue>();
        if (label == null) {
            queuesWithLabel.addAll(queues);
            return queuesWithLabel;
        }
        String labelStr = label.toString();
        String parentLabelStr = parentLabel == null ? null : parentLabel.toString();
        for (FSQueue fSQueue : queues) {
            String queueLabel = fSQueue.getLabel() == null ? null : fSQueue.getLabel().toString();
            if (queueLabel == null || !labelStr.equals(queueLabel) || parentLabelStr != null && !parentLabelStr.equals(queueLabel)) continue;
            queuesWithLabel.add(fSQueue);
        }
        return queuesWithLabel;
    }

    protected List<FSQueue> getAvailableQueuesForLabel(List<? extends FSQueue> queues, Expression label) {
        return this.getAvailableQueuesForLabel(queues, label, null);
    }

    protected Resource getAllocatedResourceForQueues(List<? extends FSQueue> queues) {
        Resource totalAllocatedResources = Resources.createResource((int)0, (int)0, (double)0.0);
        for (FSQueue fSQueue : queues) {
            Resources.addTo((Resource)totalAllocatedResources, (Resource)fSQueue.getMetrics().getAllocatedResources());
        }
        return totalAllocatedResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preemptResources(Map<FSAppAttempt, Resource> toPreempt) {
        Object container;
        long start = this.getClock().getTime();
        if (toPreempt.isEmpty()) {
            return;
        }
        Iterator<RMContainer> warnedIter = this.warnedContainers.iterator();
        while (warnedIter.hasNext()) {
            container = warnedIter.next();
            if (!(container.getState() != RMContainerState.RUNNING && container.getState() != RMContainerState.ALLOCATED || toPreempt.isEmpty())) {
                this.warnOrKillContainer((RMContainer)container);
                this.updateResourceToPreempt((RMContainer)container, toPreempt, this.preemptMapping.get(container));
                continue;
            }
            warnedIter.remove();
            this.preemptMapping.remove(container);
        }
        try {
            for (FSLeafQueue queue : this.getQueueManager().getLeafQueues()) {
                queue.resetPreemptedResources();
                queue.resetNonEligibleForPreemptionSet();
            }
            while (!toPreempt.isEmpty()) {
                container = this.getQueueManager().getRootQueue().preemptContainer();
                if (container == null) {
                    break;
                }
                FSSchedulerNode node = (FSSchedulerNode)this.nodes.get(container.getContainer().getNodeId());
                FSAppAttempt preemptApp = null;
                for (Map.Entry<FSAppAttempt, Resource> entry : toPreempt.entrySet()) {
                    if (SchedulerAppUtils.isBlacklisted(entry.getKey(), node, LOG)) continue;
                    preemptApp = entry.getKey();
                    break;
                }
                if (preemptApp == null) {
                    this.getSchedulerApp(container.getApplicationAttemptId()).addNonEligibleForPreemption((RMContainer)container);
                    continue;
                }
                this.warnOrKillContainer((RMContainer)container);
                this.warnedContainers.add((RMContainer)container);
                this.preemptMapping.put((RMContainer)container, preemptApp);
                this.updateResourceToPreempt((RMContainer)container, toPreempt, preemptApp);
            }
        }
        finally {
            for (FSLeafQueue queue : this.getQueueManager().getLeafQueues()) {
                queue.clearPreemptedResources();
                queue.resetNonEligibleForPreemptionSet();
            }
        }
        long duration = this.getClock().getTime() - start;
        this.fsOpDurations.addPreemptCallDuration(duration);
    }

    private void updateResourceToPreempt(RMContainer container, Map<FSAppAttempt, Resource> toPreempt, FSAppAttempt preemptApp) {
        Resource toPreemptResource = toPreempt.get(preemptApp);
        Resource containerResource = container.getContainer().getResource();
        if (preemptApp == null) {
            LOG.info((Object)("Preempt application list doesn't have container: " + container.getContainerId()));
        }
        if (toPreemptResource == null && preemptApp != null) {
            LOG.info((Object)("Don't find " + preemptApp.getName() + " at toPreempt list"));
        }
        if (containerResource == null) {
            LOG.info((Object)("Container " + container.getContainerId() + " resource equals null"));
        }
        if (Resources.greaterThan((ResourceCalculator)RESOURCE_CALCULATOR, (Resource)this.clusterResource, (Resource)toPreemptResource, (Resource)containerResource)) {
            toPreempt.put(preemptApp, Resources.subtractFrom((Resource)toPreemptResource, (Resource)containerResource));
        } else {
            toPreempt.remove(preemptApp);
        }
    }

    protected void warnOrKillContainer(RMContainer container) {
        ApplicationAttemptId appAttemptId = container.getApplicationAttemptId();
        FSAppAttempt app = this.getSchedulerApp(appAttemptId);
        FSLeafQueue queue = app.getQueue();
        LOG.info((Object)("Preempting container (prio=" + container.getContainer().getPriority() + "res=" + container.getContainer().getResource() + ") from queue " + queue.getName()));
        Long time = app.getContainerPreemptionTime(container);
        if (time != null) {
            if (time + this.waitTimeBeforeKill < this.getClock().getTime()) {
                ContainerStatus status = SchedulerUtils.createPreemptedContainerStatus(container.getContainerId(), "Container preempted by scheduler");
                this.completedContainer(container, status, RMContainerEventType.KILL);
                LOG.info((Object)("Killing container" + container + " (after waiting for premption for " + (this.getClock().getTime() - time) + "ms)"));
            }
        } else {
            app.addPreemption(container, this.getClock().getTime());
        }
    }

    protected Map<FSAppAttempt, Resource> resToPreempt(FSLeafQueue sched, long curTime) {
        Resource target;
        long minShareTimeout = sched.getMinSharePreemptionTimeout();
        long fairShareTimeout = sched.getFairSharePreemptionTimeout();
        Resource resDueToMinShare = Resources.none();
        Resource resDueToFairShare = Resources.none();
        if (curTime - sched.getLastTimeAtMinShare() > minShareTimeout) {
            target = Resources.componentwiseMin((Resource)sched.getMinShare(), (Resource)sched.getDemand());
            resDueToMinShare = Resources.subtractFromNonNegative((Resource)target, (Resource)sched.getResourceUsage());
        }
        if (curTime - sched.getLastTimeAtFairShareThreshold() > fairShareTimeout) {
            target = Resources.componentwiseMin((Resource)sched.getFairShare(), (Resource)sched.getDemand());
            resDueToFairShare = Resources.subtractFromNonNegative((Resource)target, (Resource)sched.getResourceUsage());
        }
        Resource resToPreempt = Resources.max((ResourceCalculator)RESOURCE_CALCULATOR, (Resource)this.clusterResource, (Resource)resDueToMinShare, (Resource)resDueToFairShare);
        HashMap<FSAppAttempt, Resource> resPerAppMap = new HashMap<FSAppAttempt, Resource>();
        if (Resources.greaterThan((ResourceCalculator)RESOURCE_CALCULATOR, (Resource)this.clusterResource, (Resource)resToPreempt, (Resource)Resources.none())) {
            String message = "Should preempt " + resToPreempt + " res for queue " + sched.getName() + ": resDueToMinShare = " + resDueToMinShare + ", resDueToFairShare = " + resDueToFairShare;
            LOG.info((Object)message);
            for (FSAppAttempt as : sched.getCopyOfRunnableAppSchedulables()) {
                Resource demand = as.getDemand();
                if (Resources.greaterThanOrEqual((ResourceCalculator)RESOURCE_CALCULATOR, (Resource)this.clusterResource, (Resource)demand, (Resource)resToPreempt)) {
                    resPerAppMap.put(as, resToPreempt);
                    break;
                }
                resPerAppMap.put(as, demand);
                if (!Resources.lessThanOrEqual((ResourceCalculator)RESOURCE_CALCULATOR, (Resource)this.clusterResource, (Resource)(resToPreempt = Resources.subtract((Resource)resToPreempt, (Resource)demand)), (Resource)Resources.none())) continue;
                break;
            }
        }
        return resPerAppMap;
    }

    public synchronized RMContainerTokenSecretManager getContainerTokenSecretManager() {
        return this.rmContext.getContainerTokenSecretManager();
    }

    public synchronized ResourceWeights getAppWeight(FSAppAttempt app) {
        double weight = 1.0;
        if (this.sizeBasedWeight) {
            weight = Math.log1p(app.getDemand().getMemory()) / Math.log(2.0);
        }
        weight *= (double)app.getPriority().getPriority();
        if (this.weightAdjuster != null) {
            weight = this.weightAdjuster.adjustWeight(app, weight);
        }
        ResourceWeights resourceWeights = app.getResourceWeights();
        resourceWeights.setWeight((float)weight);
        return resourceWeights;
    }

    @Override
    public Resource getIncrementResourceCapability() {
        return this.incrAllocation;
    }

    private FSSchedulerNode getFSSchedulerNode(NodeId nodeId) {
        return (FSSchedulerNode)this.nodes.get(nodeId);
    }

    public double getNodeLocalityThreshold() {
        return this.nodeLocalityThreshold;
    }

    public double getRackLocalityThreshold() {
        return this.rackLocalityThreshold;
    }

    public long getNodeLocalityDelayMs() {
        return this.nodeLocalityDelayMs;
    }

    public long getRackLocalityDelayMs() {
        return this.rackLocalityDelayMs;
    }

    public boolean isContinuousSchedulingEnabled() {
        return this.continuousSchedulingEnabled;
    }

    public synchronized int getContinuousSchedulingSleepMs() {
        return this.continuousSchedulingSleepMs;
    }

    public Clock getClock() {
        return this.clock;
    }

    @VisibleForTesting
    void setClock(Clock clock) {
        this.clock = clock;
    }

    public FairSchedulerEventLog getEventLog() {
        return this.eventLog;
    }

    protected synchronized void addApplication(ApplicationId applicationId, String queueName, String user, boolean isAppRecovering) {
        if (queueName == null || queueName.trim().isEmpty()) {
            String message = "Reject application " + applicationId + " submitted by user " + user + " with an empty queue name.";
            LOG.info((Object)message);
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.APP_REJECTED, message));
            return;
        }
        if (queueName.startsWith(".") || queueName.endsWith(".")) {
            String message = "Reject application " + applicationId + " submitted by user " + user + " with an illegal queue name " + queueName + ". The queue name cannot start/end with period.";
            LOG.info((Object)message);
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.APP_REJECTED, message));
            return;
        }
        queueName = queueName.trim();
        user = user.trim();
        RMApp rmApp = (RMApp)this.rmContext.getRMApps().get(applicationId);
        FSLeafQueue queue = this.assignToQueue(rmApp, queueName, user);
        if (queue == null) {
            return;
        }
        UserGroupInformation userUgi = UserGroupInformation.createRemoteUser((String)user);
        if (!queue.hasAccess(QueueACL.SUBMIT_APPLICATIONS, userUgi) && !queue.hasAccess(QueueACL.ADMINISTER_QUEUE, userUgi)) {
            String msg;
            if (isAppRecovering) {
                msg = "Application " + applicationId + " will be killed since ACL configuration was changed before recovering and user " + userUgi.getUserName() + " no longer have a rights to submit applications to queue " + queue.getName();
                this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.KILL));
            } else {
                msg = "User " + userUgi.getUserName() + " cannot submit applications to queue " + queue.getName();
                this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.APP_REJECTED, msg));
            }
            LOG.info((Object)msg);
            return;
        }
        SchedulerApplication application = new SchedulerApplication(queue, user);
        this.applications.put(applicationId, application);
        queue.getMetrics().submitApp(user);
        LOG.info((Object)("Accepted application " + applicationId + " from user: " + user + ", in queue: " + queueName + ", currently num of applications: " + this.applications.size()));
        if (isAppRecovering) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(applicationId + " is recovering. Skip notifying APP_ACCEPTED"));
            }
        } else {
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.APP_ACCEPTED));
        }
    }

    protected synchronized void addApplicationAttempt(ApplicationAttemptId applicationAttemptId, boolean transferStateFromPreviousAttempt, boolean isAttemptRecovering) {
        SchedulerApplication application = (SchedulerApplication)this.applications.get(applicationAttemptId.getApplicationId());
        if (application == null) {
            LOG.warn((Object)("Application " + applicationAttemptId.getApplicationId() + " cannot be found in scheduler."));
            return;
        }
        String user = application.getUser();
        FSLeafQueue queue = (FSLeafQueue)application.getQueue();
        FSAppAttempt attempt = new FSAppAttempt(this, applicationAttemptId, user, queue, new ActiveUsersManager(this.getRootQueueMetrics()), this.rmContext);
        if (transferStateFromPreviousAttempt) {
            attempt.transferStateFromPreviousAttempt((SchedulerApplicationAttempt)application.getCurrentAppAttempt());
        }
        application.setCurrentAppAttempt(attempt);
        boolean runnable = this.maxRunningEnforcer.canAppBeRunnable(queue, user);
        queue.addApp(attempt, runnable);
        if (runnable) {
            this.maxRunningEnforcer.trackRunnableApp(attempt);
        } else {
            this.maxRunningEnforcer.trackNonRunnableApp(attempt);
        }
        queue.getMetrics().submitAppAttempt(user);
        LOG.info((Object)("Added Application Attempt " + applicationAttemptId + " to scheduler from user: " + user));
        if (isAttemptRecovering) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(applicationAttemptId + " is recovering. Skipping notifying ATTEMPT_ADDED"));
            }
        } else {
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppAttemptEvent(applicationAttemptId, RMAppAttemptEventType.ATTEMPT_ADDED));
        }
    }

    @VisibleForTesting
    FSLeafQueue assignToQueue(RMApp rmApp, String queueName, String user) {
        FSLeafQueue queue = null;
        String appRejectMsg = null;
        try {
            QueuePlacementPolicy placementPolicy = this.allocConf.getPlacementPolicy();
            queueName = placementPolicy.assignAppToQueue(queueName, user);
            if (queueName == null) {
                appRejectMsg = "Application rejected by queue placement policy";
            } else {
                queue = this.queueMgr.getLeafQueue(queueName, true);
                if (queue == null) {
                    appRejectMsg = queueName + " is not a leaf queue";
                }
            }
        }
        catch (IOException ioe) {
            appRejectMsg = "Error assigning app to queue " + queueName;
        }
        if (appRejectMsg != null && rmApp != null) {
            LOG.error((Object)appRejectMsg);
            this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(rmApp.getApplicationId(), RMAppEventType.APP_REJECTED, appRejectMsg));
            return null;
        }
        if (rmApp != null) {
            rmApp.setQueue(queue.getName());
        } else {
            LOG.error((Object)"Couldn't find RM app to set queue name on");
        }
        return queue;
    }

    private synchronized void removeApplication(ApplicationId applicationId, RMAppState finalState) {
        SchedulerApplication application = (SchedulerApplication)this.applications.get(applicationId);
        if (application == null) {
            LOG.warn((Object)("Couldn't find application " + applicationId));
            return;
        }
        application.stop(finalState);
        this.applications.remove(applicationId);
    }

    private synchronized void removeApplicationAttempt(ApplicationAttemptId applicationAttemptId, RMAppAttemptState rmAppAttemptFinalState, boolean keepContainers) {
        LOG.info((Object)("Application " + applicationAttemptId + " is done. finalState=" + (Object)((Object)rmAppAttemptFinalState)));
        SchedulerApplication application = (SchedulerApplication)this.applications.get(applicationAttemptId.getApplicationId());
        FSAppAttempt attempt = this.getSchedulerApp(applicationAttemptId);
        if (attempt == null || application == null) {
            LOG.info((Object)("Unknown application " + applicationAttemptId + " has completed!"));
            return;
        }
        if (attempt.isStopped()) {
            LOG.info((Object)("Application " + applicationAttemptId + " has already been stopped!"));
            return;
        }
        for (RMContainer rmContainer : attempt.getLiveContainers()) {
            if (keepContainers && rmContainer.getState().equals((Object)RMContainerState.RUNNING)) {
                LOG.info((Object)("Skip killing " + rmContainer.getContainerId()));
                continue;
            }
            this.completedContainer(rmContainer, SchedulerUtils.createAbnormalContainerStatus(rmContainer.getContainerId(), "Container of a completed application"), RMContainerEventType.KILL);
        }
        for (RMContainer rmContainer : attempt.getReservedContainers()) {
            this.completedContainer(rmContainer, SchedulerUtils.createAbnormalContainerStatus(rmContainer.getContainerId(), "Application Complete"), RMContainerEventType.KILL);
        }
        attempt.stop(rmAppAttemptFinalState);
        FSLeafQueue queue = this.queueMgr.getLeafQueue(attempt.getQueue().getQueueName(), false);
        boolean wasRunnable = queue.removeApp(attempt);
        if (wasRunnable) {
            this.maxRunningEnforcer.untrackRunnableApp(attempt);
            this.maxRunningEnforcer.updateRunnabilityOnAppRemoval(attempt, attempt.getQueue());
        } else {
            this.maxRunningEnforcer.untrackNonRunnableApp(attempt);
        }
    }

    @Override
    protected synchronized void completedContainer(RMContainer rmContainer, ContainerStatus containerStatus, RMContainerEventType event) {
        if (rmContainer == null) {
            LOG.info((Object)"Null container completed...");
            return;
        }
        Container container = rmContainer.getContainer();
        FSAppAttempt application = (FSAppAttempt)this.getCurrentAttemptForContainer(container.getId());
        ApplicationId appId = container.getId().getApplicationAttemptId().getApplicationId();
        if (application == null) {
            LOG.info((Object)("Container " + container + " of unknown application attempt " + appId + " completed with event " + (Object)((Object)event)));
            return;
        }
        FSSchedulerNode node = this.getFSSchedulerNode(container.getNodeId());
        if (rmContainer.getState() == RMContainerState.RESERVED) {
            application.unreserve(rmContainer.getReservedPriority(), node);
        } else {
            application.containerCompleted(rmContainer, containerStatus, event);
            node.releaseContainer(container);
            this.updateRootQueueMetrics();
        }
        LOG.info((Object)("Application attempt " + application.getApplicationAttemptId() + " released container " + container.getId() + " on node: " + node + " with event: " + (Object)((Object)event)));
    }

    private synchronized void addNode(RMNode node) {
        FSSchedulerNode schedulerNode = new FSSchedulerNode(node, this.usePortForNodeName);
        this.nodes.put(node.getNodeID(), schedulerNode);
        Resources.addTo((Resource)this.clusterResource, (Resource)schedulerNode.getTotalResource());
        this.updateRootQueueMetrics();
        this.updateMaximumAllocation(schedulerNode, true);
        this.queueMgr.getRootQueue().setSteadyFairShare(this.clusterResource);
        this.queueMgr.getRootQueue().recomputeSteadyShares();
        LOG.info((Object)("Added node " + node.getNodeAddress() + " cluster capacity: " + this.clusterResource));
    }

    private synchronized void removeNode(RMNode rmNode) {
        FSSchedulerNode node = this.getFSSchedulerNode(rmNode.getNodeID());
        if (node == null) {
            return;
        }
        Resources.subtractFrom((Resource)this.clusterResource, (Resource)node.getTotalResource());
        this.updateRootQueueMetrics();
        List<RMContainer> runningContainers = node.getRunningContainers();
        for (RMContainer container : runningContainers) {
            this.completedContainer(container, SchedulerUtils.createAbnormalContainerStatus(container.getContainerId(), "Container released on a *lost* node"), RMContainerEventType.KILL);
        }
        RMContainer reservedContainer = node.getReservedContainer();
        if (reservedContainer != null) {
            this.completedContainer(reservedContainer, SchedulerUtils.createAbnormalContainerStatus(reservedContainer.getContainerId(), "Container released on a *lost* node"), RMContainerEventType.KILL);
        }
        this.nodes.remove(rmNode.getNodeID());
        this.queueMgr.getRootQueue().setSteadyFairShare(this.clusterResource);
        this.queueMgr.getRootQueue().recomputeSteadyShares();
        this.updateMaximumAllocation(node, false);
        LOG.info((Object)("Removed node " + rmNode.getNodeAddress() + " cluster capacity: " + this.clusterResource));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Allocation allocate(ApplicationAttemptId appAttemptId, List<ResourceRequest> ask, List<ContainerId> release, List<String> blacklistAdditions, List<String> blacklistRemovals) {
        FSAppAttempt application = this.getSchedulerApp(appAttemptId);
        if (application == null) {
            LOG.info((Object)("Calling allocate on removed or non existant application " + appAttemptId));
            return EMPTY_ALLOCATION;
        }
        SchedulerUtils.normalizeRequests(ask, RESOURCE_CALCULATOR, this.clusterResource, this.minimumAllocation, this.getMaximumResourceCapability(), this.incrAllocation);
        this.releaseContainers(release, application);
        FSAppAttempt fSAppAttempt = application;
        synchronized (fSAppAttempt) {
            if (!ask.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("allocate: pre-update applicationAttemptId=" + appAttemptId + " application=" + application.getApplicationId()));
                }
                application.showRequests();
                application.updateResourceRequests(ask);
                application.showRequests();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("allocate: post-update applicationAttemptId=" + appAttemptId + " #ask=" + ask.size() + " reservation= " + application.getCurrentReservation()));
                LOG.debug((Object)("Preempting " + application.getPreemptionContainers().size() + " container(s)"));
            }
            HashSet<ContainerId> preemptionContainerIds = new HashSet<ContainerId>();
            for (RMContainer container : application.getPreemptionContainers()) {
                preemptionContainerIds.add(container.getContainerId());
            }
            application.updateBlacklist(blacklistAdditions, blacklistRemovals);
            SchedulerApplicationAttempt.ContainersAndNMTokensAllocation allocation = application.pullNewlyAllocatedContainersAndNMTokens();
            Resource headroom = application.getHeadroom();
            application.setApplicationHeadroomForMetrics(headroom);
            return new Allocation(allocation.getContainerList(), headroom, preemptionContainerIds, null, null, allocation.getNMTokenList());
        }
    }

    private synchronized void nodeUpdate(RMNode nm) {
        long start = this.getClock().getTime();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("nodeUpdate: " + nm + " cluster capacity: " + this.clusterResource));
        }
        this.eventLog.log("HEARTBEAT", nm.getHostName());
        FSSchedulerNode node = this.getFSSchedulerNode(nm.getNodeID());
        List<UpdatedContainerInfo> containerInfoList = nm.pullContainerUpdates();
        ArrayList<ContainerStatus> newlyLaunchedContainers = new ArrayList<ContainerStatus>();
        ArrayList<ContainerStatus> completedContainers = new ArrayList<ContainerStatus>();
        for (UpdatedContainerInfo containerInfo : containerInfoList) {
            newlyLaunchedContainers.addAll(containerInfo.getNewlyLaunchedContainers());
            completedContainers.addAll(containerInfo.getCompletedContainers());
        }
        for (ContainerStatus launchedContainer : newlyLaunchedContainers) {
            this.containerLaunchedOnNode(launchedContainer.getContainerId(), node);
        }
        for (ContainerStatus completedContainer : completedContainers) {
            ContainerId containerId = completedContainer.getContainerId();
            LOG.debug((Object)("Container FINISHED: " + containerId));
            this.completedContainer(this.getRMContainer(containerId), completedContainer, RMContainerEventType.FINISHED);
        }
        if (this.continuousSchedulingEnabled) {
            if (!completedContainers.isEmpty()) {
                this.attemptScheduling(node);
            }
        } else {
            this.attemptScheduling(node);
        }
        long duration = this.getClock().getTime() - start;
        this.fsOpDurations.addNodeUpdateDuration(duration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void continuousSchedulingAttempt() throws InterruptedException {
        long start = this.getClock().getTime();
        ArrayList nodeIdList = new ArrayList(this.nodes.keySet());
        FairScheduler fairScheduler = this;
        synchronized (fairScheduler) {
            Collections.sort(nodeIdList, this.nodeAvailableResourceComparator);
        }
        for (NodeId nodeId : nodeIdList) {
            FSSchedulerNode node = this.getFSSchedulerNode(nodeId);
            try {
                if (node == null || !Resources.fitsIn((Resource)this.minimumAllocation, (Resource)node.getAvailableResource())) continue;
                this.attemptScheduling(node);
            }
            catch (Throwable ex) {
                LOG.error((Object)("Error while attempting scheduling for node " + node + ": " + ex.toString()), ex);
                if (!(ex instanceof YarnRuntimeException) || !(ex.getCause() instanceof InterruptedException)) continue;
                throw (InterruptedException)ex.getCause();
            }
        }
        long duration = this.getClock().getTime() - start;
        this.fsOpDurations.addContinuousSchedulingRunDuration(duration);
    }

    @VisibleForTesting
    synchronized void attemptScheduling(FSSchedulerNode node) {
        if (this.rmContext.isWorkPreservingRecoveryEnabled() && !this.rmContext.isSchedulerReadyForAllocatingContainers()) {
            return;
        }
        if (!SchedulerUtils.isNodeAvailable(node.getNodeID())) {
            LOG.error((Object)"Host is not resolved! Skip container scheduling on this node!", (Throwable)new UnknownHostException(node.getNodeID().getHost()));
            return;
        }
        NodeId nodeID = node.getNodeID();
        if (!this.nodes.containsKey(nodeID)) {
            LOG.info((Object)("Skipping scheduling as the node " + nodeID + " has been removed"));
            return;
        }
        boolean validReservation = false;
        FSAppAttempt reservedAppSchedulable = node.getReservedAppSchedulable();
        if (reservedAppSchedulable != null) {
            validReservation = reservedAppSchedulable.assignReservedContainer(node);
        }
        if (!validReservation) {
            int assignedContainers = 0;
            while (node.getReservedContainer() == null) {
                boolean assignedContainer = false;
                if (!this.queueMgr.getRootQueue().assignContainer(node).equals((Object)Resources.none())) {
                    ++assignedContainers;
                    assignedContainer = true;
                }
                if (assignedContainer && this.assignMultiple && (assignedContainers < this.maxAssign || this.maxAssign <= 0)) continue;
                break;
            }
        }
        this.updateRootQueueMetrics();
    }

    public FSAppAttempt getSchedulerApp(ApplicationAttemptId appAttemptId) {
        return (FSAppAttempt)super.getApplicationAttempt(appAttemptId);
    }

    @Override
    public ResourceCalculator getResourceCalculator() {
        return RESOURCE_CALCULATOR;
    }

    private void updateRootQueueMetrics() {
        this.rootMetrics.setAvailableResourcesToQueue(Resources.subtract((Resource)this.clusterResource, (Resource)this.rootMetrics.getAllocatedResources()));
    }

    private boolean shouldAttemptPreemption() {
        if (this.preemptionEnabled) {
            return (double)this.preemptionUtilizationThreshold < Math.max((double)Math.max((float)this.rootMetrics.getAllocatedMB() / (float)this.clusterResource.getMemory(), (float)this.rootMetrics.getAllocatedVirtualCores() / (float)this.clusterResource.getVirtualCores()), (double)((float)this.rootMetrics.getAllocatedDisks()) / this.clusterResource.getDisks());
        }
        return false;
    }

    private boolean shouldAttemptPreemption(Expression label, Resource allocatedResource) {
        if (this.preemptionEnabled) {
            Resource clusterResource = this.getClusterResource(label);
            return (double)this.preemptionUtilizationThreshold < Math.max((double)Math.max((float)allocatedResource.getMemory() / (float)clusterResource.getMemory(), (float)allocatedResource.getVirtualCores() / (float)clusterResource.getVirtualCores()), (double)((float)allocatedResource.getDisks()) / clusterResource.getDisks());
        }
        return false;
    }

    @Override
    public QueueMetrics getRootQueueMetrics() {
        return this.rootMetrics;
    }

    public void handle(SchedulerEvent event) {
        switch ((SchedulerEventType)event.getType()) {
            case NODE_ADDED: {
                if (!(event instanceof NodeAddedSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                NodeAddedSchedulerEvent nodeAddedEvent = (NodeAddedSchedulerEvent)event;
                this.addNode(nodeAddedEvent.getAddedRMNode());
                this.recoverContainersOnNode(nodeAddedEvent.getContainerReports(), nodeAddedEvent.getAddedRMNode());
                break;
            }
            case NODE_REMOVED: {
                if (!(event instanceof NodeRemovedSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                NodeRemovedSchedulerEvent nodeRemovedEvent = (NodeRemovedSchedulerEvent)event;
                this.removeNode(nodeRemovedEvent.getRemovedRMNode());
                break;
            }
            case NODE_UPDATE: {
                if (!(event instanceof NodeUpdateSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                NodeUpdateSchedulerEvent nodeUpdatedEvent = (NodeUpdateSchedulerEvent)event;
                this.nodeUpdate(nodeUpdatedEvent.getRMNode());
                break;
            }
            case APP_ADDED: {
                if (!(event instanceof AppAddedSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                AppAddedSchedulerEvent appAddedEvent = (AppAddedSchedulerEvent)event;
                String queueName = this.resolveReservationQueueName(appAddedEvent.getQueue(), appAddedEvent.getApplicationId(), appAddedEvent.getReservationID());
                if (queueName == null) break;
                this.addApplication(appAddedEvent.getApplicationId(), queueName, appAddedEvent.getUser(), appAddedEvent.getIsAppRecovering());
                break;
            }
            case APP_REMOVED: {
                if (!(event instanceof AppRemovedSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                AppRemovedSchedulerEvent appRemovedEvent = (AppRemovedSchedulerEvent)event;
                this.removeApplication(appRemovedEvent.getApplicationID(), appRemovedEvent.getFinalState());
                break;
            }
            case NODE_RESOURCE_UPDATE: {
                if (!(event instanceof NodeResourceUpdateSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                NodeResourceUpdateSchedulerEvent nodeResourceUpdatedEvent = (NodeResourceUpdateSchedulerEvent)event;
                this.updateNodeResource(nodeResourceUpdatedEvent.getRMNode(), nodeResourceUpdatedEvent.getResourceOption());
                break;
            }
            case APP_ATTEMPT_ADDED: {
                if (!(event instanceof AppAttemptAddedSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                AppAttemptAddedSchedulerEvent appAttemptAddedEvent = (AppAttemptAddedSchedulerEvent)event;
                this.addApplicationAttempt(appAttemptAddedEvent.getApplicationAttemptId(), appAttemptAddedEvent.getTransferStateFromPreviousAttempt(), appAttemptAddedEvent.getIsAttemptRecovering());
                break;
            }
            case APP_ATTEMPT_REMOVED: {
                if (!(event instanceof AppAttemptRemovedSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                AppAttemptRemovedSchedulerEvent appAttemptRemovedEvent = (AppAttemptRemovedSchedulerEvent)event;
                this.removeApplicationAttempt(appAttemptRemovedEvent.getApplicationAttemptID(), appAttemptRemovedEvent.getFinalAttemptState(), appAttemptRemovedEvent.getKeepContainersAcrossAppAttempts());
                break;
            }
            case CONTAINER_EXPIRED: {
                if (!(event instanceof ContainerExpiredSchedulerEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                ContainerExpiredSchedulerEvent containerExpiredEvent = (ContainerExpiredSchedulerEvent)event;
                ContainerId containerId = containerExpiredEvent.getContainerId();
                this.completedContainer(this.getRMContainer(containerId), SchedulerUtils.createAbnormalContainerStatus(containerId, "Container expired since it was unused"), RMContainerEventType.EXPIRE);
                break;
            }
            case CONTAINER_RESCHEDULED: {
                if (!(event instanceof ContainerRescheduledEvent)) {
                    throw new RuntimeException("Unexpected event type: " + (Object)((Object)event));
                }
                ContainerRescheduledEvent containerRescheduledEvent = (ContainerRescheduledEvent)event;
                RMContainer container = containerRescheduledEvent.getContainer();
                this.recoverResourceRequestForContainer(container);
                break;
            }
            default: {
                LOG.error((Object)("Unknown event arrived at FairScheduler: " + event.toString()));
            }
        }
    }

    private synchronized String resolveReservationQueueName(String queueName, ApplicationId applicationId, ReservationId reservationID) {
        FSQueue queue = this.queueMgr.getQueue(queueName);
        if (queue == null || !this.allocConf.isReservable(queue.getQueueName())) {
            return queueName;
        }
        queueName = queue.getQueueName();
        if (reservationID != null) {
            String resQName = queueName + "." + reservationID.toString();
            queue = this.queueMgr.getQueue(resQName);
            if (queue == null) {
                String message = "Application " + applicationId + " submitted to a reservation which is not yet currently active: " + resQName;
                this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.APP_REJECTED, message));
                return null;
            }
            if (!queue.getParent().getQueueName().equals(queueName)) {
                String message = "Application: " + applicationId + " submitted to a reservation " + resQName + " which does not belong to the specified queue: " + queueName;
                this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.APP_REJECTED, message));
                return null;
            }
            queueName = resQName;
        } else {
            queueName = this.getDefaultQueueForPlanQueue(queueName);
        }
        return queueName;
    }

    private String getDefaultQueueForPlanQueue(String queueName) {
        String planName = queueName.substring(queueName.lastIndexOf(".") + 1);
        queueName = queueName + "." + planName + "-default";
        return queueName;
    }

    @Override
    public void recover(RMStateStore.RMState state) throws Exception {
    }

    @Override
    public synchronized void setRMContext(RMContext rmContext) {
        this.rmContext = rmContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initScheduler(Configuration conf) throws IOException {
        FairScheduler fairScheduler = this;
        synchronized (fairScheduler) {
            this.conf = new FairSchedulerConfiguration(conf);
            this.validateConf(this.conf);
            this.minimumAllocation = this.conf.getMinimumAllocation();
            this.initMaximumResourceCapability(this.conf.getMaximumAllocation());
            this.incrAllocation = this.conf.getIncrementAllocation();
            this.continuousSchedulingEnabled = this.conf.isContinuousSchedulingEnabled();
            this.continuousSchedulingSleepMs = this.conf.getContinuousSchedulingSleepMs();
            this.nodeLocalityThreshold = this.conf.getLocalityThresholdNode();
            this.rackLocalityThreshold = this.conf.getLocalityThresholdRack();
            this.nodeLocalityDelayMs = this.conf.getLocalityDelayNodeMs();
            this.rackLocalityDelayMs = this.conf.getLocalityDelayRackMs();
            this.preemptionEnabled = this.conf.getPreemptionEnabled();
            this.preemptionUtilizationThreshold = this.conf.getPreemptionUtilizationThreshold();
            this.isPreemptionThresholdBasedOnLabelsEnabled = this.conf.isPreemptionThresholdBasedOnLabelsEnabled();
            this.assignMultiple = this.conf.getAssignMultiple();
            this.maxAssign = this.conf.getMaxAssign();
            this.sizeBasedWeight = this.conf.getSizeBasedWeight();
            this.preemptionInterval = this.conf.getPreemptionInterval();
            this.waitTimeBeforeKill = this.conf.getWaitTimeBeforeKill();
            this.usePortForNodeName = this.conf.getUsePortForNodeName();
            this.isResourcesBasedOnLabelsEnabled = this.conf.isResourcesBasedOnLabelsEnabled();
            this.updateInterval = this.conf.getUpdateInterval();
            if (this.updateInterval < 0L) {
                this.updateInterval = 500L;
                LOG.warn((Object)"yarn.scheduler.fair.update-interval-ms is invalid, so using default value 500 ms instead");
            }
            this.rootMetrics = FSQueueMetrics.forQueue("root", null, true, conf);
            this.fsOpDurations = FSOpDurations.getInstance(true);
            this.applications = new ConcurrentHashMap();
            this.eventLog = new FairSchedulerEventLog();
            this.eventLog.init(this.conf);
            this.allocConf = new AllocationConfiguration(conf);
            this.writeLockAlloc.lock();
            try {
                this.queueMgr.initialize(conf);
            }
            catch (Exception e) {
                throw new IOException("Failed to start FairScheduler", e);
            }
            finally {
                this.writeLockAlloc.unlock();
            }
            this.updateThread = new UpdateThread();
            this.updateThread.setName("FairSchedulerUpdateThread");
            this.updateThread.setDaemon(true);
            if (this.continuousSchedulingEnabled) {
                this.schedulingThread = new ContinuousSchedulingThread();
                this.schedulingThread.setName("FairSchedulerContinuousScheduling");
                this.schedulingThread.setDaemon(true);
            }
        }
        this.allocsLoader.init(conf);
        this.allocsLoader.setReloadListener(new AllocationReloadListener());
        try {
            this.allocsLoader.reloadAllocations();
        }
        catch (Exception e) {
            throw new IOException("Failed to initialize FairScheduler", e);
        }
    }

    private synchronized void startSchedulerThreads() {
        Preconditions.checkNotNull((Object)this.updateThread, (Object)"updateThread is null");
        Preconditions.checkNotNull((Object)((Object)this.allocsLoader), (Object)"allocsLoader is null");
        this.updateThread.start();
        if (this.continuousSchedulingEnabled) {
            Preconditions.checkNotNull((Object)this.schedulingThread, (Object)"schedulingThread is null");
            this.schedulingThread.start();
        }
        this.allocsLoader.start();
    }

    @Override
    public void serviceInit(Configuration conf) throws Exception {
        this.initScheduler(conf);
        super.serviceInit(conf);
    }

    public void serviceStart() throws Exception {
        this.startSchedulerThreads();
        super.serviceStart();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceStop() throws Exception {
        FairScheduler fairScheduler = this;
        synchronized (fairScheduler) {
            if (this.updateThread != null) {
                this.updateThread.interrupt();
                this.updateThread.join(1000L);
            }
            if (this.continuousSchedulingEnabled && this.schedulingThread != null) {
                this.schedulingThread.interrupt();
                this.schedulingThread.join(1000L);
            }
            if (this.allocsLoader != null) {
                this.allocsLoader.stop();
            }
        }
        super.serviceStop();
    }

    @Override
    public void reinitialize(Configuration conf, RMContext rmContext) throws IOException {
        try {
            this.allocsLoader.reloadAllocations();
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to reload allocations file", (Throwable)e);
        }
    }

    @Override
    public QueueInfo getQueueInfo(String queueName, boolean includeChildQueues, boolean recursive) throws IOException {
        if (!this.queueMgr.exists(queueName)) {
            throw new IOException("queue " + queueName + " does not exist");
        }
        return this.queueMgr.getQueue(queueName).getQueueInfo(includeChildQueues, recursive);
    }

    @Override
    public List<QueueUserACLInfo> getQueueUserAclInfo() {
        UserGroupInformation user;
        try {
            user = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ioe) {
            return new ArrayList<QueueUserACLInfo>();
        }
        return this.queueMgr.getRootQueue().getQueueUserAclInfo(user);
    }

    @Override
    public int getNumClusterNodes() {
        return this.nodes.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkAccess(UserGroupInformation callerUGI, QueueACL acl, String queueName) {
        this.readLockAlloc.lock();
        try {
            FSQueue queue = this.getQueueManager().getQueue(queueName);
            if (queue == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("ACL not found for queue access-type " + acl + " for queue " + queueName));
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = queue.hasAccess(acl, callerUGI);
            return bl;
        }
        finally {
            this.readLockAlloc.unlock();
        }
    }

    public AllocationConfiguration getAllocationConfiguration() {
        return this.allocConf;
    }

    @Override
    public List<ApplicationAttemptId> getAppsInQueue(String queueName) {
        FSQueue queue = this.queueMgr.getQueue(queueName);
        if (queue == null) {
            return null;
        }
        ArrayList<ApplicationAttemptId> apps = new ArrayList<ApplicationAttemptId>();
        queue.collectSchedulerApplications(apps);
        return apps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String moveApplication(ApplicationId appId, String queueName) throws YarnException {
        FSAppAttempt attempt;
        SchedulerApplication app = (SchedulerApplication)this.applications.get(appId);
        if (app == null) {
            throw new YarnException("App to be moved " + appId + " not found.");
        }
        FSAppAttempt fSAppAttempt = attempt = (FSAppAttempt)app.getCurrentAppAttempt();
        synchronized (fSAppAttempt) {
            FSLeafQueue oldQueue = (FSLeafQueue)app.getQueue();
            if (attempt.isStopped()) {
                LOG.info((Object)("Application " + appId + " is stopped and can't be moved!"));
                throw new YarnException("Application " + appId + " is stopped and can't be moved!");
            }
            String destQueueName = this.handleMoveToPlanQueue(queueName);
            FSLeafQueue targetQueue = this.queueMgr.getLeafQueue(destQueueName, false);
            if (targetQueue == null) {
                throw new YarnException("Target queue " + queueName + " not found or is not a leaf queue.");
            }
            if (targetQueue == oldQueue) {
                return oldQueue.getQueueName();
            }
            if (oldQueue.isRunnableApp(attempt)) {
                this.verifyMoveDoesNotViolateConstraints(attempt, oldQueue, targetQueue);
            }
            this.executeMove(app, attempt, oldQueue, targetQueue);
            return targetQueue.getQueueName();
        }
    }

    private void verifyMoveDoesNotViolateConstraints(FSAppAttempt app, FSLeafQueue oldQueue, FSLeafQueue targetQueue) throws YarnException {
        String queueName = targetQueue.getQueueName();
        ApplicationAttemptId appAttId = app.getApplicationAttemptId();
        FSQueue lowestCommonAncestor = this.findLowestCommonAncestorQueue(oldQueue, targetQueue);
        Resource consumption = app.getCurrentConsumption();
        for (FSQueue cur = targetQueue; cur != lowestCommonAncestor; cur = cur.getParent()) {
            if (cur.getNumRunnableApps() == this.allocConf.getQueueMaxApps(cur.getQueueName())) {
                throw new YarnException("Moving app attempt " + appAttId + " to queue " + queueName + " would violate queue maxRunningApps constraints on queue " + cur.getQueueName());
            }
            if (Resources.fitsIn((Resource)Resources.add((Resource)cur.getResourceUsage(), (Resource)consumption), (Resource)cur.getMaxShare())) continue;
            throw new YarnException("Moving app attempt " + appAttId + " to queue " + queueName + " would violate queue maxShare constraints on queue " + cur.getQueueName());
        }
    }

    private void executeMove(SchedulerApplication<FSAppAttempt> app, FSAppAttempt attempt, FSLeafQueue oldQueue, FSLeafQueue newQueue) throws YarnException {
        boolean wasRunnable = oldQueue.isRunnableApp(attempt);
        boolean nowRunnable = this.maxRunningEnforcer.canAppBeRunnable(newQueue, attempt.getUser());
        if (wasRunnable && !nowRunnable) {
            throw new YarnException("Should have already verified that app " + attempt.getApplicationId() + " would be runnable in new queue");
        }
        oldQueue.removeApp(attempt);
        if (wasRunnable) {
            this.maxRunningEnforcer.untrackRunnableApp(attempt);
        } else if (nowRunnable) {
            this.maxRunningEnforcer.untrackNonRunnableApp(attempt);
        }
        attempt.move(newQueue);
        app.setQueue(newQueue);
        newQueue.addApp(attempt, nowRunnable);
        if (nowRunnable) {
            this.maxRunningEnforcer.trackRunnableApp(attempt);
        }
        if (wasRunnable) {
            this.maxRunningEnforcer.updateRunnabilityOnAppRemoval(attempt, oldQueue);
        }
    }

    @VisibleForTesting
    FSQueue findLowestCommonAncestorQueue(FSQueue queue1, FSQueue queue2) {
        String name1 = queue1.getName();
        String name2 = queue2.getName();
        int lastPeriodIndex = -1;
        for (int i = 0; i < Math.max(name1.length(), name2.length()); ++i) {
            if (name1.length() <= i || name2.length() <= i || name1.charAt(i) != name2.charAt(i)) {
                return this.queueMgr.getQueue(name1.substring(0, lastPeriodIndex));
            }
            if (name1.charAt(i) != '.') continue;
            lastPeriodIndex = i;
        }
        return queue1;
    }

    @Override
    public synchronized void updateNodeResource(RMNode nm, ResourceOption resourceOption) {
        super.updateNodeResource(nm, resourceOption);
        this.updateRootQueueMetrics();
        this.queueMgr.getRootQueue().setSteadyFairShare(this.clusterResource);
        this.queueMgr.getRootQueue().recomputeSteadyShares();
    }

    @Override
    public EnumSet<YarnServiceProtos.SchedulerResourceTypes> getSchedulingResourceTypes() {
        return EnumSet.of(YarnServiceProtos.SchedulerResourceTypes.MEMORY, YarnServiceProtos.SchedulerResourceTypes.CPU, YarnServiceProtos.SchedulerResourceTypes.DISK);
    }

    @Override
    public Set<String> getPlanQueues() throws YarnException {
        HashSet<String> planQueues = new HashSet<String>();
        for (FSQueue fsQueue : this.queueMgr.getQueues()) {
            String queueName = fsQueue.getName();
            if (!this.allocConf.isReservable(queueName)) continue;
            planQueues.add(queueName);
        }
        return planQueues;
    }

    @Override
    public void setEntitlement(String queueName, QueueEntitlement entitlement) throws YarnException {
        FSLeafQueue reservationQueue = this.queueMgr.getLeafQueue(queueName, false);
        if (reservationQueue == null) {
            throw new YarnException("Target queue " + queueName + " not found or is not a leaf queue.");
        }
        reservationQueue.setWeights(entitlement.getCapacity());
    }

    @Override
    public void removeQueue(String queueName) throws YarnException {
        FSLeafQueue reservationQueue = this.queueMgr.getLeafQueue(queueName, false);
        if (reservationQueue != null && !this.queueMgr.removeLeafQueue(queueName)) {
            throw new YarnException("Could not remove queue " + queueName + " as its either not a leaf queue or its not empty");
        }
    }

    private String handleMoveToPlanQueue(String targetQueueName) {
        FSQueue dest = this.queueMgr.getQueue(targetQueueName);
        if (dest != null && this.allocConf.isReservable(dest.getQueueName())) {
            targetQueueName = this.getDefaultQueueForPlanQueue(targetQueueName);
        }
        return targetQueueName;
    }

    public boolean isResourcesBasedOnLabelsEnabled() {
        return this.isResourcesBasedOnLabelsEnabled;
    }

    private class AllocationReloadListener
    implements AllocationFileLoaderService.Listener {
        private AllocationReloadListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onReload(AllocationConfiguration queueInfo) {
            FairScheduler fairScheduler = FairScheduler.this;
            synchronized (fairScheduler) {
                FairScheduler.this.writeLockAlloc.lock();
                try {
                    FairScheduler.this.allocConf = queueInfo;
                    FairScheduler.this.allocConf.getDefaultSchedulingPolicy().initialize(FairScheduler.this.clusterResource);
                    FairScheduler.this.queueMgr.updateAllocationConfiguration(FairScheduler.this.allocConf);
                    FairScheduler.this.maxRunningEnforcer.updateRunnabilityOnReload();
                }
                finally {
                    FairScheduler.this.writeLockAlloc.unlock();
                }
            }
        }
    }

    private class NodeAvailableResourceComparator
    implements Comparator<NodeId> {
        private NodeAvailableResourceComparator() {
        }

        @Override
        public int compare(NodeId n1, NodeId n2) {
            if (!FairScheduler.this.nodes.containsKey(n1)) {
                return 1;
            }
            if (!FairScheduler.this.nodes.containsKey(n2)) {
                return -1;
            }
            return RESOURCE_CALCULATOR.compare(FairScheduler.this.clusterResource, ((FSSchedulerNode)FairScheduler.this.nodes.get(n2)).getAvailableResource(), ((FSSchedulerNode)FairScheduler.this.nodes.get(n1)).getAvailableResource());
        }
    }

    private class ContinuousSchedulingThread
    extends Thread {
        private ContinuousSchedulingThread() {
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    FairScheduler.this.continuousSchedulingAttempt();
                    Thread.sleep(FairScheduler.this.getContinuousSchedulingSleepMs());
                }
                catch (InterruptedException e) {
                    LOG.warn((Object)"Continuous scheduling thread interrupted. Exiting.", (Throwable)e);
                    return;
                }
            }
        }
    }

    private class UpdateThread
    extends Thread {
        private UpdateThread() {
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    Thread.sleep(FairScheduler.this.updateInterval);
                    long start = FairScheduler.this.getClock().getTime();
                    FairScheduler.this.update();
                    FairScheduler.this.preemptTasksIfNecessary();
                    long duration = FairScheduler.this.getClock().getTime() - start;
                    FairScheduler.this.fsOpDurations.addUpdateThreadRunDuration(duration);
                }
                catch (InterruptedException ie) {
                    LOG.warn((Object)"Update thread interrupted. Exiting.");
                    return;
                }
                catch (Exception e) {
                    LOG.error((Object)"Exception in fair scheduler UpdateThread", (Throwable)e);
                }
            }
        }
    }
}

