/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.java.dev.eval.Expression;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.QueueState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.resourcemanager.labelmanagement.LabelManager;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceWeights;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.AllocationConfigurationException;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSParentQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSSchedulerNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FairScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public abstract class FSQueue
implements Queue,
Schedulable {
    private Resource fairShare = Resources.createResource((int)0, (int)0);
    private Resource steadyFairShare = Resources.createResource((int)0, (int)0);
    private final Resource resourceUsage = Resource.newInstance((int)0, (int)0);
    private final String name;
    protected final FairScheduler scheduler;
    private final FSQueueMetrics metrics;
    protected Expression label;
    protected Queue.QueueLabelPolicy labelPolicy;
    protected String defaultLabel;
    protected final FSParentQueue parent;
    protected final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    protected SchedulingPolicy policy = SchedulingPolicy.DEFAULT_POLICY;
    private long fairSharePreemptionTimeout = Long.MAX_VALUE;
    private long minSharePreemptionTimeout = Long.MAX_VALUE;
    private float fairSharePreemptionThreshold = 0.5f;

    public FSQueue(String name, FairScheduler scheduler, FSParentQueue parent) {
        this.name = name;
        this.scheduler = scheduler;
        this.metrics = FSQueueMetrics.forQueue(this.getName(), parent, true, scheduler.getConf());
        this.metrics.setMinShare(this.getMinShare());
        this.metrics.setMaxShare(this.getMaxShare());
        this.parent = parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQueueName() {
        return this.name;
    }

    public SchedulingPolicy getPolicy() {
        return this.policy;
    }

    public FSParentQueue getParent() {
        return this.parent;
    }

    protected void throwPolicyDoesnotApplyException(SchedulingPolicy policy) throws AllocationConfigurationException {
        throw new AllocationConfigurationException("SchedulingPolicy " + policy + " does not apply to queue " + this.getName());
    }

    public abstract void setPolicy(SchedulingPolicy var1) throws AllocationConfigurationException;

    @Override
    public ResourceWeights getWeights() {
        return this.scheduler.getAllocationConfiguration().getQueueWeight(this.getName());
    }

    @Override
    public Resource getMinShare() {
        return this.scheduler.getAllocationConfiguration().getMinResources(this.getName());
    }

    @Override
    public Resource getMaxShare() {
        return this.scheduler.getAllocationConfiguration().getMaxResources(this.getName());
    }

    @Override
    public long getStartTime() {
        return 0L;
    }

    @Override
    public Priority getPriority() {
        Priority p = (Priority)this.recordFactory.newRecordInstance(Priority.class);
        p.setPriority(1);
        return p;
    }

    @Override
    public QueueInfo getQueueInfo(boolean includeChildQueues, boolean recursive) {
        Resource clusterResource;
        QueueInfo queueInfo = (QueueInfo)this.recordFactory.newRecordInstance(QueueInfo.class);
        queueInfo.setQueueName(this.getQueueName());
        Resource resource = clusterResource = this.scheduler.isResourcesBasedOnLabelsEnabled() ? this.scheduler.getClusterResource(this.label) : this.scheduler.getClusterResource();
        if (clusterResource.getMemory() == 0) {
            queueInfo.setCapacity(0.0f);
        } else {
            queueInfo.setCapacity((float)this.getFairShare().getMemory() / (float)clusterResource.getMemory());
        }
        if (this.getFairShare().getMemory() == 0) {
            queueInfo.setCurrentCapacity(0.0f);
        } else {
            queueInfo.setCurrentCapacity((float)this.getResourceUsage().getMemory() / (float)this.getFairShare().getMemory());
        }
        ArrayList<QueueInfo> childQueueInfos = new ArrayList<QueueInfo>();
        if (includeChildQueues) {
            List<FSQueue> childQueues = this.getChildQueues();
            for (FSQueue child : childQueues) {
                childQueueInfos.add(child.getQueueInfo(recursive, recursive));
            }
        }
        queueInfo.setChildQueues(childQueueInfos);
        queueInfo.setQueueState(QueueState.RUNNING);
        queueInfo.setQueueLabel(this.label == null ? "NONE" : this.label.toString());
        queueInfo.setQueueLabelPolicy(this.labelPolicy == null ? Queue.QueueLabelPolicy.AND.name() : this.labelPolicy.name());
        return queueInfo;
    }

    @Override
    public FSQueueMetrics getMetrics() {
        return this.metrics;
    }

    @Override
    public Resource getFairShare() {
        return this.fairShare;
    }

    @Override
    public void setFairShare(Resource fairShare) {
        Resource clusterResource = this.scheduler.isResourcesBasedOnLabelsEnabled() ? this.scheduler.getClusterResource(this.label) : this.scheduler.getClusterResource();
        this.fairShare = clusterResource != null ? Resources.componentwiseMin((Resource)fairShare, (Resource)clusterResource) : fairShare;
        this.metrics.setFairShare(this.fairShare);
    }

    public Resource getSteadyFairShare() {
        return this.steadyFairShare;
    }

    public void setSteadyFairShare(Resource steadyFairShare) {
        Resource clusterResource = this.scheduler.isResourcesBasedOnLabelsEnabled() ? this.scheduler.getClusterResource(this.label) : this.scheduler.getClusterResource();
        this.steadyFairShare = clusterResource != null ? Resources.componentwiseMin((Resource)steadyFairShare, (Resource)clusterResource) : steadyFairShare;
        this.metrics.setSteadyFairShare(this.steadyFairShare);
    }

    @Override
    public boolean hasAccess(QueueACL acl, UserGroupInformation user) {
        return this.scheduler.getAllocationConfiguration().hasAccess(this.name, acl, user);
    }

    public long getFairSharePreemptionTimeout() {
        return this.fairSharePreemptionTimeout;
    }

    public void setFairSharePreemptionTimeout(long fairSharePreemptionTimeout) {
        this.fairSharePreemptionTimeout = fairSharePreemptionTimeout;
    }

    public long getMinSharePreemptionTimeout() {
        return this.minSharePreemptionTimeout;
    }

    public void setMinSharePreemptionTimeout(long minSharePreemptionTimeout) {
        this.minSharePreemptionTimeout = minSharePreemptionTimeout;
    }

    public float getFairSharePreemptionThreshold() {
        return this.fairSharePreemptionThreshold;
    }

    public void setFairSharePreemptionThreshold(float fairSharePreemptionThreshold) {
        this.fairSharePreemptionThreshold = fairSharePreemptionThreshold;
    }

    public abstract void recomputeShares();

    public void updatePreemptionVariables() {
        this.minSharePreemptionTimeout = this.scheduler.getAllocationConfiguration().getMinSharePreemptionTimeout(this.getName());
        if (this.minSharePreemptionTimeout == -1L && this.parent != null) {
            this.minSharePreemptionTimeout = this.parent.getMinSharePreemptionTimeout();
        }
        this.fairSharePreemptionTimeout = this.scheduler.getAllocationConfiguration().getFairSharePreemptionTimeout(this.getName());
        if (this.fairSharePreemptionTimeout == -1L && this.parent != null) {
            this.fairSharePreemptionTimeout = this.parent.getFairSharePreemptionTimeout();
        }
        this.fairSharePreemptionThreshold = this.scheduler.getAllocationConfiguration().getFairSharePreemptionThreshold(this.getName());
        if (this.fairSharePreemptionThreshold < 0.0f && this.parent != null) {
            this.fairSharePreemptionThreshold = this.parent.getFairSharePreemptionThreshold();
        }
    }

    public abstract List<FSQueue> getChildQueues();

    public abstract void collectSchedulerApplications(Collection<ApplicationAttemptId> var1);

    public abstract int getNumRunnableApps();

    protected boolean assignContainerPreCheck(FSSchedulerNode node) {
        return Resources.fitsIn((Resource)this.getResourceUsage(), (Resource)this.scheduler.getAllocationConfiguration().getMaxResources(this.getName())) && node.getReservedContainer() == null;
    }

    public boolean isActive() {
        return this.getNumRunnableApps() > 0;
    }

    @Override
    public Resource getResourceUsage() {
        return this.resourceUsage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incUsedResource(Resource res) {
        Resource resource = this.resourceUsage;
        synchronized (resource) {
            Resources.addTo((Resource)this.resourceUsage, (Resource)res);
            if (this.parent != null) {
                this.parent.incUsedResource(res);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decUsedResource(Resource res) {
        Resource resource = this.resourceUsage;
        synchronized (resource) {
            Resources.subtractFrom((Resource)this.resourceUsage, (Resource)res);
            if (this.parent != null) {
                this.parent.decUsedResource(res);
            }
        }
    }

    public String toString() {
        return String.format("[%s, demand=%s, running=%s, share=%s, w=%s]", this.getName(), this.getDemand(), this.getResourceUsage(), this.fairShare, this.getWeights());
    }

    @Override
    public Set<String> getAccessibleNodeLabels() {
        return null;
    }

    @Override
    public String getDefaultNodeLabelExpression() {
        return null;
    }

    protected Expression refreshLabel() {
        String labelStr = this.scheduler.getAllocationConfiguration().getLabels().get(this.getName());
        if (labelStr == null && this.parent != null) {
            return this.parent.refreshLabel();
        }
        try {
            if (labelStr != null) {
                return LabelManager.getInstance().getEffectiveLabelExpr(labelStr);
            }
            return LabelManager.getInstance().getEffectiveLabelExpr("all");
        }
        catch (IOException e) {
            return null;
        }
    }

    protected void updateLabel() {
        if (!this.name.equals("root") && this.label == null && this.defaultLabel != null) {
            Expression labelExp = new Expression(this.defaultLabel);
            this.setLabel(labelExp);
        }
    }

    protected Queue.QueueLabelPolicy refreshLabelPolicy() {
        Queue.QueueLabelPolicy labelPolicy = this.scheduler.getAllocationConfiguration().getLabelPolicies().get(this.getName());
        if (labelPolicy == null && this.parent != null) {
            labelPolicy = this.parent.refreshLabelPolicy();
        }
        return labelPolicy != null ? labelPolicy : Queue.QueueLabelPolicy.AND;
    }

    @Override
    public Queue.QueueLabelPolicy getLabelPolicy() {
        return this.labelPolicy;
    }

    @Override
    public Expression getLabel() {
        return this.label;
    }

    public void setLabel(Expression label) {
        this.label = label;
    }

    public String getDefaultLabel() {
        return this.defaultLabel;
    }

    public void setDefaultLabel(String defaultLabel) {
        this.defaultLabel = defaultLabel;
    }

    public void setLabelPolicy(Queue.QueueLabelPolicy labelPolicy) {
        this.labelPolicy = labelPolicy;
    }

    public boolean fitsInMaxShare(Resource additionalResource) {
        Resource usagePlusAddition = Resources.add((Resource)this.getResourceUsage(), (Resource)additionalResource);
        if (!Resources.fitsIn((Resource)usagePlusAddition, (Resource)this.getMaxShare())) {
            return false;
        }
        FSParentQueue parentQueue = this.getParent();
        if (parentQueue != null) {
            return parentQueue.fitsInMaxShare(additionalResource);
        }
        return true;
    }
}

