/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.resource.ResourceWeights;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueueType;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.QueuePlacementPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.ReservationQueueConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.util.resource.Resources;

public class AllocationConfiguration
extends ReservationSchedulerConfiguration {
    private static final AccessControlList EVERYBODY_ACL = new AccessControlList("*");
    private static final AccessControlList NOBODY_ACL = new AccessControlList(" ");
    private final Map<String, Resource> minQueueResources;
    @VisibleForTesting
    final Map<String, Resource> maxQueueResources;
    private final Map<String, ResourceWeights> queueWeights;
    @VisibleForTesting
    final Map<String, Integer> queueMaxApps;
    @VisibleForTesting
    final Map<String, Integer> userMaxApps;
    private final int userMaxAppsDefault;
    private final int queueMaxAppsDefault;
    final Map<String, Float> queueMaxAMShares;
    private final float queueMaxAMShareDefault;
    private final Map<String, Map<QueueACL, AccessControlList>> queueAcls;
    private final Map<String, Long> minSharePreemptionTimeouts;
    private final Map<String, Long> fairSharePreemptionTimeouts;
    private final Map<String, Float> fairSharePreemptionThresholds;
    private final Set<String> reservableQueues;
    private final Map<String, SchedulingPolicy> schedulingPolicies;
    private final Map<String, String> labels;
    private final Map<String, Queue.QueueLabelPolicy> labelPolicies;
    private final String defaultQueueLabel;
    private final SchedulingPolicy defaultSchedulingPolicy;
    @VisibleForTesting
    QueuePlacementPolicy placementPolicy;
    @VisibleForTesting
    Map<FSQueueType, Set<String>> configuredQueues;
    private ReservationQueueConfiguration globalReservationQueueConfig;

    public AllocationConfiguration(Map<String, Resource> minQueueResources, Map<String, Resource> maxQueueResources, Map<String, Integer> queueMaxApps, Map<String, Integer> userMaxApps, Map<String, ResourceWeights> queueWeights, Map<String, Float> queueMaxAMShares, int userMaxAppsDefault, int queueMaxAppsDefault, float queueMaxAMShareDefault, Map<String, SchedulingPolicy> schedulingPolicies, SchedulingPolicy defaultSchedulingPolicy, Map<String, Long> minSharePreemptionTimeouts, Map<String, Long> fairSharePreemptionTimeouts, Map<String, Float> fairSharePreemptionThresholds, Map<String, Map<QueueACL, AccessControlList>> queueAcls, QueuePlacementPolicy placementPolicy, Map<FSQueueType, Set<String>> configuredQueues, ReservationQueueConfiguration globalReservationQueueConfig, Set<String> reservableQueues, Map<String, String> queueLabels, Map<String, Queue.QueueLabelPolicy> queueLabelPolicies, String defaultLabel) {
        this.minQueueResources = minQueueResources;
        this.maxQueueResources = maxQueueResources;
        this.queueMaxApps = queueMaxApps;
        this.userMaxApps = userMaxApps;
        this.queueMaxAMShares = queueMaxAMShares;
        this.queueWeights = queueWeights;
        this.userMaxAppsDefault = userMaxAppsDefault;
        this.queueMaxAppsDefault = queueMaxAppsDefault;
        this.queueMaxAMShareDefault = queueMaxAMShareDefault;
        this.defaultSchedulingPolicy = defaultSchedulingPolicy;
        this.schedulingPolicies = schedulingPolicies;
        this.minSharePreemptionTimeouts = minSharePreemptionTimeouts;
        this.fairSharePreemptionTimeouts = fairSharePreemptionTimeouts;
        this.fairSharePreemptionThresholds = fairSharePreemptionThresholds;
        this.queueAcls = queueAcls;
        this.reservableQueues = reservableQueues;
        this.globalReservationQueueConfig = globalReservationQueueConfig;
        this.placementPolicy = placementPolicy;
        this.configuredQueues = configuredQueues;
        this.labels = queueLabels;
        this.labelPolicies = queueLabelPolicies;
        this.defaultQueueLabel = defaultLabel;
    }

    public AllocationConfiguration(Configuration conf) {
        this.minQueueResources = new HashMap<String, Resource>();
        this.maxQueueResources = new HashMap<String, Resource>();
        this.queueWeights = new HashMap<String, ResourceWeights>();
        this.queueMaxApps = new HashMap<String, Integer>();
        this.userMaxApps = new HashMap<String, Integer>();
        this.queueMaxAMShares = new HashMap<String, Float>();
        this.userMaxAppsDefault = Integer.MAX_VALUE;
        this.queueMaxAppsDefault = Integer.MAX_VALUE;
        this.queueMaxAMShareDefault = 0.5f;
        this.queueAcls = new HashMap<String, Map<QueueACL, AccessControlList>>();
        this.minSharePreemptionTimeouts = new HashMap<String, Long>();
        this.fairSharePreemptionTimeouts = new HashMap<String, Long>();
        this.fairSharePreemptionThresholds = new HashMap<String, Float>();
        this.schedulingPolicies = new HashMap<String, SchedulingPolicy>();
        this.defaultSchedulingPolicy = SchedulingPolicy.DEFAULT_POLICY;
        this.reservableQueues = new HashSet<String>();
        this.configuredQueues = new HashMap<FSQueueType, Set<String>>();
        for (FSQueueType queueType : FSQueueType.values()) {
            this.configuredQueues.put(queueType, new HashSet());
        }
        this.placementPolicy = QueuePlacementPolicy.fromConfiguration(conf, this.configuredQueues);
        this.labels = new HashMap<String, String>();
        this.labelPolicies = new HashMap<String, Queue.QueueLabelPolicy>();
        this.defaultQueueLabel = null;
    }

    public AccessControlList getQueueAcl(String queue, QueueACL operation) {
        AccessControlList operationAcl;
        Map<QueueACL, AccessControlList> queueAcls = this.queueAcls.get(queue);
        if (queueAcls != null && (operationAcl = queueAcls.get(operation)) != null) {
            return operationAcl;
        }
        return queue.equals("root") ? EVERYBODY_ACL : NOBODY_ACL;
    }

    public long getMinSharePreemptionTimeout(String queueName) {
        Long minSharePreemptionTimeout = this.minSharePreemptionTimeouts.get(queueName);
        return minSharePreemptionTimeout == null ? -1L : minSharePreemptionTimeout;
    }

    public long getFairSharePreemptionTimeout(String queueName) {
        Long fairSharePreemptionTimeout = this.fairSharePreemptionTimeouts.get(queueName);
        return fairSharePreemptionTimeout == null ? -1L : fairSharePreemptionTimeout;
    }

    public float getFairSharePreemptionThreshold(String queueName) {
        Float fairSharePreemptionThreshold = this.fairSharePreemptionThresholds.get(queueName);
        return fairSharePreemptionThreshold == null ? -1.0f : fairSharePreemptionThreshold.floatValue();
    }

    public ResourceWeights getQueueWeight(String queue) {
        ResourceWeights weight = this.queueWeights.get(queue);
        return weight == null ? ResourceWeights.NEUTRAL : weight;
    }

    public void setQueueWeight(String queue, ResourceWeights weight) {
        this.queueWeights.put(queue, weight);
    }

    public int getUserMaxApps(String user) {
        Integer maxApps = this.userMaxApps.get(user);
        return maxApps == null ? this.userMaxAppsDefault : maxApps;
    }

    public int getQueueMaxApps(String queue) {
        Integer maxApps = this.queueMaxApps.get(queue);
        return maxApps == null ? this.queueMaxAppsDefault : maxApps;
    }

    public float getQueueMaxAMShare(String queue) {
        Float maxAMShare = this.queueMaxAMShares.get(queue);
        return maxAMShare == null ? this.queueMaxAMShareDefault : maxAMShare.floatValue();
    }

    public Resource getMinResources(String queue) {
        Resource minQueueResource = this.minQueueResources.get(queue);
        return minQueueResource == null ? Resources.none() : minQueueResource;
    }

    public Resource getMaxResources(String queueName) {
        Resource maxQueueResource = this.maxQueueResources.get(queueName);
        return maxQueueResource == null ? Resources.unbounded() : maxQueueResource;
    }

    public boolean hasAccess(String queueName, QueueACL acl, UserGroupInformation user) {
        int lastPeriodIndex = queueName.length();
        while (lastPeriodIndex != -1) {
            String queue = queueName.substring(0, lastPeriodIndex);
            if (this.getQueueAcl(queue, acl).isUserAllowed(user)) {
                return true;
            }
            lastPeriodIndex = queueName.lastIndexOf(46, lastPeriodIndex - 1);
        }
        return false;
    }

    public SchedulingPolicy getSchedulingPolicy(String queueName) {
        SchedulingPolicy policy = this.schedulingPolicies.get(queueName);
        return policy == null ? this.defaultSchedulingPolicy : policy;
    }

    public SchedulingPolicy getDefaultSchedulingPolicy() {
        return this.defaultSchedulingPolicy;
    }

    public Map<FSQueueType, Set<String>> getConfiguredQueues() {
        return this.configuredQueues;
    }

    public QueuePlacementPolicy getPlacementPolicy() {
        return this.placementPolicy;
    }

    @Override
    public boolean isReservable(String queue) {
        return this.reservableQueues.contains(queue);
    }

    @Override
    public long getReservationWindow(String queue) {
        return this.globalReservationQueueConfig.getReservationWindowMsec();
    }

    @Override
    public float getAverageCapacity(String queue) {
        return this.globalReservationQueueConfig.getAvgOverTimeMultiplier() * 100.0f;
    }

    @Override
    public float getInstantaneousMaxCapacity(String queue) {
        return this.globalReservationQueueConfig.getMaxOverTimeMultiplier() * 100.0f;
    }

    @Override
    public String getReservationAdmissionPolicy(String queue) {
        return this.globalReservationQueueConfig.getReservationAdmissionPolicy();
    }

    @Override
    public String getReservationAgent(String queue) {
        return this.globalReservationQueueConfig.getReservationAgent();
    }

    @Override
    public boolean getShowReservationAsQueues(String queue) {
        return this.globalReservationQueueConfig.shouldShowReservationAsQueues();
    }

    @Override
    public String getReplanner(String queue) {
        return this.globalReservationQueueConfig.getPlanner();
    }

    @Override
    public boolean getMoveOnExpiry(String queue) {
        return this.globalReservationQueueConfig.shouldMoveOnExpiry();
    }

    @Override
    public long getEnforcementWindow(String queue) {
        return this.globalReservationQueueConfig.getEnforcementWindowMsec();
    }

    @VisibleForTesting
    public void setReservationWindow(long window) {
        this.globalReservationQueueConfig.setReservationWindow(window);
    }

    @VisibleForTesting
    public void setAverageCapacity(int avgCapacity) {
        this.globalReservationQueueConfig.setAverageCapacity(avgCapacity);
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public String getDefaultQueueLabel() {
        return this.defaultQueueLabel;
    }

    public Map<String, Queue.QueueLabelPolicy> getLabelPolicies() {
        return this.labelPolicies;
    }
}

