/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.common.fica;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.nodelabels.CommonNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerApplicationAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNode;

public class FiCaSchedulerNode
extends SchedulerNode {
    private static final Log LOG = LogFactory.getLog(FiCaSchedulerNode.class);

    public FiCaSchedulerNode(RMNode node, boolean usePortForNodeName, Set<String> nodeLabels) {
        super(node, usePortForNodeName, nodeLabels);
    }

    public FiCaSchedulerNode(RMNode node, boolean usePortForNodeName) {
        this(node, usePortForNodeName, CommonNodeLabelsManager.EMPTY_STRING_SET);
    }

    @Override
    public synchronized void reserveResource(SchedulerApplicationAttempt application, Priority priority, RMContainer container) {
        RMContainer reservedContainer = this.getReservedContainer();
        if (reservedContainer != null) {
            if (!container.getContainer().getNodeId().equals((Object)this.getNodeID())) {
                throw new IllegalStateException("Trying to reserve container " + container + " on node " + container.getReservedNode() + " when currently reserved resource " + reservedContainer + " on node " + reservedContainer.getReservedNode());
            }
            if (!reservedContainer.getContainer().getId().getApplicationAttemptId().equals((Object)container.getContainer().getId().getApplicationAttemptId())) {
                throw new IllegalStateException("Trying to reserve container " + container + " for application " + application.getApplicationAttemptId() + " when currently reserved container " + reservedContainer + " on node " + this);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Updated reserved container " + container.getContainer().getId() + " on node " + this + " for application attempt " + application.getApplicationAttemptId()));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Reserved container " + container.getContainer().getId() + " on node " + this + " for application attempt " + application.getApplicationAttemptId()));
        }
        this.setReservedContainer(container);
    }

    @Override
    public synchronized void unreserveResource(SchedulerApplicationAttempt application) {
        ApplicationAttemptId reservedApplication;
        if (this.getReservedContainer() != null && this.getReservedContainer().getContainer() != null && this.getReservedContainer().getContainer().getId() != null && this.getReservedContainer().getContainer().getId().getApplicationAttemptId() != null && !(reservedApplication = this.getReservedContainer().getContainer().getId().getApplicationAttemptId()).equals((Object)application.getApplicationAttemptId())) {
            throw new IllegalStateException("Trying to unreserve  for application " + application.getApplicationAttemptId() + " when currently reserved  for application " + reservedApplication.getApplicationId() + " on node " + this);
        }
        this.setReservedContainer(null);
    }
}

