/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import java.util.List;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationDeleteRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationUpdateRequest;
import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.ReservationRequest;
import org.apache.hadoop.yarn.api.records.ReservationRequestInterpreter;
import org.apache.hadoop.yarn.api.records.ReservationRequests;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystem;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;

public class ReservationInputValidator {
    private final Clock clock;

    public ReservationInputValidator(Clock clock) {
        this.clock = clock;
    }

    private Plan validateReservation(ReservationSystem reservationSystem, ReservationId reservationId, String auditConstant) throws YarnException {
        String message = "";
        if (reservationId == null) {
            message = "Missing reservation id. Please try again by specifying a reservation id.";
            RMAuditLogger.logFailure("UNKNOWN", auditConstant, "validate reservation input", "ClientRMService", message);
            throw RPCUtil.getRemoteException((String)message);
        }
        String queueName = reservationSystem.getQueueForReservation(reservationId);
        if (queueName == null) {
            message = "The specified reservation with ID: " + reservationId + " is unknown. Please try again with a valid reservation.";
            RMAuditLogger.logFailure("UNKNOWN", auditConstant, "validate reservation input", "ClientRMService", message);
            throw RPCUtil.getRemoteException((String)message);
        }
        Plan plan = reservationSystem.getPlan(queueName);
        if (plan == null) {
            message = "The specified reservation: " + reservationId + " is not associated with any valid plan. Please try again with a valid reservation.";
            RMAuditLogger.logFailure("UNKNOWN", auditConstant, "validate reservation input", "ClientRMService", message);
            throw RPCUtil.getRemoteException((String)message);
        }
        return plan;
    }

    private void validateReservationDefinition(ReservationId reservationId, ReservationDefinition contract, Plan plan, String auditConstant) throws YarnException {
        String message = "";
        if (contract == null) {
            message = "Missing reservation definition. Please try again by specifying a reservation definition.";
            RMAuditLogger.logFailure("UNKNOWN", auditConstant, "validate reservation input definition", "ClientRMService", message);
            throw RPCUtil.getRemoteException((String)message);
        }
        if (contract.getDeadline() <= this.clock.getTime()) {
            message = "The specified deadline: " + contract.getDeadline() + " is the past. Please try again with deadline in the future.";
            RMAuditLogger.logFailure("UNKNOWN", auditConstant, "validate reservation input definition", "ClientRMService", message);
            throw RPCUtil.getRemoteException((String)message);
        }
        ReservationRequests resReqs = contract.getReservationRequests();
        if (resReqs == null) {
            message = "No resources have been specified to reserve.Please try again by specifying the resources to reserve.";
            RMAuditLogger.logFailure("UNKNOWN", auditConstant, "validate reservation input definition", "ClientRMService", message);
            throw RPCUtil.getRemoteException((String)message);
        }
        List resReq = resReqs.getReservationResources();
        if (resReq == null || resReq.isEmpty()) {
            message = "No resources have been specified to reserve. Please try again by specifying the resources to reserve.";
            RMAuditLogger.logFailure("UNKNOWN", auditConstant, "validate reservation input definition", "ClientRMService", message);
            throw RPCUtil.getRemoteException((String)message);
        }
        long minDuration = 0L;
        Resource maxGangSize = Resource.newInstance((int)0, (int)0);
        ReservationRequestInterpreter type = contract.getReservationRequests().getInterpreter();
        for (ReservationRequest rr : resReq) {
            minDuration = type == ReservationRequestInterpreter.R_ALL || type == ReservationRequestInterpreter.R_ANY ? Math.max(minDuration, rr.getDuration()) : (minDuration += rr.getDuration());
            maxGangSize = Resources.max((ResourceCalculator)plan.getResourceCalculator(), (Resource)plan.getTotalCapacity(), (Resource)maxGangSize, (Resource)Resources.multiply((Resource)rr.getCapability(), (double)rr.getConcurrency()));
        }
        if (contract.getDeadline() - contract.getArrival() < minDuration && type != ReservationRequestInterpreter.R_ANY) {
            message = "The time difference (" + (contract.getDeadline() - contract.getArrival()) + ") between arrival (" + contract.getArrival() + ") and deadline (" + contract.getDeadline() + ") must  be greater or equal to the minimum resource duration (" + minDuration + ")";
            RMAuditLogger.logFailure("UNKNOWN", auditConstant, "validate reservation input definition", "ClientRMService", message);
            throw RPCUtil.getRemoteException((String)message);
        }
        if (Resources.greaterThan((ResourceCalculator)plan.getResourceCalculator(), (Resource)plan.getTotalCapacity(), (Resource)maxGangSize, (Resource)plan.getTotalCapacity()) && type != ReservationRequestInterpreter.R_ANY) {
            message = "The size of the largest gang in the reservation refinition (" + maxGangSize + ") exceed the capacity available (" + plan.getTotalCapacity() + " )";
            RMAuditLogger.logFailure("UNKNOWN", auditConstant, "validate reservation input definition", "ClientRMService", message);
            throw RPCUtil.getRemoteException((String)message);
        }
    }

    public Plan validateReservationSubmissionRequest(ReservationSystem reservationSystem, ReservationSubmissionRequest request, ReservationId reservationId) throws YarnException {
        String queueName = request.getQueue();
        if (queueName == null || queueName.isEmpty()) {
            String errMsg = "The queue to submit is not specified. Please try again with a valid reservable queue.";
            RMAuditLogger.logFailure("UNKNOWN", "Submit Reservation Request", "validate reservation input", "ClientRMService", errMsg);
            throw RPCUtil.getRemoteException((String)errMsg);
        }
        Plan plan = reservationSystem.getPlan(queueName);
        if (plan == null) {
            String errMsg = "The specified queue: " + queueName + " is not managed by reservation system. Please try again with a valid reservable queue.";
            RMAuditLogger.logFailure("UNKNOWN", "Submit Reservation Request", "validate reservation input", "ClientRMService", errMsg);
            throw RPCUtil.getRemoteException((String)errMsg);
        }
        this.validateReservationDefinition(reservationId, request.getReservationDefinition(), plan, "Submit Reservation Request");
        return plan;
    }

    public Plan validateReservationUpdateRequest(ReservationSystem reservationSystem, ReservationUpdateRequest request) throws YarnException {
        ReservationId reservationId = request.getReservationId();
        Plan plan = this.validateReservation(reservationSystem, reservationId, "Update Reservation Request");
        this.validateReservationDefinition(reservationId, request.getReservationDefinition(), plan, "Update Reservation Request");
        return plan;
    }

    public Plan validateReservationDeleteRequest(ReservationSystem reservationSystem, ReservationDeleteRequest request) throws YarnException {
        return this.validateReservation(reservationSystem, request.getReservationId(), "Delete Reservation Request");
    }
}

