/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.proto.YarnServerCommonProtos;
import org.apache.hadoop.yarn.proto.YarnServerResourceManagerRecoveryProtos;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.security.client.YARNDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.records.impl.pb.VersionPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.AMRMTokenSecretManagerState;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationAttemptStateData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.Epoch;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.RMDelegationTokenIdentifierData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.AMRMTokenSecretManagerStatePBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.ApplicationAttemptStateDataPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.ApplicationStateDataPBImpl;
import org.apache.hadoop.yarn.server.utils.LeveldbIterator;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.fusesource.leveldbjni.JniDBFactory;
import org.fusesource.leveldbjni.internal.NativeDB;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBException;
import org.iq80.leveldb.Logger;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.WriteBatch;

public class LeveldbRMStateStore
extends RMStateStore {
    public static final Log LOG = LogFactory.getLog(LeveldbRMStateStore.class);
    private static final String SEPARATOR = "/";
    private static final String DB_NAME = "yarn-rm-state";
    private static final String RM_DT_MASTER_KEY_KEY_PREFIX = "RMDTSecretManagerRoot/DelegationKey_";
    private static final String RM_DT_TOKEN_KEY_PREFIX = "RMDTSecretManagerRoot/RMDelegationToken_";
    private static final String RM_DT_SEQUENCE_NUMBER_KEY = "RMDTSecretManagerRoot/RMDTSequentialNumber";
    private static final String RM_APP_KEY_PREFIX = "RMAppRoot/application_";
    private static final Version CURRENT_VERSION_INFO = Version.newInstance((int)1, (int)0);
    private DB db;

    private String getApplicationNodeKey(ApplicationId appId) {
        return "RMAppRoot/" + appId;
    }

    private String getApplicationAttemptNodeKey(ApplicationAttemptId attemptId) {
        return this.getApplicationAttemptNodeKey(this.getApplicationNodeKey(attemptId.getApplicationId()), attemptId);
    }

    private String getApplicationAttemptNodeKey(String appNodeKey, ApplicationAttemptId attemptId) {
        return appNodeKey + SEPARATOR + attemptId;
    }

    private String getRMDTMasterKeyNodeKey(DelegationKey masterKey) {
        return RM_DT_MASTER_KEY_KEY_PREFIX + masterKey.getKeyId();
    }

    private String getRMDTTokenNodeKey(RMDelegationTokenIdentifier tokenId) {
        return RM_DT_TOKEN_KEY_PREFIX + tokenId.getSequenceNumber();
    }

    @Override
    protected void initInternal(Configuration conf) throws Exception {
    }

    private Path getStorageDir() throws IOException {
        Configuration conf = this.getConfig();
        String storePath = conf.get("yarn.resourcemanager.leveldb-state-store.path");
        if (storePath == null) {
            throw new IOException("No store location directory configured in yarn.resourcemanager.leveldb-state-store.path");
        }
        return new Path(storePath, DB_NAME);
    }

    private Path createStorageDir() throws IOException {
        Path root = this.getStorageDir();
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.getConfig());
        fs.mkdirs(root, new FsPermission(448));
        return root;
    }

    @Override
    protected void startInternal() throws Exception {
        Path storeRoot = this.createStorageDir();
        Options options = new Options();
        options.createIfMissing(false);
        options.logger((Logger)new LeveldbLogger());
        LOG.info((Object)("Using state database at " + storeRoot + " for recovery"));
        File dbfile = new File(storeRoot.toString());
        try {
            this.db = JniDBFactory.factory.open(dbfile, options);
        }
        catch (NativeDB.DBException e) {
            if (e.isNotFound() || e.getMessage().contains(" does not exist ")) {
                LOG.info((Object)("Creating state database at " + dbfile));
                options.createIfMissing(true);
                try {
                    this.db = JniDBFactory.factory.open(dbfile, options);
                    this.storeVersion();
                }
                catch (DBException dbErr) {
                    throw new IOException(dbErr.getMessage(), dbErr);
                }
            }
            throw e;
        }
    }

    @Override
    protected void closeInternal() throws Exception {
        if (this.db != null) {
            this.db.close();
            this.db = null;
        }
    }

    @VisibleForTesting
    boolean isClosed() {
        return this.db == null;
    }

    @Override
    protected Version loadVersion() throws Exception {
        VersionPBImpl version = null;
        try {
            byte[] data = this.db.get(JniDBFactory.bytes((String)"RMVersionNode"));
            if (data != null) {
                version = new VersionPBImpl(YarnServerCommonProtos.VersionProto.parseFrom((byte[])data));
            }
        }
        catch (DBException e) {
            throw new IOException(e);
        }
        return version;
    }

    @Override
    protected void storeVersion() throws Exception {
        this.dbStoreVersion(CURRENT_VERSION_INFO);
    }

    void dbStoreVersion(Version state) throws IOException {
        String key = "RMVersionNode";
        byte[] data = ((VersionPBImpl)state).getProto().toByteArray();
        try {
            this.db.put(JniDBFactory.bytes((String)key), data);
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected Version getCurrentVersion() {
        return CURRENT_VERSION_INFO;
    }

    @Override
    public synchronized long getAndIncrementEpoch() throws Exception {
        long currentEpoch = 0L;
        byte[] dbKeyBytes = JniDBFactory.bytes((String)"EpochNode");
        try {
            byte[] data = this.db.get(dbKeyBytes);
            if (data != null) {
                currentEpoch = YarnServerResourceManagerRecoveryProtos.EpochProto.parseFrom(data).getEpoch();
            }
            YarnServerResourceManagerRecoveryProtos.EpochProto proto = Epoch.newInstance(currentEpoch + 1L).getProto();
            this.db.put(dbKeyBytes, proto.toByteArray());
        }
        catch (DBException e) {
            throw new IOException(e);
        }
        return currentEpoch;
    }

    @Override
    public RMStateStore.RMState loadState() throws Exception {
        RMStateStore.RMState rmState = new RMStateStore.RMState();
        this.loadRMDTSecretManagerState(rmState);
        this.loadRMApps(rmState);
        this.loadAMRMTokenSecretManagerState(rmState);
        return rmState;
    }

    private void loadRMDTSecretManagerState(RMStateStore.RMState state) throws IOException {
        int numKeys = this.loadRMDTSecretManagerKeys(state);
        LOG.info((Object)("Recovered " + numKeys + " RM delegation token master keys"));
        int numTokens = this.loadRMDTSecretManagerTokens(state);
        LOG.info((Object)("Recovered " + numTokens + " RM delegation tokens"));
        this.loadRMDTSecretManagerTokenSequenceNumber(state);
    }

    private int loadRMDTSecretManagerKeys(RMStateStore.RMState state) throws IOException {
        int numKeys = 0;
        try (LeveldbIterator iter = null;){
            iter = new LeveldbIterator(this.db);
            iter.seek(JniDBFactory.bytes((String)RM_DT_MASTER_KEY_KEY_PREFIX));
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = JniDBFactory.asString((byte[])((byte[])entry.getKey()));
                if (!key.startsWith(RM_DT_MASTER_KEY_KEY_PREFIX)) {
                    break;
                }
                DelegationKey masterKey = this.loadDelegationKey((byte[])entry.getValue());
                state.rmSecretManagerState.masterKeyState.add(masterKey);
                ++numKeys;
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Loaded RM delegation key from " + key + ": keyId=" + masterKey.getKeyId() + ", expirationDate=" + masterKey.getExpiryDate()));
            }
        }
        return numKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DelegationKey loadDelegationKey(byte[] data) throws IOException {
        DelegationKey key = new DelegationKey();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
        try {
            key.readFields((DataInput)in);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{in});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{in});
        return key;
    }

    private int loadRMDTSecretManagerTokens(RMStateStore.RMState state) throws IOException {
        int numTokens = 0;
        try (LeveldbIterator iter = null;){
            iter = new LeveldbIterator(this.db);
            iter.seek(JniDBFactory.bytes((String)RM_DT_TOKEN_KEY_PREFIX));
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = JniDBFactory.asString((byte[])((byte[])entry.getKey()));
                if (!key.startsWith(RM_DT_TOKEN_KEY_PREFIX)) {
                    break;
                }
                RMDelegationTokenIdentifierData tokenData = this.loadDelegationToken((byte[])entry.getValue());
                RMDelegationTokenIdentifier tokenId = tokenData.getTokenIdentifier();
                long renewDate = tokenData.getRenewDate();
                state.rmSecretManagerState.delegationTokenState.put(tokenId, renewDate);
                ++numTokens;
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("Loaded RM delegation token from " + key + ": tokenId=" + tokenId + ", renewDate=" + renewDate));
            }
        }
        return numTokens;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RMDelegationTokenIdentifierData loadDelegationToken(byte[] data) throws IOException {
        RMDelegationTokenIdentifierData tokenData = new RMDelegationTokenIdentifierData();
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
        try {
            tokenData.readFields(in);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{in});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{in});
        return tokenData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadRMDTSecretManagerTokenSequenceNumber(RMStateStore.RMState state) throws IOException {
        byte[] data = null;
        try {
            data = this.db.get(JniDBFactory.bytes((String)RM_DT_SEQUENCE_NUMBER_KEY));
        }
        catch (DBException e) {
            throw new IOException(e);
        }
        if (data != null) {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
            try {
                state.rmSecretManagerState.dtSequenceNumber = in.readInt();
            }
            catch (Throwable throwable) {
                IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{in});
                throw throwable;
            }
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{in});
        }
    }

    private void loadRMApps(RMStateStore.RMState state) throws IOException {
        int numApps = 0;
        int numAppAttempts = 0;
        try (LeveldbIterator iter = null;){
            iter = new LeveldbIterator(this.db);
            iter.seek(JniDBFactory.bytes((String)RM_APP_KEY_PREFIX));
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String key = JniDBFactory.asString((byte[])((byte[])entry.getKey()));
                if (!key.startsWith(RM_APP_KEY_PREFIX)) {
                    break;
                }
                String appIdStr = key.substring("RMAppRoot".length() + 1);
                if (appIdStr.contains(SEPARATOR)) {
                    LOG.warn((Object)("Skipping extraneous data " + key));
                    continue;
                }
                numAppAttempts += this.loadRMApp(state, iter, appIdStr, (byte[])entry.getValue());
                ++numApps;
            }
        }
        LOG.info((Object)("Recovered " + numApps + " applications and " + numAppAttempts + " application attempts"));
    }

    private int loadRMApp(RMStateStore.RMState rmState, LeveldbIterator iter, String appIdStr, byte[] appData) throws IOException {
        Map.Entry entry;
        String key;
        ApplicationStateData appState = this.createApplicationState(appIdStr, appData);
        ApplicationId appId = appState.getApplicationSubmissionContext().getApplicationId();
        rmState.appState.put(appId, appState);
        String attemptNodePrefix = this.getApplicationNodeKey(appId) + SEPARATOR;
        while (iter.hasNext() && (key = JniDBFactory.asString((byte[])((byte[])(entry = iter.peekNext()).getKey()))).startsWith(attemptNodePrefix)) {
            String attemptId = key.substring(attemptNodePrefix.length());
            if (attemptId.startsWith("appattempt_")) {
                ApplicationAttemptStateData attemptState = this.createAttemptState(attemptId, (byte[])entry.getValue());
                appState.attempts.put(attemptState.getAttemptId(), attemptState);
            } else {
                LOG.warn((Object)("Ignoring unknown application key: " + key));
            }
            iter.next();
        }
        int numAttempts = appState.attempts.size();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Loaded application " + appId + " with " + numAttempts + " attempts"));
        }
        return numAttempts;
    }

    private ApplicationStateData createApplicationState(String appIdStr, byte[] data) throws IOException {
        ApplicationStateDataPBImpl appState;
        ApplicationId appId = ConverterUtils.toApplicationId((String)appIdStr);
        if (!appId.equals((Object)(appState = new ApplicationStateDataPBImpl(YarnServerResourceManagerRecoveryProtos.ApplicationStateDataProto.parseFrom(data))).getApplicationSubmissionContext().getApplicationId())) {
            throw new YarnRuntimeException("The database entry for " + appId + " contains data for " + appState.getApplicationSubmissionContext().getApplicationId());
        }
        return appState;
    }

    @VisibleForTesting
    ApplicationStateData loadRMAppState(ApplicationId appId) throws IOException {
        String appKey = this.getApplicationNodeKey(appId);
        byte[] data = null;
        try {
            data = this.db.get(JniDBFactory.bytes((String)appKey));
        }
        catch (DBException e) {
            throw new IOException(e);
        }
        if (data == null) {
            return null;
        }
        return this.createApplicationState(appId.toString(), data);
    }

    @VisibleForTesting
    ApplicationAttemptStateData loadRMAppAttemptState(ApplicationAttemptId attemptId) throws IOException {
        String attemptKey = this.getApplicationAttemptNodeKey(attemptId);
        byte[] data = null;
        try {
            data = this.db.get(JniDBFactory.bytes((String)attemptKey));
        }
        catch (DBException e) {
            throw new IOException(e);
        }
        if (data == null) {
            return null;
        }
        return this.createAttemptState(attemptId.toString(), data);
    }

    private ApplicationAttemptStateData createAttemptState(String itemName, byte[] data) throws IOException {
        ApplicationAttemptStateDataPBImpl attemptState;
        ApplicationAttemptId attemptId = ConverterUtils.toApplicationAttemptId((String)itemName);
        if (!attemptId.equals((Object)(attemptState = new ApplicationAttemptStateDataPBImpl(YarnServerResourceManagerRecoveryProtos.ApplicationAttemptStateDataProto.parseFrom(data))).getAttemptId())) {
            throw new YarnRuntimeException("The database entry for " + attemptId + " contains data for " + attemptState.getAttemptId());
        }
        return attemptState;
    }

    private void loadAMRMTokenSecretManagerState(RMStateStore.RMState rmState) throws IOException {
        try {
            byte[] data = this.db.get(JniDBFactory.bytes((String)"AMRMTokenSecretManagerRoot"));
            if (data != null) {
                AMRMTokenSecretManagerStatePBImpl stateData = new AMRMTokenSecretManagerStatePBImpl(YarnServerResourceManagerRecoveryProtos.AMRMTokenSecretManagerStateProto.parseFrom(data));
                rmState.amrmTokenSecretManagerState = AMRMTokenSecretManagerState.newInstance(stateData.getCurrentMasterKey(), stateData.getNextMasterKey());
            }
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void storeApplicationStateInternal(ApplicationId appId, ApplicationStateData appStateData) throws IOException {
        String key = this.getApplicationNodeKey(appId);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Storing state for app " + appId + " at " + key));
        }
        try {
            this.db.put(JniDBFactory.bytes((String)key), appStateData.getProto().toByteArray());
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void updateApplicationStateInternal(ApplicationId appId, ApplicationStateData appStateData) throws IOException {
        this.storeApplicationStateInternal(appId, appStateData);
    }

    @Override
    protected void storeApplicationAttemptStateInternal(ApplicationAttemptId attemptId, ApplicationAttemptStateData attemptStateData) throws IOException {
        String key = this.getApplicationAttemptNodeKey(attemptId);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Storing state for attempt " + attemptId + " at " + key));
        }
        try {
            this.db.put(JniDBFactory.bytes((String)key), attemptStateData.getProto().toByteArray());
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void updateApplicationAttemptStateInternal(ApplicationAttemptId attemptId, ApplicationAttemptStateData attemptStateData) throws IOException {
        this.storeApplicationAttemptStateInternal(attemptId, attemptStateData);
    }

    @Override
    public synchronized void removeApplicationAttemptInternal(ApplicationAttemptId attemptId) throws IOException {
        String attemptKey = this.getApplicationAttemptNodeKey(attemptId);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing state for attempt " + attemptId + " at " + attemptKey));
        }
        try {
            this.db.delete(JniDBFactory.bytes((String)attemptKey));
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeApplicationStateInternal(ApplicationStateData appState) throws IOException {
        ApplicationId appId = appState.getApplicationSubmissionContext().getApplicationId();
        String appKey = this.getApplicationNodeKey(appId);
        try (WriteBatch batch = this.db.createWriteBatch();){
            batch.delete(JniDBFactory.bytes((String)appKey));
            for (ApplicationAttemptId attemptId : appState.attempts.keySet()) {
                String attemptKey = this.getApplicationAttemptNodeKey(appKey, attemptId);
                batch.delete(JniDBFactory.bytes((String)attemptKey));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removing state for app " + appId + " and " + appState.attempts.size() + " attempts at " + appKey));
            }
            this.db.write(batch);
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeOrUpdateRMDT(RMDelegationTokenIdentifier tokenId, Long renewDate, boolean isUpdate) throws IOException {
        String tokenKey = this.getRMDTTokenNodeKey(tokenId);
        RMDelegationTokenIdentifierData tokenData = new RMDelegationTokenIdentifierData((YARNDelegationTokenIdentifier)tokenId, renewDate);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Storing token to " + tokenKey));
        }
        try (WriteBatch batch = this.db.createWriteBatch();){
            batch.put(JniDBFactory.bytes((String)tokenKey), tokenData.toByteArray());
            if (!isUpdate) {
                ByteArrayOutputStream bs = new ByteArrayOutputStream();
                try (DataOutputStream ds = new DataOutputStream(bs);){
                    ds.writeInt(tokenId.getSequenceNumber());
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Storing " + tokenId.getSequenceNumber() + " to " + RM_DT_SEQUENCE_NUMBER_KEY));
                }
                batch.put(JniDBFactory.bytes((String)RM_DT_SEQUENCE_NUMBER_KEY), bs.toByteArray());
            }
            this.db.write(batch);
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void storeRMDelegationTokenState(RMDelegationTokenIdentifier tokenId, Long renewDate) throws IOException {
        this.storeOrUpdateRMDT(tokenId, renewDate, false);
    }

    @Override
    protected void updateRMDelegationTokenState(RMDelegationTokenIdentifier tokenId, Long renewDate) throws IOException {
        this.storeOrUpdateRMDT(tokenId, renewDate, true);
    }

    @Override
    protected void removeRMDelegationTokenState(RMDelegationTokenIdentifier tokenId) throws IOException {
        String tokenKey = this.getRMDTTokenNodeKey(tokenId);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing token at " + tokenKey));
        }
        try {
            this.db.delete(JniDBFactory.bytes((String)tokenKey));
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void storeRMDTMasterKeyState(DelegationKey masterKey) throws IOException {
        String dbKey = this.getRMDTMasterKeyNodeKey(masterKey);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Storing token master key to " + dbKey));
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (DataOutputStream out = new DataOutputStream(os);){
            masterKey.write((DataOutput)out);
        }
        try {
            this.db.put(JniDBFactory.bytes((String)dbKey), os.toByteArray());
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected void removeRMDTMasterKeyState(DelegationKey masterKey) throws IOException {
        String dbKey = this.getRMDTMasterKeyNodeKey(masterKey);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Removing token master key at " + dbKey));
        }
        try {
            this.db.delete(JniDBFactory.bytes((String)dbKey));
        }
        catch (DBException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void storeOrUpdateAMRMTokenSecretManagerState(AMRMTokenSecretManagerState state, boolean isUpdate) {
        AMRMTokenSecretManagerState data = AMRMTokenSecretManagerState.newInstance(state);
        byte[] stateData = data.getProto().toByteArray();
        this.db.put(JniDBFactory.bytes((String)"AMRMTokenSecretManagerRoot"), stateData);
    }

    @Override
    public void deleteStore() throws IOException {
        Path root = this.getStorageDir();
        LOG.info((Object)("Deleting state database at " + root));
        this.db.close();
        this.db = null;
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.getConfig());
        fs.delete(root, true);
    }

    @VisibleForTesting
    int getNumEntriesInDatabase() throws IOException {
        int numEntries = 0;
        try (LeveldbIterator iter = null;){
            iter = new LeveldbIterator(this.db);
            iter.seekToFirst();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                LOG.info((Object)("entry: " + JniDBFactory.asString((byte[])((byte[])entry.getKey()))));
                ++numEntries;
            }
        }
        return numEntries;
    }

    private static class LeveldbLogger
    implements Logger {
        private static final Log LOG = LogFactory.getLog(LeveldbLogger.class);

        private LeveldbLogger() {
        }

        public void log(String message) {
            LOG.info((Object)message);
        }
    }
}

