/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.labelmanagement;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import net.java.dev.eval.Expression;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeToLabelsList;
import org.apache.hadoop.yarn.server.resourcemanager.labelmanagement.LabelExpressionHandlingHelper;
import org.apache.hadoop.yarn.server.resourcemanager.labelmanagement.LabelStorage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;

public class LabelManager {
    private static final Log LOG = LogFactory.getLog(LabelManager.class);
    private long lastModified = 0L;
    public static final String NODE_LABELS_FILE = "node.labels.file";
    public static final String NODE_LABELS_MONITOR_INTERVAL = "node.labels.monitor.interval";
    public static final long DEFAULT_RELOAD_INTERVAL = 120000L;
    private FileSystem fs;
    private Configuration config;
    private Path labelFile = null;
    private long labelManagerMonitorInterval = 120000L;
    private static LabelManager s_instance = new LabelManager();
    private Timer timer;
    private FileMonitor ttask;
    private volatile boolean isServiceEnabled;
    private LabelStorage storage = LabelStorage.getInstance();

    private LabelManager() {
    }

    public static LabelManager getInstance() {
        return s_instance;
    }

    void serviceInit(Configuration conf) throws Exception {
        this.setConfig(conf);
        this.fs = FileSystem.get((Configuration)conf);
        String labelFilePath = conf.get(NODE_LABELS_FILE, null);
        if (labelFilePath != null) {
            this.labelFile = new Path(labelFilePath);
            if (!this.fs.exists(this.labelFile)) {
                LOG.warn((Object)("Could not find node label file " + this.fs.makeQualified(this.labelFile) + ". Node labels will not be set."));
                this.labelFile = null;
            }
            this.labelManagerMonitorInterval = conf.getLong(NODE_LABELS_MONITOR_INTERVAL, 120000L);
        }
        this.storage.storageInit(this.fs, this.labelFile);
    }

    void serviceStart() throws Exception {
        if (this.labelFile != null) {
            this.timer = new Timer();
            this.ttask = new FileMonitor();
            this.timer.scheduleAtFixedRate((TimerTask)this.ttask, 0L, this.labelManagerMonitorInterval);
            this.isServiceEnabled = true;
        }
    }

    void serviceStop() throws Exception {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public void setConfig(Configuration conf) {
        this.config = conf;
    }

    public boolean isServiceEnabled() {
        return this.isServiceEnabled;
    }

    private boolean fileChanged() throws IOException {
        FileStatus labelFileStatus = null;
        if (!this.fs.exists(this.labelFile)) {
            return false;
        }
        labelFileStatus = this.fs.getFileStatus(this.labelFile);
        if (labelFileStatus != null && (this.lastModified == 0L || this.lastModified < labelFileStatus.getModificationTime())) {
            this.lastModified = labelFileStatus.getModificationTime();
            return true;
        }
        return false;
    }

    @InterfaceAudience.Private
    public void refreshLabels(Configuration conf) throws IOException {
        this.storage.loadAndApplyLabels(conf);
    }

    public Set<String> getLabelsForNode(String node) {
        return this.storage.getLabelsForNode(node);
    }

    public List<NodeToLabelsList> getLabelsForAllNodes() {
        return this.storage.getLabelsForAllNodes();
    }

    public Set<Expression> getLabels() {
        return this.storage.getLabels();
    }

    public Map<String, Set<NodeId>> getLabelsToNodes(Set<String> labelsToAdd) {
        HashMap<String, Set<NodeId>> labelsToNodes = new HashMap<String, Set<NodeId>>();
        for (NodeToLabelsList n : this.storage.getLabelsForAllNodes()) {
            NodeId nodeId = NodeId.newInstance((String)n.getNode(), (int)0);
            List nodeLabels = n.getNodeLabel();
            for (String label : nodeLabels) {
                if (labelsToAdd != null && !labelsToAdd.isEmpty() && (labelsToAdd == null || !labelsToAdd.contains(label))) continue;
                HashSet<NodeId> nodeIds = (HashSet<NodeId>)labelsToNodes.get(label);
                if (nodeIds == null) {
                    nodeIds = new HashSet<NodeId>();
                    nodeIds.add(nodeId);
                    labelsToNodes.put(label, nodeIds);
                    continue;
                }
                nodeIds.add(nodeId);
                labelsToNodes.remove(label);
                labelsToNodes.put(label, nodeIds);
            }
        }
        return labelsToNodes;
    }

    public Map<NodeId, Set<String>> getNodeToLabels() {
        HashMap<NodeId, Set<String>> nodeToLabels = new HashMap<NodeId, Set<String>>();
        for (NodeToLabelsList n : this.storage.getLabelsForAllNodes()) {
            NodeId nodeId = NodeId.newInstance((String)n.getNode(), (int)0);
            HashSet nodeLabels = new HashSet(n.getNodeLabel());
            nodeToLabels.put(nodeId, nodeLabels);
        }
        return nodeToLabels;
    }

    public Expression getEffectiveLabelExpr(String labelStr) throws IOException {
        return LabelExpressionHandlingHelper.getEffectiveLabelExpr(labelStr);
    }

    public Expression constructAppLabel(Queue.QueueLabelPolicy policy, Expression appLabelExpression, Expression queueLabelExpression) {
        return LabelExpressionHandlingHelper.constructAppLabel(policy, appLabelExpression, queueLabelExpression);
    }

    public LabelApplicabilityStatus isNodeApplicableForApp(String node, Expression finalAppLabelExp) throws IOException {
        return LabelExpressionHandlingHelper.isNodeApplicableForApp(node, finalAppLabelExp);
    }

    public List<String> getNodesForLabel(Expression label) throws IOException {
        return LabelExpressionHandlingHelper.getNodesForLabel(label);
    }

    public Path getLabelFile() {
        return this.labelFile;
    }

    public static enum LabelApplicabilityStatus {
        NOT_APPLICABLE,
        NODE_HAS_LABEL,
        NODE_DOES_NOT_HAVE_LABEL;

    }

    private class FileMonitor
    extends TimerTask {
        private FileMonitor() {
        }

        @Override
        public void run() {
            try {
                if (LabelManager.this.fileChanged()) {
                    LabelManager.this.storage.loadAndApplyLabels(LabelManager.this.config);
                }
            }
            catch (Exception e) {
                LOG.error((Object)("LabelManager Thread got exception: " + StringUtils.stringifyException((Throwable)e) + ". Ignoring..."));
            }
        }
    }
}

