/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.labelmanagement;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.java.dev.eval.Expression;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.NodeToLabelsList;
import org.apache.hadoop.yarn.server.resourcemanager.labelmanagement.LabelManager;
import org.apache.hadoop.yarn.server.resourcemanager.labelmanagement.LabelStorage;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.Queue;

public class LabelExpressionHandlingHelper {
    private static final Log LOG = LogFactory.getLog(LabelExpressionHandlingHelper.class);

    static Expression getEffectiveLabelExpr(String label) throws IOException {
        Expression labelExpression;
        if (label == null) {
            return null;
        }
        String labelExpressionString = label.replaceAll("^\"|\"$", "");
        if ("*".equals(labelExpressionString) || "all".equals(labelExpressionString)) {
            labelExpression = null;
        } else {
            labelExpressionString = LabelExpressionHandlingHelper.parseAndWrapLabel(labelExpressionString);
            try {
                labelExpression = new Expression(labelExpressionString);
            }
            catch (Throwable t) {
                LOG.warn((Object)("Invalid label format " + labelExpressionString + " Error " + t));
                return null;
            }
        }
        return labelExpression;
    }

    private static String parseAndWrapLabel(String label) {
        String[] labels = label.split("\\(|\\)|!|&&|\\|\\|");
        ArrayList<String> cleanLabels = new ArrayList<String>();
        for (int i = 0; i < labels.length; ++i) {
            if (labels[i].matches(" ||")) continue;
            cleanLabels.add(labels[i].trim());
        }
        int endInd = 0;
        for (String tmpLabel : cleanLabels) {
            int startInd = label.indexOf(tmpLabel, endInd);
            endInd = startInd + tmpLabel.length();
            String wrappedLabel = LabelExpressionHandlingHelper.wrapIfNeeded(tmpLabel);
            label = label.substring(0, startInd) + wrappedLabel + label.substring(endInd);
            if (wrappedLabel.equals(tmpLabel)) continue;
            endInd += 2;
        }
        LOG.debug((Object)("Final wrapped label expression: " + label));
        return label;
    }

    private static String wrapIfNeeded(String label) {
        boolean shouldBeWrapped;
        String SINGLE_QUOTATION_MARK = "'";
        String DOUBLE_QUOTATION_MARK = "\"";
        boolean bl = shouldBeWrapped = !(!label.contains(" ") || StringUtils.startsWith((String)label, (String)"'") && StringUtils.endsWith((String)label, (String)"'") || StringUtils.startsWith((String)label, (String)"\"") && StringUtils.endsWith((String)label, (String)"\""));
        if (shouldBeWrapped) {
            label = "'" + label + "'";
        }
        return label;
    }

    static Expression constructAppLabel(Queue.QueueLabelPolicy policy, Expression appLabelExpression, Expression queueLabelExpression) {
        if (Queue.QueueLabelPolicy.AND.equals((Object)policy)) {
            if (queueLabelExpression != null && appLabelExpression != null) {
                return new Expression("(" + queueLabelExpression.toString() + ") && (" + appLabelExpression.toString() + ")");
            }
            if (queueLabelExpression == null) {
                return appLabelExpression;
            }
            return queueLabelExpression;
        }
        if (Queue.QueueLabelPolicy.OR.equals((Object)policy)) {
            if (queueLabelExpression != null && appLabelExpression != null) {
                return new Expression("(" + queueLabelExpression.toString() + ") || (" + appLabelExpression.toString() + ")");
            }
            if (queueLabelExpression == null) {
                return appLabelExpression;
            }
            return queueLabelExpression;
        }
        if (Queue.QueueLabelPolicy.PREFER_QUEUE.equals((Object)policy)) {
            return queueLabelExpression;
        }
        if (Queue.QueueLabelPolicy.PREFER_APP.equals((Object)policy)) {
            return appLabelExpression;
        }
        return appLabelExpression;
    }

    static LabelManager.LabelApplicabilityStatus isNodeApplicableForApp(String node, Expression finalAppLabelExp) throws IOException {
        if (finalAppLabelExp == null) {
            return LabelManager.LabelApplicabilityStatus.NOT_APPLICABLE;
        }
        Set<String> nodeLabels = LabelStorage.getInstance().getLabelsForNode(node);
        if (nodeLabels == null || nodeLabels.isEmpty()) {
            return LabelManager.LabelApplicabilityStatus.NODE_DOES_NOT_HAVE_LABEL;
        }
        Map<String, BigDecimal> labelEvalFillersTmp = LabelStorage.getInstance().getFillers();
        for (String label : nodeLabels) {
            labelEvalFillersTmp.put(label, BigDecimal.valueOf(1L));
        }
        try {
            BigDecimal retValue = finalAppLabelExp.eval(labelEvalFillersTmp);
            return retValue.intValue() == 0 ? LabelManager.LabelApplicabilityStatus.NODE_DOES_NOT_HAVE_LABEL : LabelManager.LabelApplicabilityStatus.NODE_HAS_LABEL;
        }
        catch (Throwable t) {
            LOG.warn((Object)("Exception while evaluating: " + finalAppLabelExp), t);
            throw new IOException("Exception while evaluating: " + finalAppLabelExp);
        }
    }

    static List<String> getNodesForLabel(Expression label) throws IOException {
        ArrayList<String> nodesForLabel = new ArrayList<String>();
        List<NodeToLabelsList> labelsForAllNodes = LabelStorage.getInstance().getLabelsForAllNodes();
        LabelManager lb = LabelManager.getInstance();
        for (NodeToLabelsList nodeToLabels : labelsForAllNodes) {
            LabelManager.LabelApplicabilityStatus blackListStatus = lb.isNodeApplicableForApp(nodeToLabels.getNode(), label);
            if (blackListStatus != LabelManager.LabelApplicabilityStatus.NOT_APPLICABLE && blackListStatus != LabelManager.LabelApplicabilityStatus.NODE_HAS_LABEL) continue;
            nodesForLabel.add(nodeToLabels.getNode());
        }
        return nodesForLabel;
    }
}

