/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceBlacklistRequest;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.YarnApplicationAttemptState;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.exceptions.InvalidContainerReleaseException;
import org.apache.hadoop.yarn.exceptions.InvalidResourceBlacklistRequestException;
import org.apache.hadoop.yarn.exceptions.InvalidResourceRequestException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.security.YarnAuthorizationProvider;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttemptState;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.resource.Resources;

public class RMServerUtils {
    public static final ApplicationResourceUsageReport DUMMY_APPLICATION_RESOURCE_USAGE_REPORT = BuilderUtils.newApplicationResourceUsageReport((int)-1, (int)-1, (Resource)Resources.createResource((int)-1, (int)-1), (Resource)Resources.createResource((int)-1, (int)-1), (Resource)Resources.createResource((int)-1, (int)-1), (long)0L, (long)0L);

    public static List<RMNode> queryRMNodes(RMContext context, EnumSet<NodeState> acceptedStates) {
        ArrayList<RMNode> results = new ArrayList<RMNode>();
        if (acceptedStates.contains(NodeState.NEW) || acceptedStates.contains(NodeState.RUNNING) || acceptedStates.contains(NodeState.UNHEALTHY)) {
            for (RMNode rmNode : context.getRMNodes().values()) {
                if (!acceptedStates.contains(rmNode.getState())) continue;
                results.add(rmNode);
            }
        }
        if (acceptedStates.contains(NodeState.DECOMMISSIONED) || acceptedStates.contains(NodeState.LOST) || acceptedStates.contains(NodeState.REBOOTED)) {
            for (RMNode rmNode : context.getInactiveRMNodes().values()) {
                if (!acceptedStates.contains(rmNode.getState())) continue;
                results.add(rmNode);
            }
        }
        return results;
    }

    public static void normalizeAndValidateRequests(List<ResourceRequest> ask, Resource maximumResource, String queueName, YarnScheduler scheduler) throws InvalidResourceRequestException {
        for (ResourceRequest resReq : ask) {
            SchedulerUtils.normalizeAndvalidateRequest(resReq, maximumResource, queueName, scheduler);
        }
    }

    public static void validateBlacklistRequest(ResourceBlacklistRequest blacklistRequest) throws InvalidResourceBlacklistRequestException {
        List plus;
        if (blacklistRequest != null && (plus = blacklistRequest.getBlacklistAdditions()) != null && plus.contains("*")) {
            throw new InvalidResourceBlacklistRequestException("Cannot add * to the blacklist!");
        }
    }

    public static void validateContainerReleaseRequest(List<ContainerId> containerReleaseList, ApplicationAttemptId appAttemptId) throws InvalidContainerReleaseException {
        for (ContainerId cId : containerReleaseList) {
            if (appAttemptId.equals((Object)cId.getApplicationAttemptId())) continue;
            throw new InvalidContainerReleaseException("Cannot release container : " + cId.toString() + " not belonging to this application attempt : " + appAttemptId);
        }
    }

    public static UserGroupInformation verifyAdminAccess(YarnAuthorizationProvider authorizer, String method, Log LOG) throws IOException {
        return RMServerUtils.verifyAdminAccess(authorizer, method, "AdminService", LOG);
    }

    public static UserGroupInformation verifyAdminAccess(YarnAuthorizationProvider authorizer, String method, String module, Log LOG) throws IOException {
        UserGroupInformation user;
        try {
            user = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ioe) {
            LOG.warn((Object)"Couldn't get current user", (Throwable)ioe);
            RMAuditLogger.logFailure("UNKNOWN", method, "", "AdminService", "Couldn't get current user");
            throw ioe;
        }
        if (!authorizer.isAdmin(user)) {
            LOG.warn((Object)("User " + user.getShortUserName() + " doesn't have permission to call '" + method + "'"));
            RMAuditLogger.logFailure(user.getShortUserName(), method, "", module, "Unauthorized user");
            throw new AccessControlException("User " + user.getShortUserName() + " doesn't have permission to call '" + method + "'");
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(method + " invoked by user " + user.getShortUserName()));
        }
        return user;
    }

    public static YarnApplicationState createApplicationState(RMAppState rmAppState) {
        switch (rmAppState) {
            case NEW: {
                return YarnApplicationState.NEW;
            }
            case NEW_SAVING: {
                return YarnApplicationState.NEW_SAVING;
            }
            case SUBMITTED: {
                return YarnApplicationState.SUBMITTED;
            }
            case ACCEPTED: {
                return YarnApplicationState.ACCEPTED;
            }
            case RUNNING: {
                return YarnApplicationState.RUNNING;
            }
            case FINISHING: 
            case FINISHED: {
                return YarnApplicationState.FINISHED;
            }
            case KILLED: {
                return YarnApplicationState.KILLED;
            }
            case FAILED: {
                return YarnApplicationState.FAILED;
            }
        }
        throw new YarnRuntimeException("Unknown state passed!");
    }

    public static YarnApplicationAttemptState createApplicationAttemptState(RMAppAttemptState rmAppAttemptState) {
        switch (rmAppAttemptState) {
            case NEW: {
                return YarnApplicationAttemptState.NEW;
            }
            case SUBMITTED: {
                return YarnApplicationAttemptState.SUBMITTED;
            }
            case SCHEDULED: {
                return YarnApplicationAttemptState.SCHEDULED;
            }
            case ALLOCATED: {
                return YarnApplicationAttemptState.ALLOCATED;
            }
            case LAUNCHED: {
                return YarnApplicationAttemptState.LAUNCHED;
            }
            case ALLOCATED_SAVING: 
            case LAUNCHED_UNMANAGED_SAVING: {
                return YarnApplicationAttemptState.ALLOCATED_SAVING;
            }
            case RUNNING: {
                return YarnApplicationAttemptState.RUNNING;
            }
            case FINISHING: {
                return YarnApplicationAttemptState.FINISHING;
            }
            case FINISHED: {
                return YarnApplicationAttemptState.FINISHED;
            }
            case KILLED: {
                return YarnApplicationAttemptState.KILLED;
            }
            case FAILED: {
                return YarnApplicationAttemptState.FAILED;
            }
        }
        throw new YarnRuntimeException("Unknown state passed!");
    }

    public static void processRMProxyUsersConf(Configuration conf) {
        HashMap rmProxyUsers = new HashMap();
        for (Map.Entry entry : conf) {
            String propName = (String)entry.getKey();
            if (!propName.startsWith("yarn.resourcemanager.proxyuser.")) continue;
            rmProxyUsers.put("hadoop.proxyuser." + propName.substring("yarn.resourcemanager.proxyuser.".length()), entry.getValue());
        }
        for (Map.Entry entry : rmProxyUsers.entrySet()) {
            conf.set((String)entry.getKey(), (String)entry.getValue());
        }
    }
}

