/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import com.google.protobuf.InvalidProtocolBufferException;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.ActiveStandbyElector;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.ServiceFailedException;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.ZKUtil;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.proto.YarnServerResourceManagerServiceProtos;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMFatalEvent;
import org.apache.hadoop.yarn.server.resourcemanager.RMFatalEventType;
import org.apache.hadoop.yarn.server.resourcemanager.RMZKUtils;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.ACL;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class EmbeddedElectorService
extends AbstractService
implements ActiveStandbyElector.ActiveStandbyElectorCallback {
    private static final Log LOG = LogFactory.getLog((String)EmbeddedElectorService.class.getName());
    private static final HAServiceProtocol.StateChangeRequestInfo req = new HAServiceProtocol.StateChangeRequestInfo(HAServiceProtocol.RequestSource.REQUEST_BY_ZKFC);
    private RMContext rmContext;
    private byte[] localActiveNodeInfo;
    private ActiveStandbyElector elector;

    EmbeddedElectorService(RMContext rmContext) {
        super(EmbeddedElectorService.class.getName());
        this.rmContext = rmContext;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        String zkQuorum = (conf = conf instanceof YarnConfiguration ? conf : new YarnConfiguration(conf)).get("yarn.resourcemanager.zk-address");
        if (zkQuorum == null) {
            throw new YarnRuntimeException("Embedded automatic failover is enabled, but yarn.resourcemanager.zk-address is not set");
        }
        String rmId = HAUtil.getRMHAId((Configuration)conf);
        String clusterId = YarnConfiguration.getClusterId((Configuration)conf);
        this.localActiveNodeInfo = EmbeddedElectorService.createActiveNodeInfo(clusterId, rmId);
        String zkBasePath = conf.get("yarn.resourcemanager.ha.automatic-failover.zk-base-path", "/yarn-leader-election");
        String electionZNode = zkBasePath + "/" + clusterId;
        long zkSessionTimeout = conf.getLong("yarn.resourcemanager.zk-timeout-ms", 10000L);
        List<ACL> zkAcls = RMZKUtils.getZKAcls(conf);
        List<ZKUtil.ZKAuthInfo> zkAuths = RMZKUtils.getZKAuths(conf);
        int maxRetryNum = conf.getInt("ha.failover-controller.active-standby-elector.zk.op.retries", 3);
        this.elector = new ActiveStandbyElector(zkQuorum, (int)zkSessionTimeout, electionZNode, zkAcls, zkAuths, (ActiveStandbyElector.ActiveStandbyElectorCallback)this, maxRetryNum);
        this.elector.ensureParentZNode();
        if (!this.isParentZnodeSafe(clusterId)) {
            this.notifyFatalError(electionZNode + " znode has invalid data! Might need formatting!");
        }
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        this.elector.joinElection(this.localActiveNodeInfo);
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.elector != null) {
            this.elector.quitElection(false);
            this.elector.terminateConnection();
        }
        super.serviceStop();
    }

    public void becomeActive() throws ServiceFailedException {
        try {
            this.rmContext.getRMAdminService().transitionToActive(req);
        }
        catch (Exception e) {
            throw new ServiceFailedException("RM could not transition to Active", (Throwable)e);
        }
    }

    public void becomeStandby() {
        try {
            this.rmContext.getRMAdminService().transitionToStandby(req);
        }
        catch (Exception e) {
            LOG.error((Object)"RM could not transition to Standby", (Throwable)e);
        }
    }

    public void enterNeutralMode() {
    }

    public void notifyFatalError(String errorMessage) {
        this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMFatalEvent(RMFatalEventType.EMBEDDED_ELECTOR_FAILED, errorMessage));
    }

    public void fenceOldActive(byte[] oldActiveData) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Request to fence old active being ignored, as embedded leader election doesn't support fencing");
        }
    }

    private static byte[] createActiveNodeInfo(String clusterId, String rmId) throws IOException {
        return YarnServerResourceManagerServiceProtos.ActiveRMInfoProto.newBuilder().setClusterId(clusterId).setRmId(rmId).build().toByteArray();
    }

    private boolean isParentZnodeSafe(String clusterId) throws InterruptedException, IOException, KeeperException {
        YarnServerResourceManagerServiceProtos.ActiveRMInfoProto proto;
        byte[] data;
        try {
            data = this.elector.getActiveData();
        }
        catch (ActiveStandbyElector.ActiveNotFoundException e) {
            return true;
        }
        try {
            proto = YarnServerResourceManagerServiceProtos.ActiveRMInfoProto.parseFrom((byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            LOG.error((Object)("Invalid data in ZK: " + StringUtils.byteToHexString((byte[])data)));
            return false;
        }
        if (!proto.getClusterId().equals(clusterId)) {
            LOG.error((Object)("Mismatched cluster! The other RM seems to be from a different cluster. Current cluster = " + clusterId + "Other RM's cluster = " + proto.getClusterId()));
            return false;
        }
        return true;
    }

    public void resetLeaderElection() {
        this.elector.quitElection(false);
        this.elector.joinElection(this.localActiveNodeInfo);
    }
}

