/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.SettableFuture;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.security.AccessControlException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.math.LongRange;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.ApplicationsRequestScope;
import org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.CancelDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationAttemptsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetApplicationsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterMetricsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodeLabelsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetClusterNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainerReportResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetLabelsToNodesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetLabelsToNodesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetNodesToLabelsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetNodesToLabelsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueUserAclsInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetQueueUserAclsInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.KillApplicationResponse;
import org.apache.hadoop.yarn.api.protocolrecords.MoveApplicationAcrossQueuesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.MoveApplicationAcrossQueuesResponse;
import org.apache.hadoop.yarn.api.protocolrecords.NoOpGetClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.NoOpGetClusterNodeLabelsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RefreshClusterNodeLabelsRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RefreshClusterNodeLabelsResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RenewDelegationTokenResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationDeleteRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationDeleteResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationSubmissionResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationUpdateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ReservationUpdateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationRequest;
import org.apache.hadoop.yarn.api.protocolrecords.SubmitApplicationResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAccessType;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.NodeToLabelsList;
import org.apache.hadoop.yarn.api.records.QueueACL;
import org.apache.hadoop.yarn.api.records.QueueInfo;
import org.apache.hadoop.yarn.api.records.ReservationDefinition;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.YarnClusterMetrics;
import org.apache.hadoop.yarn.event.Event;
import org.apache.hadoop.yarn.exceptions.ApplicationAttemptNotFoundException;
import org.apache.hadoop.yarn.exceptions.ApplicationNotFoundException;
import org.apache.hadoop.yarn.exceptions.ContainerNotFoundException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.ipc.RPCUtil;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.RMAppManager;
import org.apache.hadoop.yarn.server.resourcemanager.RMAuditLogger;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.RMServerUtils;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.labelmanagement.LabelManager;
import org.apache.hadoop.yarn.server.resourcemanager.nodelabels.RMNodeLabelsManager;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationInputValidator;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSystem;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningException;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppEventType;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppMoveEvent;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMAppState;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.attempt.RMAppAttempt;
import org.apache.hadoop.yarn.server.resourcemanager.rmcontainer.RMContainer;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerAppReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.SchedulerNodeReport;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.YarnScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.security.QueueACLsManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.RMDelegationTokenSecretManager;
import org.apache.hadoop.yarn.server.resourcemanager.security.authorize.RMPolicyProvider;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.server.utils.BuilderUtils;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.Records;
import org.apache.hadoop.yarn.util.UTCClock;

public class ClientRMService
extends AbstractService
implements ApplicationClientProtocol {
    private static final ArrayList<ApplicationReport> EMPTY_APPS_REPORT = new ArrayList();
    private static final Log LOG = LogFactory.getLog(ClientRMService.class);
    private final AtomicInteger applicationCounter = new AtomicInteger(0);
    private final YarnScheduler scheduler;
    private final RMContext rmContext;
    private final RMAppManager rmAppManager;
    private Server server;
    protected RMDelegationTokenSecretManager rmDTSecretManager;
    private final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    InetSocketAddress clientBindAddress;
    private final ApplicationACLsManager applicationsACLsManager;
    private final QueueACLsManager queueACLsManager;
    private Clock clock;
    private ReservationSystem reservationSystem;
    private ReservationInputValidator rValidator;
    private LabelManager labelManager;

    public ClientRMService(RMContext rmContext, YarnScheduler scheduler, RMAppManager rmAppManager, ApplicationACLsManager applicationACLsManager, QueueACLsManager queueACLsManager, RMDelegationTokenSecretManager rmDTSecretManager) {
        this(rmContext, scheduler, rmAppManager, applicationACLsManager, queueACLsManager, rmDTSecretManager, (Clock)new UTCClock());
    }

    public ClientRMService(RMContext rmContext, YarnScheduler scheduler, RMAppManager rmAppManager, ApplicationACLsManager applicationACLsManager, QueueACLsManager queueACLsManager, RMDelegationTokenSecretManager rmDTSecretManager, Clock clock) {
        super(ClientRMService.class.getName());
        this.scheduler = scheduler;
        this.rmContext = rmContext;
        this.rmAppManager = rmAppManager;
        this.applicationsACLsManager = applicationACLsManager;
        this.queueACLsManager = queueACLsManager;
        this.rmDTSecretManager = rmDTSecretManager;
        this.reservationSystem = rmContext.getReservationSystem();
        this.clock = clock;
        this.rValidator = new ReservationInputValidator(clock);
        this.labelManager = LabelManager.getInstance();
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.clientBindAddress = this.getBindAddress(conf);
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        Configuration conf = this.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        this.server = rpc.getServer(ApplicationClientProtocol.class, (Object)this, this.clientBindAddress, conf, (SecretManager)this.rmDTSecretManager, conf.getInt("yarn.resourcemanager.client.thread-count", 50));
        if (conf.getBoolean("hadoop.security.authorization", false)) {
            InputStream inputStream = this.rmContext.getConfigurationProvider().getConfigurationInputStream(conf, "hadoop-policy.xml");
            if (inputStream != null) {
                conf.addResource(inputStream);
            }
            this.refreshServiceAcls(conf, RMPolicyProvider.getInstance());
        }
        this.server.start();
        this.clientBindAddress = conf.updateConnectAddr("yarn.resourcemanager.bind-host", "yarn.resourcemanager.address", "0.0.0.0:8032", this.server.getListenerAddress());
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
        super.serviceStop();
    }

    InetSocketAddress getBindAddress(Configuration conf) {
        InetSocketAddress configuredAddr = conf.getSocketAddr("yarn.resourcemanager.bind-host", "yarn.resourcemanager.address", "0.0.0.0:8032", 8032);
        if (conf.getBoolean("yarn.resourcemanager.all-ifaces", true)) {
            configuredAddr = NetUtils.createSocketAddr((String)"0.0.0.0", (int)configuredAddr.getPort(), (String)"yarn.resourcemanager.admin.address");
        }
        return configuredAddr;
    }

    @InterfaceAudience.Private
    public InetSocketAddress getBindAddress() {
        return this.clientBindAddress;
    }

    private boolean checkAccess(UserGroupInformation callerUGI, String owner, ApplicationAccessType operationPerformed, RMApp application) {
        return this.applicationsACLsManager.checkAccess(callerUGI, operationPerformed, owner, application.getApplicationId()) || this.queueACLsManager.checkAccess(callerUGI, QueueACL.ADMINISTER_QUEUE, application.getQueue());
    }

    ApplicationId getNewApplicationId() {
        ApplicationId applicationId = BuilderUtils.newApplicationId((RecordFactory)this.recordFactory, (long)ResourceManager.getClusterTimeStamp(), (int)this.applicationCounter.incrementAndGet());
        LOG.info((Object)("Allocated new applicationId: " + applicationId.getId()));
        return applicationId;
    }

    public GetNewApplicationResponse getNewApplication(GetNewApplicationRequest request) throws YarnException {
        GetNewApplicationResponse response = (GetNewApplicationResponse)this.recordFactory.newRecordInstance(GetNewApplicationResponse.class);
        response.setApplicationId(this.getNewApplicationId());
        response.setMaximumResourceCapability(this.scheduler.getMaximumResourceCapability());
        return response;
    }

    public GetApplicationReportResponse getApplicationReport(GetApplicationReportRequest request) throws YarnException {
        UserGroupInformation callerUGI;
        ApplicationId applicationId = request.getApplicationId();
        if (applicationId == null) {
            throw new ApplicationNotFoundException("Invalid application id: null");
        }
        try {
            callerUGI = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ie) {
            LOG.info((Object)"Error getting UGI ", (Throwable)ie);
            throw RPCUtil.getRemoteException((Throwable)ie);
        }
        RMApp application = (RMApp)this.rmContext.getRMApps().get(applicationId);
        if (application == null) {
            throw new ApplicationNotFoundException("Application with id '" + applicationId + "' doesn't exist in RM.");
        }
        boolean allowAccess = this.checkAccess(callerUGI, application.getUser(), ApplicationAccessType.VIEW_APP, application);
        ApplicationReport report = application.createAndGetApplicationReport(callerUGI.getUserName(), allowAccess);
        GetApplicationReportResponse response = (GetApplicationReportResponse)this.recordFactory.newRecordInstance(GetApplicationReportResponse.class);
        response.setApplicationReport(report);
        return response;
    }

    public GetApplicationAttemptReportResponse getApplicationAttemptReport(GetApplicationAttemptReportRequest request) throws YarnException, IOException {
        RMAppAttempt appAttempt;
        UserGroupInformation callerUGI;
        ApplicationAttemptId appAttemptId = request.getApplicationAttemptId();
        try {
            callerUGI = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ie) {
            LOG.info((Object)"Error getting UGI ", (Throwable)ie);
            throw RPCUtil.getRemoteException((Throwable)ie);
        }
        RMApp application = (RMApp)this.rmContext.getRMApps().get(appAttemptId.getApplicationId());
        if (application == null) {
            throw new ApplicationNotFoundException("Application with id '" + request.getApplicationAttemptId().getApplicationId() + "' doesn't exist in RM.");
        }
        boolean allowAccess = this.checkAccess(callerUGI, application.getUser(), ApplicationAccessType.VIEW_APP, application);
        GetApplicationAttemptReportResponse response = null;
        if (allowAccess) {
            appAttempt = application.getAppAttempts().get(appAttemptId);
            if (appAttempt == null) {
                throw new ApplicationAttemptNotFoundException("ApplicationAttempt with id '" + appAttemptId + "' doesn't exist in RM.");
            }
        } else {
            throw new YarnException("User " + callerUGI.getShortUserName() + " does not have privilage to see this attempt " + appAttemptId);
        }
        ApplicationAttemptReport attemptReport = appAttempt.createApplicationAttemptReport();
        response = GetApplicationAttemptReportResponse.newInstance((ApplicationAttemptReport)attemptReport);
        return response;
    }

    public GetApplicationAttemptsResponse getApplicationAttempts(GetApplicationAttemptsRequest request) throws YarnException, IOException {
        ArrayList<ApplicationAttemptReport> listAttempts;
        UserGroupInformation callerUGI;
        ApplicationId appId = request.getApplicationId();
        try {
            callerUGI = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ie) {
            LOG.info((Object)"Error getting UGI ", (Throwable)ie);
            throw RPCUtil.getRemoteException((Throwable)ie);
        }
        RMApp application = (RMApp)this.rmContext.getRMApps().get(appId);
        if (application == null) {
            throw new ApplicationNotFoundException("Application with id '" + appId + "' doesn't exist in RM.");
        }
        boolean allowAccess = this.checkAccess(callerUGI, application.getUser(), ApplicationAccessType.VIEW_APP, application);
        GetApplicationAttemptsResponse response = null;
        if (allowAccess) {
            Map<ApplicationAttemptId, RMAppAttempt> attempts = application.getAppAttempts();
            listAttempts = new ArrayList<ApplicationAttemptReport>();
            Iterator<Map.Entry<ApplicationAttemptId, RMAppAttempt>> iter = attempts.entrySet().iterator();
            while (iter.hasNext()) {
                listAttempts.add(iter.next().getValue().createApplicationAttemptReport());
            }
        } else {
            throw new YarnException("User " + callerUGI.getShortUserName() + " does not have privilage to see this aplication " + appId);
        }
        response = GetApplicationAttemptsResponse.newInstance(listAttempts);
        return response;
    }

    public GetContainerReportResponse getContainerReport(GetContainerReportRequest request) throws YarnException, IOException {
        RMContainer rmConatiner;
        UserGroupInformation callerUGI;
        ContainerId containerId = request.getContainerId();
        if (containerId == null) {
            throw new ContainerNotFoundException("Invalid container id: null");
        }
        ApplicationAttemptId appAttemptId = containerId.getApplicationAttemptId();
        ApplicationId appId = appAttemptId.getApplicationId();
        try {
            callerUGI = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ie) {
            LOG.info((Object)"Error getting UGI ", (Throwable)ie);
            throw RPCUtil.getRemoteException((Throwable)ie);
        }
        RMApp application = (RMApp)this.rmContext.getRMApps().get(appId);
        if (application == null) {
            throw new ApplicationNotFoundException("Application with id '" + appId + "' doesn't exist in RM.");
        }
        boolean allowAccess = this.checkAccess(callerUGI, application.getUser(), ApplicationAccessType.VIEW_APP, application);
        GetContainerReportResponse response = null;
        if (allowAccess) {
            RMAppAttempt appAttempt = application.getAppAttempts().get(appAttemptId);
            if (appAttempt == null) {
                throw new ApplicationAttemptNotFoundException("ApplicationAttempt with id '" + appAttemptId + "' doesn't exist in RM.");
            }
            rmConatiner = this.rmContext.getScheduler().getRMContainer(containerId);
            if (rmConatiner == null) {
                throw new ContainerNotFoundException("Container with id '" + containerId + "' doesn't exist in RM.");
            }
        } else {
            throw new YarnException("User " + callerUGI.getShortUserName() + " does not have privilage to see this aplication " + appId);
        }
        response = GetContainerReportResponse.newInstance((ContainerReport)rmConatiner.createContainerReport());
        return response;
    }

    public GetContainersResponse getContainers(GetContainersRequest request) throws YarnException, IOException {
        ArrayList<ContainerReport> listContainers;
        UserGroupInformation callerUGI;
        ApplicationAttemptId appAttemptId = request.getApplicationAttemptId();
        ApplicationId appId = appAttemptId.getApplicationId();
        try {
            callerUGI = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ie) {
            LOG.info((Object)"Error getting UGI ", (Throwable)ie);
            throw RPCUtil.getRemoteException((Throwable)ie);
        }
        RMApp application = (RMApp)this.rmContext.getRMApps().get(appId);
        if (application == null) {
            throw new ApplicationNotFoundException("Application with id '" + appId + "' doesn't exist in RM.");
        }
        boolean allowAccess = this.checkAccess(callerUGI, application.getUser(), ApplicationAccessType.VIEW_APP, application);
        GetContainersResponse response = null;
        if (allowAccess) {
            RMAppAttempt appAttempt = application.getAppAttempts().get(appAttemptId);
            if (appAttempt == null) {
                throw new ApplicationAttemptNotFoundException("ApplicationAttempt with id '" + appAttemptId + "' doesn't exist in RM.");
            }
            Collection<Object> rmContainers = Collections.emptyList();
            SchedulerAppReport schedulerAppReport = this.rmContext.getScheduler().getSchedulerAppInfo(appAttemptId);
            if (schedulerAppReport != null) {
                rmContainers = schedulerAppReport.getLiveContainers();
            }
            listContainers = new ArrayList<ContainerReport>();
            for (RMContainer rMContainer : rmContainers) {
                listContainers.add(rMContainer.createContainerReport());
            }
        } else {
            throw new YarnException("User " + callerUGI.getShortUserName() + " does not have privilage to see this aplication " + appId);
        }
        response = GetContainersResponse.newInstance(listContainers);
        return response;
    }

    public SubmitApplicationResponse submitApplication(SubmitApplicationRequest request) throws YarnException {
        ApplicationSubmissionContext submissionContext = request.getApplicationSubmissionContext();
        ApplicationId applicationId = submissionContext.getApplicationId();
        String user = null;
        try {
            user = UserGroupInformation.getCurrentUser().getShortUserName();
        }
        catch (IOException ie) {
            LOG.warn((Object)"Unable to get the current user.", (Throwable)ie);
            RMAuditLogger.logFailure(user, "Submit Application Request", ie.getMessage(), "ClientRMService", "Exception in submitting application", applicationId);
            throw RPCUtil.getRemoteException((Throwable)ie);
        }
        if (this.rmContext.getRMApps().get(applicationId) != null) {
            LOG.info((Object)("This is an earlier submitted application: " + applicationId));
            return SubmitApplicationResponse.newInstance();
        }
        if (submissionContext.getQueue() == null) {
            submissionContext.setQueue("default");
        }
        if (submissionContext.getApplicationName() == null) {
            submissionContext.setApplicationName("N/A");
        }
        if (submissionContext.getApplicationType() == null) {
            submissionContext.setApplicationType("YARN");
        } else if (submissionContext.getApplicationType().length() > 20) {
            submissionContext.setApplicationType(submissionContext.getApplicationType().substring(0, 20));
        }
        try {
            this.rmAppManager.submitApplication(submissionContext, System.currentTimeMillis(), user);
            LOG.info((Object)("Application with id " + applicationId.getId() + " submitted by user " + user));
            RMAuditLogger.logSuccess(user, "Submit Application Request", "ClientRMService", applicationId);
        }
        catch (YarnException e) {
            LOG.info((Object)("Exception in submitting application with id " + applicationId.getId()), (Throwable)e);
            RMAuditLogger.logFailure(user, "Submit Application Request", e.getMessage(), "ClientRMService", "Exception in submitting application", applicationId);
            throw e;
        }
        SubmitApplicationResponse response = (SubmitApplicationResponse)this.recordFactory.newRecordInstance(SubmitApplicationResponse.class);
        return response;
    }

    public KillApplicationResponse forceKillApplication(KillApplicationRequest request) throws YarnException {
        UserGroupInformation callerUGI;
        ApplicationId applicationId = request.getApplicationId();
        try {
            callerUGI = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ie) {
            LOG.info((Object)"Error getting UGI ", (Throwable)ie);
            RMAuditLogger.logFailure("UNKNOWN", "Kill Application Request", "UNKNOWN", "ClientRMService", "Error getting UGI", applicationId);
            throw RPCUtil.getRemoteException((Throwable)ie);
        }
        RMApp application = (RMApp)this.rmContext.getRMApps().get(applicationId);
        if (application == null) {
            RMAuditLogger.logFailure(callerUGI.getUserName(), "Kill Application Request", "UNKNOWN", "ClientRMService", "Trying to kill an absent application", applicationId);
            throw new ApplicationNotFoundException("Trying to kill an absent application " + applicationId);
        }
        if (!this.checkAccess(callerUGI, application.getUser(), ApplicationAccessType.MODIFY_APP, application)) {
            RMAuditLogger.logFailure(callerUGI.getShortUserName(), "Kill Application Request", "User doesn't have permissions to " + ApplicationAccessType.MODIFY_APP.toString(), "ClientRMService", "Unauthorized user", applicationId);
            throw RPCUtil.getRemoteException((Throwable)new AccessControlException("User " + callerUGI.getShortUserName() + " cannot perform operation " + ApplicationAccessType.MODIFY_APP.name() + " on " + applicationId));
        }
        if (application.isAppFinalStateStored()) {
            RMAuditLogger.logSuccess(callerUGI.getShortUserName(), "Kill Application Request", "ClientRMService", applicationId);
            return KillApplicationResponse.newInstance((boolean)true);
        }
        String message = "Kill application " + applicationId + " received from " + callerUGI;
        if (null != Server.getRemoteAddress()) {
            message = message + " at " + Server.getRemoteAddress();
        }
        this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppEvent(applicationId, RMAppEventType.KILL, message));
        return KillApplicationResponse.newInstance((boolean)application.getApplicationSubmissionContext().getUnmanagedAM());
    }

    public GetClusterMetricsResponse getClusterMetrics(GetClusterMetricsRequest request) throws YarnException {
        GetClusterMetricsResponse response = (GetClusterMetricsResponse)this.recordFactory.newRecordInstance(GetClusterMetricsResponse.class);
        YarnClusterMetrics ymetrics = (YarnClusterMetrics)this.recordFactory.newRecordInstance(YarnClusterMetrics.class);
        ymetrics.setNumNodeManagers(this.rmContext.getRMNodes().size());
        response.setClusterMetrics(ymetrics);
        return response;
    }

    public GetApplicationsResponse getApplications(GetApplicationsRequest request) throws YarnException {
        Iterator<RMApp> appsIter;
        UserGroupInformation callerUGI;
        try {
            callerUGI = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ie) {
            LOG.info((Object)"Error getting UGI ", (Throwable)ie);
            throw RPCUtil.getRemoteException((Throwable)ie);
        }
        Set<String> applicationTypes = this.getLowerCasedAppTypes(request);
        EnumSet applicationStates = request.getApplicationStates();
        Set users = request.getUsers();
        Set queues = request.getQueues();
        Set tags = request.getApplicationTags();
        long limit = request.getLimit();
        LongRange start = request.getStartRange();
        LongRange finish = request.getFinishRange();
        ApplicationsRequestScope scope = request.getScope();
        final ConcurrentMap<ApplicationId, RMApp> apps = this.rmContext.getRMApps();
        if (queues != null && !queues.isEmpty()) {
            final ArrayList<List<ApplicationAttemptId>> queueAppLists = new ArrayList<List<ApplicationAttemptId>>();
            for (String queue : queues) {
                List<ApplicationAttemptId> appsInQueue = this.scheduler.getAppsInQueue(queue);
                if (appsInQueue == null || appsInQueue.isEmpty()) continue;
                queueAppLists.add(appsInQueue);
            }
            appsIter = new Iterator<RMApp>(){
                Iterator<List<ApplicationAttemptId>> appListIter;
                Iterator<ApplicationAttemptId> schedAppsIter;
                {
                    this.appListIter = queueAppLists.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.schedAppsIter != null && this.schedAppsIter.hasNext() || this.appListIter.hasNext();
                }

                @Override
                public RMApp next() {
                    if (this.schedAppsIter == null || !this.schedAppsIter.hasNext()) {
                        this.schedAppsIter = this.appListIter.next().iterator();
                    }
                    return (RMApp)apps.get(this.schedAppsIter.next().getApplicationId());
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Remove not supported");
                }
            };
        } else {
            appsIter = apps.values().iterator();
        }
        ArrayList<ApplicationReport> reports = new ArrayList<ApplicationReport>();
        while (appsIter.hasNext() && (long)reports.size() < limit) {
            String appTypeToMatch;
            RMApp application = (RMApp)appsIter.next();
            if (scope == ApplicationsRequestScope.OWN && !callerUGI.getUserName().equals(application.getUser()) || applicationTypes != null && !applicationTypes.isEmpty() && !applicationTypes.contains(appTypeToMatch = StringUtils.toLowerCase((String)application.getApplicationType())) || applicationStates != null && !applicationStates.isEmpty() && !applicationStates.contains(application.createApplicationState()) || users != null && !users.isEmpty() && !users.contains(application.getUser()) || start != null && !start.containsLong(application.getStartTime()) || finish != null && !finish.containsLong(application.getFinishTime())) continue;
            if (tags != null && !tags.isEmpty()) {
                Set<String> appTags = application.getApplicationTags();
                if (appTags == null || appTags.isEmpty()) continue;
                boolean match = false;
                for (String tag : tags) {
                    if (!appTags.contains(tag)) continue;
                    match = true;
                    break;
                }
                if (!match) continue;
            }
            boolean allowAccess = this.checkAccess(callerUGI, application.getUser(), ApplicationAccessType.VIEW_APP, application);
            if (scope == ApplicationsRequestScope.VIEWABLE && !allowAccess) continue;
            reports.add(application.createAndGetApplicationReport(callerUGI.getUserName(), allowAccess));
        }
        GetApplicationsResponse response = (GetApplicationsResponse)this.recordFactory.newRecordInstance(GetApplicationsResponse.class);
        response.setApplicationList(reports);
        return response;
    }

    private Set<String> getLowerCasedAppTypes(GetApplicationsRequest request) {
        HashSet<String> applicationTypes = new HashSet<String>();
        if (request.getApplicationTypes() != null && !request.getApplicationTypes().isEmpty()) {
            for (String type : request.getApplicationTypes()) {
                applicationTypes.add(StringUtils.toLowerCase((String)type));
            }
        }
        return applicationTypes;
    }

    public GetClusterNodesResponse getClusterNodes(GetClusterNodesRequest request) throws YarnException {
        GetClusterNodesResponse response = (GetClusterNodesResponse)this.recordFactory.newRecordInstance(GetClusterNodesResponse.class);
        EnumSet<NodeState> nodeStates = request.getNodeStates();
        if (nodeStates == null || nodeStates.isEmpty()) {
            nodeStates = EnumSet.allOf(NodeState.class);
        }
        List<RMNode> nodes = RMServerUtils.queryRMNodes(this.rmContext, nodeStates);
        ArrayList<NodeReport> nodeReports = new ArrayList<NodeReport>(nodes.size());
        for (RMNode nodeInfo : nodes) {
            nodeReports.add(this.createNodeReports(nodeInfo));
        }
        response.setNodeReports(nodeReports);
        return response;
    }

    public GetQueueInfoResponse getQueueInfo(GetQueueInfoRequest request) throws YarnException {
        UserGroupInformation callerUGI;
        try {
            callerUGI = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ie) {
            LOG.info((Object)"Error getting UGI ", (Throwable)ie);
            throw RPCUtil.getRemoteException((Throwable)ie);
        }
        GetQueueInfoResponse response = (GetQueueInfoResponse)this.recordFactory.newRecordInstance(GetQueueInfoResponse.class);
        try {
            QueueInfo queueInfo = this.scheduler.getQueueInfo(request.getQueueName(), request.getIncludeChildQueues(), request.getRecursive());
            ArrayList<Object> appReports = EMPTY_APPS_REPORT;
            if (request.getIncludeApplications()) {
                List<ApplicationAttemptId> apps = this.scheduler.getAppsInQueue(request.getQueueName());
                appReports = new ArrayList(apps.size());
                for (ApplicationAttemptId app : apps) {
                    RMApp rmApp = (RMApp)this.rmContext.getRMApps().get(app.getApplicationId());
                    if (rmApp == null || !this.checkAccess(callerUGI, rmApp.getUser(), ApplicationAccessType.VIEW_APP, rmApp)) continue;
                    appReports.add(rmApp.createAndGetApplicationReport(callerUGI.getUserName(), true));
                }
            }
            queueInfo.setApplications(appReports);
            response.setQueueInfo(queueInfo);
        }
        catch (IOException ioe) {
            LOG.info((Object)("Failed to getQueueInfo for " + request.getQueueName()), (Throwable)ioe);
        }
        return response;
    }

    private NodeReport createNodeReports(RMNode rmNode) {
        SchedulerNodeReport schedulerNodeReport = this.scheduler.getNodeReport(rmNode.getNodeID());
        Resource used = BuilderUtils.newResource((int)0, (int)0);
        int numContainers = 0;
        if (schedulerNodeReport != null) {
            used = schedulerNodeReport.getUsedResource();
            numContainers = schedulerNodeReport.getNumContainers();
        }
        NodeReport report = BuilderUtils.newNodeReport((NodeId)rmNode.getNodeID(), (NodeState)rmNode.getState(), (String)rmNode.getHttpAddress(), (String)rmNode.getRackName(), (Resource)used, (Resource)rmNode.getTotalCapability(), (int)numContainers, (String)rmNode.getHealthReport(), (long)rmNode.getLastHealthReportTime(), rmNode.getNodeLabels());
        return report;
    }

    public GetQueueUserAclsInfoResponse getQueueUserAcls(GetQueueUserAclsInfoRequest request) throws YarnException {
        GetQueueUserAclsInfoResponse response = (GetQueueUserAclsInfoResponse)this.recordFactory.newRecordInstance(GetQueueUserAclsInfoResponse.class);
        response.setUserAclsInfoList(this.scheduler.getQueueUserAclInfo());
        return response;
    }

    public GetDelegationTokenResponse getDelegationToken(GetDelegationTokenRequest request) throws YarnException {
        try {
            if (!this.isAllowedDelegationTokenOp()) {
                throw new IOException("Delegation Token can be issued only with kerberos authentication");
            }
            GetDelegationTokenResponse response = (GetDelegationTokenResponse)this.recordFactory.newRecordInstance(GetDelegationTokenResponse.class);
            UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
            Text owner = new Text(ugi.getUserName());
            Text realUser = null;
            if (ugi.getRealUser() != null) {
                realUser = new Text(ugi.getRealUser().getUserName());
            }
            RMDelegationTokenIdentifier tokenIdentifier = new RMDelegationTokenIdentifier(owner, new Text(request.getRenewer()), realUser);
            Token realRMDTtoken = new Token((TokenIdentifier)tokenIdentifier, (SecretManager)this.rmDTSecretManager);
            response.setRMDelegationToken(BuilderUtils.newDelegationToken((byte[])realRMDTtoken.getIdentifier(), (String)realRMDTtoken.getKind().toString(), (byte[])realRMDTtoken.getPassword(), (String)realRMDTtoken.getService().toString()));
            return response;
        }
        catch (IOException io) {
            throw RPCUtil.getRemoteException((Throwable)io);
        }
    }

    public RenewDelegationTokenResponse renewDelegationToken(RenewDelegationTokenRequest request) throws YarnException {
        try {
            if (!this.isAllowedDelegationTokenOp()) {
                throw new IOException("Delegation Token can be renewed only with kerberos authentication");
            }
            org.apache.hadoop.yarn.api.records.Token protoToken = request.getDelegationToken();
            Token token = new Token(protoToken.getIdentifier().array(), protoToken.getPassword().array(), new Text(protoToken.getKind()), new Text(protoToken.getService()));
            String user = this.getRenewerForToken((Token<RMDelegationTokenIdentifier>)token);
            long nextExpTime = this.rmDTSecretManager.renewToken(token, user);
            RenewDelegationTokenResponse renewResponse = (RenewDelegationTokenResponse)Records.newRecord(RenewDelegationTokenResponse.class);
            renewResponse.setNextExpirationTime(nextExpTime);
            return renewResponse;
        }
        catch (IOException e) {
            throw RPCUtil.getRemoteException((Throwable)e);
        }
    }

    public CancelDelegationTokenResponse cancelDelegationToken(CancelDelegationTokenRequest request) throws YarnException {
        try {
            if (!this.isAllowedDelegationTokenOp()) {
                throw new IOException("Delegation Token can be cancelled only with kerberos authentication");
            }
            org.apache.hadoop.yarn.api.records.Token protoToken = request.getDelegationToken();
            Token token = new Token(protoToken.getIdentifier().array(), protoToken.getPassword().array(), new Text(protoToken.getKind()), new Text(protoToken.getService()));
            String user = UserGroupInformation.getCurrentUser().getUserName();
            this.rmDTSecretManager.cancelToken(token, user);
            return (CancelDelegationTokenResponse)Records.newRecord(CancelDelegationTokenResponse.class);
        }
        catch (IOException e) {
            throw RPCUtil.getRemoteException((Throwable)e);
        }
    }

    public MoveApplicationAcrossQueuesResponse moveApplicationAcrossQueues(MoveApplicationAcrossQueuesRequest request) throws YarnException {
        UserGroupInformation callerUGI;
        ApplicationId applicationId = request.getApplicationId();
        try {
            callerUGI = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ie) {
            LOG.info((Object)"Error getting UGI ", (Throwable)ie);
            RMAuditLogger.logFailure("UNKNOWN", "Move Application Request", "UNKNOWN", "ClientRMService", "Error getting UGI", applicationId);
            throw RPCUtil.getRemoteException((Throwable)ie);
        }
        RMApp application = (RMApp)this.rmContext.getRMApps().get(applicationId);
        if (application == null) {
            RMAuditLogger.logFailure(callerUGI.getUserName(), "Move Application Request", "UNKNOWN", "ClientRMService", "Trying to move an absent application", applicationId);
            throw new ApplicationNotFoundException("Trying to move an absent application " + applicationId);
        }
        if (!this.checkAccess(callerUGI, application.getUser(), ApplicationAccessType.MODIFY_APP, application)) {
            RMAuditLogger.logFailure(callerUGI.getShortUserName(), "Move Application Request", "User doesn't have permissions to " + ApplicationAccessType.MODIFY_APP.toString(), "ClientRMService", "Unauthorized user", applicationId);
            throw RPCUtil.getRemoteException((Throwable)new AccessControlException("User " + callerUGI.getShortUserName() + " cannot perform operation " + ApplicationAccessType.MODIFY_APP.name() + " on " + applicationId));
        }
        if (EnumSet.of(RMAppState.NEW, new RMAppState[]{RMAppState.NEW_SAVING, RMAppState.FAILED, RMAppState.FINAL_SAVING, RMAppState.FINISHING, RMAppState.FINISHED, RMAppState.KILLED, RMAppState.KILLING, RMAppState.FAILED}).contains((Object)application.getState())) {
            String msg = "App in " + (Object)((Object)application.getState()) + " state cannot be moved.";
            RMAuditLogger.logFailure(callerUGI.getShortUserName(), "Move Application Request", "UNKNOWN", "ClientRMService", msg);
            throw new YarnException(msg);
        }
        SettableFuture future = SettableFuture.create();
        this.rmContext.getDispatcher().getEventHandler().handle((Event)new RMAppMoveEvent(applicationId, request.getTargetQueue(), (SettableFuture<Object>)future));
        try {
            Futures.get((Future)future, YarnException.class);
        }
        catch (YarnException ex) {
            RMAuditLogger.logFailure(callerUGI.getShortUserName(), "Move Application Request", "UNKNOWN", "ClientRMService", ex.getMessage());
            throw ex;
        }
        RMAuditLogger.logSuccess(callerUGI.getShortUserName(), "Move Application Request", "ClientRMService", applicationId);
        MoveApplicationAcrossQueuesResponse response = (MoveApplicationAcrossQueuesResponse)this.recordFactory.newRecordInstance(MoveApplicationAcrossQueuesResponse.class);
        return response;
    }

    private String getRenewerForToken(Token<RMDelegationTokenIdentifier> token) throws IOException {
        UserGroupInformation user = UserGroupInformation.getCurrentUser();
        UserGroupInformation loginUser = UserGroupInformation.getLoginUser();
        return loginUser.getUserName().equals(user.getUserName()) ? ((RMDelegationTokenIdentifier)token.decodeIdentifier()).getRenewer().toString() : user.getShortUserName();
    }

    public GetClusterNodeLabelsResponse getClusterNodeLabels(GetClusterNodeLabelsRequest request) throws YarnException, IOException {
        GetClusterNodeLabelsResponse response = (GetClusterNodeLabelsResponse)this.recordFactory.newRecordInstance(GetClusterNodeLabelsResponse.class);
        LabelManager labelManager = LabelManager.getInstance();
        List<NodeToLabelsList> clusterNodeLabels = null;
        clusterNodeLabels = labelManager.getLabelsForAllNodes();
        response.setClusterNodeLabels(clusterNodeLabels);
        return response;
    }

    public RefreshClusterNodeLabelsResponse refreshClusterNodeLabels(RefreshClusterNodeLabelsRequest request) throws YarnException, IOException {
        RefreshClusterNodeLabelsResponse response = (RefreshClusterNodeLabelsResponse)this.recordFactory.newRecordInstance(RefreshClusterNodeLabelsResponse.class);
        boolean isRefreshCompleted = false;
        try {
            LabelManager labelManager = LabelManager.getInstance();
            labelManager.refreshLabels(this.getConfig());
            isRefreshCompleted = true;
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to refresh cluster node labels", (Throwable)e);
        }
        response.setIsRefreshLabelsComplete(isRefreshCompleted);
        return response;
    }

    void refreshServiceAcls(Configuration configuration, PolicyProvider policyProvider) {
        this.server.refreshServiceAclWithLoadedConfiguration(configuration, policyProvider);
    }

    private boolean isAllowedDelegationTokenOp() throws IOException {
        return !UserGroupInformation.isSecurityEnabled() || UserGroupInformation.getCurrentUser().getRealAuthenticationMethod().allowsDelegation();
    }

    @VisibleForTesting
    public Server getServer() {
        return this.server;
    }

    public ReservationSubmissionResponse submitReservation(ReservationSubmissionRequest request) throws YarnException, IOException {
        this.checkReservationSytem("Submit Reservation Request");
        ReservationSubmissionResponse response = (ReservationSubmissionResponse)this.recordFactory.newRecordInstance(ReservationSubmissionResponse.class);
        ReservationId reservationId = this.reservationSystem.getNewReservationId();
        Plan plan = this.rValidator.validateReservationSubmissionRequest(this.reservationSystem, request, reservationId);
        String queueName = request.getQueue();
        String user = this.checkReservationACLs(queueName, "Submit Reservation Request");
        try {
            boolean result = plan.getReservationAgent().createReservation(reservationId, user, plan, request.getReservationDefinition());
            if (result) {
                this.reservationSystem.setQueueForReservation(reservationId, queueName);
                this.refreshScheduler(queueName, request.getReservationDefinition(), reservationId.toString());
                response.setReservationId(reservationId);
            }
        }
        catch (PlanningException e) {
            RMAuditLogger.logFailure(user, "Submit Reservation Request", e.getMessage(), "ClientRMService", "Unable to create the reservation: " + reservationId);
            throw RPCUtil.getRemoteException((Throwable)e);
        }
        RMAuditLogger.logSuccess(user, "Submit Reservation Request", "ClientRMService: " + reservationId);
        return response;
    }

    public ReservationUpdateResponse updateReservation(ReservationUpdateRequest request) throws YarnException, IOException {
        this.checkReservationSytem("Update Reservation Request");
        ReservationUpdateResponse response = (ReservationUpdateResponse)this.recordFactory.newRecordInstance(ReservationUpdateResponse.class);
        Plan plan = this.rValidator.validateReservationUpdateRequest(this.reservationSystem, request);
        ReservationId reservationId = request.getReservationId();
        String queueName = this.reservationSystem.getQueueForReservation(reservationId);
        String user = this.checkReservationACLs(queueName, "Update Reservation Request");
        try {
            boolean result = plan.getReservationAgent().updateReservation(reservationId, user, plan, request.getReservationDefinition());
            if (!result) {
                String errMsg = "Unable to update reservation: " + reservationId;
                RMAuditLogger.logFailure(user, "Update Reservation Request", errMsg, "ClientRMService", errMsg);
                throw RPCUtil.getRemoteException((String)errMsg);
            }
        }
        catch (PlanningException e) {
            RMAuditLogger.logFailure(user, "Update Reservation Request", e.getMessage(), "ClientRMService", "Unable to update the reservation: " + reservationId);
            throw RPCUtil.getRemoteException((Throwable)e);
        }
        RMAuditLogger.logSuccess(user, "Update Reservation Request", "ClientRMService: " + reservationId);
        return response;
    }

    public ReservationDeleteResponse deleteReservation(ReservationDeleteRequest request) throws YarnException, IOException {
        this.checkReservationSytem("Delete Reservation Request");
        ReservationDeleteResponse response = (ReservationDeleteResponse)this.recordFactory.newRecordInstance(ReservationDeleteResponse.class);
        Plan plan = this.rValidator.validateReservationDeleteRequest(this.reservationSystem, request);
        ReservationId reservationId = request.getReservationId();
        String queueName = this.reservationSystem.getQueueForReservation(reservationId);
        String user = this.checkReservationACLs(queueName, "Delete Reservation Request");
        try {
            boolean result = plan.getReservationAgent().deleteReservation(reservationId, user, plan);
            if (!result) {
                String errMsg = "Could not delete reservation: " + reservationId;
                RMAuditLogger.logFailure(user, "Delete Reservation Request", errMsg, "ClientRMService", errMsg);
                throw RPCUtil.getRemoteException((String)errMsg);
            }
        }
        catch (PlanningException e) {
            RMAuditLogger.logFailure(user, "Delete Reservation Request", e.getMessage(), "ClientRMService", "Unable to delete the reservation: " + reservationId);
            throw RPCUtil.getRemoteException((Throwable)e);
        }
        RMAuditLogger.logSuccess(user, "Delete Reservation Request", "ClientRMService: " + reservationId);
        return response;
    }

    public GetNodesToLabelsResponse getNodeToLabels(GetNodesToLabelsRequest request) throws YarnException, IOException {
        GetNodesToLabelsResponse response = GetNodesToLabelsResponse.newInstance(this.labelManager.getNodeToLabels());
        return response;
    }

    public GetLabelsToNodesResponse getLabelsToNodes(GetLabelsToNodesRequest request) throws YarnException, IOException {
        if (request.getNodeLabels() == null || request.getNodeLabels().isEmpty()) {
            return GetLabelsToNodesResponse.newInstance(this.labelManager.getLabelsToNodes(new HashSet<String>()));
        }
        return GetLabelsToNodesResponse.newInstance(this.labelManager.getLabelsToNodes(request.getNodeLabels()));
    }

    public NoOpGetClusterNodeLabelsResponse getClusterNodeLabelsNoOp(NoOpGetClusterNodeLabelsRequest request) throws YarnException, IOException {
        RMNodeLabelsManager labelsMgr = this.rmContext.getNodeLabelManager();
        NoOpGetClusterNodeLabelsResponse response = NoOpGetClusterNodeLabelsResponse.newInstance((Set)labelsMgr.getClusterNodeLabels());
        return response;
    }

    private void checkReservationSytem(String auditConstant) throws YarnException {
        if (this.reservationSystem == null) {
            throw RPCUtil.getRemoteException((String)"Reservation is not enabled. Please enable & try again");
        }
    }

    private void refreshScheduler(String planName, ReservationDefinition contract, String reservationId) {
        if (contract.getArrival() - this.clock.getTime() < this.reservationSystem.getPlanFollowerTimeStep()) {
            LOG.debug((Object)MessageFormat.format("Reservation {0} is within threshold so attempting to create synchronously.", reservationId));
            this.reservationSystem.synchronizePlan(planName);
            LOG.info((Object)MessageFormat.format("Created reservation {0} synchronously.", reservationId));
        }
    }

    private String checkReservationACLs(String queueName, String auditConstant) throws YarnException {
        UserGroupInformation callerUGI;
        try {
            callerUGI = UserGroupInformation.getCurrentUser();
        }
        catch (IOException ie) {
            RMAuditLogger.logFailure("UNKNOWN", auditConstant, queueName, "ClientRMService", "Error getting UGI");
            throw RPCUtil.getRemoteException((Throwable)ie);
        }
        if (!this.queueACLsManager.checkAccess(callerUGI, QueueACL.SUBMIT_APPLICATIONS, queueName)) {
            RMAuditLogger.logFailure(callerUGI.getShortUserName(), auditConstant, "User doesn't have permissions to " + QueueACL.SUBMIT_APPLICATIONS.toString(), "ClientRMService", "Unauthorized user");
            throw RPCUtil.getRemoteException((Throwable)new AccessControlException("User " + callerUGI.getShortUserName() + " cannot perform operation " + QueueACL.SUBMIT_APPLICATIONS.name() + " on queue" + queueName));
        }
        return callerUGI.getShortUserName();
    }
}

