/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.common.util;

import com.mapr.fs.proto.Security;
import com.mapr.login.MapRLoginException;
import com.mapr.security.JNISecurity;
import com.mapr.security.MutableInt;
import com.mapr.security.Security;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import org.apache.hive.com.google.common.annotations.VisibleForTesting;
import org.apache.hive.common.util.MapRTicketValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapRTicketUtil {
    private static final Logger LOG = LoggerFactory.getLogger(MapRTicketUtil.class);

    private MapRTicketUtil() {
    }

    public static void validateExpiryTime() {
        if (MapRTicketUtil.isExpired()) {
            throw new MapRTicketValidationException(MapRTicketUtil.buildExpirationMessage());
        }
    }

    private static boolean isExpired() {
        Date today = Calendar.getInstance().getTime();
        long expiryTime = MapRTicketUtil.getCurrentUserTicketExpiryTime();
        return today.getTime() > expiryTime;
    }

    private static String buildExpirationMessage() {
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        TimeZone timeZone = Calendar.getInstance().getTimeZone();
        sdf.setTimeZone(timeZone);
        long expiryTime = MapRTicketUtil.getCurrentUserTicketExpiryTime();
        String userName = MapRTicketUtil.getCurrentUserNameFromTicket();
        String cluster = MapRTicketUtil.getCluster();
        return String.format("ERROR: Unable to obtain MapR credentials. Found ticket for cluster '%s' user '%s' but it has expired. Expiration date is %s %s.", cluster, userName, sdf.format(new Date(expiryTime)), timeZone.getDisplayName());
    }

    public static void validateCanImpersonate() {
        String userName = MapRTicketUtil.getCurrentUserNameFromTicket();
        if (!MapRTicketUtil.getCurrentUserTicketCanImpersonate()) {
            throw new MapRTicketValidationException(String.format("ERROR: MapR ticket for user '%s' configured so CanImpersonate = false. Renew current user MapR ticket and set CanImpersonate = true.", userName));
        }
    }

    private static String getCluster() {
        try {
            return String.join((CharSequence)",", MapRTicketUtil.getClusterSet(MapRTicketUtil.getMapRTicketLocation()));
        }
        catch (IOException e) {
            throw new MapRTicketValidationException(e);
        }
    }

    private static String getCurrentUserNameFromTicket() {
        String userName = "";
        try {
            Security.TicketAndKey ticketAndKey = MapRTicketUtil.getCurrentUserTicket();
            if (ticketAndKey != null && ticketAndKey.getUserCreds() != null) {
                userName = ticketAndKey.getUserCreds().getUserName();
            }
        }
        catch (IOException e) {
            throw new MapRTicketValidationException(e);
        }
        return userName;
    }

    private static long getCurrentUserTicketExpiryTime() {
        try {
            Security.TicketAndKey currentUserTicket = MapRTicketUtil.getCurrentUserTicket();
            if (currentUserTicket != null) {
                return currentUserTicket.getExpiryTime() * 1000L;
            }
            throw new MapRTicketValidationException("Current user MapR ticket is not available. Use maprlogin password.");
        }
        catch (IOException e) {
            throw new MapRTicketValidationException(e);
        }
    }

    private static boolean getCurrentUserTicketCanImpersonate() {
        try {
            Security.TicketAndKey currentUserTicket = MapRTicketUtil.getCurrentUserTicket();
            if (currentUserTicket != null) {
                return currentUserTicket.getCanUserImpersonate();
            }
            throw new MapRTicketValidationException("Current user MapR ticket is not available. Use maprlogin password.");
        }
        catch (IOException e) {
            throw new MapRTicketValidationException(e);
        }
    }

    private static Security.TicketAndKey getCurrentUserTicket() throws IOException {
        for (Security.TicketAndKey ticketAndKey : MapRTicketUtil.getTicketAndKeys(MapRTicketUtil.getClusterSet(MapRTicketUtil.getMapRTicketLocation()))) {
            String userName;
            if (!ticketAndKey.hasUserCreds() || ticketAndKey.getUserCreds() == null || (userName = ticketAndKey.getUserCreds().getUserName()) == null) continue;
            return ticketAndKey;
        }
        return null;
    }

    private static Set<Security.TicketAndKey> getTicketAndKeys(Set<String> clusterSet) {
        HashSet<Security.TicketAndKey> ticketAndKeys = new HashSet<Security.TicketAndKey>();
        MutableInt err = new MutableInt();
        for (String cluster : clusterSet) {
            for (int i = Security.ServerKeyType.CldbKey.getNumber(); i <= Security.ServerKeyType.ServerKeyTypeMax.getNumber(); ++i) {
                Security.ServerKeyType sKType = Security.ServerKeyType.valueOf((int)i);
                Security.TicketAndKey tk = Security.GetTicketAndKeyForCluster((Security.ServerKeyType)sKType, (String)cluster, (MutableInt)err);
                if (tk == null) continue;
                ticketAndKeys.add(tk);
            }
        }
        return ticketAndKeys;
    }

    @VisibleForTesting
    public static Set<String> getClusterSet(File file) throws IOException {
        HashSet<String> clusterSet = new HashSet<String>();
        try (FileInputStream inRaw = new FileInputStream(file);
             BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)inRaw, StandardCharsets.UTF_8));){
            String line = in.readLine();
            if (line == null) {
                throw new MapRLoginException("Empty ticket file");
            }
            while (line != null) {
                String cluster = line.split(" ")[0];
                clusterSet.add(cluster);
                LOG.info("Found cluster {}", (Object)cluster);
                line = in.readLine();
            }
        }
        return clusterSet;
    }

    private static File getMapRTicketLocation() throws MapRLoginException {
        String location = JNISecurity.GetUserTicketAndKeyFileLocation();
        LOG.info("Opening keyfile {}", (Object)location);
        File file = new File(location);
        if (!file.exists()) {
            throw new MapRLoginException("keyfile not found");
        }
        int errno = Security.SetTicketAndKeyFile((String)location);
        if (errno != 0) {
            throw new MapRLoginException("Problem reading keyfile, error = " + errno);
        }
        return new File(location);
    }
}

