/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import hive.com.fasterxml.jackson.core.JsonFactory;
import hive.com.fasterxml.jackson.core.JsonParser;
import hive.com.fasterxml.jackson.databind.JavaType;
import hive.com.fasterxml.jackson.databind.ObjectMapper;
import hive.com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.Text;
import org.apache.hive.com.google.common.collect.Iterators;

@Description(name="get_json_object", value="_FUNC_(json_txt, path) - Extract a json object from path ", extended="Extract json object from a json string based on json path specified, and return json string of the extracted json object. It will return null if the input json string is invalid.\nA limited version of JSONPath supported:\n  $   : Root object\n  .   : Child operator\n  []  : Subscript operator for array\n  *   : Wildcard for []\nSyntax not supported that's worth noticing:\n  ''  : Zero length string as key\n  ..  : Recursive descent\n  &amp;#064;   : Current object/element\n  ()  : Script expression\n  ?() : Filter (script) expression.\n  [,] : Union operator\n  [start:end:step] : array slice operator\n")
public class UDFJson
extends UDF {
    private static final Pattern patternKey = Pattern.compile("^([a-zA-Z0-9_\\-\\:\\s]+).*");
    private static final Pattern patternIndex = Pattern.compile("\\[([0-9]+|\\*)\\]");
    private static final JavaType MAP_TYPE = TypeFactory.defaultInstance().constructType((Type)((Object)Map.class));
    private static final JavaType LIST_TYPE = TypeFactory.defaultInstance().constructType((Type)((Object)List.class));
    private final JsonFactory jsonFactory = new JsonFactory();
    private final ObjectMapper objectMapper = new ObjectMapper(this.jsonFactory);
    Map<String, Object> extractObjectCache = new HashCache<String, Object>();
    Map<String, String[]> pathExprCache = new HashCache<String, String[]>();
    Map<String, ArrayList<String>> indexListCache = new HashCache<String, ArrayList<String>>();
    Map<String, String> mKeyGroup1Cache = new HashCache<String, String>();
    Map<String, Boolean> mKeyMatchesCache = new HashCache<String, Boolean>();
    private transient AddingList jsonList = new AddingList();

    public UDFJson() {
        this.jsonFactory.enable(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS);
        this.jsonFactory.enable(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER);
    }

    public Text evaluate(String jsonString, String pathString) {
        Object extractObject;
        String[] pathExpr;
        if (jsonString == null || jsonString.isEmpty() || pathString == null || pathString.isEmpty() || pathString.charAt(0) != '$') {
            return null;
        }
        int pathExprStart = 1;
        boolean unknownType = pathString.equals("$");
        boolean isRootArray = false;
        if (pathString.length() > 1) {
            if (pathString.charAt(1) == '[') {
                pathExprStart = 0;
                isRootArray = true;
            } else if (pathString.charAt(1) == '.') {
                isRootArray = pathString.length() > 2 && pathString.charAt(2) == '[';
            } else {
                return null;
            }
        }
        if ((pathExpr = this.pathExprCache.get(pathString)) == null) {
            pathExpr = pathString.split("\\.", -1);
            this.pathExprCache.put(pathString, pathExpr);
        }
        if ((extractObject = this.extractObjectCache.get(jsonString)) == null) {
            if (unknownType) {
                try {
                    extractObject = this.objectMapper.readValue(jsonString, LIST_TYPE);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (extractObject == null) {
                    try {
                        extractObject = this.objectMapper.readValue(jsonString, MAP_TYPE);
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            } else {
                JavaType javaType = isRootArray ? LIST_TYPE : MAP_TYPE;
                try {
                    extractObject = this.objectMapper.readValue(jsonString, javaType);
                }
                catch (Exception e) {
                    return null;
                }
            }
            this.extractObjectCache.put(jsonString, extractObject);
        }
        for (int i = pathExprStart; i < pathExpr.length; ++i) {
            if (extractObject == null) {
                return null;
            }
            extractObject = this.extract(extractObject, pathExpr[i], i == pathExprStart && isRootArray);
        }
        Text result = new Text();
        if (extractObject instanceof Map || extractObject instanceof List) {
            try {
                result.set(this.objectMapper.writeValueAsString(extractObject));
            }
            catch (Exception e) {
                return null;
            }
        } else if (extractObject != null) {
            result.set(extractObject.toString());
        } else {
            return null;
        }
        return result;
    }

    private Object extract(Object json, String path, boolean skipMapProc) {
        ArrayList<String> indexList;
        if (!skipMapProc) {
            Matcher mKey = null;
            Boolean mKeyMatches = this.mKeyMatchesCache.get(path);
            if (mKeyMatches == null) {
                mKey = patternKey.matcher(path);
                mKeyMatches = mKey.matches() ? Boolean.TRUE : Boolean.FALSE;
                this.mKeyMatchesCache.put(path, mKeyMatches);
            }
            if (!mKeyMatches.booleanValue()) {
                return null;
            }
            String mKeyGroup1 = this.mKeyGroup1Cache.get(path);
            if (mKeyGroup1 == null) {
                if (mKey == null) {
                    mKey = patternKey.matcher(path);
                    mKeyMatches = mKey.matches() ? Boolean.TRUE : Boolean.FALSE;
                    this.mKeyMatchesCache.put(path, mKeyMatches);
                    if (!mKeyMatches.booleanValue()) {
                        return null;
                    }
                }
                mKeyGroup1 = mKey.group(1);
                this.mKeyGroup1Cache.put(path, mKeyGroup1);
            }
            json = this.extract_json_withkey(json, mKeyGroup1);
        }
        if ((indexList = this.indexListCache.get(path)) == null) {
            Matcher mIndex = patternIndex.matcher(path);
            indexList = new ArrayList();
            while (mIndex.find()) {
                indexList.add(mIndex.group(1));
            }
            this.indexListCache.put(path, indexList);
        }
        if (indexList.size() > 0) {
            json = this.extract_json_withindex(json, indexList);
        }
        return json;
    }

    private Object extract_json_withindex(Object json, ArrayList<String> indexList) {
        this.jsonList.clear();
        this.jsonList.add(json);
        for (String index : indexList) {
            int targets = this.jsonList.size();
            if (index.equalsIgnoreCase("*")) {
                for (Object array : this.jsonList) {
                    if (!(array instanceof List)) continue;
                    for (int j = 0; j < ((List)array).size(); ++j) {
                        this.jsonList.add(((List)array).get(j));
                    }
                }
            } else {
                for (Object array : this.jsonList) {
                    List list;
                    int indexValue = Integer.parseInt(index);
                    if (!(array instanceof List) || indexValue >= (list = (List)array).size()) continue;
                    this.jsonList.add(list.get(indexValue));
                }
            }
            if (this.jsonList.size() == targets) {
                return null;
            }
            this.jsonList.removeRange(0, targets);
        }
        if (this.jsonList.isEmpty()) {
            return null;
        }
        return this.jsonList.size() > 1 ? new ArrayList<Object>(this.jsonList) : this.jsonList.get(0);
    }

    private Object extract_json_withkey(Object json, String path) {
        if (json instanceof List) {
            ArrayList jsonArray = new ArrayList();
            for (int i = 0; i < ((List)json).size(); ++i) {
                Object json_elem = ((List)json).get(i);
                Object json_obj = null;
                if (!(json_elem instanceof Map)) continue;
                json_obj = ((Map)json_elem).get(path);
                if (json_obj instanceof List) {
                    for (int j = 0; j < ((List)json_obj).size(); ++j) {
                        jsonArray.add(((List)json_obj).get(j));
                    }
                    continue;
                }
                if (json_obj == null) continue;
                jsonArray.add(json_obj);
            }
            return jsonArray.size() == 0 ? null : jsonArray;
        }
        if (json instanceof Map) {
            return ((Map)json).get(path);
        }
        return null;
    }

    private static class AddingList
    extends ArrayList<Object> {
        private static final long serialVersionUID = 1L;

        private AddingList() {
        }

        @Override
        public Iterator<Object> iterator() {
            return Iterators.forArray(this.toArray());
        }

        @Override
        public void removeRange(int fromIndex, int toIndex) {
            super.removeRange(fromIndex, toIndex);
        }
    }

    static class HashCache<K, V>
    extends LinkedHashMap<K, V> {
        private static final int CACHE_SIZE = 16;
        private static final int INIT_SIZE = 32;
        private static final float LOAD_FACTOR = 0.6f;
        private static final long serialVersionUID = 1L;

        HashCache() {
            super(32, 0.6f);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > 16;
        }
    }
}

