/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization.plugin;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.DefaultMetaStoreFilterHookImpl;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAccessControlException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObjectUtils;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class AuthorizationMetaStoreFilterHook
extends DefaultMetaStoreFilterHookImpl {
    public static final Logger LOG = LoggerFactory.getLogger(AuthorizationMetaStoreFilterHook.class);

    public AuthorizationMetaStoreFilterHook(HiveConf conf) {
        super(conf);
    }

    @Override
    public List<String> filterTableNames(String dbName, List<String> tableList) throws MetaException {
        List<HivePrivilegeObject> listObjs = this.getHivePrivObjects(dbName, tableList);
        return this.getTableNames(this.getFilteredObjects(listObjs));
    }

    @Override
    public List<String> filterDatabases(List<String> dbList) throws MetaException {
        List<HivePrivilegeObject> listObjs = HivePrivilegeObjectUtils.getHivePrivDbObjects(dbList);
        return this.getDbNames(this.getFilteredObjects(listObjs));
    }

    private List<String> getDbNames(List<HivePrivilegeObject> filteredObjects) {
        ArrayList<String> tnames = new ArrayList<String>();
        for (HivePrivilegeObject obj : filteredObjects) {
            tnames.add(obj.getDbname());
        }
        return tnames;
    }

    private List<String> getTableNames(List<HivePrivilegeObject> filteredObjects) {
        ArrayList<String> tnames = new ArrayList<String>();
        for (HivePrivilegeObject obj : filteredObjects) {
            tnames.add(obj.getObjectName());
        }
        return tnames;
    }

    private List<HivePrivilegeObject> getFilteredObjects(List<HivePrivilegeObject> listObjs) throws MetaException {
        SessionState ss = SessionState.get();
        HiveAuthzContext.Builder authzContextBuilder = new HiveAuthzContext.Builder();
        authzContextBuilder.setUserIpAddress(ss.getUserIpAddress());
        authzContextBuilder.setForwardedAddresses(ss.getForwardedAddresses());
        try {
            return ss.getAuthorizerV2().filterListCmdObjects(listObjs, authzContextBuilder.build());
        }
        catch (HiveAuthzPluginException e) {
            LOG.error("Authorization error", e);
            throw new MetaException(e.getMessage());
        }
        catch (HiveAccessControlException e) {
            LOG.error("AccessControlException", e);
            throw new MetaException(e.getMessage());
        }
    }

    private List<HivePrivilegeObject> getHivePrivObjects(String dbName, List<String> tableList) {
        ArrayList<HivePrivilegeObject> objs = new ArrayList<HivePrivilegeObject>();
        for (String tname : tableList) {
            objs.add(new HivePrivilegeObject(HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW, dbName, tname));
        }
        return objs;
    }
}

