/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelOptUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAggregate;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveGroupingID;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.apache.hive.com.google.common.collect.ImmutableList;
import org.apache.hive.com.google.common.collect.Lists;

public class HiveAggregateProjectMergeRule
extends RelOptRule {
    public static final HiveAggregateProjectMergeRule INSTANCE = new HiveAggregateProjectMergeRule();

    private HiveAggregateProjectMergeRule() {
        super(HiveAggregateProjectMergeRule.operand(HiveAggregate.class, (RelOptRuleOperand)HiveAggregateProjectMergeRule.operand(HiveProject.class, (RelOptRuleOperandChildren)HiveAggregateProjectMergeRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
    }

    public boolean matches(RelOptRuleCall call) {
        Aggregate aggregate = (Aggregate)call.rel(0);
        for (AggregateCall aggCall : aggregate.getAggCallList()) {
            if (!aggCall.getAggregation().equals((Object)HiveGroupingID.INSTANCE)) continue;
            return false;
        }
        return super.matches(call);
    }

    public void onMatch(RelOptRuleCall call) {
        HiveProject project;
        HiveAggregate aggregate = (HiveAggregate)call.rel(0);
        RelNode x = HiveAggregateProjectMergeRule.apply(aggregate, project = (HiveProject)call.rel(1));
        if (x != null) {
            call.transformTo(x);
        }
    }

    public static RelNode apply(HiveAggregate aggregate, HiveProject project) {
        Aggregate newAggregate;
        ArrayList<Integer> newKeys = Lists.newArrayList();
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        Iterator iterator = aggregate.getGroupSet().iterator();
        while (iterator.hasNext()) {
            int key = (Integer)iterator.next();
            RexNode rex = (RexNode)project.getProjects().get(key);
            if (rex instanceof RexInputRef) {
                int newKey = ((RexInputRef)rex).getIndex();
                newKeys.add(newKey);
                map.put(key, newKey);
                continue;
            }
            return null;
        }
        ImmutableBitSet newGroupSet = aggregate.getGroupSet().permute(map);
        ImmutableList<ImmutableBitSet> newGroupingSets = null;
        if (aggregate.indicator) {
            newGroupingSets = ImmutableBitSet.ORDERING.immutableSortedCopy(ImmutableBitSet.permute((Iterable)aggregate.getGroupSets(), map));
        }
        ImmutableList.Builder aggCalls = ImmutableList.builder();
        for (AggregateCall aggregateCall : aggregate.getAggCallList()) {
            int newFilterArg;
            ImmutableList.Builder newArgs = ImmutableList.builder();
            Iterator iterator2 = aggregateCall.getArgList().iterator();
            while (iterator2.hasNext()) {
                int arg = (Integer)iterator2.next();
                RexNode rex = (RexNode)project.getProjects().get(arg);
                if (rex instanceof RexInputRef) {
                    newArgs.add((Object)((RexInputRef)rex).getIndex());
                    continue;
                }
                return null;
            }
            if (aggregateCall.filterArg >= 0) {
                RexNode rex = (RexNode)project.getProjects().get(aggregateCall.filterArg);
                if (!(rex instanceof RexInputRef)) {
                    return null;
                }
                newFilterArg = ((RexInputRef)rex).getIndex();
            } else {
                newFilterArg = -1;
            }
            aggCalls.add(aggregateCall.copy((List)((Object)newArgs.build()), newFilterArg));
        }
        Aggregate rel = newAggregate = aggregate.copy(aggregate.getTraitSet(), project.getInput(), aggregate.indicator, newGroupSet, newGroupingSets, (List<AggregateCall>)((Object)aggCalls.build()));
        if (!newKeys.equals(newGroupSet.asList())) {
            ArrayList<Integer> posList = Lists.newArrayList();
            Iterator newFilterArg = newKeys.iterator();
            while (newFilterArg.hasNext()) {
                int newKey = (Integer)newFilterArg.next();
                posList.add(newGroupSet.indexOf(newKey));
            }
            if (aggregate.indicator) {
                newFilterArg = newKeys.iterator();
                while (newFilterArg.hasNext()) {
                    int newKey = (Integer)newFilterArg.next();
                    posList.add(aggregate.getGroupCount() + newGroupSet.indexOf(newKey));
                }
            }
            for (int i = newAggregate.getGroupCount() + newAggregate.getIndicatorCount(); i < newAggregate.getRowType().getFieldCount(); ++i) {
                posList.add(i);
            }
            rel = HiveRelOptUtil.createProject(HiveRelFactories.HIVE_BUILDER.create(aggregate.getCluster(), null), (RelNode)rel, posList);
        }
        return rel;
    }
}

