/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite;

import java.math.BigDecimal;
import java.util.AbstractList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.Context;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.runtime.CalciteException;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.server.CalciteServerStatement;
import org.apache.calcite.sql.SemiJoinType;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.util.CompositeList;
import org.apache.calcite.util.Holder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.NlsString;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Static;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hive.com.google.common.base.Function;
import org.apache.hive.com.google.common.base.Joiner;
import org.apache.hive.com.google.common.base.Preconditions;
import org.apache.hive.com.google.common.collect.ImmutableList;
import org.apache.hive.com.google.common.collect.ImmutableSet;
import org.apache.hive.com.google.common.collect.Iterables;
import org.apache.hive.com.google.common.collect.Lists;

public class HiveSubQRemoveRelBuilder {
    private static final Function<RexNode, String> FN_TYPE = new Function<RexNode, String>(){

        @Override
        public String apply(RexNode input) {
            return input + ": " + input.getType();
        }
    };
    protected final RelOptCluster cluster;
    protected final RelOptSchema relOptSchema;
    private final RelFactories.FilterFactory filterFactory;
    private final RelFactories.ProjectFactory projectFactory;
    private final RelFactories.AggregateFactory aggregateFactory;
    private final RelFactories.SortFactory sortFactory;
    private final RelFactories.SetOpFactory setOpFactory;
    private final RelFactories.JoinFactory joinFactory;
    private final RelFactories.SemiJoinFactory semiJoinFactory;
    private final RelFactories.CorrelateFactory correlateFactory;
    private final RelFactories.ValuesFactory valuesFactory;
    private final RelFactories.TableScanFactory scanFactory;
    private final Deque<Frame> stack = new ArrayDeque<Frame>();

    public HiveSubQRemoveRelBuilder(Context context, RelOptCluster cluster, RelOptSchema relOptSchema) {
        this.cluster = cluster;
        this.relOptSchema = relOptSchema;
        if (context == null) {
            context = Contexts.EMPTY_CONTEXT;
        }
        this.aggregateFactory = (RelFactories.AggregateFactory)Util.first((Object)context.unwrap(RelFactories.AggregateFactory.class), (Object)HiveRelFactories.HIVE_AGGREGATE_FACTORY);
        this.filterFactory = (RelFactories.FilterFactory)Util.first((Object)context.unwrap(RelFactories.FilterFactory.class), (Object)HiveRelFactories.HIVE_FILTER_FACTORY);
        this.projectFactory = (RelFactories.ProjectFactory)Util.first((Object)context.unwrap(RelFactories.ProjectFactory.class), (Object)HiveRelFactories.HIVE_PROJECT_FACTORY);
        this.sortFactory = (RelFactories.SortFactory)Util.first((Object)context.unwrap(RelFactories.SortFactory.class), (Object)HiveRelFactories.HIVE_SORT_FACTORY);
        this.setOpFactory = (RelFactories.SetOpFactory)Util.first((Object)context.unwrap(RelFactories.SetOpFactory.class), (Object)HiveRelFactories.HIVE_SET_OP_FACTORY);
        this.joinFactory = (RelFactories.JoinFactory)Util.first((Object)context.unwrap(RelFactories.JoinFactory.class), (Object)HiveRelFactories.HIVE_JOIN_FACTORY);
        this.semiJoinFactory = (RelFactories.SemiJoinFactory)Util.first((Object)context.unwrap(RelFactories.SemiJoinFactory.class), (Object)HiveRelFactories.HIVE_SEMI_JOIN_FACTORY);
        this.correlateFactory = (RelFactories.CorrelateFactory)Util.first((Object)context.unwrap(RelFactories.CorrelateFactory.class), (Object)RelFactories.DEFAULT_CORRELATE_FACTORY);
        this.valuesFactory = (RelFactories.ValuesFactory)Util.first((Object)context.unwrap(RelFactories.ValuesFactory.class), (Object)RelFactories.DEFAULT_VALUES_FACTORY);
        this.scanFactory = (RelFactories.TableScanFactory)Util.first((Object)context.unwrap(RelFactories.TableScanFactory.class), (Object)RelFactories.DEFAULT_TABLE_SCAN_FACTORY);
    }

    public static HiveSubQRemoveRelBuilder create(FrameworkConfig config) {
        final RelOptCluster[] clusters = new RelOptCluster[]{null};
        final RelOptSchema[] relOptSchemas = new RelOptSchema[]{null};
        Frameworks.withPrepare((Frameworks.PrepareAction)new Frameworks.PrepareAction<Void>(config){

            public Void apply(RelOptCluster cluster, RelOptSchema relOptSchema, SchemaPlus rootSchema, CalciteServerStatement statement) {
                clusters[0] = cluster;
                relOptSchemas[0] = relOptSchema;
                return null;
            }
        });
        return new HiveSubQRemoveRelBuilder(config.getContext(), clusters[0], relOptSchemas[0]);
    }

    public RelDataTypeFactory getTypeFactory() {
        return this.cluster.getTypeFactory();
    }

    public RexBuilder getRexBuilder() {
        return this.cluster.getRexBuilder();
    }

    public HiveSubQRemoveRelBuilder push(RelNode node) {
        this.stack.push(new Frame(node));
        return this;
    }

    public HiveSubQRemoveRelBuilder pushAll(Iterable<? extends RelNode> nodes) {
        for (RelNode relNode : nodes) {
            this.push(relNode);
        }
        return this;
    }

    public RelNode build() {
        return this.stack.pop().rel;
    }

    public RelNode peek() {
        return this.peek_().rel;
    }

    private Frame peek_() {
        return this.stack.peek();
    }

    public RelNode peek(int n) {
        return this.peek_((int)n).rel;
    }

    private Frame peek_(int n) {
        return Iterables.get(this.stack, n);
    }

    public RelNode peek(int inputCount, int inputOrdinal) {
        return this.peek_((int)inputCount, (int)inputOrdinal).rel;
    }

    private Frame peek_(int inputCount, int inputOrdinal) {
        return this.peek_(inputCount - 1 - inputOrdinal);
    }

    private int inputOffset(int inputCount, int inputOrdinal) {
        int offset = 0;
        for (int i = 0; i < inputOrdinal; ++i) {
            offset += this.peek(inputCount, i).getRowType().getFieldCount();
        }
        return offset;
    }

    public RexNode literal(Object value) {
        RexBuilder rexBuilder = this.cluster.getRexBuilder();
        if (value == null) {
            return rexBuilder.constantNull();
        }
        if (value instanceof Boolean) {
            return rexBuilder.makeLiteral(((Boolean)value).booleanValue());
        }
        if (value instanceof BigDecimal) {
            return rexBuilder.makeExactLiteral((BigDecimal)value);
        }
        if (value instanceof Float || value instanceof Double) {
            return rexBuilder.makeApproxLiteral(BigDecimal.valueOf(((Number)value).doubleValue()));
        }
        if (value instanceof Number) {
            return rexBuilder.makeExactLiteral(BigDecimal.valueOf(((Number)value).longValue()));
        }
        if (value instanceof String) {
            return rexBuilder.makeLiteral((String)value);
        }
        throw new IllegalArgumentException("cannot convert " + value + " (" + value.getClass() + ") to a constant");
    }

    public RexInputRef field(String fieldName) {
        return this.field(1, 0, fieldName);
    }

    public RexInputRef field(int inputCount, int inputOrdinal, String fieldName) {
        Frame frame = this.peek_(inputCount, inputOrdinal);
        List fieldNames = Pair.left(frame.fields());
        int i = fieldNames.indexOf(fieldName);
        if (i >= 0) {
            return this.field(inputCount, inputOrdinal, i);
        }
        throw new IllegalArgumentException("field [" + fieldName + "] not found; input fields are: " + fieldNames);
    }

    public RexInputRef field(int fieldOrdinal) {
        return (RexInputRef)this.field(1, 0, fieldOrdinal, false);
    }

    public RexInputRef field(int inputCount, int inputOrdinal, int fieldOrdinal) {
        return (RexInputRef)this.field(inputCount, inputOrdinal, fieldOrdinal, false);
    }

    private RexNode field(int inputCount, int inputOrdinal, int fieldOrdinal, boolean alias) {
        Frame frame = this.peek_(inputCount, inputOrdinal);
        RelNode input = frame.rel;
        RelDataType rowType = input.getRowType();
        if (fieldOrdinal < 0 || fieldOrdinal > rowType.getFieldCount()) {
            throw new IllegalArgumentException("field ordinal [" + fieldOrdinal + "] out of range; input fields are: " + rowType.getFieldNames());
        }
        RelDataTypeField field = (RelDataTypeField)rowType.getFieldList().get(fieldOrdinal);
        int offset = this.inputOffset(inputCount, inputOrdinal);
        RexInputRef ref = this.cluster.getRexBuilder().makeInputRef(field.getType(), offset + fieldOrdinal);
        RelDataTypeField aliasField = frame.fields().get(fieldOrdinal);
        if (!alias || field.getName().equals(aliasField.getName())) {
            return ref;
        }
        return this.alias((RexNode)ref, aliasField.getName());
    }

    public RexNode field(String alias, String fieldName) {
        Preconditions.checkNotNull(alias);
        Preconditions.checkNotNull(fieldName);
        Frame frame = this.stack.peek();
        ArrayList<Object> aliases = new ArrayList<Object>();
        int offset = 0;
        for (Pair pair : frame.right) {
            if (pair.left != null && ((String)pair.left).equals(alias)) {
                int i = ((RelDataType)pair.right).getFieldNames().indexOf(fieldName);
                if (i >= 0) {
                    return this.field(offset + i);
                }
                throw new IllegalArgumentException("no field '" + fieldName + "' in relation '" + alias + "'; fields are: " + ((RelDataType)pair.right).getFieldNames());
            }
            aliases.add(pair.left);
            offset += ((RelDataType)pair.right).getFieldCount();
        }
        throw new IllegalArgumentException("no relation wtih alias '" + alias + "'; aliases are: " + aliases);
    }

    public ImmutableList<RexNode> fields() {
        return this.fields(1, 0);
    }

    public ImmutableList<RexNode> fields(int inputCount, int inputOrdinal) {
        RelNode input = this.peek(inputCount, inputOrdinal);
        RelDataType rowType = input.getRowType();
        ImmutableList.Builder nodes = ImmutableList.builder();
        Iterator iterator = Util.range((int)rowType.getFieldCount()).iterator();
        while (iterator.hasNext()) {
            int fieldOrdinal = (Integer)iterator.next();
            nodes.add(this.field(inputCount, inputOrdinal, fieldOrdinal));
        }
        return nodes.build();
    }

    public ImmutableList<RexNode> fields(RelCollation collation) {
        ImmutableList.Builder nodes = ImmutableList.builder();
        for (RelFieldCollation fieldCollation : collation.getFieldCollations()) {
            RexInputRef node = this.field(fieldCollation.getFieldIndex());
            switch (fieldCollation.direction) {
                case DESCENDING: {
                    node = this.desc((RexNode)node);
                }
            }
            switch (fieldCollation.nullDirection) {
                case FIRST: {
                    node = this.nullsFirst((RexNode)node);
                    break;
                }
                case LAST: {
                    node = this.nullsLast((RexNode)node);
                }
            }
            nodes.add(node);
        }
        return nodes.build();
    }

    public ImmutableList<RexNode> fields(List<? extends Number> ordinals) {
        ImmutableList.Builder nodes = ImmutableList.builder();
        for (Number number : ordinals) {
            RexNode node = this.field(1, 0, number.intValue(), true);
            nodes.add(node);
        }
        return nodes.build();
    }

    public ImmutableList<RexNode> fields(Iterable<String> fieldNames) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String fieldName : fieldNames) {
            builder.add(this.field(fieldName));
        }
        return builder.build();
    }

    public ImmutableList<RexNode> fields(Mappings.TargetMapping mapping) {
        return this.fields(Mappings.asList((Mappings.TargetMapping)mapping));
    }

    public RexNode dot(RexNode node, String fieldName) {
        RexBuilder builder = this.cluster.getRexBuilder();
        return builder.makeFieldAccess(node, fieldName, true);
    }

    public RexNode dot(RexNode node, int fieldOrdinal) {
        RexBuilder builder = this.cluster.getRexBuilder();
        return builder.makeFieldAccess(node, fieldOrdinal);
    }

    public RexNode call(SqlOperator operator, RexNode ... operands) {
        ImmutableList<RexNode> operandList;
        RexBuilder builder = this.cluster.getRexBuilder();
        RelDataType type = builder.deriveReturnType(operator, operandList = ImmutableList.copyOf(operands));
        if (type == null) {
            throw new IllegalArgumentException("cannot derive type: " + operator + "; operands: " + Lists.transform(operandList, FN_TYPE));
        }
        return builder.makeCall(type, operator, operandList);
    }

    public RexNode call(SqlOperator operator, Iterable<? extends RexNode> operands) {
        return this.cluster.getRexBuilder().makeCall(operator, ImmutableList.copyOf(operands));
    }

    public RexNode and(RexNode ... operands) {
        return this.and(ImmutableList.copyOf(operands));
    }

    public RexNode and(Iterable<? extends RexNode> operands) {
        return RexUtil.simplifyAnds((RexBuilder)this.cluster.getRexBuilder(), operands);
    }

    public RexNode or(RexNode ... operands) {
        return this.or(ImmutableList.copyOf(operands));
    }

    public RexNode or(Iterable<? extends RexNode> operands) {
        return RexUtil.composeDisjunction((RexBuilder)this.cluster.getRexBuilder(), operands, (boolean)false);
    }

    public RexNode not(RexNode operand) {
        return this.call((SqlOperator)SqlStdOperatorTable.NOT, operand);
    }

    public RexNode equals(RexNode operand0, RexNode operand1) {
        return this.call((SqlOperator)SqlStdOperatorTable.EQUALS, operand0, operand1);
    }

    public RexNode isNull(RexNode operand) {
        return this.call((SqlOperator)SqlStdOperatorTable.IS_NULL, operand);
    }

    public RexNode isNotNull(RexNode operand) {
        return this.call((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, operand);
    }

    public RexNode cast(RexNode expr, SqlTypeName typeName) {
        RelDataType type = this.cluster.getTypeFactory().createSqlType(typeName);
        return this.cluster.getRexBuilder().makeCast(type, expr);
    }

    public RexNode cast(RexNode expr, SqlTypeName typeName, int precision) {
        RelDataType type = this.cluster.getTypeFactory().createSqlType(typeName, precision);
        return this.cluster.getRexBuilder().makeCast(type, expr);
    }

    public RexNode cast(RexNode expr, SqlTypeName typeName, int precision, int scale) {
        RelDataType type = this.cluster.getTypeFactory().createSqlType(typeName, precision, scale);
        return this.cluster.getRexBuilder().makeCast(type, expr);
    }

    public RexNode alias(RexNode expr, String alias) {
        return this.call((SqlOperator)SqlStdOperatorTable.AS, expr, this.literal(alias));
    }

    public RexNode desc(RexNode node) {
        return this.call((SqlOperator)SqlStdOperatorTable.DESC, node);
    }

    public RexNode nullsLast(RexNode node) {
        return this.call((SqlOperator)SqlStdOperatorTable.NULLS_LAST, node);
    }

    public RexNode nullsFirst(RexNode node) {
        return this.call((SqlOperator)SqlStdOperatorTable.NULLS_FIRST, node);
    }

    public GroupKey groupKey() {
        return this.groupKey(ImmutableList.of());
    }

    public GroupKey groupKey(RexNode ... nodes) {
        return this.groupKey(ImmutableList.copyOf(nodes));
    }

    public GroupKey groupKey(Iterable<? extends RexNode> nodes) {
        return new GroupKeyImpl(ImmutableList.copyOf(nodes), false, null, null);
    }

    public GroupKey groupKey(Iterable<? extends RexNode> nodes, boolean indicator, Iterable<? extends Iterable<? extends RexNode>> nodeLists) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Iterable<? extends RexNode> iterable : nodeLists) {
            builder.add(ImmutableList.copyOf(iterable));
        }
        return new GroupKeyImpl(ImmutableList.copyOf(nodes), indicator, (ImmutableList<ImmutableList<RexNode>>)builder.build(), null);
    }

    public GroupKey groupKey(int ... fieldOrdinals) {
        return this.groupKey(this.fields((List<? extends Number>)ImmutableIntList.of((int[])fieldOrdinals)));
    }

    public GroupKey groupKey(String ... fieldNames) {
        return this.groupKey(this.fields((Iterable<String>)ImmutableList.copyOf(fieldNames)));
    }

    public GroupKey groupKey(ImmutableBitSet groupSet, boolean indicator, ImmutableList<ImmutableBitSet> groupSets) {
        if (groupSet.length() > this.peek().getRowType().getFieldCount()) {
            throw new IllegalArgumentException("out of bounds: " + groupSet);
        }
        if (groupSets == null) {
            groupSets = ImmutableList.of(groupSet);
        }
        ImmutableList<RexNode> nodes = this.fields((List<? extends Number>)ImmutableIntList.of((int[])groupSet.toArray()));
        List<ImmutableList<RexNode>> nodeLists = Lists.transform(groupSets, new Function<ImmutableBitSet, ImmutableList<RexNode>>(){

            @Override
            public ImmutableList<RexNode> apply(ImmutableBitSet input) {
                return HiveSubQRemoveRelBuilder.this.fields((List<? extends Number>)ImmutableIntList.of((int[])input.toArray()));
            }
        });
        return this.groupKey(nodes, indicator, nodeLists);
    }

    public AggCall aggregateCall(SqlAggFunction aggFunction, boolean distinct, RexNode filter, String alias, RexNode ... operands) {
        return this.aggregateCall(aggFunction, distinct, filter, alias, ImmutableList.copyOf(operands));
    }

    public AggCall aggregateCall(SqlAggFunction aggFunction, boolean distinct, RexNode filter, String alias, Iterable<? extends RexNode> operands) {
        if (filter != null) {
            if (filter.getType().getSqlTypeName() != SqlTypeName.BOOLEAN) {
                throw (CalciteException)Static.RESOURCE.filterMustBeBoolean().ex();
            }
            if (filter.getType().isNullable()) {
                filter = this.call((SqlOperator)SqlStdOperatorTable.IS_TRUE, filter);
            }
        }
        return new AggCallImpl(aggFunction, distinct, filter, alias, ImmutableList.copyOf(operands));
    }

    public AggCall count(boolean distinct, String alias, RexNode ... operands) {
        return this.aggregateCall(SqlStdOperatorTable.COUNT, distinct, null, alias, operands);
    }

    public AggCall countStar(String alias) {
        return this.aggregateCall(SqlStdOperatorTable.COUNT, false, null, alias, new RexNode[0]);
    }

    public AggCall sum(boolean distinct, String alias, RexNode operand) {
        return this.aggregateCall(SqlStdOperatorTable.SUM, distinct, null, alias, operand);
    }

    public AggCall avg(boolean distinct, String alias, RexNode operand) {
        return this.aggregateCall(SqlStdOperatorTable.AVG, distinct, null, alias, operand);
    }

    public AggCall min(String alias, RexNode operand) {
        return this.aggregateCall(SqlStdOperatorTable.MIN, false, null, alias, operand);
    }

    public AggCall max(String alias, RexNode operand) {
        return this.aggregateCall(SqlStdOperatorTable.MAX, false, null, alias, operand);
    }

    public HiveSubQRemoveRelBuilder scan(Iterable<String> tableNames) {
        ImmutableList<String> names = ImmutableList.copyOf(tableNames);
        RelOptTable relOptTable = this.relOptSchema.getTableForMember(names);
        if (relOptTable == null) {
            throw (CalciteException)Static.RESOURCE.tableNotFound(Joiner.on(".").join(names)).ex();
        }
        RelNode scan = this.scanFactory.createScan(this.cluster, relOptTable);
        this.push(scan);
        return this;
    }

    public HiveSubQRemoveRelBuilder scan(String ... tableNames) {
        return this.scan(ImmutableList.copyOf(tableNames));
    }

    public HiveSubQRemoveRelBuilder filter(RexNode ... predicates) {
        return this.filter(ImmutableList.copyOf(predicates));
    }

    public HiveSubQRemoveRelBuilder filter(Iterable<? extends RexNode> predicates) {
        RexNode x = RexUtil.simplifyAnds((RexBuilder)this.cluster.getRexBuilder(), predicates, (boolean)true);
        if (x.isAlwaysFalse()) {
            return this.empty();
        }
        if (!x.isAlwaysTrue()) {
            Frame frame = this.stack.pop();
            RelNode filter = this.filterFactory.createFilter(frame.rel, x);
            this.stack.push(new Frame(filter, frame.right));
        }
        return this;
    }

    public HiveSubQRemoveRelBuilder project(Iterable<? extends RexNode> nodes) {
        return this.project(nodes, ImmutableList.of());
    }

    public HiveSubQRemoveRelBuilder project(Iterable<? extends RexNode> nodes, Iterable<String> fieldNames) {
        return this.project(nodes, fieldNames, false);
    }

    public HiveSubQRemoveRelBuilder project(Iterable<? extends RexNode> nodes, Iterable<String> fieldNames, boolean force) {
        ArrayList<Object> names = new ArrayList<Object>();
        ArrayList<RexNode> exprList = Lists.newArrayList(nodes);
        Iterator<String> nameIterator = fieldNames.iterator();
        for (RexNode rexNode : nodes) {
            String name = nameIterator.hasNext() ? nameIterator.next() : null;
            String name2 = this.inferAlias(exprList, rexNode);
            names.add(Util.first((Object)name, (Object)name2));
        }
        RelDataType inputRowType = this.peek().getRowType();
        if (!force && RexUtil.isIdentity(exprList, (RelDataType)inputRowType)) {
            if (names.equals(inputRowType.getFieldNames())) {
                return this;
            }
            Frame frame = this.stack.pop();
            RelDataType rowType = RexUtil.createStructType((RelDataTypeFactory)this.cluster.getTypeFactory(), exprList, names, (SqlValidatorUtil.Suggester)SqlValidatorUtil.F_SUGGESTER);
            this.stack.push(new Frame(frame.rel, ImmutableList.of(Pair.of((Object)((Pair)frame.right.get((int)0)).left, (Object)rowType))));
            return this;
        }
        RelNode relNode = this.projectFactory.createProject(this.build(), ImmutableList.copyOf(exprList), names);
        this.push(relNode);
        return this;
    }

    public HiveSubQRemoveRelBuilder project(RexNode ... nodes) {
        return this.project(ImmutableList.copyOf(nodes));
    }

    private String inferAlias(List<RexNode> exprList, RexNode expr) {
        switch (expr.getKind()) {
            case INPUT_REF: {
                RexInputRef ref = (RexInputRef)expr;
                return (String)this.peek(0).getRowType().getFieldNames().get(ref.getIndex());
            }
            case CAST: {
                return this.inferAlias(exprList, (RexNode)((RexCall)expr).getOperands().get(0));
            }
            case AS: {
                int i;
                RexCall call = (RexCall)expr;
                while ((i = exprList.indexOf(expr)) >= 0) {
                    exprList.set(i, (RexNode)call.getOperands().get(0));
                }
                return ((NlsString)((RexLiteral)call.getOperands().get(1)).getValue()).getValue();
            }
        }
        return null;
    }

    public HiveSubQRemoveRelBuilder distinct() {
        return this.aggregate(this.groupKey(this.fields()), new AggCall[0]);
    }

    public HiveSubQRemoveRelBuilder aggregate(GroupKey groupKey, AggCall ... aggCalls) {
        return this.aggregate(groupKey, (Iterable<AggCall>)ImmutableList.copyOf(aggCalls));
    }

    public HiveSubQRemoveRelBuilder aggregate(GroupKey groupKey, Iterable<AggCall> aggCalls) {
        ImmutableList<Object> groupSets;
        RelDataType inputRowType = this.peek().getRowType();
        List<RexNode> extraNodes = this.projects(inputRowType);
        GroupKeyImpl groupKey_ = (GroupKeyImpl)groupKey;
        ImmutableBitSet groupSet = ImmutableBitSet.of(HiveSubQRemoveRelBuilder.registerExpressions(extraNodes, groupKey_.nodes));
        if (groupKey_.nodeLists != null) {
            int sizeBefore = extraNodes.size();
            TreeSet<ImmutableBitSet> groupSetSet = new TreeSet<ImmutableBitSet>(ImmutableBitSet.ORDERING);
            for (ImmutableList immutableList : groupKey_.nodeLists) {
                ImmutableBitSet groupSet2 = ImmutableBitSet.of(HiveSubQRemoveRelBuilder.registerExpressions(extraNodes, immutableList));
                if (!groupSet.contains(groupSet2)) {
                    throw new IllegalArgumentException("group set element " + immutableList + " must be a subset of group key");
                }
                groupSetSet.add(groupSet2);
            }
            groupSets = ImmutableList.copyOf(groupSetSet);
            if (extraNodes.size() > sizeBefore) {
                throw new IllegalArgumentException("group sets contained expressions not in group key: " + extraNodes.subList(sizeBefore, extraNodes.size()));
            }
        } else {
            groupSets = ImmutableList.of(groupSet);
        }
        for (AggCall aggCall : aggCalls) {
            if (!(aggCall instanceof AggCallImpl)) continue;
            AggCallImpl aggCall1 = (AggCallImpl)aggCall;
            HiveSubQRemoveRelBuilder.registerExpressions(extraNodes, aggCall1.operands);
            if (aggCall1.filter == null) continue;
            HiveSubQRemoveRelBuilder.registerExpression(extraNodes, aggCall1.filter);
        }
        if (extraNodes.size() > inputRowType.getFieldCount()) {
            this.project(extraNodes);
        }
        RelNode r = this.build();
        ArrayList<AggregateCall> aggregateCalls = new ArrayList<AggregateCall>();
        for (AggCall aggCall : aggCalls) {
            AggregateCall aggregateCall;
            if (aggCall instanceof AggCallImpl) {
                AggCallImpl aggCall1 = (AggCallImpl)aggCall;
                List<Integer> args = HiveSubQRemoveRelBuilder.registerExpressions(extraNodes, aggCall1.operands);
                int filterArg = aggCall1.filter == null ? -1 : HiveSubQRemoveRelBuilder.registerExpression(extraNodes, aggCall1.filter);
                aggregateCall = AggregateCall.create((SqlAggFunction)aggCall1.aggFunction, (boolean)aggCall1.distinct, args, (int)filterArg, (int)groupSet.cardinality(), (RelNode)r, null, (String)aggCall1.alias);
            } else {
                aggregateCall = ((AggCallImpl2)aggCall).aggregateCall;
            }
            aggregateCalls.add(aggregateCall);
        }
        assert (ImmutableBitSet.ORDERING.isStrictlyOrdered(groupSets)) : groupSets;
        for (ImmutableBitSet immutableBitSet : groupSets) {
            assert (groupSet.contains(immutableBitSet));
        }
        RelNode aggregate = this.aggregateFactory.createAggregate(r, groupKey_.indicator, groupSet, groupSets, aggregateCalls);
        this.push(aggregate);
        return this;
    }

    private List<RexNode> projects(RelDataType inputRowType) {
        ArrayList<RexNode> exprList = new ArrayList<RexNode>();
        for (RelDataTypeField field : inputRowType.getFieldList()) {
            RexBuilder rexBuilder = this.cluster.getRexBuilder();
            exprList.add((RexNode)rexBuilder.makeInputRef(field.getType(), field.getIndex()));
        }
        return exprList;
    }

    private static int registerExpression(List<RexNode> exprList, RexNode node) {
        int i = exprList.indexOf(node);
        if (i < 0) {
            i = exprList.size();
            exprList.add(node);
        }
        return i;
    }

    private static List<Integer> registerExpressions(List<RexNode> extraNodes, Iterable<? extends RexNode> nodes) {
        ArrayList<Integer> builder = new ArrayList<Integer>();
        for (RexNode rexNode : nodes) {
            builder.add(HiveSubQRemoveRelBuilder.registerExpression(extraNodes, rexNode));
        }
        return builder;
    }

    private HiveSubQRemoveRelBuilder setOp(boolean all, SqlKind kind, int n) {
        LinkedList<RelNode> inputs = new LinkedList<RelNode>();
        for (int i = 0; i < n; ++i) {
            inputs.add(0, this.build());
        }
        switch (kind) {
            case UNION: 
            case INTERSECT: 
            case EXCEPT: {
                if (n >= 1) break;
                throw new IllegalArgumentException("bad INTERSECT/UNION/EXCEPT input count");
            }
            default: {
                throw new AssertionError((Object)("bad setOp " + kind));
            }
        }
        switch (n) {
            case 1: {
                return this.push((RelNode)inputs.get(0));
            }
        }
        return this.push(this.setOpFactory.createSetOp(kind, inputs, all));
    }

    public HiveSubQRemoveRelBuilder union(boolean all) {
        return this.union(all, 2);
    }

    public HiveSubQRemoveRelBuilder union(boolean all, int n) {
        return this.setOp(all, SqlKind.UNION, n);
    }

    public HiveSubQRemoveRelBuilder intersect(boolean all) {
        return this.intersect(all, 2);
    }

    public HiveSubQRemoveRelBuilder intersect(boolean all, int n) {
        return this.setOp(all, SqlKind.INTERSECT, n);
    }

    public HiveSubQRemoveRelBuilder minus(boolean all) {
        return this.minus(all, 2);
    }

    public HiveSubQRemoveRelBuilder minus(boolean all, int n) {
        return this.setOp(all, SqlKind.EXCEPT, n);
    }

    public HiveSubQRemoveRelBuilder join(JoinRelType joinType, RexNode condition0, RexNode ... conditions) {
        return this.join(joinType, Lists.asList(condition0, conditions));
    }

    public HiveSubQRemoveRelBuilder join(JoinRelType joinType, Iterable<? extends RexNode> conditions) {
        return this.join(joinType, this.and(conditions), ImmutableSet.of());
    }

    public HiveSubQRemoveRelBuilder join(JoinRelType joinType, RexNode condition) {
        return this.join(joinType, condition, ImmutableSet.of());
    }

    public HiveSubQRemoveRelBuilder variable(Holder<RexCorrelVariable> v) {
        v.set((Object)((RexCorrelVariable)this.getRexBuilder().makeCorrel(this.peek().getRowType(), this.cluster.createCorrel())));
        return this;
    }

    public RexNode field(RexNode e, String name) {
        return this.getRexBuilder().makeFieldAccess(e, name, false);
    }

    public HiveSubQRemoveRelBuilder join(JoinRelType joinType, RexNode condition, Set<CorrelationId> variablesSet) {
        RelNode join;
        Frame right = this.stack.pop();
        Frame left = this.stack.pop();
        boolean correlate = variablesSet.size() == 1;
        RexNode postCondition = this.literal(true);
        if (correlate) {
            CorrelationId id = Iterables.getOnlyElement(variablesSet);
            ImmutableBitSet requiredColumns = RelOptUtil.correlationColumns((CorrelationId)id, (RelNode)right.rel);
            if (!RelOptUtil.notContainsCorrelation((RelNode)left.rel, (CorrelationId)id, (Litmus)Litmus.IGNORE)) {
                throw new IllegalArgumentException("variable " + id + " must not be used by left input to correlation");
            }
            switch (joinType) {
                case LEFT: {
                    this.stack.push(right);
                    this.filter((RexNode)condition.accept((RexVisitor)new Shifter(left.rel, id, right.rel)));
                    right = this.stack.pop();
                    break;
                }
                default: {
                    postCondition = condition;
                }
            }
            join = this.correlateFactory.createCorrelate(left.rel, right.rel, id, requiredColumns, SemiJoinType.of((JoinRelType)joinType));
        } else {
            join = this.joinFactory.createJoin(left.rel, right.rel, condition, variablesSet, joinType, false);
        }
        ArrayList<Pair<String, RelDataType>> pairs = new ArrayList<Pair<String, RelDataType>>();
        pairs.addAll(left.right);
        pairs.addAll(right.right);
        this.stack.push(new Frame(join, ImmutableList.copyOf(pairs)));
        this.filter(postCondition);
        return this;
    }

    public HiveSubQRemoveRelBuilder join(JoinRelType joinType, String ... fieldNames) {
        ArrayList<RexNode> conditions = new ArrayList<RexNode>();
        for (String fieldName : fieldNames) {
            conditions.add(this.call((SqlOperator)SqlStdOperatorTable.EQUALS, new RexNode[]{this.field(2, 0, fieldName), this.field(2, 1, fieldName)}));
        }
        return this.join(joinType, conditions);
    }

    public HiveSubQRemoveRelBuilder semiJoin(Iterable<? extends RexNode> conditions) {
        Frame right = this.stack.pop();
        Frame left = this.stack.pop();
        RelNode semiJoin = this.semiJoinFactory.createSemiJoin(left.rel, right.rel, this.and(conditions));
        this.stack.push(new Frame(semiJoin, left.right));
        return this;
    }

    public HiveSubQRemoveRelBuilder semiJoin(RexNode ... conditions) {
        return this.semiJoin(ImmutableList.copyOf(conditions));
    }

    public HiveSubQRemoveRelBuilder as(String alias) {
        Frame pair = this.stack.pop();
        this.stack.push(new Frame(pair.rel, ImmutableList.of(Pair.of((Object)alias, (Object)((Pair)pair.right.get((int)0)).right))));
        return this;
    }

    public HiveSubQRemoveRelBuilder values(String[] fieldNames, Object ... values) {
        if (fieldNames == null || fieldNames.length == 0 || values.length % fieldNames.length != 0 || values.length < fieldNames.length) {
            throw new IllegalArgumentException("Value count must be a positive multiple of field count");
        }
        final int rowCount = values.length / fieldNames.length;
        for (Ord fieldName : Ord.zip((Object[])fieldNames)) {
            if (!this.allNull(values, fieldName.i, fieldNames.length)) continue;
            throw new IllegalArgumentException("All values of field '" + (String)fieldName.e + "' are null; cannot deduce type");
        }
        final ImmutableList<ImmutableList<RexLiteral>> tupleList = this.tupleList(fieldNames.length, values);
        RelDataTypeFactory.FieldInfoBuilder rowTypeBuilder = this.cluster.getTypeFactory().builder();
        for (final Ord fieldName : Ord.zip((Object[])fieldNames)) {
            String name = fieldName.e != null ? (String)fieldName.e : "expr$" + fieldName.i;
            RelDataType type = this.cluster.getTypeFactory().leastRestrictive((List)new AbstractList<RelDataType>(){

                @Override
                public RelDataType get(int index) {
                    return ((RexLiteral)((ImmutableList)tupleList.get(index)).get(fieldName.i)).getType();
                }

                @Override
                public int size() {
                    return rowCount;
                }
            });
            rowTypeBuilder.add(name, type);
        }
        RelDataType rowType = rowTypeBuilder.build();
        return this.values(tupleList, rowType);
    }

    private ImmutableList<ImmutableList<RexLiteral>> tupleList(int columnCount, Object[] values) {
        ImmutableList.Builder listBuilder = ImmutableList.builder();
        ArrayList<RexLiteral> valueList = new ArrayList<RexLiteral>();
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            valueList.add((RexLiteral)this.literal(value));
            if ((i + 1) % columnCount != 0) continue;
            listBuilder.add(ImmutableList.copyOf(valueList));
            valueList.clear();
        }
        return listBuilder.build();
    }

    private boolean allNull(Object[] values, int column, int columnCount) {
        for (int i = column; i < values.length; i += columnCount) {
            if (values[i] == null) continue;
            return false;
        }
        return true;
    }

    public HiveSubQRemoveRelBuilder empty() {
        RelNode input = this.build();
        RelNode sort = HiveRelFactories.HIVE_SORT_FACTORY.createSort(input, RelCollations.of((RelFieldCollation[])new RelFieldCollation[0]), null, this.literal(0));
        return this.push(sort);
    }

    public HiveSubQRemoveRelBuilder values(RelDataType rowType, Object ... columnValues) {
        ImmutableList<ImmutableList<RexLiteral>> tupleList = this.tupleList(rowType.getFieldCount(), columnValues);
        RelNode values = this.valuesFactory.createValues(this.cluster, rowType, ImmutableList.copyOf(tupleList));
        this.push(values);
        return this;
    }

    public HiveSubQRemoveRelBuilder values(Iterable<? extends List<RexLiteral>> tupleList, RelDataType rowType) {
        RelNode values = this.valuesFactory.createValues(this.cluster, rowType, HiveSubQRemoveRelBuilder.copy(tupleList));
        this.push(values);
        return this;
    }

    public HiveSubQRemoveRelBuilder values(RelDataType rowType) {
        return this.values(ImmutableList.of(), rowType);
    }

    private static <E> ImmutableList<ImmutableList<E>> copy(Iterable<? extends List<E>> tupleList) {
        ImmutableList.Builder builder = ImmutableList.builder();
        int changeCount = 0;
        for (List<E> literals : tupleList) {
            ImmutableList<E> literals2 = ImmutableList.copyOf(literals);
            builder.add(literals2);
            if (literals == literals2) continue;
            ++changeCount;
        }
        if (changeCount == 0) {
            return (ImmutableList)tupleList;
        }
        return builder.build();
    }

    public HiveSubQRemoveRelBuilder limit(int offset, int fetch) {
        return this.sortLimit(offset, fetch, ImmutableList.of());
    }

    public HiveSubQRemoveRelBuilder sort(int ... fields) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int field : fields) {
            builder.add(field < 0 ? this.desc((RexNode)this.field(-field - 1)) : this.field(field));
        }
        return this.sortLimit(-1, -1, builder.build());
    }

    public HiveSubQRemoveRelBuilder sort(RexNode ... nodes) {
        return this.sortLimit(-1, -1, ImmutableList.copyOf(nodes));
    }

    public HiveSubQRemoveRelBuilder sort(Iterable<? extends RexNode> nodes) {
        return this.sortLimit(-1, -1, nodes);
    }

    public HiveSubQRemoveRelBuilder sortLimit(int offset, int fetch, RexNode ... nodes) {
        return this.sortLimit(offset, fetch, ImmutableList.copyOf(nodes));
    }

    public HiveSubQRemoveRelBuilder sortLimit(int offset, int fetch, Iterable<? extends RexNode> nodes) {
        boolean addedFields;
        RexNode rexNode;
        ArrayList<RelFieldCollation> fieldCollations = new ArrayList<RelFieldCollation>();
        RelDataType inputRowType = this.peek().getRowType();
        List<RexNode> extraNodes = this.projects(inputRowType);
        ImmutableList<RexNode> originalExtraNodes = ImmutableList.copyOf(extraNodes);
        for (RexNode rexNode2 : nodes) {
            fieldCollations.add(HiveSubQRemoveRelBuilder.collation(rexNode2, RelFieldCollation.Direction.ASCENDING, null, extraNodes));
        }
        RexNode offsetNode = offset <= 0 ? null : this.literal(offset);
        RexNode rexNode3 = rexNode = fetch < 0 ? null : this.literal(fetch);
        if (offsetNode == null && fetch == 0) {
            return this.empty();
        }
        if (offsetNode == null && rexNode == null && fieldCollations.isEmpty()) {
            return this;
        }
        boolean bl = addedFields = extraNodes.size() > originalExtraNodes.size();
        if (fieldCollations.isEmpty()) {
            Project project;
            assert (!addedFields);
            RelNode top = this.peek();
            if (top instanceof Sort) {
                Sort sort2 = (Sort)top;
                if (sort2.offset == null && sort2.fetch == null) {
                    this.stack.pop();
                    this.push(sort2.getInput());
                    RelNode sort = this.sortFactory.createSort(this.build(), sort2.collation, offsetNode, rexNode);
                    this.push(sort);
                    return this;
                }
            }
            if (top instanceof Project && (project = (Project)top).getInput() instanceof Sort) {
                Sort sort2 = (Sort)project.getInput();
                if (sort2.offset == null && sort2.fetch == null) {
                    this.stack.pop();
                    this.push(sort2.getInput());
                    RelNode sort = this.sortFactory.createSort(this.build(), sort2.collation, offsetNode, rexNode);
                    this.push(sort);
                    this.project(project.getProjects());
                    return this;
                }
            }
        }
        if (addedFields) {
            this.project(extraNodes);
        }
        RelNode sort = this.sortFactory.createSort(this.build(), RelCollations.of(fieldCollations), offsetNode, rexNode);
        this.push(sort);
        if (addedFields) {
            this.project(originalExtraNodes);
        }
        return this;
    }

    private static RelFieldCollation collation(RexNode node, RelFieldCollation.Direction direction, RelFieldCollation.NullDirection nullDirection, List<RexNode> extraNodes) {
        switch (node.getKind()) {
            case INPUT_REF: {
                return new RelFieldCollation(((RexInputRef)node).getIndex(), direction, (RelFieldCollation.NullDirection)Util.first((Object)nullDirection, (Object)direction.defaultNullDirection()));
            }
            case DESCENDING: {
                return HiveSubQRemoveRelBuilder.collation((RexNode)((RexCall)node).getOperands().get(0), RelFieldCollation.Direction.DESCENDING, nullDirection, extraNodes);
            }
            case NULLS_FIRST: {
                return HiveSubQRemoveRelBuilder.collation((RexNode)((RexCall)node).getOperands().get(0), direction, RelFieldCollation.NullDirection.FIRST, extraNodes);
            }
            case NULLS_LAST: {
                return HiveSubQRemoveRelBuilder.collation((RexNode)((RexCall)node).getOperands().get(0), direction, RelFieldCollation.NullDirection.LAST, extraNodes);
            }
        }
        int fieldIndex = extraNodes.size();
        extraNodes.add(node);
        return new RelFieldCollation(fieldIndex, direction, (RelFieldCollation.NullDirection)Util.first((Object)nullDirection, (Object)direction.defaultNullDirection()));
    }

    public HiveSubQRemoveRelBuilder convert(RelDataType castRowType, boolean rename) {
        RelNode r = this.build();
        RelNode r2 = RelOptUtil.createCastRel((RelNode)r, (RelDataType)castRowType, (boolean)rename, (RelFactories.ProjectFactory)this.projectFactory);
        this.push(r2);
        return this;
    }

    public HiveSubQRemoveRelBuilder permute(Mapping mapping) {
        assert (mapping.getMappingType().isSingleSource());
        assert (mapping.getMappingType().isMandatorySource());
        if (mapping.isIdentity()) {
            return this;
        }
        ArrayList<RexInputRef> exprList = Lists.newArrayList();
        for (int i = 0; i < mapping.getTargetCount(); ++i) {
            exprList.add(this.field(mapping.getSource(i)));
        }
        return this.project(exprList);
    }

    public HiveSubQRemoveRelBuilder aggregate(GroupKey groupKey, List<AggregateCall> aggregateCalls) {
        return this.aggregate(groupKey, (Iterable<AggCall>)Lists.transform(aggregateCalls, new Function<AggregateCall, AggCall>(){

            @Override
            public AggCall apply(AggregateCall input) {
                return new AggCallImpl2(input);
            }
        }));
    }

    public void clear() {
        this.stack.clear();
    }

    protected String getAlias() {
        Frame frame = this.stack.peek();
        return frame.right.size() == 1 ? (String)((Pair)frame.right.get((int)0)).left : null;
    }

    private class Shifter
    extends RexShuttle {
        private final RelNode left;
        private final CorrelationId id;
        private final RelNode right;

        Shifter(RelNode left, CorrelationId id, RelNode right) {
            this.left = left;
            this.id = id;
            this.right = right;
        }

        public RexNode visitInputRef(RexInputRef inputRef) {
            RelDataType leftRowType = this.left.getRowType();
            RexBuilder rexBuilder = HiveSubQRemoveRelBuilder.this.getRexBuilder();
            int leftCount = leftRowType.getFieldCount();
            if (inputRef.getIndex() < leftCount) {
                RexNode v = rexBuilder.makeCorrel(leftRowType, this.id);
                return rexBuilder.makeFieldAccess(v, inputRef.getIndex());
            }
            return rexBuilder.makeInputRef(this.right, inputRef.getIndex() - leftCount);
        }
    }

    private static class Frame {
        static final Function<Pair<String, RelDataType>, List<RelDataTypeField>> FN = new Function<Pair<String, RelDataType>, List<RelDataTypeField>>(){

            @Override
            public List<RelDataTypeField> apply(Pair<String, RelDataType> input) {
                return ((RelDataType)input.right).getFieldList();
            }
        };
        final RelNode rel;
        final ImmutableList<Pair<String, RelDataType>> right;

        private Frame(RelNode rel, ImmutableList<Pair<String, RelDataType>> pairs) {
            this.rel = rel;
            this.right = pairs;
        }

        private Frame(RelNode rel) {
            this(rel, ImmutableList.of(Pair.of((Object)Frame.deriveAlias(rel), (Object)rel.getRowType())));
        }

        private static String deriveAlias(RelNode rel) {
            List names;
            if (rel instanceof TableScan && !(names = rel.getTable().getQualifiedName()).isEmpty()) {
                return (String)Util.last((List)names);
            }
            return null;
        }

        List<RelDataTypeField> fields() {
            return CompositeList.ofCopy(Iterables.transform(this.right, FN));
        }
    }

    private static class AggCallImpl2
    implements AggCall {
        private final AggregateCall aggregateCall;

        AggCallImpl2(AggregateCall aggregateCall) {
            this.aggregateCall = Preconditions.checkNotNull(aggregateCall);
        }
    }

    private static class AggCallImpl
    implements AggCall {
        private final SqlAggFunction aggFunction;
        private final boolean distinct;
        private final RexNode filter;
        private final String alias;
        private final ImmutableList<RexNode> operands;

        AggCallImpl(SqlAggFunction aggFunction, boolean distinct, RexNode filter, String alias, ImmutableList<RexNode> operands) {
            this.aggFunction = aggFunction;
            this.distinct = distinct;
            this.filter = filter;
            this.alias = alias;
            this.operands = operands;
        }
    }

    protected static class GroupKeyImpl
    implements GroupKey {
        final ImmutableList<RexNode> nodes;
        final boolean indicator;
        final ImmutableList<ImmutableList<RexNode>> nodeLists;
        final String alias;

        GroupKeyImpl(ImmutableList<RexNode> nodes, boolean indicator, ImmutableList<ImmutableList<RexNode>> nodeLists, String alias) {
            this.nodes = Preconditions.checkNotNull(nodes);
            this.indicator = indicator;
            this.nodeLists = nodeLists;
            this.alias = alias;
        }

        public String toString() {
            return this.alias == null ? this.nodes.toString() : this.nodes + " as " + this.alias;
        }

        @Override
        public GroupKey alias(String alias) {
            return Objects.equals(this.alias, alias) ? this : new GroupKeyImpl(this.nodes, this.indicator, this.nodeLists, alias);
        }
    }

    public static interface GroupKey {
        public GroupKey alias(String var1);
    }

    public static interface AggCall {
    }
}

