/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.Stack;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.optimizer.spark.SparkPartitionPruningSinkDesc;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.spark.OptimizeSparkProcContext;
import org.apache.hadoop.hive.ql.parse.spark.SparkPartitionPruningSinkOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkRemoveDynamicPruningBySize
implements NodeProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(SparkRemoveDynamicPruningBySize.class.getName());

    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procContext, Object ... nodeOutputs) throws SemanticException {
        OptimizeSparkProcContext context = (OptimizeSparkProcContext)procContext;
        SparkPartitionPruningSinkOperator op = (SparkPartitionPruningSinkOperator)nd;
        SparkPartitionPruningSinkDesc desc = (SparkPartitionPruningSinkDesc)op.getConf();
        if (desc.getStatistics().getDataSize() > context.getConf().getLongVar(HiveConf.ConfVars.SPARK_DYNAMIC_PARTITION_PRUNING_MAX_DATA_SIZE)) {
            OperatorUtils.removeBranch(op);
            LOG.info("Disabling dynamic pruning for: " + desc.getTableScan().getName() + ". Expected data size is too big: " + desc.getStatistics().getDataSize());
        }
        return false;
    }
}

