/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata.formatting;

import hive.org.apache.commons.lang.StringEscapeUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData;
import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.Date;
import org.apache.hadoop.hive.metastore.api.DateColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Decimal;
import org.apache.hadoop.hive.metastore.api.DecimalColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.apache.hadoop.hive.ql.index.HiveIndex;
import org.apache.hadoop.hive.ql.metadata.ForeignKeyInfo;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.PrimaryKeyInfo;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.metadata.formatting.JsonMetaDataFormatter;
import org.apache.hadoop.hive.ql.metadata.formatting.MetaDataFormatter;
import org.apache.hadoop.hive.ql.metadata.formatting.TextMetaDataFormatter;
import org.apache.hadoop.hive.ql.plan.DescTableDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ShowIndexesDesc;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hive.common.util.HiveStringUtils;

public final class MetaDataFormatUtils {
    public static final String FIELD_DELIM = "\t";
    public static final String LINE_DELIM = "\n";
    static final int DEFAULT_STRINGBUILDER_SIZE = 2048;
    private static final int ALIGNMENT = 20;

    private MetaDataFormatUtils() {
    }

    private static void formatColumnsHeader(StringBuilder columnInformation, List<ColumnStatisticsObj> colStats) {
        columnInformation.append("# ");
        MetaDataFormatUtils.formatOutput(MetaDataFormatUtils.getColumnsHeader(colStats), columnInformation);
        columnInformation.append(LINE_DELIM);
    }

    public static String getAllColumnsInformation(List<FieldSchema> cols, boolean printHeader, boolean isOutputPadded, List<ColumnStatisticsObj> colStats) {
        StringBuilder columnInformation = new StringBuilder(2048);
        if (printHeader) {
            MetaDataFormatUtils.formatColumnsHeader(columnInformation, colStats);
        }
        MetaDataFormatUtils.formatAllFields(columnInformation, cols, isOutputPadded, colStats);
        return columnInformation.toString();
    }

    public static String getAllColumnsInformation(List<FieldSchema> cols, List<FieldSchema> partCols, boolean printHeader, boolean isOutputPadded, boolean showPartColsSep) {
        StringBuilder columnInformation = new StringBuilder(2048);
        if (printHeader) {
            MetaDataFormatUtils.formatColumnsHeader(columnInformation, null);
        }
        MetaDataFormatUtils.formatAllFields(columnInformation, cols, isOutputPadded, null);
        if (partCols != null && !partCols.isEmpty() && showPartColsSep) {
            columnInformation.append(LINE_DELIM).append("# Partition Information").append(LINE_DELIM);
            MetaDataFormatUtils.formatColumnsHeader(columnInformation, null);
            MetaDataFormatUtils.formatAllFields(columnInformation, partCols, isOutputPadded, null);
        }
        return columnInformation.toString();
    }

    private static void formatAllFields(StringBuilder tableInfo, List<FieldSchema> cols, boolean isOutputPadded, List<ColumnStatisticsObj> colStats) {
        for (FieldSchema col : cols) {
            if (isOutputPadded) {
                MetaDataFormatUtils.formatWithIndentation(col.getName(), col.getType(), MetaDataFormatUtils.getComment(col), tableInfo, colStats);
                continue;
            }
            MetaDataFormatUtils.formatWithoutIndentation(col.getName(), col.getType(), col.getComment(), tableInfo, colStats);
        }
    }

    private static String convertToString(Decimal val) {
        if (val == null) {
            return "";
        }
        HiveDecimal result = HiveDecimal.create(new BigInteger(val.getUnscaled()), (int)val.getScale());
        if (result != null) {
            return result.toString();
        }
        return "";
    }

    private static String convertToString(Date val) {
        if (val == null) {
            return "";
        }
        DateWritable writableValue = new DateWritable((int)val.getDaysSinceEpoch());
        return writableValue.toString();
    }

    private static ColumnStatisticsObj getColumnStatisticsObject(String colName, String colType, List<ColumnStatisticsObj> colStats) {
        if (colStats != null && !colStats.isEmpty()) {
            for (ColumnStatisticsObj cso : colStats) {
                if (!cso.getColName().equalsIgnoreCase(colName) || !cso.getColType().equalsIgnoreCase(colType)) continue;
                return cso;
            }
        }
        return null;
    }

    private static void formatWithoutIndentation(String name, String type, String comment, StringBuilder colBuffer, List<ColumnStatisticsObj> colStats) {
        colBuffer.append(name);
        colBuffer.append(FIELD_DELIM);
        colBuffer.append(type);
        colBuffer.append(FIELD_DELIM);
        if (colStats != null) {
            ColumnStatisticsObj cso = MetaDataFormatUtils.getColumnStatisticsObject(name, type, colStats);
            if (cso != null) {
                ColumnStatisticsData csd = cso.getStatsData();
                if (csd.isSetBinaryStats()) {
                    BinaryColumnStatsData bcsd = csd.getBinaryStats();
                    MetaDataFormatUtils.appendColumnStatsNoFormatting(colBuffer, "", "", bcsd.getNumNulls(), "", bcsd.getAvgColLen(), bcsd.getMaxColLen(), "", "");
                } else if (csd.isSetStringStats()) {
                    StringColumnStatsData scsd = csd.getStringStats();
                    MetaDataFormatUtils.appendColumnStatsNoFormatting(colBuffer, "", "", scsd.getNumNulls(), scsd.getNumDVs(), scsd.getAvgColLen(), scsd.getMaxColLen(), "", "");
                } else if (csd.isSetBooleanStats()) {
                    BooleanColumnStatsData bcsd = csd.getBooleanStats();
                    MetaDataFormatUtils.appendColumnStatsNoFormatting(colBuffer, "", "", bcsd.getNumNulls(), "", "", "", bcsd.getNumTrues(), bcsd.getNumFalses());
                } else if (csd.isSetDecimalStats()) {
                    DecimalColumnStatsData dcsd = csd.getDecimalStats();
                    MetaDataFormatUtils.appendColumnStatsNoFormatting(colBuffer, MetaDataFormatUtils.convertToString(dcsd.getLowValue()), MetaDataFormatUtils.convertToString(dcsd.getHighValue()), dcsd.getNumNulls(), dcsd.getNumDVs(), "", "", "", "");
                } else if (csd.isSetDoubleStats()) {
                    DoubleColumnStatsData dcsd = csd.getDoubleStats();
                    MetaDataFormatUtils.appendColumnStatsNoFormatting(colBuffer, dcsd.getLowValue(), dcsd.getHighValue(), dcsd.getNumNulls(), dcsd.getNumDVs(), "", "", "", "");
                } else if (csd.isSetLongStats()) {
                    LongColumnStatsData lcsd = csd.getLongStats();
                    MetaDataFormatUtils.appendColumnStatsNoFormatting(colBuffer, lcsd.getLowValue(), lcsd.getHighValue(), lcsd.getNumNulls(), lcsd.getNumDVs(), "", "", "", "");
                } else if (csd.isSetDateStats()) {
                    DateColumnStatsData dcsd = csd.getDateStats();
                    MetaDataFormatUtils.appendColumnStatsNoFormatting(colBuffer, MetaDataFormatUtils.convertToString(dcsd.getLowValue()), MetaDataFormatUtils.convertToString(dcsd.getHighValue()), dcsd.getNumNulls(), dcsd.getNumDVs(), "", "", "", "");
                }
            } else {
                MetaDataFormatUtils.appendColumnStatsNoFormatting(colBuffer, "", "", "", "", "", "", "", "");
            }
        }
        colBuffer.append(comment == null ? "" : HiveStringUtils.escapeJava(comment));
        colBuffer.append(LINE_DELIM);
    }

    public static String getIndexInformation(Index index, boolean isOutputPadded) {
        StringBuilder indexInfo = new StringBuilder(2048);
        ArrayList<String> indexColumns = new ArrayList<String>();
        indexColumns.add(index.getIndexName());
        indexColumns.add(index.getOrigTableName());
        List<FieldSchema> indexKeys = index.getSd().getCols();
        StringBuilder keyString = new StringBuilder();
        boolean first = true;
        for (FieldSchema key : indexKeys) {
            if (!first) {
                keyString.append(", ");
            }
            keyString.append(key.getName());
            first = false;
        }
        indexColumns.add(keyString.toString());
        indexColumns.add(index.getIndexTableName());
        String indexHandlerClass = index.getIndexHandlerClass();
        HiveIndex.IndexType indexType = HiveIndex.getIndexTypeByClassName(indexHandlerClass);
        indexColumns.add(indexType.getName());
        String comment = index.getParameters().get("comment");
        indexColumns.add(comment == null ? null : HiveStringUtils.escapeJava(comment));
        MetaDataFormatUtils.formatOutput(indexColumns.toArray(new String[0]), indexInfo, isOutputPadded);
        return indexInfo.toString();
    }

    public static String getConstraintsInformation(PrimaryKeyInfo pkInfo, ForeignKeyInfo fkInfo) {
        StringBuilder constraintsInfo = new StringBuilder(2048);
        constraintsInfo.append(LINE_DELIM).append("# Constraints").append(LINE_DELIM);
        if (pkInfo != null && !pkInfo.getColNames().isEmpty()) {
            constraintsInfo.append(LINE_DELIM).append("# Primary Key").append(LINE_DELIM);
            MetaDataFormatUtils.getPrimaryKeyInformation(constraintsInfo, pkInfo);
        }
        if (fkInfo != null && !fkInfo.getForeignKeys().isEmpty()) {
            constraintsInfo.append(LINE_DELIM).append("# Foreign Keys").append(LINE_DELIM);
            MetaDataFormatUtils.getForeignKeysInformation(constraintsInfo, fkInfo);
        }
        return constraintsInfo.toString();
    }

    private static void getPrimaryKeyInformation(StringBuilder constraintsInfo, PrimaryKeyInfo pkInfo) {
        MetaDataFormatUtils.formatOutput("Table:", pkInfo.getDatabaseName() + "." + pkInfo.getTableName(), constraintsInfo);
        MetaDataFormatUtils.formatOutput("Constraint Name:", pkInfo.getConstraintName(), constraintsInfo);
        Map<Integer, String> colNames = pkInfo.getColNames();
        String columnNames = "Column Names:";
        constraintsInfo.append(String.format("%-20s", "Column Names:")).append(FIELD_DELIM);
        if (colNames != null && colNames.size() > 0) {
            MetaDataFormatUtils.formatOutput(colNames.values().toArray(new String[colNames.size()]), constraintsInfo);
        }
    }

    private static void getForeignKeyColInformation(StringBuilder constraintsInfo, ForeignKeyInfo.ForeignKeyCol fkCol) {
        String[] fkcFields = new String[]{"Parent Column Name:" + fkCol.parentDatabaseName + "." + fkCol.parentTableName + "." + fkCol.parentColName, "Column Name:" + fkCol.childColName, "Key Sequence:" + fkCol.position};
        MetaDataFormatUtils.formatOutput(fkcFields, constraintsInfo);
    }

    private static void getForeignKeyRelInformation(StringBuilder constraintsInfo, String constraintName, List<ForeignKeyInfo.ForeignKeyCol> fkRel) {
        MetaDataFormatUtils.formatOutput("Constraint Name:", constraintName, constraintsInfo);
        if (fkRel != null && fkRel.size() > 0) {
            for (ForeignKeyInfo.ForeignKeyCol fkc : fkRel) {
                MetaDataFormatUtils.getForeignKeyColInformation(constraintsInfo, fkc);
            }
        }
        constraintsInfo.append(LINE_DELIM);
    }

    private static void getForeignKeysInformation(StringBuilder constraintsInfo, ForeignKeyInfo fkInfo) {
        MetaDataFormatUtils.formatOutput("Table:", fkInfo.getChildDatabaseName() + "." + fkInfo.getChildTableName(), constraintsInfo);
        Map<String, List<ForeignKeyInfo.ForeignKeyCol>> foreignKeys = fkInfo.getForeignKeys();
        if (foreignKeys != null && foreignKeys.size() > 0) {
            for (Map.Entry<String, List<ForeignKeyInfo.ForeignKeyCol>> me : foreignKeys.entrySet()) {
                MetaDataFormatUtils.getForeignKeyRelInformation(constraintsInfo, me.getKey(), me.getValue());
            }
        }
    }

    public static String getPartitionInformation(Partition part) {
        StringBuilder tableInfo = new StringBuilder(2048);
        tableInfo.append(LINE_DELIM).append("# Detailed Partition Information").append(LINE_DELIM);
        MetaDataFormatUtils.getPartitionMetaDataInformation(tableInfo, part);
        if (part.getTable().getTableType() != TableType.VIRTUAL_VIEW) {
            tableInfo.append(LINE_DELIM).append("# Storage Information").append(LINE_DELIM);
            MetaDataFormatUtils.getStorageDescriptorInfo(tableInfo, part.getTPartition().getSd());
        }
        return tableInfo.toString();
    }

    public static String getTableInformation(Table table, boolean isOutputPadded) {
        StringBuilder tableInfo = new StringBuilder(2048);
        tableInfo.append(LINE_DELIM).append("# Detailed Table Information").append(LINE_DELIM);
        MetaDataFormatUtils.getTableMetaDataInformation(tableInfo, table, isOutputPadded);
        tableInfo.append(LINE_DELIM).append("# Storage Information").append(LINE_DELIM);
        MetaDataFormatUtils.getStorageDescriptorInfo(tableInfo, table.getTTable().getSd());
        if (table.isView() || table.isMaterializedView()) {
            tableInfo.append(LINE_DELIM).append("# View Information").append(LINE_DELIM);
            MetaDataFormatUtils.getViewInfo(tableInfo, table);
        }
        return tableInfo.toString();
    }

    private static void getViewInfo(StringBuilder tableInfo, Table tbl) {
        MetaDataFormatUtils.formatOutput("View Original Text:", tbl.getViewOriginalText(), tableInfo);
        MetaDataFormatUtils.formatOutput("View Expanded Text:", tbl.getViewExpandedText(), tableInfo);
        MetaDataFormatUtils.formatOutput("View Rewrite Enabled:", tbl.isRewriteEnabled() ? "Yes" : "No", tableInfo);
    }

    private static void getStorageDescriptorInfo(StringBuilder tableInfo, StorageDescriptor storageDesc) {
        MetaDataFormatUtils.formatOutput("SerDe Library:", storageDesc.getSerdeInfo().getSerializationLib(), tableInfo);
        MetaDataFormatUtils.formatOutput("InputFormat:", storageDesc.getInputFormat(), tableInfo);
        MetaDataFormatUtils.formatOutput("OutputFormat:", storageDesc.getOutputFormat(), tableInfo);
        MetaDataFormatUtils.formatOutput("Compressed:", storageDesc.isCompressed() ? "Yes" : "No", tableInfo);
        MetaDataFormatUtils.formatOutput("Num Buckets:", String.valueOf(storageDesc.getNumBuckets()), tableInfo);
        MetaDataFormatUtils.formatOutput("Bucket Columns:", storageDesc.getBucketCols().toString(), tableInfo);
        MetaDataFormatUtils.formatOutput("Sort Columns:", storageDesc.getSortCols().toString(), tableInfo);
        if (storageDesc.isStoredAsSubDirectories()) {
            MetaDataFormatUtils.formatOutput("Stored As SubDirectories:", "Yes", tableInfo);
        }
        if (null != storageDesc.getSkewedInfo()) {
            List<List<String>> skewedColValues;
            List<String> skewedColNames = MetaDataFormatUtils.sortedList(storageDesc.getSkewedInfo().getSkewedColNames());
            if (skewedColNames != null && skewedColNames.size() > 0) {
                MetaDataFormatUtils.formatOutput("Skewed Columns:", skewedColNames.toString(), tableInfo);
            }
            if ((skewedColValues = MetaDataFormatUtils.sortedList(storageDesc.getSkewedInfo().getSkewedColValues(), new VectorComparator())) != null && skewedColValues.size() > 0) {
                MetaDataFormatUtils.formatOutput("Skewed Values:", skewedColValues.toString(), tableInfo);
            }
            TreeMap skewedColMap = new TreeMap(new VectorComparator());
            skewedColMap.putAll(storageDesc.getSkewedInfo().getSkewedColValueLocationMaps());
            if (skewedColMap != null && skewedColMap.size() > 0) {
                MetaDataFormatUtils.formatOutput("Skewed Value to Path:", ((Object)skewedColMap).toString(), tableInfo);
                TreeMap truncatedSkewedColMap = new TreeMap(new VectorComparator());
                Set entries = skewedColMap.entrySet();
                for (Map.Entry entry : entries) {
                    truncatedSkewedColMap.put(entry.getKey(), PlanUtils.removePrefixFromWarehouseConfig((String)entry.getValue()));
                }
                MetaDataFormatUtils.formatOutput("Skewed Value to Truncated Path:", ((Object)truncatedSkewedColMap).toString(), tableInfo);
            }
        }
        if (storageDesc.getSerdeInfo().getParametersSize() > 0) {
            tableInfo.append("Storage Desc Params:").append(LINE_DELIM);
            MetaDataFormatUtils.displayAllParameters(storageDesc.getSerdeInfo().getParameters(), tableInfo);
        }
    }

    private static void getTableMetaDataInformation(StringBuilder tableInfo, Table tbl, boolean isOutputPadded) {
        MetaDataFormatUtils.formatOutput("Database:", tbl.getDbName(), tableInfo);
        MetaDataFormatUtils.formatOutput("Owner:", tbl.getOwner(), tableInfo);
        MetaDataFormatUtils.formatOutput("CreateTime:", MetaDataFormatUtils.formatDate(tbl.getTTable().getCreateTime()), tableInfo);
        MetaDataFormatUtils.formatOutput("LastAccessTime:", MetaDataFormatUtils.formatDate(tbl.getTTable().getLastAccessTime()), tableInfo);
        MetaDataFormatUtils.formatOutput("Retention:", Integer.toString(tbl.getRetention()), tableInfo);
        if (!tbl.isView()) {
            MetaDataFormatUtils.formatOutput("Location:", tbl.getDataLocation().toString(), tableInfo);
        }
        MetaDataFormatUtils.formatOutput("Table Type:", tbl.getTableType().name(), tableInfo);
        if (tbl.getParameters().size() > 0) {
            tableInfo.append("Table Parameters:").append(LINE_DELIM);
            MetaDataFormatUtils.displayAllParameters(tbl.getParameters(), tableInfo, false, isOutputPadded);
        }
    }

    private static void getPartitionMetaDataInformation(StringBuilder tableInfo, Partition part) {
        MetaDataFormatUtils.formatOutput("Partition Value:", part.getValues().toString(), tableInfo);
        MetaDataFormatUtils.formatOutput("Database:", part.getTPartition().getDbName(), tableInfo);
        MetaDataFormatUtils.formatOutput("Table:", part.getTable().getTableName(), tableInfo);
        MetaDataFormatUtils.formatOutput("CreateTime:", MetaDataFormatUtils.formatDate(part.getTPartition().getCreateTime()), tableInfo);
        MetaDataFormatUtils.formatOutput("LastAccessTime:", MetaDataFormatUtils.formatDate(part.getTPartition().getLastAccessTime()), tableInfo);
        MetaDataFormatUtils.formatOutput("Location:", part.getLocation(), tableInfo);
        if (part.getTPartition().getParameters().size() > 0) {
            tableInfo.append("Partition Parameters:").append(LINE_DELIM);
            MetaDataFormatUtils.displayAllParameters(part.getTPartition().getParameters(), tableInfo);
        }
    }

    private static void displayAllParameters(Map<String, String> params, StringBuilder tableInfo) {
        MetaDataFormatUtils.displayAllParameters(params, tableInfo, true, false);
    }

    private static void displayAllParameters(Map<String, String> params, StringBuilder tableInfo, boolean escapeUnicode, boolean isOutputPadded) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            tableInfo.append(FIELD_DELIM);
            MetaDataFormatUtils.formatOutput(key, escapeUnicode ? StringEscapeUtils.escapeJava(params.get(key)) : HiveStringUtils.escapeJava(params.get(key)), tableInfo, isOutputPadded);
        }
    }

    static String getComment(FieldSchema col) {
        return col.getComment() != null ? col.getComment() : "";
    }

    static <T extends Comparable<T>> List<T> sortedList(List<T> list) {
        if (list == null || list.size() <= 1) {
            return list;
        }
        ArrayList<T> ret = new ArrayList<T>();
        ret.addAll(list);
        Collections.sort(ret);
        return ret;
    }

    static <T> List<T> sortedList(List<T> list, Comparator<T> comp) {
        if (list == null || list.size() <= 1) {
            return list;
        }
        ArrayList<T> ret = new ArrayList<T>();
        ret.addAll(list);
        Collections.sort(ret, comp);
        return ret;
    }

    private static String formatDate(long timeInSeconds) {
        if (timeInSeconds != 0L) {
            java.util.Date date = new java.util.Date(timeInSeconds * 1000L);
            return date.toString();
        }
        return "UNKNOWN";
    }

    private static void formatOutput(String[] fields, StringBuilder tableInfo, boolean isLastLinePadded) {
        int[] paddings = new int[fields.length - 1];
        if (fields.length > 1) {
            for (int i = 0; i < fields.length - 1; ++i) {
                if (fields[i] == null) {
                    tableInfo.append(FIELD_DELIM);
                    continue;
                }
                tableInfo.append(String.format("%-20s", fields[i])).append(FIELD_DELIM);
                paddings[i] = 20 > fields[i].length() ? 20 : fields[i].length();
            }
        }
        if (fields.length > 0) {
            String value = fields[fields.length - 1];
            String unescapedValue = isLastLinePadded && value != null ? value.replaceAll("\\\\n|\\\\r|\\\\r\\\\n", LINE_DELIM) : value;
            MetaDataFormatUtils.indentMultilineValue(unescapedValue, tableInfo, paddings, false);
        } else {
            tableInfo.append(LINE_DELIM);
        }
    }

    private static void formatOutput(String[] fields, StringBuilder tableInfo) {
        MetaDataFormatUtils.formatOutput(fields, tableInfo, false);
    }

    private static void formatOutput(String name, String value, StringBuilder tableInfo) {
        tableInfo.append(String.format("%-20s", name)).append(FIELD_DELIM);
        int colNameLength = 20 > name.length() ? 20 : name.length();
        MetaDataFormatUtils.indentMultilineValue(value, tableInfo, new int[]{0, colNameLength}, true);
    }

    protected static void formatOutput(String name, String value, StringBuilder tableInfo, boolean isOutputPadded) {
        String unescapedValue = isOutputPadded && value != null ? value.replaceAll("\\\\n|\\\\r|\\\\r\\\\n", LINE_DELIM) : value;
        MetaDataFormatUtils.formatOutput(name, unescapedValue, tableInfo);
    }

    private static void formatWithIndentation(String colName, String colType, String colComment, StringBuilder tableInfo, List<ColumnStatisticsObj> colStats) {
        tableInfo.append(String.format("%-20s", colName)).append(FIELD_DELIM);
        tableInfo.append(String.format("%-20s", colType)).append(FIELD_DELIM);
        if (colStats != null) {
            ColumnStatisticsObj cso = MetaDataFormatUtils.getColumnStatisticsObject(colName, colType, colStats);
            if (cso != null) {
                ColumnStatisticsData csd = cso.getStatsData();
                if (csd.isSetBinaryStats()) {
                    BinaryColumnStatsData bcsd = csd.getBinaryStats();
                    MetaDataFormatUtils.appendColumnStats(tableInfo, "", "", bcsd.getNumNulls(), "", bcsd.getAvgColLen(), bcsd.getMaxColLen(), "", "");
                } else if (csd.isSetStringStats()) {
                    StringColumnStatsData scsd = csd.getStringStats();
                    MetaDataFormatUtils.appendColumnStats(tableInfo, "", "", scsd.getNumNulls(), scsd.getNumDVs(), scsd.getAvgColLen(), scsd.getMaxColLen(), "", "");
                } else if (csd.isSetBooleanStats()) {
                    BooleanColumnStatsData bcsd = csd.getBooleanStats();
                    MetaDataFormatUtils.appendColumnStats(tableInfo, "", "", bcsd.getNumNulls(), "", "", "", bcsd.getNumTrues(), bcsd.getNumFalses());
                } else if (csd.isSetDecimalStats()) {
                    DecimalColumnStatsData dcsd = csd.getDecimalStats();
                    MetaDataFormatUtils.appendColumnStats(tableInfo, MetaDataFormatUtils.convertToString(dcsd.getLowValue()), MetaDataFormatUtils.convertToString(dcsd.getHighValue()), dcsd.getNumNulls(), dcsd.getNumDVs(), "", "", "", "");
                } else if (csd.isSetDoubleStats()) {
                    DoubleColumnStatsData dcsd = csd.getDoubleStats();
                    MetaDataFormatUtils.appendColumnStats(tableInfo, dcsd.getLowValue(), dcsd.getHighValue(), dcsd.getNumNulls(), dcsd.getNumDVs(), "", "", "", "");
                } else if (csd.isSetLongStats()) {
                    LongColumnStatsData lcsd = csd.getLongStats();
                    MetaDataFormatUtils.appendColumnStats(tableInfo, lcsd.getLowValue(), lcsd.getHighValue(), lcsd.getNumNulls(), lcsd.getNumDVs(), "", "", "", "");
                } else if (csd.isSetDateStats()) {
                    DateColumnStatsData dcsd = csd.getDateStats();
                    MetaDataFormatUtils.appendColumnStats(tableInfo, MetaDataFormatUtils.convertToString(dcsd.getLowValue()), MetaDataFormatUtils.convertToString(dcsd.getHighValue()), dcsd.getNumNulls(), dcsd.getNumDVs(), "", "", "", "");
                }
            } else {
                MetaDataFormatUtils.appendColumnStats(tableInfo, "", "", "", "", "", "", "", "");
            }
        }
        int colNameLength = 20 > colName.length() ? 20 : colName.length();
        int colTypeLength = 20 > colType.length() ? 20 : colType.length();
        MetaDataFormatUtils.indentMultilineValue(colComment, tableInfo, new int[]{colNameLength, colTypeLength}, false);
    }

    private static void indentMultilineValue(String value, StringBuilder tableInfo, int[] columnWidths, boolean printNull) {
        if (value == null) {
            if (printNull) {
                tableInfo.append(String.format("%-20s", value));
            }
            tableInfo.append(LINE_DELIM);
        } else {
            String[] valueSegments = value.split("\n|\r|\r\n");
            tableInfo.append(String.format("%-20s", valueSegments[0])).append(LINE_DELIM);
            for (int i = 1; i < valueSegments.length; ++i) {
                MetaDataFormatUtils.printPadding(tableInfo, columnWidths);
                tableInfo.append(String.format("%-20s", valueSegments[i])).append(LINE_DELIM);
            }
        }
    }

    private static void printPadding(StringBuilder tableInfo, int[] columnWidths) {
        for (int columnWidth : columnWidths) {
            if (columnWidth == 0) {
                tableInfo.append(FIELD_DELIM);
                continue;
            }
            tableInfo.append(String.format("%" + columnWidth + "s" + FIELD_DELIM, ""));
        }
    }

    private static void appendColumnStats(StringBuilder sb, Object min, Object max, Object numNulls, Object ndv, Object avgColLen, Object maxColLen, Object numTrues, Object numFalses) {
        sb.append(String.format("%-20s", min)).append(FIELD_DELIM);
        sb.append(String.format("%-20s", max)).append(FIELD_DELIM);
        sb.append(String.format("%-20s", numNulls)).append(FIELD_DELIM);
        sb.append(String.format("%-20s", ndv)).append(FIELD_DELIM);
        sb.append(String.format("%-20s", avgColLen)).append(FIELD_DELIM);
        sb.append(String.format("%-20s", maxColLen)).append(FIELD_DELIM);
        sb.append(String.format("%-20s", numTrues)).append(FIELD_DELIM);
        sb.append(String.format("%-20s", numFalses)).append(FIELD_DELIM);
    }

    private static void appendColumnStatsNoFormatting(StringBuilder sb, Object min, Object max, Object numNulls, Object ndv, Object avgColLen, Object maxColLen, Object numTrues, Object numFalses) {
        sb.append(min).append(FIELD_DELIM);
        sb.append(max).append(FIELD_DELIM);
        sb.append(numNulls).append(FIELD_DELIM);
        sb.append(ndv).append(FIELD_DELIM);
        sb.append(avgColLen).append(FIELD_DELIM);
        sb.append(maxColLen).append(FIELD_DELIM);
        sb.append(numTrues).append(FIELD_DELIM);
        sb.append(numFalses).append(FIELD_DELIM);
    }

    public static String[] getColumnsHeader(List<ColumnStatisticsObj> colStats) {
        boolean showColStats = false;
        if (colStats != null) {
            showColStats = true;
        }
        return DescTableDesc.getSchema(showColStats).split("#")[0].split(",");
    }

    public static String getIndexColumnsHeader() {
        StringBuilder indexCols = new StringBuilder(2048);
        MetaDataFormatUtils.formatOutput(ShowIndexesDesc.getSchema().split("#")[0].split(","), indexCols);
        return indexCols.toString();
    }

    public static MetaDataFormatter getFormatter(HiveConf conf) {
        if ("json".equals(conf.get(HiveConf.ConfVars.HIVE_DDL_OUTPUT_FORMAT.varname, "text"))) {
            return new JsonMetaDataFormatter();
        }
        return new TextMetaDataFormatter(conf.getIntVar(HiveConf.ConfVars.CLIPRETTYOUTPUTNUMCOLS), conf.getBoolVar(HiveConf.ConfVars.HIVE_DISPLAY_PARTITION_COLUMNS_SEPARATELY));
    }

    private static class VectorComparator<T extends Comparable<T>>
    implements Comparator<List<T>> {
        private VectorComparator() {
        }

        @Override
        public int compare(List<T> listA, List<T> listB) {
            for (int i = 0; i < listA.size() && i < listB.size(); ++i) {
                Comparable valA = (Comparable)listA.get(i);
                Comparable valB = (Comparable)listB.get(i);
                if (valA != null) {
                    int ret = valA.compareTo(valB);
                    if (ret == 0) continue;
                    return ret;
                }
                if (valB == null) continue;
                return -1;
            }
            return Integer.compare(listA.size(), listB.size());
        }
    }
}

