/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.timestamp;

import hive.org.apache.parquet.Preconditions;
import hive.org.apache.parquet.io.api.Binary;
import hive.org.apache.parquet.io.api.RecordConsumer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class NanoTime {
    private final int julianDay;
    private final long timeOfDayNanos;

    public static NanoTime fromBinary(Binary bytes) {
        Preconditions.checkArgument(bytes.length() == 12, "Must be 12 bytes");
        ByteBuffer buf = bytes.toByteBuffer();
        buf.order(ByteOrder.LITTLE_ENDIAN);
        long timeOfDayNanos = buf.getLong();
        int julianDay = buf.getInt();
        return new NanoTime(julianDay, timeOfDayNanos);
    }

    public NanoTime(int julianDay, long timeOfDayNanos) {
        this.julianDay = julianDay;
        this.timeOfDayNanos = timeOfDayNanos;
    }

    public int getJulianDay() {
        return this.julianDay;
    }

    public long getTimeOfDayNanos() {
        return this.timeOfDayNanos;
    }

    public Binary toBinary() {
        ByteBuffer buf = ByteBuffer.allocate(12);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putLong(this.timeOfDayNanos);
        buf.putInt(this.julianDay);
        buf.flip();
        return Binary.fromByteBuffer(buf);
    }

    public void writeValue(RecordConsumer recordConsumer) {
        recordConsumer.addBinary(this.toBinary());
    }

    public String toString() {
        return "NanoTime{julianDay=" + this.julianDay + ", timeOfDayNanos=" + this.timeOfDayNanos + "}";
    }
}

