/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.io.TableUtils;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapRDbJsonUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MapRDbJsonUtils.class.getName());
    private static final String MAPR_DB_JSON_STORAGE_HANDLER = "org.apache.hadoop.hive.maprdb.json.MapRDBJsonStorageHandler";
    private static final String MAPR_DB_JSON_INPUT_FORMAT = "org.apache.hadoop.hive.maprdb.json.input.HiveMapRDBJsonInputFormat";
    private static final String MAPR_DB_JSON_OUTPUT_FORMAT = "org.apache.hadoop.hive.maprdb.json.output.HiveMapRDBJsonOutputFormat";

    private MapRDbJsonUtils() {
    }

    public static boolean isMapRDbJsonTable(ASTNode tree, HiveConf conf) throws SemanticException {
        return MapRDbJsonUtils.isMapRDbJsonTable(TableUtils.findTable(tree, conf));
    }

    public static boolean isMapRDbJsonTable(Table table) {
        HiveStorageHandler hiveStorageHandler = table.getStorageHandler();
        return hiveStorageHandler != null && MAPR_DB_JSON_STORAGE_HANDLER.equals(hiveStorageHandler.getClass().getCanonicalName());
    }

    public static boolean isMapRDbJsonTable(TableDesc table_desc) {
        String inputFileFormatClassName = table_desc.getInputFileFormatClassName();
        String outputFileFormatClassName = table_desc.getOutputFileFormatClassName();
        LOG.debug(String.format("Input File Format class name is %s", inputFileFormatClassName));
        LOG.debug(String.format("Output File Format class name is %s", outputFileFormatClassName));
        return MAPR_DB_JSON_INPUT_FORMAT.equals(inputFileFormatClassName) && MAPR_DB_JSON_OUTPUT_FORMAT.equals(outputFileFormatClassName);
    }

    public static String getMapRDbTableName(Table table) {
        return table.getParameters().get("maprdb.table.name");
    }

    public static enum Operation {
        UNKNOWN,
        INSERT,
        UPDATE,
        DELETE;

    }
}

