/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.tez.monitoring;

import hive.org.apache.commons.lang3.exception.ExceptionUtils;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.common.log.InPlaceUpdate;
import org.apache.hadoop.hive.common.log.ProgressMonitor;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.tez.TezSessionPoolManager;
import org.apache.hadoop.hive.ql.exec.tez.monitoring.DAGSummary;
import org.apache.hadoop.hive.ql.exec.tez.monitoring.FSCountersSummary;
import org.apache.hadoop.hive.ql.exec.tez.monitoring.LLAPioSummary;
import org.apache.hadoop.hive.ql.exec.tez.monitoring.QueryExecutionBreakdownSummary;
import org.apache.hadoop.hive.ql.exec.tez.monitoring.RenderStrategy;
import org.apache.hadoop.hive.ql.exec.tez.monitoring.TezProgressMonitor;
import org.apache.hadoop.hive.ql.log.PerfLogger;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hive.com.google.common.base.Preconditions;
import org.apache.hive.common.util.ShutdownHookManager;
import org.apache.tez.common.counters.CounterGroup;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.TezException;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.dag.api.client.Progress;

public class TezJobMonitor {
    static final String CLASS_NAME = TezJobMonitor.class.getName();
    private static final int CHECK_INTERVAL = 200;
    private static final int MAX_RETRY_INTERVAL = 2500;
    private final PerfLogger perfLogger = SessionState.getPerfLogger();
    private static final List<DAGClient> shutdownList = new LinkedList<DAGClient>();
    private final Map<String, BaseWork> workMap;
    transient SessionState.LogHelper console;
    private StringWriter diagnostics = new StringWriter();
    private final DAGClient dagClient;
    private final HiveConf hiveConf;
    private final DAG dag;
    private final Context context;
    private long executionStartTime = 0L;
    private final RenderStrategy.UpdateFunction updateFunction;

    public static void initShutdownHook() {
        Preconditions.checkNotNull(shutdownList, "Shutdown hook was not properly initialized");
    }

    public TezJobMonitor(Map<String, BaseWork> workMap, DAGClient dagClient, HiveConf conf, DAG dag, Context ctx) {
        this.workMap = workMap;
        this.dagClient = dagClient;
        this.hiveConf = conf;
        this.dag = dag;
        this.context = ctx;
        this.console = SessionState.getConsole();
        this.updateFunction = this.updateFunction();
    }

    private RenderStrategy.UpdateFunction updateFunction() {
        return InPlaceUpdate.canRenderInPlace(this.hiveConf) && !SessionState.getConsole().getIsSilent() && !SessionState.get().isHiveServerQuery() ? new RenderStrategy.InPlaceUpdateFunction(this) : new RenderStrategy.LogToFileFunction(this);
    }

    private boolean isProfilingEnabled() {
        return HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.TEZ_EXEC_SUMMARY) || Utilities.isPerfOrAboveLogging(this.hiveConf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public int monitorExecution() {
        done = false;
        success = false;
        failedCounter = 0;
        rc = 0;
        status = null;
        vertexProgressMap = null;
        monitorStartTime = System.currentTimeMillis();
        var9_8 = TezJobMonitor.shutdownList;
        synchronized (var9_8) {
            TezJobMonitor.shutdownList.add(this.dagClient);
        }
        this.perfLogger.PerfLogBegin(TezJobMonitor.CLASS_NAME, "TezRunDag");
        this.perfLogger.PerfLogBegin(TezJobMonitor.CLASS_NAME, "TezSubmitToRunningDag");
        lastState = null;
        running = false;
        block27: while (true) lbl-1000:
        // 10 sources

        {
            try {
                if (this.context != null) {
                    this.context.checkHeartbeaterLockException();
                }
                status = this.dagClient.getDAGStatus(new HashSet<E>(), 200L);
                vertexProgressMap = status.getVertexProgress();
                state = status.getState();
                if (state == lastState && state != DAGStatus.State.RUNNING) continue;
                lastState = state;
                switch (2.$SwitchMap$org$apache$tez$dag$api$client$DAGStatus$State[state.ordinal()]) {
                    case 1: {
                        this.console.printInfo("Status: Submitted");
                        ** break;
                    }
                    case 2: {
                        this.console.printInfo("Status: Initializing");
                        this.executionStartTime = System.currentTimeMillis();
                        ** break;
                    }
                    case 3: {
                        if (!running) {
                            this.perfLogger.PerfLogEnd(TezJobMonitor.CLASS_NAME, "TezSubmitToRunningDag");
                            this.console.printInfo("Status: Running (" + this.dagClient.getExecutionContext() + ")\n");
                            this.executionStartTime = System.currentTimeMillis();
                            running = true;
                        }
                        this.updateFunction.update(status, vertexProgressMap);
                        ** break;
                    }
                    case 4: {
                        if (!running) {
                            this.executionStartTime = monitorStartTime;
                        }
                        this.updateFunction.update(status, vertexProgressMap);
                        success = true;
                        running = false;
                        done = true;
                        ** break;
                    }
                    case 5: {
                        if (!running) {
                            this.executionStartTime = monitorStartTime;
                        }
                        this.updateFunction.update(status, vertexProgressMap);
                        this.console.printInfo("Status: Killed");
                        running = false;
                        done = true;
                        rc = 1;
                        ** break;
                    }
                    case 6: 
                    case 7: {
                        if (!running) {
                            this.executionStartTime = monitorStartTime;
                        }
                        this.updateFunction.update(status, vertexProgressMap);
                        this.console.printError("Status: Failed");
                        running = false;
                        done = true;
                        rc = 2;
                        continue block27;
                    }
                    ** default:
lbl73:
                    // 1 sources

                    continue block27;
                }
            }
            catch (Exception e) {
                this.console.printInfo("Exception: " + e.getMessage());
                isInterrupted = TezJobMonitor.hasInterruptedException(e);
                if (isInterrupted || ++failedCounter % 2500 / 200 == 0) {
                    try {
                        this.console.printInfo("Killing DAG...");
                        this.dagClient.tryKillDAG();
                    }
                    catch (IOException | TezException var13_17) {
                        // empty catch block
                    }
                    this.console.printError("Execution has failed. stack trace: " + ExceptionUtils.getStackTrace(e));
                    rc = 1;
                    done = true;
                }
                this.console.printInfo("Retrying...");
            }
            finally {
                if (done) ** break;
                continue;
                if (rc != 0 && status != null) {
                    for (String diag : status.getDiagnostics()) {
                        this.console.printError(diag);
                        this.diagnostics.append(diag);
                    }
                }
                var11_13 = TezJobMonitor.shutdownList;
                synchronized (var11_13) {
                    TezJobMonitor.shutdownList.remove(this.dagClient);
                }
            }
            break;
        }
        this.perfLogger.PerfLogEnd(TezJobMonitor.CLASS_NAME, "TezRunDag");
        this.printSummary(success, vertexProgressMap);
        return rc;
    }

    private void printSummary(boolean success, Map<String, Progress> progressMap) {
        if (this.isProfilingEnabled() && success && progressMap != null) {
            double duration = (double)(System.currentTimeMillis() - this.executionStartTime) / 1000.0;
            this.console.printInfo("Status: DAG finished successfully in " + String.format("%.2f seconds", duration));
            this.console.printInfo("");
            new QueryExecutionBreakdownSummary(this.perfLogger).print(this.console);
            new DAGSummary(progressMap, this.hiveConf, this.dagClient, this.dag, this.perfLogger).print(this.console);
            if (HiveConf.getBoolVar(this.hiveConf, HiveConf.ConfVars.LLAP_IO_ENABLED, false)) {
                new LLAPioSummary(progressMap, this.dagClient).print(this.console);
                new FSCountersSummary(progressMap, this.dagClient).print(this.console);
            }
            this.console.printInfo("");
        }
    }

    private static boolean hasInterruptedException(Throwable e) {
        while (e != null) {
            if (e instanceof InterruptedException || e instanceof InterruptedIOException) {
                return true;
            }
            e = e.getCause();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void killRunningJobs() {
        List<DAGClient> list = shutdownList;
        synchronized (list) {
            for (DAGClient c : shutdownList) {
                try {
                    System.err.println("Trying to shutdown DAG");
                    c.tryKillDAG();
                }
                catch (Exception exception) {}
            }
        }
    }

    static long getCounterValueByGroupName(TezCounters vertexCounters, String groupNamePattern, String counterName) {
        TezCounter tezCounter = ((CounterGroup)vertexCounters.getGroup(groupNamePattern)).findCounter(counterName);
        return tezCounter == null ? 0L : tezCounter.getValue();
    }

    public String getDiagnostics() {
        return this.diagnostics.toString();
    }

    ProgressMonitor progressMonitor(DAGStatus status, Map<String, Progress> progressMap) {
        try {
            return new TezProgressMonitor(this.dagClient, status, this.workMap, progressMap, this.console, this.executionStartTime);
        }
        catch (IOException | TezException e) {
            this.console.printInfo("Getting  Progress Information: " + e.getMessage() + " stack trace: " + ExceptionUtils.getStackTrace(e));
            return TezProgressMonitor.NULL;
        }
    }

    static {
        ShutdownHookManager.addShutdownHook(new Runnable(){

            @Override
            public void run() {
                TezJobMonitor.killRunningJobs();
                try {
                    TezSessionPoolManager.getInstance().closeNonDefaultSessions(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }
}

