/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.hadoop.util;

import hive.org.apache.parquet.hadoop.util.HadoopStreams;
import hive.org.apache.parquet.io.InputFile;
import hive.org.apache.parquet.io.SeekableInputStream;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class HadoopInputFile
implements InputFile {
    private final FileSystem fs;
    private final FileStatus stat;
    private final Configuration conf;

    public static HadoopInputFile fromPath(Path path, Configuration conf) throws IOException {
        FileSystem fs = path.getFileSystem(conf);
        return new HadoopInputFile(fs, fs.getFileStatus(path), conf);
    }

    public static HadoopInputFile fromStatus(FileStatus stat, Configuration conf) throws IOException {
        FileSystem fs = stat.getPath().getFileSystem(conf);
        return new HadoopInputFile(fs, stat, conf);
    }

    private HadoopInputFile(FileSystem fs, FileStatus stat, Configuration conf) {
        this.fs = fs;
        this.stat = stat;
        this.conf = conf;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    @Override
    public long getLength() {
        return this.stat.getLen();
    }

    @Override
    public SeekableInputStream newStream() throws IOException {
        return HadoopStreams.wrap(this.fs.open(this.stat.getPath()));
    }

    public String toString() {
        return this.stat.getPath().toString();
    }
}

