/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.hadoop.example;

import hive.org.apache.parquet.Preconditions;
import hive.org.apache.parquet.example.data.Group;
import hive.org.apache.parquet.example.data.GroupWriter;
import hive.org.apache.parquet.hadoop.api.WriteSupport;
import hive.org.apache.parquet.io.api.RecordConsumer;
import hive.org.apache.parquet.schema.MessageType;
import hive.org.apache.parquet.schema.MessageTypeParser;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;

public class GroupWriteSupport
extends WriteSupport<Group> {
    public static final String PARQUET_EXAMPLE_SCHEMA = "parquet.example.schema";
    private MessageType schema = null;
    private GroupWriter groupWriter;

    public static void setSchema(MessageType schema, Configuration configuration) {
        configuration.set(PARQUET_EXAMPLE_SCHEMA, schema.toString());
    }

    public static MessageType getSchema(Configuration configuration) {
        return MessageTypeParser.parseMessageType(Preconditions.checkNotNull(configuration.get(PARQUET_EXAMPLE_SCHEMA), PARQUET_EXAMPLE_SCHEMA));
    }

    public GroupWriteSupport() {
    }

    GroupWriteSupport(MessageType schema) {
        this.schema = schema;
    }

    @Override
    public String getName() {
        return "example";
    }

    @Override
    public WriteSupport.WriteContext init(Configuration configuration) {
        if (this.schema == null) {
            this.schema = GroupWriteSupport.getSchema(configuration);
        }
        return new WriteSupport.WriteContext(this.schema, new HashMap<String, String>());
    }

    @Override
    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.groupWriter = new GroupWriter(recordConsumer, this.schema);
    }

    @Override
    public void write(Group record) {
        this.groupWriter.write(record);
    }
}

