/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app.rm;

import java.util.EnumSet;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;

public class ResourceCalculatorUtils {
    private static final double ZERO_LIMIT = 0.0099999999999999;

    public static int divideAndCeil(int a, int b) {
        if (b == 0) {
            return 0;
        }
        return (a + (b - 1)) / b;
    }

    private static boolean isZero(double a) {
        return !(Math.abs(a) > 0.0099999999999999);
    }

    public static double divideAndCeil(double a, double b) {
        if (ResourceCalculatorUtils.isZero(b)) {
            return 0.0;
        }
        return a / b;
    }

    public static int computeAvailableContainers(Resource available, Resource required, EnumSet<YarnServiceProtos.SchedulerResourceTypes> resourceTypes) {
        if (resourceTypes.contains(YarnServiceProtos.SchedulerResourceTypes.CPU) && resourceTypes.contains(YarnServiceProtos.SchedulerResourceTypes.DISK)) {
            return (int)Math.min((double)Math.min(ResourceCalculatorUtils.calculateRatioOrMaxValue(available.getMemory(), required.getMemory()), ResourceCalculatorUtils.calculateRatioOrMaxValue(available.getVirtualCores(), required.getVirtualCores())), ResourceCalculatorUtils.calculateRatioOrMaxValue(available.getDisks(), required.getDisks()));
        }
        if (resourceTypes.contains(YarnServiceProtos.SchedulerResourceTypes.CPU)) {
            return Math.min(ResourceCalculatorUtils.calculateRatioOrMaxValue(available.getMemory(), required.getMemory()), ResourceCalculatorUtils.calculateRatioOrMaxValue(available.getVirtualCores(), required.getVirtualCores()));
        }
        return ResourceCalculatorUtils.calculateRatioOrMaxValue(available.getMemory(), required.getMemory());
    }

    public static int divideAndCeilContainers(Resource required, Resource factor, EnumSet<YarnServiceProtos.SchedulerResourceTypes> resourceTypes) {
        if (resourceTypes.contains(YarnServiceProtos.SchedulerResourceTypes.CPU) && resourceTypes.contains(YarnServiceProtos.SchedulerResourceTypes.DISK)) {
            return (int)Math.max((double)Math.max(ResourceCalculatorUtils.divideAndCeil(required.getMemory(), factor.getMemory()), ResourceCalculatorUtils.divideAndCeil(required.getVirtualCores(), factor.getVirtualCores())), ResourceCalculatorUtils.divideAndCeil(required.getDisks(), factor.getDisks()));
        }
        if (resourceTypes.contains(YarnServiceProtos.SchedulerResourceTypes.CPU)) {
            return Math.max(ResourceCalculatorUtils.divideAndCeil(required.getMemory(), factor.getMemory()), ResourceCalculatorUtils.divideAndCeil(required.getVirtualCores(), factor.getVirtualCores()));
        }
        return ResourceCalculatorUtils.divideAndCeil(required.getMemory(), factor.getMemory());
    }

    private static int calculateRatioOrMaxValue(int numerator, int denominator) {
        if (denominator == 0) {
            return Integer.MAX_VALUE;
        }
        return numerator / denominator;
    }

    private static double calculateRatioOrMaxValue(double numerator, double denominator) {
        if (denominator == 0.0) {
            return 2.147483647E9;
        }
        return numerator / denominator;
    }
}

