/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.jobhistory;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.avro.Schema;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.avro.util.Utf8;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.jobhistory.Event;
import org.apache.hadoop.mapreduce.jobhistory.HistoryEvent;
import org.apache.hadoop.mapreduce.jobhistory.JhCounter;
import org.apache.hadoop.mapreduce.jobhistory.JhCounterGroup;
import org.apache.hadoop.mapreduce.jobhistory.JhCounters;

class EventWriter {
    static final String VERSION = "Avro-Json";
    static final String VERSION_BINARY = "Avro-Binary";
    private FSDataOutputStream out;
    private DatumWriter<Event> writer = new SpecificDatumWriter(Event.class);
    private Encoder encoder;
    private static final Log LOG = LogFactory.getLog(EventWriter.class);
    private final WriteMode writeMode;
    private final boolean jsonOutput;
    private static final Schema GROUPS = Schema.createArray((Schema)JhCounterGroup.SCHEMA$);
    private static final Schema COUNTERS = Schema.createArray((Schema)JhCounter.SCHEMA$);

    EventWriter(FSDataOutputStream out, WriteMode mode) throws IOException {
        this.out = out;
        this.writeMode = mode;
        if (this.writeMode == WriteMode.JSON) {
            this.jsonOutput = true;
            out.writeBytes(VERSION);
        } else if (this.writeMode == WriteMode.BINARY) {
            this.jsonOutput = false;
            out.writeBytes(VERSION_BINARY);
        } else {
            throw new IOException("Unknown mode: " + (Object)((Object)mode));
        }
        out.writeBytes("\n");
        out.writeBytes(Event.SCHEMA$.toString());
        out.writeBytes("\n");
        this.encoder = !this.jsonOutput ? EncoderFactory.get().binaryEncoder((OutputStream)out, null) : EncoderFactory.get().jsonEncoder(Event.SCHEMA$, (OutputStream)out);
    }

    synchronized void write(HistoryEvent event) throws IOException {
        Event wrapper = new Event();
        wrapper.type = event.getEventType();
        wrapper.event = event.getDatum();
        this.writer.write((Object)wrapper, this.encoder);
        this.encoder.flush();
        if (this.jsonOutput) {
            this.out.writeBytes("\n");
        }
    }

    void flush() throws IOException {
        this.encoder.flush();
        this.out.flush();
        this.out.hflush();
    }

    void close() throws IOException {
        try {
            this.encoder.flush();
            this.out.close();
            this.out = null;
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.out});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{this.out});
    }

    static JhCounters toAvro(Counters counters) {
        return EventWriter.toAvro(counters, "COUNTERS");
    }

    static JhCounters toAvro(Counters counters, String name) {
        JhCounters result = new JhCounters();
        result.name = new Utf8(name);
        result.groups = new ArrayList<JhCounterGroup>(0);
        if (counters == null) {
            return result;
        }
        for (CounterGroup group : counters) {
            JhCounterGroup g = new JhCounterGroup();
            g.name = new Utf8(group.getName());
            g.displayName = new Utf8(group.getDisplayName());
            g.counts = new ArrayList<JhCounter>(group.size());
            for (Counter counter : group) {
                JhCounter c = new JhCounter();
                c.name = new Utf8(counter.getName());
                c.displayName = new Utf8(counter.getDisplayName());
                c.value = counter.getValue();
                g.counts.add(c);
            }
            result.groups.add(g);
        }
        return result;
    }

    public static enum WriteMode {
        JSON,
        BINARY;

    }
}

