/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.rpc;

import com.google.protobuf.Internal;
import com.google.protobuf.MessageLite;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.drill.shaded.guava.com.google.common.base.Preconditions;
import org.apache.drill.shaded.guava.com.google.common.collect.ImmutableMap;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcConfig {
    static final Logger logger = LoggerFactory.getLogger(RpcConfig.class);
    private final String name;
    private final int timeout;
    private final Map<Internal.EnumLite, RpcMessageType<?, ?, ?>> sendMap;
    private final Map<Integer, RpcMessageType<?, ?, ?>> receiveMap;
    private final Executor executor;

    private RpcConfig(String name, Map<Internal.EnumLite, RpcMessageType<?, ?, ?>> sendMap, Map<Integer, RpcMessageType<?, ?, ?>> receiveMap, int timeout, Executor executor) {
        Preconditions.checkNotNull((Object)executor, (Object)"Executor must be defined.");
        this.name = name;
        this.timeout = timeout;
        this.sendMap = ImmutableMap.copyOf(sendMap);
        this.receiveMap = ImmutableMap.copyOf(receiveMap);
        this.executor = executor;
    }

    public String getName() {
        return this.name;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public boolean hasTimeout() {
        return this.timeout > 0;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public boolean checkReceive(int rpcType, Class<?> receiveClass) {
        RpcMessageType<?, ?, ?> type = this.receiveMap.get(rpcType);
        if (type == null) {
            throw new IllegalStateException(String.format("%s: There is no defined RpcMessage type for a Rpc receive type number of %s.", this.name, rpcType));
        }
        if (receiveClass != type.getRet()) {
            throw new IllegalStateException(String.format("%s: The definition for receive doesn't match implementation code.  The definition is %s however the current receive for this type was of type %s.", this.name, type, receiveClass.getCanonicalName()));
        }
        return true;
    }

    public boolean checkSend(Internal.EnumLite send, Class<?> sendClass, Class<?> receiveClass) {
        RpcMessageType<?, ?, ?> type = this.sendMap.get(send);
        if (type == null) {
            throw new IllegalStateException(String.format("%s: There is no defined RpcMessage type for a Rpc send type of %s.", this.name, send));
        }
        if (type.getSend() != sendClass) {
            throw new IllegalStateException(String.format("%s: The definition for send doesn't match implementation code.  The definition is %s however the current send is trying to send an object of type %s.", this.name, type, sendClass.getCanonicalName()));
        }
        if (type.getRet() != receiveClass) {
            throw new IllegalStateException(String.format("%s: The definition for send doesn't match implementation code.  The definition is %s however the current send is trying to setup an expected reception of an object of type %s.", this.name, type, receiveClass.getCanonicalName()));
        }
        return true;
    }

    public boolean checkResponseSend(Internal.EnumLite responseType, Class<?> responseClass) {
        RpcMessageType<?, ?, ?> type = this.receiveMap.get(responseType.getNumber());
        if (type == null) {
            throw new IllegalStateException(String.format("%s: There is no defined RpcMessage type for a Rpc response of type %s.", this.name, responseType));
        }
        if (type.getRet() != responseClass) {
            throw new IllegalStateException(String.format("%s: The definition for the response doesn't match implementation code.  The definition is %s however the current response is trying to response with an object of type %s.", this.name, type, responseClass.getCanonicalName()));
        }
        return true;
    }

    public static RpcConfigBuilder newBuilder() {
        return new RpcConfigBuilder();
    }

    public static class RpcConfigBuilder {
        private String name;
        private int timeout = -1;
        private Executor executor;
        private Map<Internal.EnumLite, RpcMessageType<?, ?, ?>> sendMap = Maps.newHashMap();
        private Map<Integer, RpcMessageType<?, ?, ?>> receiveMap = Maps.newHashMap();

        private RpcConfigBuilder() {
        }

        public RpcConfigBuilder name(String name) {
            this.name = name;
            return this;
        }

        public RpcConfigBuilder timeout(int timeoutInSeconds) {
            this.timeout = timeoutInSeconds;
            return this;
        }

        public <SEND extends MessageLite, RECEIVE extends MessageLite, T extends Internal.EnumLite> RpcConfigBuilder add(T sendEnum, Class<SEND> send, T receiveEnum, Class<RECEIVE> rec) {
            RpcMessageType<SEND, RECEIVE, T> type = new RpcMessageType<SEND, RECEIVE, T>(sendEnum, send, receiveEnum, rec);
            this.sendMap.put(sendEnum, type);
            this.receiveMap.put(receiveEnum.getNumber(), type);
            return this;
        }

        public RpcConfigBuilder executor(Executor executor) {
            this.executor = executor;
            return this;
        }

        public RpcConfig build() {
            Preconditions.checkArgument((this.timeout > -1 ? 1 : 0) != 0, (Object)"Timeout must be a positive number or zero for disabled.");
            Preconditions.checkArgument((this.name != null ? 1 : 0) != 0, (Object)"RpcConfig name must be set.");
            return new RpcConfig(this.name, this.sendMap, this.receiveMap, this.timeout, this.executor);
        }
    }

    public static class RpcMessageType<SEND extends MessageLite, RECEIVE extends MessageLite, T extends Internal.EnumLite> {
        private T sendEnum;
        private Class<SEND> send;
        private T receiveEnum;
        private Class<RECEIVE> ret;

        public RpcMessageType(T sendEnum, Class<SEND> send, T receiveEnum, Class<RECEIVE> ret) {
            this.sendEnum = sendEnum;
            this.send = send;
            this.receiveEnum = receiveEnum;
            this.ret = ret;
        }

        public Class<SEND> getSend() {
            return this.send;
        }

        public void setSend(Class<SEND> send) {
            this.send = send;
        }

        public T getSendEnum() {
            return this.sendEnum;
        }

        public void setSendEnum(T sendEnum) {
            this.sendEnum = sendEnum;
        }

        public Class<RECEIVE> getRet() {
            return this.ret;
        }

        public void setRet(Class<RECEIVE> ret) {
            this.ret = ret;
        }

        public T getReceiveEnum() {
            return this.receiveEnum;
        }

        public void setReceiveEnum(T receiveEnum) {
            this.receiveEnum = receiveEnum;
        }

        public String toString() {
            return "RpcMessageType [sendEnum=" + this.sendEnum + ", send=" + this.send + ", receiveEnum=" + this.receiveEnum + ", ret=" + this.ret + "]";
        }
    }
}

