/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.openTSDB.client.services;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.store.openTSDB.client.OpenTSDB;
import org.apache.drill.exec.store.openTSDB.client.OpenTSDBTypes;
import org.apache.drill.exec.store.openTSDB.client.Service;
import org.apache.drill.exec.store.openTSDB.client.query.DBQuery;
import org.apache.drill.exec.store.openTSDB.client.query.Query;
import org.apache.drill.exec.store.openTSDB.dto.ColumnDTO;
import org.apache.drill.exec.store.openTSDB.dto.MetricDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class ServiceImpl
implements Service {
    private static final Logger log = LoggerFactory.getLogger(ServiceImpl.class);
    private final OpenTSDB client;

    public ServiceImpl(String connectionURL) {
        this.client = (OpenTSDB)new Retrofit.Builder().baseUrl(connectionURL).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build().create(OpenTSDB.class);
    }

    @Override
    public Set<MetricDTO> getAllMetrics(Map<String, String> queryParams) {
        return this.getAllMetricsByTags(queryParams);
    }

    @Override
    public Set<String> getAllMetricNames() {
        return this.getTableNames();
    }

    @Override
    public List<ColumnDTO> getUnfixedColumns(Map<String, String> queryParam) {
        Set<MetricDTO> metrics = this.getAllMetricsByTags(queryParam);
        ArrayList<ColumnDTO> unfixedColumns = new ArrayList<ColumnDTO>();
        for (MetricDTO metric : metrics) {
            for (String tag : metric.getTags().keySet()) {
                ColumnDTO tmp = new ColumnDTO(tag, OpenTSDBTypes.STRING);
                if (unfixedColumns.contains(tmp)) continue;
                unfixedColumns.add(tmp);
            }
        }
        return unfixedColumns;
    }

    private Set<MetricDTO> getAllMetricsByTags(Map<String, String> queryParams) {
        try {
            return this.getAllMetricsFromDBByTags(queryParams);
        }
        catch (IOException e) {
            throw UserException.connectionError((Throwable)e).message("Cannot connect to the db. Maybe you have incorrect connection params or db unavailable now", new Object[0]).build(log);
        }
    }

    private Set<String> getTableNames() {
        try {
            return (Set)this.client.getAllTablesName().execute().body();
        }
        catch (IOException e) {
            throw UserException.connectionError((Throwable)e).message("Cannot connect to the db. Maybe you have incorrect connection params or db unavailable now", new Object[0]).build(log);
        }
    }

    private Set<MetricDTO> getMetricsByTags(DBQuery base) throws IOException {
        return (Set)this.client.getTables(base).execute().body();
    }

    private Set<MetricDTO> getAllMetricsFromDBByTags(Map<String, String> queryParams) throws IOException {
        HashMap<String, String> tags = new HashMap<String, String>();
        DBQuery baseQuery = this.getConfiguredDbQuery(tags, queryParams);
        Set<MetricDTO> metrics = this.getBaseMetric(baseQuery);
        if (metrics == null || metrics.isEmpty()) {
            throw UserException.validationError().message(String.format("Table '%s' not found. Please check your query and params", queryParams.get("metric")), new Object[0]).build(log);
        }
        Set<String> extractedTags = this.getTagsFromMetrics(metrics);
        return this.getMetricsByTags(extractedTags, queryParams);
    }

    private Set<MetricDTO> getMetricsByTags(Set<String> extractedTags, Map<String, String> queryParams) throws IOException {
        HashSet<MetricDTO> metrics = new HashSet<MetricDTO>();
        for (String value : extractedTags) {
            metrics.addAll(this.getMetricsByTags(this.getConfiguredDbQuery(this.getTransformedTag(value), queryParams)));
        }
        return metrics;
    }

    private DBQuery getConfiguredDbQuery(Map<String, String> tags, Map<String, String> queryParams) {
        Query subQuery = new Query.Builder(queryParams.get("metric")).setAggregator(queryParams.get("aggregator")).setDownsample(queryParams.get("downsample")).setTags(tags).build();
        HashSet<Query> queries = new HashSet<Query>();
        queries.add(subQuery);
        return new DBQuery.Builder().setStartTime(queryParams.get("start")).setEndTime(queryParams.get("end")).setQueries(queries).build();
    }

    private Set<MetricDTO> getBaseMetric(DBQuery base) throws IOException {
        return this.getMetricsByTags(base);
    }

    private Set<String> getTagsFromMetrics(Set<MetricDTO> metrics) {
        HashSet<String> extractedTags = new HashSet<String>();
        for (MetricDTO table : metrics) {
            extractedTags.addAll(table.getAggregateTags());
            extractedTags.addAll(table.getTags().keySet());
        }
        return extractedTags;
    }

    private Map<String, String> getTransformedTag(String tag) {
        HashMap<String, String> tags = new HashMap<String, String>();
        tags.put(tag, "*");
        return tags;
    }
}

