/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.openTSDB.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.drill.exec.store.openTSDB.Util;
import org.apache.drill.exec.store.openTSDB.client.OpenTSDBTypes;
import org.apache.drill.exec.store.openTSDB.client.Service;
import org.apache.drill.exec.store.openTSDB.dto.ColumnDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Schema {
    private static final Logger log = LoggerFactory.getLogger(Schema.class);
    private final List<ColumnDTO> columns = new ArrayList<ColumnDTO>();
    private final Service db;
    private final String name;

    public Schema(Service db, String name) {
        this.db = db;
        this.name = name;
        this.setupStructure();
    }

    private void setupStructure() {
        this.columns.add(new ColumnDTO(DefaultColumns.METRIC.toString(), OpenTSDBTypes.STRING));
        this.columns.add(new ColumnDTO(DefaultColumns.AGGREGATE_TAGS.toString(), OpenTSDBTypes.STRING));
        this.columns.add(new ColumnDTO(DefaultColumns.TIMESTAMP.toString(), OpenTSDBTypes.TIMESTAMP));
        this.columns.add(new ColumnDTO(DefaultColumns.AGGREGATED_VALUE.toString(), OpenTSDBTypes.DOUBLE));
        this.columns.addAll(this.db.getUnfixedColumns(this.getParamsForQuery()));
    }

    public List<ColumnDTO> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public ColumnDTO getColumnByIndex(int columnIndex) {
        return this.columns.get(columnIndex);
    }

    private Map<String, String> getParamsForQuery() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("metric", Util.getValidTableName(this.name));
        params.put("aggregator", "sum");
        params.put("start", "47y-ago");
        return params;
    }

    static enum DefaultColumns {
        METRIC("metric"),
        TIMESTAMP("timestamp"),
        AGGREGATE_TAGS("aggregate tags"),
        AGGREGATED_VALUE("aggregated value");

        private String columnName;

        private DefaultColumns(String name) {
            this.columnName = name;
        }

        public String toString() {
            return this.columnName;
        }
    }
}

