/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.openTSDB;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.IOException;
import java.util.Objects;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.logical.StoragePluginConfigBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeName(value="openTSDB")
public class OpenTSDBStoragePluginConfig
extends StoragePluginConfigBase {
    private static final Logger log = LoggerFactory.getLogger(OpenTSDBStoragePluginConfig.class);
    public static final String NAME = "openTSDB";
    private final String connection;

    @JsonCreator
    public OpenTSDBStoragePluginConfig(@JsonProperty(value="connection") String connection) throws IOException {
        if (connection == null || connection.isEmpty()) {
            throw UserException.validationError().message("Connection property must not be null. Check plugin configuration.", new Object[0]).build(log);
        }
        this.connection = connection;
    }

    public String getConnection() {
        return this.connection;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        OpenTSDBStoragePluginConfig that = (OpenTSDBStoragePluginConfig)((Object)o);
        return Objects.equals(this.connection, that.connection);
    }

    public int hashCode() {
        return this.connection != null ? this.connection.hashCode() : 0;
    }

    public String toString() {
        return "OpenTSDBStoragePluginConfig{connection='" + this.connection + '\'' + '}';
    }
}

