/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapreduce.replication;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HConnectable;
import org.apache.hadoop.hbase.client.HConnection;
import org.apache.hadoop.hbase.client.HConnectionManager;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableMapReduceUtil;
import org.apache.hadoop.hbase.mapreduce.TableMapper;
import org.apache.hadoop.hbase.mapreduce.TableSplit;
import org.apache.hadoop.hbase.replication.ReplicationException;
import org.apache.hadoop.hbase.replication.ReplicationFactory;
import org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hadoop.hbase.replication.ReplicationPeers;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.output.NullOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;

public class VerifyReplication
extends Configured
implements Tool {
    private static final Log LOG = LogFactory.getLog(VerifyReplication.class);
    public static final String NAME = "verifyrep";
    private static final String PEER_CONFIG_PREFIX = "verifyrep.peer.";
    static long startTime = 0L;
    static long endTime = Long.MAX_VALUE;
    static int batch = -1;
    static int versions = -1;
    static String tableName = null;
    static String families = null;
    static String delimiter = "";
    static String peerId = null;
    static String rowPrefixes = null;
    static int sleepMsBeforeReCompare = 0;
    static boolean verbose = false;
    static boolean includeDeletedCells = false;

    private static Pair<ReplicationPeerConfig, Configuration> getPeerQuorumConfig(Configuration conf) throws IOException {
        ZooKeeperWatcher localZKW = null;
        Object peer = null;
        try {
            localZKW = new ZooKeeperWatcher(conf, "VerifyReplication", new Abortable(){

                public void abort(String why, Throwable e) {
                }

                public boolean isAborted() {
                    return false;
                }
            });
            ReplicationPeers rp = ReplicationFactory.getReplicationPeers((ZooKeeperWatcher)localZKW, (Configuration)conf, (Abortable)localZKW);
            rp.init();
            Pair pair = rp.getPeerConf(peerId);
            if (pair == null) {
                throw new IOException("Couldn't get peer conf!");
            }
            Pair pair2 = pair;
            return pair2;
        }
        catch (ReplicationException e) {
            throw new IOException("An error occurred while trying to connect to the remote peer cluster", e);
        }
        finally {
            if (peer != null) {
                peer.close();
            }
            if (localZKW != null) {
                localZKW.close();
            }
        }
    }

    public static Job createSubmittableJob(Configuration conf, String[] args) throws IOException {
        if (!VerifyReplication.doCommandLine(args)) {
            return null;
        }
        if (!conf.getBoolean("hbase.replication", true)) {
            throw new IOException("Replication needs to be enabled to verify it.");
        }
        conf.set("verifyrep.peerId", peerId);
        conf.set("verifyrep.tableName", tableName);
        conf.setLong("verifyrep.startTime", startTime);
        conf.setLong("verifyrep.endTime", endTime);
        conf.setInt("verifyrep.sleepMsBeforeReCompare", sleepMsBeforeReCompare);
        conf.set("verifyrep.delimiter", delimiter);
        conf.setInt("verifyrep.batch", batch);
        conf.setBoolean("verifyrep.verbose", verbose);
        conf.setBoolean("verifyrep.includeDeletedCells", includeDeletedCells);
        if (families != null) {
            conf.set("verifyrep.families", families);
        }
        if (rowPrefixes != null) {
            conf.set("verifyrep.rowPrefixes", rowPrefixes);
        }
        Pair<ReplicationPeerConfig, Configuration> peerConfigPair = VerifyReplication.getPeerQuorumConfig(conf);
        ReplicationPeerConfig peerConfig = (ReplicationPeerConfig)peerConfigPair.getFirst();
        String peerQuorumAddress = peerConfig.getClusterKey();
        LOG.info((Object)("Peer Quorum Address: " + peerQuorumAddress + ", Peer Configuration: " + peerConfig.getConfiguration()));
        conf.set("verifyrep.peerQuorumAddress", peerQuorumAddress);
        HBaseConfiguration.setWithPrefix((Configuration)conf, (String)PEER_CONFIG_PREFIX, peerConfig.getConfiguration().entrySet());
        conf.setInt("verifyrep.versions", versions);
        LOG.info((Object)("Number of version: " + versions));
        Job job = new Job(conf, "verifyrep_" + tableName);
        job.setJarByClass(VerifyReplication.class);
        Scan scan = new Scan();
        scan.setTimeRange(startTime, endTime);
        scan.setRaw(includeDeletedCells);
        scan.setCacheBlocks(false);
        if (batch > 0) {
            scan.setBatch(batch);
        }
        if (versions >= 0) {
            scan.setMaxVersions(versions);
            LOG.info((Object)("Number of versions set to " + versions));
        }
        if (families != null) {
            String[] fams;
            for (String fam : fams = families.split(",")) {
                scan.addFamily(Bytes.toBytes((String)fam));
            }
        }
        VerifyReplication.setRowPrefixFilter(scan, rowPrefixes);
        TableMapReduceUtil.initTableMapperJob(tableName, scan, Verifier.class, null, null, job);
        Configuration peerClusterConf = (Configuration)peerConfigPair.getSecond();
        TableMapReduceUtil.initCredentialsForCluster(job, peerClusterConf);
        job.setOutputFormatClass(NullOutputFormat.class);
        job.setNumReduceTasks(0);
        return job;
    }

    private static void setRowPrefixFilter(Scan scan, String rowPrefixes) {
        if (rowPrefixes != null && !rowPrefixes.isEmpty()) {
            Object[] rowPrefixArray = rowPrefixes.split(",");
            Arrays.sort(rowPrefixArray);
            FilterList filterList = new FilterList(FilterList.Operator.MUST_PASS_ONE);
            for (Object prefix : rowPrefixArray) {
                PrefixFilter filter = new PrefixFilter(Bytes.toBytes((String)prefix));
                filterList.addFilter((Filter)filter);
            }
            scan.setFilter((Filter)filterList);
            byte[] startPrefixRow = Bytes.toBytes((String)rowPrefixArray[0]);
            byte[] lastPrefixRow = Bytes.toBytes((String)rowPrefixArray[rowPrefixArray.length - 1]);
            VerifyReplication.setStartAndStopRows(scan, startPrefixRow, lastPrefixRow);
        }
    }

    private static void setStartAndStopRows(Scan scan, byte[] startPrefixRow, byte[] lastPrefixRow) {
        scan.setStartRow(startPrefixRow);
        byte[] stopRow = Bytes.add((byte[])Bytes.head((byte[])lastPrefixRow, (int)(lastPrefixRow.length - 1)), (byte[])new byte[]{(byte)(lastPrefixRow[lastPrefixRow.length - 1] + 1)});
        scan.setStopRow(stopRow);
    }

    private static boolean doCommandLine(String[] args) {
        if (args.length < 2) {
            VerifyReplication.printUsage(null);
            return false;
        }
        VerifyReplication.restoreDefaults();
        try {
            for (int i = 0; i < args.length; ++i) {
                String cmd = args[i];
                if (cmd.equals("-h") || cmd.startsWith("--h")) {
                    VerifyReplication.printUsage(null);
                    return false;
                }
                String startTimeArgKey = "--starttime=";
                if (cmd.startsWith("--starttime=")) {
                    startTime = Long.parseLong(cmd.substring("--starttime=".length()));
                    continue;
                }
                String endTimeArgKey = "--endtime=";
                if (cmd.startsWith("--endtime=")) {
                    endTime = Long.parseLong(cmd.substring("--endtime=".length()));
                    continue;
                }
                String includeDeletedCellsArgKey = "--raw";
                if (cmd.equals("--raw")) {
                    includeDeletedCells = true;
                    continue;
                }
                String versionsArgKey = "--versions=";
                if (cmd.startsWith("--versions=")) {
                    versions = Integer.parseInt(cmd.substring("--versions=".length()));
                    continue;
                }
                String batchArgKey = "--batch=";
                if (cmd.startsWith("--batch=")) {
                    batch = Integer.parseInt(cmd.substring("--batch=".length()));
                    continue;
                }
                String familiesArgKey = "--families=";
                if (cmd.startsWith("--families=")) {
                    families = cmd.substring("--families=".length());
                    continue;
                }
                String rowPrefixesKey = "--row-prefixes=";
                if (cmd.startsWith("--row-prefixes=")) {
                    rowPrefixes = cmd.substring("--row-prefixes=".length());
                    continue;
                }
                String delimiterArgKey = "--delimiter=";
                if (cmd.startsWith("--delimiter=")) {
                    delimiter = cmd.substring("--delimiter=".length());
                    continue;
                }
                String sleepToReCompareKey = "--recomparesleep=";
                if (cmd.startsWith("--recomparesleep=")) {
                    sleepMsBeforeReCompare = Integer.parseInt(cmd.substring("--recomparesleep=".length()));
                    continue;
                }
                String verboseKey = "--verbose";
                if (cmd.startsWith("--verbose")) {
                    verbose = true;
                    continue;
                }
                if (cmd.startsWith("--")) {
                    VerifyReplication.printUsage("Invalid argument '" + cmd + "'");
                }
                if (i == args.length - 2) {
                    peerId = cmd;
                }
                if (i != args.length - 1) continue;
                tableName = cmd;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            VerifyReplication.printUsage("Can't start because " + e.getMessage());
            return false;
        }
        return true;
    }

    private static void restoreDefaults() {
        startTime = 0L;
        endTime = Long.MAX_VALUE;
        batch = -1;
        versions = -1;
        tableName = null;
        families = null;
        peerId = null;
        rowPrefixes = null;
        includeDeletedCells = false;
    }

    private static void printUsage(String errorMsg) {
        if (errorMsg != null && errorMsg.length() > 0) {
            System.err.println("ERROR: " + errorMsg);
        }
        System.err.println("Usage: verifyrep [--starttime=X] [--endtime=Y] [--families=A] [--row-prefixes=B] [--delimiter=] [--recomparesleep=] [--batch=] [--verbose] <peerid> <tablename>");
        System.err.println();
        System.err.println("Options:");
        System.err.println(" starttime    beginning of the time range");
        System.err.println("              without endtime means from starttime to forever");
        System.err.println(" endtime      end of the time range");
        System.err.println(" versions     number of cell versions to verify");
        System.err.println(" batch        batch count for scan, note that result row counts will no longer be actual number of rows when you use this option");
        System.err.println(" raw          includes raw scan if given in options");
        System.err.println(" families     comma-separated list of families to copy");
        System.err.println(" row-prefixes comma-separated list of row key prefixes to filter on ");
        System.err.println(" delimiter    the delimiter used in display around rowkey");
        System.err.println(" recomparesleep   milliseconds to sleep before recompare row, default value is 0 which disables the recompare.");
        System.err.println(" verbose      logs row keys of good rows");
        System.err.println();
        System.err.println("Args:");
        System.err.println(" peerid       Id of the peer used for verification, must match the one given for replication");
        System.err.println(" tablename    Name of the table to verify");
        System.err.println();
        System.err.println("Examples:");
        System.err.println(" To verify the data replicated from TestTable for a 1 hour window with peer #5 ");
        System.err.println(" $ bin/hbase org.apache.hadoop.hbase.mapreduce.replication.VerifyReplication --starttime=1265875194289 --endtime=1265878794289 5 TestTable ");
    }

    public int run(String[] args) throws Exception {
        Configuration conf = this.getConf();
        Job job = VerifyReplication.createSubmittableJob(conf, args);
        if (job != null) {
            return job.waitForCompletion(true) ? 0 : 1;
        }
        return 1;
    }

    public static void main(String[] args) throws Exception {
        int res = ToolRunner.run((Configuration)HBaseConfiguration.create(), (Tool)new VerifyReplication(), (String[])args);
        System.exit(res);
    }

    public static class Verifier
    extends TableMapper<ImmutableBytesWritable, Put> {
        private Table sourceTable;
        private ResultScanner replicatedScanner;
        private Result currentCompareRowInPeerTable;
        private Table replicatedTable;
        private int sleepMsBeforeReCompare;
        private String delimiter = "";
        private boolean verbose = false;
        private int batch = -1;

        public void map(ImmutableBytesWritable row, final Result value, Mapper.Context context) throws IOException {
            if (this.replicatedScanner == null) {
                Configuration conf = context.getConfiguration();
                this.sleepMsBeforeReCompare = conf.getInt("verifyrep.sleepMsBeforeReCompare", 0);
                this.delimiter = conf.get("verifyrep.delimiter", "");
                this.verbose = conf.getBoolean("verifyrep.verbose", false);
                this.batch = conf.getInt("verifyrep.batch", -1);
                final Scan scan = new Scan();
                if (this.batch > 0) {
                    scan.setBatch(this.batch);
                }
                scan.setCacheBlocks(false);
                scan.setCaching(conf.getInt("hbase.mapreduce.scan.cachedrows", 1));
                long startTime = conf.getLong("verifyrep.startTime", 0L);
                long endTime = conf.getLong("verifyrep.endTime", Long.MAX_VALUE);
                String families = conf.get("verifyrep.families", null);
                if (families != null) {
                    String[] fams;
                    for (String fam : fams = families.split(",")) {
                        scan.addFamily(Bytes.toBytes((String)fam));
                    }
                }
                boolean includeDeletedCells = conf.getBoolean("verifyrep.includeDeletedCells", false);
                scan.setRaw(includeDeletedCells);
                String rowPrefixes = conf.get("verifyrep.rowPrefixes", null);
                VerifyReplication.setRowPrefixFilter(scan, rowPrefixes);
                scan.setTimeRange(startTime, endTime);
                int versions = conf.getInt("verifyrep.versions", -1);
                LOG.info((Object)("Setting number of version inside map as: " + versions));
                if (versions >= 0) {
                    scan.setMaxVersions(versions);
                }
                TableName tableName = TableName.valueOf((String)conf.get("verifyrep.tableName"));
                this.sourceTable = ConnectionFactory.createConnection((Configuration)conf).getTable(tableName);
                final TableSplit tableSplit = (TableSplit)context.getInputSplit();
                HConnectionManager.execute((HConnectable)new HConnectable<Void>(conf){

                    public Void connect(HConnection conn) throws IOException {
                        String zkClusterKey = this.conf.get("verifyrep.peerQuorumAddress");
                        Configuration peerConf = HBaseConfiguration.createClusterConf((Configuration)this.conf, (String)zkClusterKey, (String)VerifyReplication.PEER_CONFIG_PREFIX);
                        TableName tableName = TableName.valueOf((String)this.conf.get("verifyrep.tableName"));
                        replicatedTable = (Table)new HTable(peerConf, tableName);
                        scan.setStartRow(value.getRow());
                        scan.setStopRow(tableSplit.getEndRow());
                        replicatedScanner = replicatedTable.getScanner(scan);
                        return null;
                    }
                });
                this.currentCompareRowInPeerTable = this.replicatedScanner.next();
            }
            while (true) {
                if (this.currentCompareRowInPeerTable == null) {
                    this.logFailRowAndIncreaseCounter(context, Counters.ONLY_IN_SOURCE_TABLE_ROWS, value);
                    break;
                }
                int rowCmpRet = Bytes.compareTo((byte[])value.getRow(), (byte[])this.currentCompareRowInPeerTable.getRow());
                if (rowCmpRet == 0) {
                    try {
                        Result.compareResults((Result)value, (Result)this.currentCompareRowInPeerTable);
                        context.getCounter((Enum)Counters.GOODROWS).increment(1L);
                        if (this.verbose) {
                            LOG.info((Object)("Good row key: " + this.delimiter + Bytes.toStringBinary((byte[])value.getRow()) + this.delimiter));
                        }
                    }
                    catch (Exception e) {
                        this.logFailRowAndIncreaseCounter(context, Counters.CONTENT_DIFFERENT_ROWS, value);
                    }
                    this.currentCompareRowInPeerTable = this.replicatedScanner.next();
                    break;
                }
                if (rowCmpRet < 0) {
                    this.logFailRowAndIncreaseCounter(context, Counters.ONLY_IN_SOURCE_TABLE_ROWS, value);
                    break;
                }
                this.logFailRowAndIncreaseCounter(context, Counters.ONLY_IN_PEER_TABLE_ROWS, this.currentCompareRowInPeerTable);
                this.currentCompareRowInPeerTable = this.replicatedScanner.next();
            }
        }

        private void logFailRowAndIncreaseCounter(Mapper.Context context, Counters counter, Result row) {
            if (this.sleepMsBeforeReCompare > 0) {
                Threads.sleep((long)this.sleepMsBeforeReCompare);
                try {
                    Result sourceResult = this.sourceTable.get(new Get(row.getRow()));
                    Result replicatedResult = this.replicatedTable.get(new Get(row.getRow()));
                    Result.compareResults((Result)sourceResult, (Result)replicatedResult);
                    if (!sourceResult.isEmpty()) {
                        context.getCounter((Enum)Counters.GOODROWS).increment(1L);
                        if (this.verbose) {
                            LOG.info((Object)("Good row key (with recompare): " + this.delimiter + Bytes.toStringBinary((byte[])row.getRow()) + this.delimiter));
                        }
                    }
                    return;
                }
                catch (Exception e) {
                    LOG.error((Object)("recompare fail after sleep, rowkey=" + this.delimiter + Bytes.toStringBinary((byte[])row.getRow()) + this.delimiter));
                }
            }
            context.getCounter((Enum)counter).increment(1L);
            context.getCounter((Enum)Counters.BADROWS).increment(1L);
            LOG.error((Object)(counter.toString() + ", rowkey=" + this.delimiter + Bytes.toStringBinary((byte[])row.getRow()) + this.delimiter));
        }

        protected void cleanup(Mapper.Context context) {
            TableName tableName;
            if (this.replicatedScanner != null) {
                try {
                    while (this.currentCompareRowInPeerTable != null) {
                        this.logFailRowAndIncreaseCounter(context, Counters.ONLY_IN_PEER_TABLE_ROWS, this.currentCompareRowInPeerTable);
                        this.currentCompareRowInPeerTable = this.replicatedScanner.next();
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)"fail to scan peer table in cleanup", (Throwable)e);
                }
                finally {
                    this.replicatedScanner.close();
                    this.replicatedScanner = null;
                }
            }
            if (this.sourceTable != null) {
                tableName = this.sourceTable.getName();
                try {
                    this.sourceTable.close();
                }
                catch (IOException ioe) {
                    LOG.warn((Object)("Exception closing source table: " + tableName), (Throwable)ioe);
                }
            }
            if (this.replicatedTable != null) {
                tableName = this.replicatedTable.getName();
                try {
                    this.replicatedTable.close();
                }
                catch (IOException ioe) {
                    LOG.warn((Object)("Exception closing replicated table: " + tableName), (Throwable)ioe);
                }
            }
        }

        public static enum Counters {
            GOODROWS,
            BADROWS,
            ONLY_IN_SOURCE_TABLE_ROWS,
            ONLY_IN_PEER_TABLE_ROWS,
            CONTENT_DIFFERENT_ROWS;

        }
    }
}

